<?php
/**
* fileupload.php 処理概要：ファイルアップロード処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

require_once("function/KakikoCommon.php");
require_once("function/KakikoFile.php");
require_once("class/xml/ReadResource.class.php");

define("UPLOAD_FILE_NAME",    "mapfile%03d.xxx");
define("UPLOAD_GISFILE_NAME", "gisfile.xxx");

// POST情報取得
$error_check_flg = false;
$uploadpath = "";
if (!isset($_POST['uploadmode'])) {
    $error_check_flg = true;
} else {
    $o_tblname = unserialize($_SESSION['_tablename']);
    switch ($_POST['uploadmode']) {
        // GIS有りの場合
        case "0":
            $uploadpath = "../../contents/".$o_tblname->get_DirectryName()."/img/map/temp";
            break;
        // GIS無しの場合
        case "1":
        case "2":
        case "3":
        case "4":
        case "5":
        case "6":
        case "7":
        case "8":
        case "9":
        case "10":
            $uploadpath = "../../contents/".$o_tblname->get_DirectryName()."/img/map/temp/".sprintf("%03d", $_POST['uploadmode']);
            break;
        default:
            $uploadpath = "";
    }
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_ADMIN);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("fileupload", "POST", $_SERVER["PHP_SELF"]);

// 入力項目のデフォルトをセット
$form_def = array(
    "formName"    => $_POST['formName'],
    "mapNo"       => $_POST['mapNo'],
    "uploadmode"  => $_POST['uploadmode']
);
$o_form->setDefaults($form_def);

// 項目セット
$o_form->addElement("header",        "header",     $o_resource->getValue("G03014L001"));
$o_form->addElement("hidden",        "formName");
$o_form->addElement("hidden",        "mapNo");
$o_form->addElement("hidden",        "uploadmode");
$o_form->addElement("submit",        "submit_run", $o_resource->getValue("G03014L004"), array("class"=>"fs12_black", ($error_check_flg==false)?"":"disabled"));
$o_form->addElement("button",        "button_cls", $o_resource->getValue("G03014L005"), array("onclick"=>"close_window();", "class"=>"fs12_black"));
$file =& $o_form->addElement("file", "uploadfile", $o_resource->getValue("G03014L002"), array("size"=>"50", "class"=>"fs12_black"));

// チェック項目
$o_form->addRule("uploadfile", $o_resource->getValue("G03014M002"),	"uploadedfile");
$o_form->addRule("uploadfile", $o_resource->getValue("G03014M003"),	"maxfilesize", return_bytes(ini_get("upload_max_filesize")));
if ($_POST['uploadmode'] == "0") {
//	$o_form->addRule("uploadfile", $o_resource->getValue("G03014M004"),	"mimetype",    array("file"));
} else {
	$mimetype_array = split(",", UPLOAD_MIME_TYPE);
	$o_form->addRule("uploadfile", $o_resource->getValue("G03014M004"),	"mimetype",    $mimetype_array);
//	$o_form->addRule("uploadfile", $o_resource->getValue("G03014M004"),	"mimetype",    array("image/gif", "image/pjpeg", "image/png"));
}

$errorMessage = "";

// 登録ボタン
if (isset($_POST[submit_run])) {
    // 妥当性チェック
    if ($o_form->validate()) {
        // アップロード先の作成
        if (file_exists($uploadpath)) {
            kakikoDelete($uploadpath);
        }
        mkdir($uploadpath);
        // アップロード
        $o_form->process("process", TRUE);
        // 親画面に戻る
        header("location: ./fileuploadfin.php?fn=".$_POST['formName']."&no=".$_POST['mapNo']."&name=".$file->_value['name']);
        exit(0);
    }
}

// エラー判定
if ($error_check_flg == true) {
print "ERROR<br>";
    $errorMessage = $o_resource->getValue("G03014M001");
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form",         $o_renderer->toArray());
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display("./fileupload.tpl");


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################

/**
* 関数概要：ファイルアップロード
* 処理詳細：ファイルのアップロードを行う
*
* @引数： (I) $values - array 入力された連想配列
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function process($values){
    global $file;
    global $uploadpath;
    global $uploadfile;
    if ($file->isUploadedFile()) {
        $file->moveUploadedFile($uploadpath);
        return TRUE;
    }
    else {
        return FALSE;
    }
}

?>
