<?php
/**
* layerinfodel.php 処理概要：レイヤー削除
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

require_once("function/KakikoCommon.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ../index.php");
}

require_once("class/db/service/MapAdminService.class.php");
require_once("class/xml/ReadResource.class.php");							// リソースファイル読込み

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_ADMIN);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"    => $o_resource->getValue("G03009L001"),
    "topTitle2"   => $o_resource->getValue("G03009L002"),
    "listTitle01" => $o_resource->getValue("G03009L003"),
    "listTitle02" => $o_resource->getValue("G03009L004"),
    "listTitle03" => $o_resource->getValue("G03009L005"),
    "listTitle04" => $o_resource->getValue("G03009L006"),
    "listTitle05" => $o_resource->getValue("G03009L007"),
    "listTitle06" => $o_resource->getValue("G03009L008"),
    "listTitle07" => $o_resource->getValue("G03009L009"),
    "stsKnd00"    => $o_resource->getValue("G03009L010"),
    "stsKnd01"    => $o_resource->getValue("G03009L011"),
    "stsKnd02"    => $o_resource->getValue("G03009L012"),
    "delBtn"      => $o_resource->getValue("G03009L013"),
    "lstBtn"      => $o_resource->getValue("G03009L014"),
    "rtnBtn"      => $o_resource->getValue("G03009L015")
);

//セッションのテーブルオブジェクト取得
$tablename_obj = unserialize($_SESSION['_tablename']);
// DB接続サービス呼び出し
$o_service = new MapAdminService($tablename_obj->get_DirectryName());

// QuickForm インスタンス化
$o_form = new HTML_QuickForm('layerinfodel', 'POST', $_SERVER["PHP_SELF"]);

$pageFlg = 0;

if (isset($_POST[run])) {
    if ($o_form->validate()) {
        if ($_POST['delchk'] == 1) {
            if (deleteRecode($o_service) == true) {
                $pageFlg = 1;
            }
        } else {
            $errorMessage = $o_resource->getValue("G03009M007");
        }
    }
}

if ($pageFlg == 0) {
    // 削除確認画面
    $o_form->addElement("header",   "header",        $label['topTitle']);
    $o_form->addElement("hidden",   "h_userid",      $_POST['h_userid']);
    $o_form->addElement("hidden",   "h_username",    $_POST['h_username']);
    $o_form->addElement("hidden",   "h_layerid",     $_POST['h_layerid']);
    $o_form->addElement("hidden",   "h_layername",   $_POST['h_layername']);
    $o_form->addElement("hidden",   "h_mailaddress", $_POST['h_mailaddress']);
    $o_form->addElement("hidden",   "h_adddatetime", $_POST['h_adddatetime']);
    $o_form->addElement("hidden",   "h_statusflg",   $_POST['h_statusflg']);

    $o_form->addElement("static",   "userid",        $label['listTitle01'], $_POST['h_userid']);
    $o_form->addElement("static",   "username",      $label['listTitle02'], $_POST['h_username']);
    $o_form->addElement("static",   "layerid",       $label['listTitle03'], $_POST['h_layerid']);
    $o_form->addElement("static",   "layername",     $label['listTitle04'], $_POST['h_layername']);
    $o_form->addElement("static",   "mailaddress",   $label['listTitle05'], $_POST['h_mailaddress']);
    $o_form->addElement("static",   "adddatetime",   $label['listTitle06'], $_POST['h_adddatetime']);
    $o_form->addElement("static",   "statusflg",     $label['listTitle07'], $_POST['h_statusflg']==KAKIKOMAP_STATUSFLG_ON?$label['stsKnd00']:
                                                               ($_POST['h_statusflg']==KAKIKOMAP_STATUSFLG_OFF?$label['stsKnd01']:$label['stsKnd02']));

    $o_form->addElement("checkbox", "delchk",        null, $o_resource->getValue("G03009M006"));

    $o_form->addElement("submit",   "run",           $label['delBtn'], array("class"=>"fs12_black"));
    $o_form->addElement("button",   "return",        $label['rtnBtn'], array("onclick"=>"location.href='./layerlist.php'", "class"=>"fs12_black"));
    $tplarray = array();
    $tplName = "admin_layerinfodel.tpl";
} else {
    // 完了画面
    $tplarray    = array(
                          "title"         => $label['topTitle2'],
                          "infomessage"   => $o_resource->getValue("G03009M003"),
                          "tablewidth"    => "550",
                          "tdwidth"       => "150",
                          "listdatas"     => "",
                          "buttonname"    => $label['lstBtn'],
                          "buttononclick" => "location.href='./layerlist.php'"
                         );
    $tplName = "commonfin.tpl";
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form",         $o_renderer->toArray());
$o_smarty->assign("infoMsg01",    $o_resource->getValue("G03009M001"));
$o_smarty->assign("infoMsg02",    $o_resource->getValue("G03009M002"));
$o_smarty->assign("tplarray",     $tplarray);
$o_smarty->assign("delchk1",      $o_resource->getValue("G03009M004"));
$o_smarty->assign("delchk2",      $o_resource->getValue("G03009M005"));
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display($tplName);


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：レイヤー削除処理
* 処理詳細：レイヤー管理テーブルより該当レコードを削除する
*
* @引数： (I) o_service     - object DBサービスクラス
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function deleteRecode($o_service) {

	// レイヤー削除処理
	$rtn = $o_service->deleteLayerByKey($_POST['h_userid'], $_POST['h_layerid']);

    return $rtn;
}

?>
