<?php
/**
* layerlist.php 処理概要：レイヤー一覧
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/

require_once("function/KakikoCommon.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ../index.php");
}
// POST値をURLデコード
if (isset($_POST['serchLayer'])) {
    $_POST['serchLayer'] = urldecode($_POST['serchLayer']);
}
if (isset($_POST['serchUser'])) {
    $_POST['serchUser'] = urldecode($_POST['serchUser']);
}

require_once("class/mail/KakikoMail.class.php");                     // メール送信クラス
require_once("class/db/service/MapAdminService.class.php");
require_once("class/db/tabledata/LayerData.class.php");
require_once("class/xml/ReadResource.class.php");							// リソースファイル読込み


// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_ADMIN);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"    => $o_resource->getValue("G03008L001"),
    "colTitleA01" => $o_resource->getValue("G03008L002"),
    "colTitleA02" => $o_resource->getValue("G03008L003"),
    "colTitleB01" => $o_resource->getValue("G03008L004"),
    "colTitleB02" => $o_resource->getValue("G03008L005"),
    "colTitleB03" => $o_resource->getValue("G03008L006"),
    "colTitleB04" => $o_resource->getValue("G03008L007"),
    "colTitleB05" => $o_resource->getValue("G03008L008"),
    "colTitleB06" => $o_resource->getValue("G03008L009"),
    "colTitleB07" => $o_resource->getValue("G03008L010"),
    "colTitleC01" => $o_resource->getValue("G03008L011"),
    "colTitleC02" => $o_resource->getValue("G03008L012"),
    "colTitleC03" => $o_resource->getValue("G03008L013"),
    "colTitleC04" => $o_resource->getValue("G03008L014"),
    "colTitleC05" => $o_resource->getValue("G03008L015"),
    "colTitleC06" => $o_resource->getValue("G03008L016"),
    "stsKnd00"    => $o_resource->getValue("G03008L017"),
    "stsKnd01"    => $o_resource->getValue("G03008L018"),
    "listTitle1"  => $o_resource->getValue("G03008L019"),
    "listTitle2"  => $o_resource->getValue("G03008L020"),
    "sthBtn"      => $o_resource->getValue("G03008L021"),
    "delBtn"      => $o_resource->getValue("G03008L022"),
    "athBtn"      => $o_resource->getValue("G03008L023"),
    "updBtn"      => $o_resource->getValue("G03008L024")
);

// 日付クラス
$o_date = new Date();

//セッションのテーブルオブジェクト取得
$tablename_obj = unserialize($_SESSION['_tablename']);
// DB接続サービス呼び出し
$o_service = new MapAdminService($tablename_obj->get_DirectryName());

// 状態の変更
if ($_POST['submitKnd'] == 1) {
	changeStatus($o_service, $_POST['h_sts'] == KAKIKOMAP_STATUSFLG_ON ? KAKIKOMAP_STATUSFLG_OFF : KAKIKOMAP_STATUSFLG_ON);
}
if ($_POST['submitKnd'] == 2) {
	changeStatus($o_service, KAKIKOMAP_STATUSFLG_ON);
	sendMail($o_resource);
}

// 抽出条件有無
if (isset($_POST['serchLayer'])) {
    $serchLayer = $_POST['serchLayer'];
} else {
    $serchLayer = "";
}
if (isset($_POST['serchUser'])) {
    $serchUser = $_POST['serchUser'];
} else {
    $serchUser = "";
}

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("layerlist", "POST", $_SERVER["PHP_SELF"]);

// 入力項目のデフォルトをセット
$o_form->setDefaults(array(
    "serchLayer"=>$serchLayer,
    "serchUser"=>$serchUser
));

// 項目セット
$o_form->addElement("header", "header",     $label['topTitle']);
$o_form->addElement("text",   "serchLayer", $label['colTitleA01'], array("size"=>30, "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("text",   "serchUser",  $label['colTitleA02'], array("size"=>30, "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("submit", "search",     $label['sthBtn'],       array("class"=>"fs12_black"));

// チェック項目

$errorMessage = "";

// 登録ボタン
if (isset($_POST[run])) {
    // 妥当性チェック
    if ($o_form->validate()) {
        // このページはチェックがありません
    }
}

// POSTで渡って来た内容を破棄
$_myPOST = $_POST;
unset($_POST['h_userid'],
      $_POST['h_layerid'],
      $_POST['h_sts'], 
      $_POST['h_page1'], 
      $_POST['h_page2'], 
      $_POST['submitKnd']
      );

//-----------------------------//
//* 認証済みリストのPeger処理 *//
//-----------------------------//

if ($_myPOST['submitKnd']==1) {
    $nowpage1 = $_myPOST['h_page1'];
    $chgsts1 = TRUE;
} else {
    $nowpage1 = 1;
    $chgsts1 = FALSE;
}

// クエリーセット
$data_array = getLayerListData($o_service, 0, $serchLayer, $serchUser);
if (is_null($data_array)) {
	exit();
}

// Pager
$rowNum1 = count($data_array);
$params1 = array(
    "perPage"=>LAYERLIST1_ROW,
    "urlVar"=>"list1",
    "mode"=>"Jumping",
    "totalItems"=>$rowNum1,
    "prevImg"=>$o_resource->getValue("G03008L025"),
    "nextImg"=>$o_resource->getValue("G03008L026"),
    "httpMethod"=>"POST"
);

$o_page1 = Pager::factory($params1);
if ($nowpage1 > $o_page1->numPages()){
    $nowpage1 = $o_page1->numPages();
}
if ($chgsts1) {
    $navi1 = $o_page1->getlinks($nowpage1);
} else {
    $navi1 = $o_page1->getlinks();
    $nowpage1 = $o_page1->getCurrentPageID();
}

$listData1 = getListData($data_array, $o_date, ($nowpage1 - 1) * LAYERLIST1_ROW, LAYERLIST1_ROW, $rowNum1);


//-----------------------------//
//* 許可待ちリストのPeger処理 *//
//-----------------------------//

if ($_myPOST['submitKnd']==2) {
    $nowpage2 = $_myPOST['h_page2'];
    $chgsts2 = TRUE;            // ステータスを変更するボタンが押された
} else {
    $nowpage2 = 1;
    $chgsts2 = FALSE;
}

// クエリーセット
$data_array = getLayerListData($o_service, 1, $serchLayer, $serchUser);
if (is_null($data_array)) {
	exit();
}

// Pager
$rowNum2 = count($data_array);
$params2 = array(
    "perPage"=>LAYERLIST2_ROW,
    "urlVar"=>"list2",
    "mode"=>"Jumping",
    "totalItems"=>$rowNum2,
    "prevImg"=>$o_resource->getValue("G03008L027"),
    "nextImg"=>$o_resource->getValue("G03008L028"),
    "httpMethod"=>"POST"
);

$o_page2 = Pager::factory($params2);
if ($nowpage2 > $o_page2->numPages()){
    $nowpage2 = $o_page2->numPages();
}
if ($chgsts2) {
    $navi2 = $o_page2->getlinks($nowpage2);
} else {
    $navi2 = $o_page2->getlinks();
    $nowpage2 = $o_page2->getCurrentPageID();
}
$listData2 = getListData($data_array, $o_date, ($nowpage2 - 1) * LAYERLIST2_ROW, LAYERLIST2_ROW, $rowNum2);

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form",         $o_renderer->toArray());
$o_smarty->assign("listDatas1",   $listData1);
$o_smarty->assign("listDatas2",   $listData2);
$o_smarty->assign("labels",       $label);
$o_smarty->assign("infoMsg01",    $o_resource->getValue("G03008M001"));
$o_smarty->assign("chkmsg1",      $o_resource->getValue("G03008M002"));
$o_smarty->assign("chkmsg2",      $o_resource->getValue("G03008M003"));
$o_smarty->assign("pager1",       $navi1["all"]);
$o_smarty->assign("pager2",       $navi2["all"]);
$o_smarty->assign("nowpage1",     $nowpage1);
$o_smarty->assign("nowpage2",     $nowpage2);
$o_smarty->assign("serchLayer",   $serchLayer);
$o_smarty->assign("serchUser",    $serchUser);
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display("admin_layerlist.tpl");


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：レイヤー一覧表示情報取得
* 処理詳細：レイヤー管理テーブルより情報を取得するクエリーをセット
*
* @引数： (I) o_service     - object DBサービスクラス
*      ： (I) knd         	- integer 取得区分(0:認証済み,2:許可待ち)
*      ： (I) searchLayer  	- string  抽出条件(レイヤー名称)
*      ： (I) searchUser   	- string  抽出条件(ユーザ名称)
* @戻値： object レコードセット
*                DBエラーの場合はnull
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getLayerListData($o_service, $knd, $searchLayer = "", $searchUser = "") {

	$data = $o_service->getLayerDataList($knd, $searchLayer, $searchUser);

	return $data;
}

/**
* 関数概要：レイヤー一覧表示情報取得
* 処理詳細：レイヤー管理テーブルより情報を取得する
*
* @引数： (I) data		- object  データオブジェクト型配列
*         (I) o_date	- object  日付クラス
*         (I) start		- integer 開始抽出データ
*         (I) cnt		- integer 抽出データ数
*         (I) rowNum	- integer データ件数
* @戻値： array 一覧情報(連想配列)
* @戻値： 一覧情報配列
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getListData($data, $o_date, $start, $cnt, $rowNum) {

    $ret_array = array();

    if (count($data) <> 0) {

        for ($i = $start; $i < $start + $cnt; $i++) {
    
            if ($i == $rowNum) break;

			if (is_null($data[$i]))	break;

			$o_date->setDate($data[$i]->getAddDateTime_Layer());

			$recode_array = array(
	               "userid"=>$data[$i]->getUserID_User(),
	               "username"=>$data[$i]->getUserName_User(),
	               "mailaddress"=>$data[$i]->getMailAddress_User(),
	               "layerid"=>$data[$i]->getLayerID_Layer(),
	               "layername"=>$data[$i]->getLayerName_Layer(),
	               "adddatetime"=>$o_date->format("%Y/%m/%d"),
	               "statusflg"=>$data[$i]->getStatusFlg_Layer()
			);
            $ret_array[] = $recode_array;
        }
    }
    return $ret_array;
}

/**
* 関数概要：レイヤー管理テーブル状態更新
* 処理詳細：レイヤー管理テーブルの状態フラグを変更する
*
* @引数： (I) o_service     - object DBサービスクラス
*      ： (I) status        - integer 更新する値
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function changeStatus($o_service, $status){

	// マップ配下のレイヤー管理テーブルデータの更新

	// 条件及びNULL等のターゲット設定
	$targetLayerDataObj = new LayerData();

	// 条件
	$targetLayerDataObj->setUserID(WHERE_KEY);
	$targetLayerDataObj->setLayerID(WHERE_KEY);

	// 更新項目ターゲット設定
	$targetLayerDataObj->setStatusFlg(VAL_TARGET);
	$targetLayerDataObj->setUpdateDateTime(VAL_TARGET);

	// 更新項目設定
	$valLayerDataObj = new LayerData();

	// ユーザID(キー)
	$valLayerDataObj->setUserID($_POST['h_userid']);
	// レイヤーID(キー)
	$valLayerDataObj->setLayerID($_POST['h_layerid']);
	// 状態フラグ
	$valLayerDataObj->setStatusFlg($status);
	// 更新日時
	$valLayerDataObj->setUpdateDateTime(date('Y/m/d H:i:s'));

	// レイヤーデータ更新処理
	$rtn = $o_service->updateLayerDataByKey($targetLayerDataObj, $valLayerDataObj);

    return $rtn;

}

/**
* 関数概要：メール送信処理
* 処理詳細：レイヤー登録者に対して許可通知メールを送信する
*
* @引数： (I) o_resource   - object リソースクラス
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function sendMail($o_resource) {

    // -----------------------
    // メール送信用設定
    // -----------------------
    // メール種類
    $mode        = "smtp";
    // 送信先アドレス
    $toAddress   = ereg_replace("\n|\r", "", $_POST['h_mailaddress']);
    // 送信先名称
    $toName      = (($_POST['h_username']=="--")?$_POST['h_userid']:$_POST['h_username']).$o_resource->getValue("G03008M005");
    // 送信元アドレス
    $fromAddress = $_SESSION['_authadminsession']['data']['mailaddress'];
    // 送信元名称
    $fromName    = $o_resource->getValue("G03008M006");
    // 件名
    $subject     = $o_resource->getValue("G03008M007");
    // 本文
    $message     = (($_POST['h_username']=="--")?$_POST['h_userid']:$_POST['h_username']).$o_resource->getValue("G03008M008")."\n"
                  ."\n"
                  .$o_resource->getValue("G03008M009")."\n"
                  ."\n"
                  .$o_resource->getValue("G03008M010").$_POST['h_layerid']."\n"
                  .$o_resource->getValue("G03008M011").$_POST['h_layername']."\n"
                  .$o_resource->getValue("G03008M012").$_POST['h_adddatetime']."\n"
                  ."\n"
                  ."\n"
                  .$o_resource->getValue("G03008M013")."\n";

    
    // メール送信処理
    $o_email = new KakikoMail();
    $mailitems = array(
                        "ToAddress"   => $toAddress,    //送信先アドレス
                        "ToName"      => $toName,       //送信先名称
                        "FromAddress" => $fromAddress,  //送信元アドレス
                        "FromName"    => $fromName,     //送信元名称
                        "ReplyTo"     => $fromAddress,  //返信先アドレス
                        "Subject"     => $subject,      //件名
                        "Message"     => $message,      //本文
                       );
    $o_email->createMail($mailitems);
    $ret = $o_email->sendEmail($mode);
    if (PEAR::isError($ret)){
        trigger_error($ret->getMessage()."\n".$o_resource->getValue("G03008M004"), E_USER_ERROR);
        return false;
    }

    return true;

}

?>
