<?php
/**
* mapadmininfoset.php 処理概要：マップ管理者情報設定
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

require_once("function/KakikoCommon.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ../index.php");
}

require_once("class/db/service/MapAdminService.class.php");
require_once("class/db/tabledata/UserData.class.php");
require_once("class/xml/ReadResource.class.php");							// リソースファイル読込み


// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_ADMIN);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"   => $o_resource->getValue("G03002L001"),
    "topTitle2"  => $o_resource->getValue("G03002L002"),
    "colTitle01" => $o_resource->getValue("G03002L003"),
    "colTitle02" => $o_resource->getValue("G03002L004"),
    "colTitle03" => $o_resource->getValue("G03002L005"),
    "colTitle04" => $o_resource->getValue("G03002L006"),
    "colTitle05" => $o_resource->getValue("G03002L007"),
    "addBtn"     => $o_resource->getValue("G03002L008"),
    "rstBtn"     => $o_resource->getValue("G03002L009")
);

//セッションのテーブルオブジェクト取得
$tablename_obj = unserialize($_SESSION['_tablename']);
// DB接続サービス呼び出し
$o_service = new MapAdminService($tablename_obj->get_DirectryName());

// ユーザデータ型オブジェクト
$userdata = new UserData();
// マップ管理者情報の取得
if (selectRecode($o_service, $userdata) == false) {
    trigger_error($o_resource->getValue("G03002M009"), E_USER_ERROR);
    exit();
}

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("mapadmininfoset", "POST", $_SERVER["PHP_SELF"]);

// 入力項目のデフォルトをセット
$o_form->setDefaults(array(
    "userID"       => $userdata->getUserID(),
    "userName"     => $userdata->getUserName(),
    "mailAddress"  => $userdata->getMailAddress()
));

// 項目セット
$o_form->addElement("static",   "userID",      $label['colTitle01']);
$o_form->addElement("text",     "userName",    $label['colTitle02'], array("size"=>50, "maxlength"=>32,  "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("password", "password1",   $label['colTitle03'], array("size"=>30, "maxlength"=>20,  "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("password", "password2",   $label['colTitle04'], array("size"=>30, "maxlength"=>20,  "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("text",     "mailAddress", $label['colTitle05'], array("size"=>50, "maxlength"=>128, "autocomplete"=>"off", "class"=>"fs12_black"));

// 独自チェックルールの定義
$o_form->registerRule('minlength_valid', 'callback', 'check_minlength_valid');
$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');

// チェック項目
$o_form->addRule("userName",   	$o_resource->getValue("G03002M001"), "required",    null);
//$o_form->addRule("userName",	$o_resource->getValue("G03002M002"), "maxlength_valid",	128);
$o_form->addRule("password1",   $o_resource->getValue("G03002M003"), "required",    null);
$o_form->addRule("password1",	$o_resource->getValue("G03002M004"), "regex", 			"/^[a-zA-Z0-9]+$/");
//$o_form->addRule("password1",   $o_resource->getValue("G03002M005"), "rangelength", array(8, 20));
$o_form->addRule("password1",	$o_resource->getValue("G03002M005"), "minlength_valid",	8);
$o_form->addRule("password1",	$o_resource->getValue("G03002M005"), "maxlength_valid",	20);
$o_form->addRule("password2",   $o_resource->getValue("G03002M006"), "required",    null);
$o_form->addRule( array("password1","password2"), $o_resource->getValue("G03002M007"), "compare", NULL);
$o_form->addRule("mailAddress", $o_resource->getValue("G03002M008"), "required",    null);
$o_form->addRule("mailAddress",	$o_resource->getValue("G03002M009"), "maxlength_valid",	128);
$o_form->addRule("mailAddress", $o_resource->getValue("G03002M010"), "email",       null);

$errorMessage = "";
$pageFlg = 0;

// 登録ボタン
if (isset($_POST[run])) {
    // 妥当性チェック
    if ($o_form->validate()) {
        if (insertRecode($o_service) == true) {
            $pageFlg = 1;
        }
    } else {
    	// パスワードエリアを初期化
    	$pass = &$o_form->getElement("password1");
    	$pass->setValue("");
    	$pass = &$o_form->getElement("password2");
    	$pass->setValue("");
    }
}

// ボタンを表示
if ($pageFlg == 0) {
    $o_form->addElement("header", "header", $label['topTitle']);
    $o_form->addElement("submit", "run",    $label['addBtn'], array("class"=>"fs12_black"));
    $o_form->addElement("reset",  "reset",  $label['rstBtn'], array("class"=>"fs12_black"));
    $tplarray = array();
    $tplName = "admin_mapadmininfoset.tpl";
} else {
    // 完了画面
    $listdatas = array();
    $listdatas[] = array("rowname" => $label['colTitle01'], "rowdata" => $_SESSION['_userid']);
    $listdatas[] = array("rowname" => $label['colTitle02'], "rowdata" => $_POST['userName']);
    $listdatas[] = array("rowname" => $label['colTitle05'], "rowdata" => $_POST['mailAddress']);
    $tplarray    = array(
                          "title"         => $label['topTitle2'],
                          "infomessage"   => $o_resource->getValue("G03002M012"),
                          "tablewidth"    => "550",
                          "tdwidth"       => "150",
                          "listdatas"     => $listdatas,
                          "buttonname"    => "",
                          "buttononclick" => ""
                         );
    $tplName = "commonfin.tpl";
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form", $o_renderer->toArray());
$o_smarty->assign("infoMsg01", $o_resource->getValue("G03002M011"));
$o_smarty->assign("tplarray", $tplarray);
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display($tplName);


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：マップ管理者情報設定表示情報取得
* 処理詳細：管理者ユーザテーブルより該当の情報を取得する
*
* @引数： (I)   o_service    - object DBサービスクラス
*         (I/O) data		 - object データオブジェクト
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：s
* @更新内容：
*/
function selectRecode($o_service, &$data) {


	$data = $o_service->getMapAdminInfoData($_SESSION['_userid']);
	if (is_null($data)) {
		return false;
	}

	return true;
}

/**
* 関数概要：マップ管理者情報設定内容更新
* 処理詳細：入力された内容をデータベースへ更新する
*
* @引数： (I)   o_service    - object DBサービスクラス
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function insertRecode($o_service) {

	// 条件及びNULL等のターゲット設定
	$targetUserDataObj = new UserData();

	// 条件
	$targetUserDataObj->setUserID(WHERE_KEY);

	// 更新項目ターゲット設定
	$targetUserDataObj->setMailAddress(VAL_TARGET);
	$targetUserDataObj->setUserName(VAL_TARGET);
	$targetUserDataObj->setPassword(VAL_TARGET);
	$targetUserDataObj->setUpdateDateTime(VAL_TARGET);

	// 更新項目設定
	$valUserDataObj = new UserData();

	// ユーザID(キー)
	$valUserDataObj->setUserID($_SESSION['_userid']);
	// ユーザ名称
	$valUserDataObj->setUserName($_POST['userName']);
	// パスワード
	$valUserDataObj->setPassword(md5($_POST['password1']));
	// メールアドレス
	$valUserDataObj->setMailAddress($_POST['mailAddress']);
	// 更新日時
	$valUserDataObj->setUpdateDateTime(date('Y/m/d H:i:s'));

	// ユーザデータ更新処理
	$rtn = $o_service->updateUserDataByKey($targetUserDataObj, $valUserDataObj);

    return $rtn;
}

?>
