<?php
/**
* userlist.php 処理概要：ユーザ一覧
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/

require_once("function/KakikoCommon.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ../index.php");
}
// POST値をURLデコード
if (isset($_POST['serchLayer'])) {
    $_POST['serchLayer'] = urldecode($_POST['serchLayer']);
}
if (isset($_POST['serchUser'])) {
    $_POST['serchUser'] = urldecode($_POST['serchUser']);
}

require_once("class/db/service/MapAdminService.class.php");
require_once("class/db/tabledata/UserData.class.php");
require_once("class/xml/ReadResource.class.php");							// リソースファイル読込み


// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_ADMIN);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"    =>$o_resource->getValue("G03011L001"),
    "colTitleA01" =>$o_resource->getValue("G03011L002"),
    "colTitleA02" =>$o_resource->getValue("G03011L003"),
    "colTitleB01" =>$o_resource->getValue("G03011L004"),
    "colTitleB02" =>$o_resource->getValue("G03011L005"),
    "colTitleB03" =>$o_resource->getValue("G03011L006"),
    "colTitleB04" =>$o_resource->getValue("G03011L007"),
    "colTitleB05" =>$o_resource->getValue("G03011L008"),
    "stsKnd00"    =>$o_resource->getValue("G03011L009"),
    "stsKnd01"    =>$o_resource->getValue("G03011L010"),
    "sthBtn"      =>$o_resource->getValue("G03011L011"),
    "delBtn"      =>$o_resource->getValue("G03011L012"),
    "updBtn"      =>$o_resource->getValue("G03011L013")
);

// 日付クラス
$o_date = new Date();

// DB インスタンス化
//$o_db = new KakikoDb(DBHOST, DBNAME, DBUSER, DBPASS, DBTYPE);
//セッションのテーブルオブジェクト取得
$tablename_obj = unserialize($_SESSION['_tablename']);
// DB接続サービス呼び出し
$o_service = new MapAdminService($tablename_obj->get_DirectryName());

// 状態の変更
if ($_POST['submitKnd'] == 1) {
	chengeStatus($o_service, $_POST['h_sts'] == KAKIKOMAP_STATUSFLG_ON ? KAKIKOMAP_STATUSFLG_OFF : KAKIKOMAP_STATUSFLG_ON);
}

// 抽出条件有無
if (isset($_POST['serchLayer'])) {
    $serchLayer = $_POST['serchLayer'];
} else {
    $serchLayer = "";
}
if (isset($_POST['serchUser'])){
    $serchUser = $_POST['serchUser'];
} else {
    $serchUser = "";
}

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("userlist", "POST", $_SERVER["PHP_SELF"]);

// 入力項目のデフォルトをセット
$o_form->setDefaults(array(
    "serchLayer"=>$serchLayer,
    "serchUser"=>$serchUser
));

// 項目セット
$o_form->addElement("header", "header",     $label['topTitle']);
$o_form->addElement("text",   "serchLayer", $label['colTitleA01'], array("size"=>30, "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("text",   "serchUser",  $label['colTitleA02'], array("size"=>30, "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("submit", "search",     $label['sthBtn'],       array("class"=>"fs12_black"));

// チェック項目

$errorMessage = "";

// 登録ボタン
if (isset($_POST[run])) {
    // 妥当性チェック
    if ($o_form->validate()) {
        // このページはチェックがありません
    }
}

if ($_POST['submitKnd']==1) {
    $perPage = $_POST['h_perpage'];
    $nowpage = $_POST['h_page'];
    $chgsts = TRUE;            // ステータスを変更するボタンが押された
} else {
    $nowpage = 1;
    $chgsts = FALSE;
}

// クエリーセット
$data_array = getUserListData($o_service, $serchLayer, $serchUser);
if (is_null($data_array)) {
	exit();
}

// Pager
$rowNum = count($data_array);
$params = array(
    "perPage"=>USERLIST_ROW,
    "urlVar"=>"list",
    "mode"=>"Jumping",
    "totalItems"=>$rowNum,
    "prevImg"=>$o_resource->getValue("G03011L014"),
    "nextImg"=>$o_resource->getValue("G03011L015"),
    "httpMethod"=>"POST"
);

// POSTで渡って来た内容を破棄
unset($_POST['h_userid'],
      $_POST['h_sts'], 
      $_POST['h_page'],
      $_POST['submitKnd']
      );

$o_page = Pager::factory($params);
if ($nowpage > $o_page->numPages()){
    $nowpage = $o_page->numPages();
}
if ($chgsts) {
    $navi = $o_page->getlinks($nowpage);
} else {
    $navi = $o_page->getlinks();
    $nowpage = $o_page->getCurrentPageID();
}
$listData = getListData($data_array, $o_date, ($nowpage - 1) * USERLIST_ROW, USERLIST_ROW, $rowNum);

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form",         $o_renderer->toArray());
$o_smarty->assign("listDatas",    $listData);
$o_smarty->assign("labels",       $label);
$o_smarty->assign("chkmsg",       $o_resource->getValue("G03011M001"));
$o_smarty->assign("pager",        $navi["all"]);
$o_smarty->assign("nowpage",      $nowpage);
$o_smarty->assign("serchLayer",   $serchLayer);
$o_smarty->assign("serchUser",    $serchUser);
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display("admin_userlist.tpl");


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：ユーザ一覧表示情報取得
* 処理詳細：レイヤーユーザ管理テーブルより情報を取得するクエリーをセット
*
* @引数： (I) o_service     - object DBサービスクラス
*      ： (I) searchLayer	- string 抽出条件(レイヤー名称)
*      ： (I) searchUser	- string 抽出条件(ユーザ名称)
* @戻値： object レコードセット
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getUserListData($o_service, $searchLayer = "", $searchUser = ""){

	$data = $o_service->getUserDataList($searchLayer, $searchUser);

	return $data;
}

/**
* 関数概要：ユーザ一覧表示情報取得
* 処理詳細：レイヤーユーザ管理テーブルより情報を取得する
*
* @引数： (I) data		- object  データオブジェクト型配列
*         (I) o_date 	- object  日付クラス
*         (I) start  	- integer 開始抽出データ
*         (I) cnt    	- integer 抽出データ数
*         (I) rowNum 	- integer データ件数
* @戻値： array 一覧情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getListData($data, $o_date, $start, $cnt, $rowNum) {

    $ret_array = array();

    if (count($data) <> 0) {

        for ($i = $start; $i < $start + $cnt; $i++) {
    
            if ($i == $rowNum) break;

			if (is_null($data[$i]))	break;

			$o_date->setDate($data[$i]->getAddDateTime_User());

			$recode_array = array(
	               "userid"=>$data[$i]->getUserID_User(),
	               "username"=>$data[$i]->getUserName_User(),
	               "mailaddress"=>$data[$i]->getMailAddress_User(),
	               "adddatetime"=>$o_date->format("%Y/%m/%d"),
	               "statusflg"=>$data[$i]->getStatusFlg_User()
			);
            $ret_array[] = $recode_array;
        }
    }
    return $ret_array;
}

/**
* 関数概要：レイヤーユーザ管理テーブル状態更新
* 処理詳細：レイヤーユーザ管理テーブルの状態フラグを変更する
*
* @引数： (I) o_service     - object DBサービスクラス
*      ： (I) status		- integer 更新する値
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function chengeStatus($o_service, $status) {

	// マップ配下のユーザ管理テーブルデータの更新

	// 条件及びNULL等のターゲット設定
	$targetUserDataObj = new UserData();

	// 条件
	$targetUserDataObj->setUserID(WHERE_KEY);

	// 更新項目ターゲット設定
	$targetUserDataObj->setStatusFlg(VAL_TARGET);
	$targetUserDataObj->setUpdateDateTime(VAL_TARGET);

	// 更新項目設定
	$valUserDataObj = new UserData();

	// ユーザID(キー)
	$valUserDataObj->setUserID($_POST['h_userid']);
	// 状態フラグ
	$valUserDataObj->setStatusFlg($status);
	// 更新日時
	$valUserDataObj->setUpdateDateTime(date('Y/m/d H:i:s'));

	// レイヤーデータ更新処理
	$rtn = $o_service->updateUserDataByKey($targetUserDataObj, $valUserDataObj);

    return $rtn;
}

?>
