<?php
/**
* _mapadminlist.php 処理概要：マップ管理者一覧
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

require_once("function/KakikoCommon.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ../index.php");
}

require_once("Config.php");
require_once("class/db/dbaccess/DataObject.php");
require_once("class/db/service/SystemAdminService.class.php");
require_once("class/db/tabledata/MapData.class.php");
require_once("class/db/tabledata/UserData.class.php");
require_once("class/xml/ReadResource.class.php");							// リソースファイル読込み

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_ADMIN);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"=>$o_resource->getValue("G02002L001"),
    "listTitle01"=>$o_resource->getValue("G02002L002"),
    "listTitle02"=>$o_resource->getValue("G02002L003"),
    "listTitle03"=>$o_resource->getValue("G02002L004"),
    "listTitle04"=>$o_resource->getValue("G02002L005"),
    "listTitle05"=>$o_resource->getValue("G02002L006"),
    "sts0"=>$o_resource->getValue("G02002L007"),
    "sts1"=>$o_resource->getValue("G02002L008"),
    "newBtn"=>$o_resource->getValue("G02002L009"),
    "delBtn"=>$o_resource->getValue("G02002L010"),
    "updBtn"=>$o_resource->getValue("G02002L011")
);

// 日付クラス
$o_date = new Date();

// DB接続サービス呼び出し
if (isset($_POST['h_dir'])) {
$o_service = new SystemAdminService($_POST['h_dir']);
} else {
$o_service = new SystemAdminService();
}

// 状態の変更
if (isset($_POST['submitKnd']) && $_POST['submitKnd']=="1") {
    $rtn = changeRecord($o_service);
    if ($rtn != true) {
    	exit();
    }
}

// マップ管理者情報一覧データの取得
$classdata = $o_service->getMapAdminInfoDataList();
if (is_null($classdata)) {
	exit();
}

if (isset($_POST['submitKnd']) && $_POST['submitKnd']=="1") {
    $perPage = $_POST['h_perpage'];
    $nowpage = $_POST['h_page'];
    $chgsts = TRUE;
} else {
    $nowpage = 1;
    $chgsts = FALSE;
}

// Pager
$rowNum = count($classdata);
$params = array(
    "perPage"=>MAPADMINLIST_ROW,
    "mode"=>"Jumping",
    "totalItems"=>$rowNum,
    "prevImg"=>$o_resource->getValue("G02002L012"),
    "nextImg"=>$o_resource->getValue("G02002L013"),
    "httpMethod"=>"POST"
);

// POSTで渡って来た内容を破棄
unset($_POST['h_userid'], 
      $_POST['h_sts'], 
      $_POST['h_dir'],
      $_POST['h_page'], 
      $_POST['submitKnd']
      );

$o_page = Pager::factory($params);
if ($nowpage > $o_page->numPages()){
    $nowpage = $o_page->numPages();
}
if ($chgsts) {
    $navi = $o_page->getlinks($nowpage);
} else {
    $navi = $o_page->getlinks();
    $nowpage = $o_page->getCurrentPageID();
}

// 一覧データ作成
$list = createList($classdata, $o_date, ($nowpage - 1) * MAPADMINLIST_ROW, MAPADMINLIST_ROW, $rowNum);

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_smarty->assign("labels", $label);
$o_smarty->assign("listdatas", $list);
$o_smarty->assign("pager", $navi["all"]);
$o_smarty->assign("nowpage", $nowpage);
$o_smarty->assign("chkmsg", $o_resource->getValue("G02002M001"));

$o_smarty->display("admin_mapadminlist.tpl");


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：マップ管理者一覧表示情報取得
* 処理詳細：管理者ユーザテーブルより情報を取得する
*
* @引数： (I) data		- object  データオブジェクト
*         (I) o_date	- object  日付クラス
*         (I) start  	- integer 開始抽出データ
*         (I) cnt    	- integer 抽出データ数
*         (I) rowNum 	- integer データ件数
* @戻値： array 一覧情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function createList($data, $o_date, $start, $cnt, $rowNum) {

    $array_user = array();

    for ($i = $start; $i < $start + $cnt; $i++) {

        if ($i == $rowNum) break;
        
		if (is_null($data[$i]))	break;

		$o_date->setDate($data[$i]->getAddDateTime_AdminUser());

		$o_user = array(
			"userID"=>$data[$i]->getUserID_AdminUser(),
            "userName"=>$data[$i]->getUserName_AdminUser(),
            "contentsName"=>$data[$i]->getContentsName_Map(),
            "directoryName"=>$data[$i]->getDirectryName_Map(),
            "mailAddress"=>$data[$i]->getMailAddress_AdminUser(),
            "addDateTime"=>$o_date->format("%Y/%m/%d"),
            "statusFlg"=>$data[$i]->getStatusFlg_AdminUser()
		);
		$array_user[] = $o_user;
    }
    return $array_user;
}

/**
* 関数概要：管理者ユーザ管理テーブル状態更新
* 処理詳細：管理者ユーザ管理テーブルの状態フラグを変更する
*
* @引数： (I) o_service    - object DBサービスクラス
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function changeRecord($o_service) {

	// マップ配下のユーザ管理テーブルデータの更新

	// 条件及びNULL等のターゲット設定
	$targetUserDataObj = new UserData();

	// 条件
	$targetUserDataObj->setUserID(WHERE_KEY);

	// 更新項目ターゲット設定
	$targetUserDataObj->setStatusFlg(VAL_TARGET);
	$targetUserDataObj->setUpdateDateTime(VAL_TARGET);

	// 更新項目設定
	$valUserDataObj = new UserData();

	// ユーザID(キー)
	$valUserDataObj->setUserID($_POST['h_userid']);
	// 状態フラグ
	$valUserDataObj->setStatusFlg(
				$_POST['h_sts'] == KAKIKOMAP_STATUSFLG_ON 
					? KAKIKOMAP_STATUSFLG_OFF : KAKIKOMAP_STATUSFLG_ON
				);
	// 更新日時
	$valUserDataObj->setUpdateDateTime(date('Y/m/d H:i:s'));

    // マップ管理テーブルデータの更新
	// 条件及びNULL等のターゲット設定
	$targetMapDataObj = new MapData();

	// 条件
	$targetMapDataObj->setUserID(WHERE_KEY);

	// 更新項目ターゲット設定
	if ($valUserDataObj->getStatusFlg() == KAKIKOMAP_STATUSFLG_OFF) {
        $targetMapDataObj->setPublicContents(VAL_TARGET);
    }
    $targetMapDataObj->setUserType(VAL_TARGET);
    $targetMapDataObj->setUpdateDateTime(VAL_TARGET);

    // 更新項目設定
    $valMapDataObj = new MapData();

	// ユーザID(キー)
	$valMapDataObj->setUserID($_POST['h_userid']);
	// コンテンツ公開区分
	if ($valUserDataObj->getStatusFlg() == KAKIKOMAP_STATUSFLG_OFF) {
        $valMapDataObj->setPublicContents(KAKIKOMAP_PUBLICCONTENTS_CLOSED);
    }
	// ユーザ種別
	if ($valUserDataObj->getStatusFlg() == KAKIKOMAP_STATUSFLG_OFF) {
        $valMapDataObj->setUserType(KAKIKOMAP_USERTYPE_SYSTEM);
	} else if ($valUserDataObj->getStatusFlg() == KAKIKOMAP_STATUSFLG_ON) {
        $valMapDataObj->setUserType(KAKIKOMAP_USERTYPE_MAP);
	}

	// 更新日時
	$valMapDataObj->setUpdateDateTime(date('Y/m/d H:i:s'));

	// ユーザデータ&マップデータ更新処理
    $rtn = $o_service->updateUserAndMapDataByKey($targetUserDataObj, $valUserDataObj, $targetMapDataObj, $valMapDataObj);
    if ($rtn) {
        // ユーザ状態を有効から無効に変えたときのみ
        if ($valUserDataObj->getStatusFlg() == KAKIKOMAP_STATUSFLG_OFF) {
            // iniファイルへの書き出し
            writeIniFile();
        }
    }

    return $rtn;
}

/**
* 関数概要：イニファイル項目書込み処理
* 処理詳細：コンテンツ対象のイニファイルへの項目書込み処理を行う
*
* @引数： 
* @戻値： 
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @更新内容：
*/
function writeIniFile() {

    $dirname = $_POST['h_dir'];

	$dirs = split(PATH_SEPARATOR, ini_get('include_path')); 
	foreach ($dirs as $dirpath) {

	    $fpath = $dirpath.DIRECTORY_SEPARATOR."kakikomap".DIRECTORY_SEPARATOR."ini".DIRECTORY_SEPARATOR."auto".DIRECTORY_SEPARATOR.$dirname."_setting.ini";

		if(is_file($fpath)){
			$config = new Config();
			$setting = $config->parseConfig($fpath, "inicommented");
			break;
		}
	}

	// マップ公開区分
	$map_public =& $setting->searchPath(array("MAP_PUBLIC"));

	// 設定
	// マップ公開区分
    $map_public->setContent(KAKIKOMAP_PUBLICCONTENTS_CLOSED);

	$rtn = $config->writeConfig($fpath, "inicommented");
	if ($rtn != true) {
//		trigger_error($o_resource->getValue("G02007M002"), E_USER_ERROR);
		return;
	}

	return;
}

?>
