/**
* カキコまっぷ用 DragableFloat DIV
*
* @作者(改良者)：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
* 　※このスクリプトは 高橋登史朗氏の「jsgt_dragfloat08.js」を参考に
* 　　カキコまっぷの意味空間用に改良させていただいております。
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/


/**
* グローバル変数
*
* @var    zcount             全ドラッガブルDIV中で現在のzindex最前面
* @var    clickElement       現在ドラッグ中のDIVのID名
* @var    canvas             document.body のDOCTYPE標準モード対応
* @array  dragableFloatId    全ドラッガブルDIVのID名を格納
*/
var zcount = 0          ;
var clickElement = ""   ;
if(document.getElementsByTagName('BODY').length==0)document.write('<body>')//ダミーのbodyタグ
var canvas = document[ 'CSS1Compat' == document.compatMode ? 'documentElement' : 'body'];
var dragableFloatId=[]  ;
var recx1,recy1,recx2,recy2,recxOffset,recyOffset

var selectedFloatId = [];      // 選択されているオブジェクトIDを保持（範囲選択高速化）
var rangeSelectFlag = false;     // 範囲選択＆ドラッグ状態保持フラグ

// ドラッグ用グローバル変数
var _mousedownX;               // マウスダウン時のX座標
var _mousedownY;               // マウスダウン時のY座標
var _mousemoveX;               // ドラッグ中のX座標
var _mousemoveY;               // ドラッグ中のY座標
var flgDrag = false;           // ドラッグ中フラグ

var flgSlider = false;         // スライダーモードフラグ

////
// 設定された全ドラッガブルDIVを開始
//
//
function doDragableFloat()
{ 

    for(i in dragableFloatId){ 
        var oj = document.getElementById(dragableFloatId[i]) ;
        if(oj.floatEnabled){

            if(!(is.safari || is.khtml))
            {
                //スクロール時の動作
                window.onscroll = function(e){
                    moveDiv(oj,oj.style.left,oj.style.top);
                }
            }else{
                aaa=setInterval(function(){
                        moveDiv(oj,oj.style.left,oj.style.top);
                        },100)
            }
        }
    }
}

// 全ドラッガブルDIVのフロートをスタート
function startDragableFloat()
{
    for(i in dragableFloat ){
        var oj = document.getElementById(dragableFloat[i].id) ;
        moveDiv(oj,oj.style.left,oj.style.top);
    }
}

// DIVを浮かす    
function moveDiv(oj,ofx,ofy)
{
    if(oj.draging) return;//ドラッグ中は無視
    if(oj.dragcnt == 0 ){
        ofx = parseInt(ofx, 10);
        ofy = parseInt(ofx, 10);
        oj.dragcnt++;
    } else {//ドラッグ終了位置がオフセット
        ofx = parseInt(oj.pageOffLeft, 10);
        ofy = parseInt(oj.pageOffTop, 10);
    }
    var l = parseInt(canvas.scrollLeft, 10);
    var t = parseInt(canvas.scrollTop, 10);
    oj.style.left = l + ofx + "px";
    oj.style.top  = t + ofy + "px";
}


/**
* ブラウザ判定
*
* @sample               alert(is.ie)
*/
var is = 
{
    ie     : !!document.all ,
    mac45  : navigator.userAgent.indexOf('MSIE 4.5; Mac_PowerPC') != -1 ,
    opera  : !!window.opera ,
    safari : navigator.userAgent.indexOf('Safari') != -1 ,
    khtml  : navigator.userAgent.indexOf('Konqueror') != -1 
}

/**
* 関数概要：メモ表示用のDIVを作成
* 処理詳細：メモ表示用のDIVを作成する
*
* @引数： (I) id - string DIVオブジェクトのID
*      ： (I) x - float メモのX座標 
*      ： (I) y - float メモのY座標
*      ： (I) layerId - string レイヤーID
*      ： (I) memoId  - string メモID
*      ： (I) colorId - string カラーID
* @戻値： object DIVオブジェクト
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function dragableFloat(id, x, y, layerId, memoTypeId, memoId, colorId)
{
    if(!!dragableFloatId[id]) return document.getElementById(id)
    
    ////
    // DIV生成
    // @param  id             DIVのID名
    //
    this.mkDiv = function (id) 
    {
        var canvas = document[ 'CSS1Compat' == document.compatMode ? 'documentElement' : 'body'];
        var div   = document.getElementById('mapArea').appendChild(document.createElement("DIV")); //DIV要素を生成

            div.setAttribute("id", id);
            div.style.position = "absolute";
            div.style.left     = x + "px";
            div.style.top      = y + "px";
            div.innerHTML      = "";
            div.offLeft        = 0;
            div.offTop         = 0;
            div.pageOffLeft    = x-parseInt(canvas.scrollLeft,10)+ "px";
            div.pageOffTop     = y-parseInt(canvas.scrollTop,10) + "px";
            div.dragcnt        = 0;
            div.draging        = false;
            div.getTOP         = getTOP;
            div.getLEFT        = getLEFT;
            div.getMouseX      = getMouseX;
            div.getMouseY      = getMouseY;
            recx1              = x
            recy1              = y
            div.enabled        = true;  //DIV可能 true|false
            div.floatEnabled   = true;  //フロート可能 true|false
            div.boundEnabled   = false; //移動可能領域あり true|false

            div.beforeBackgroundColor = "";  // 編集前のBackgroundColor待避変数
            div.beforeColor =  "";           // 編集前のColor待避変数
            div.selectingFlag = false;       // DIVの選択状態を持つフラグ

            div.memoID = memoId;         // メモID
            div.memoTypeID = memoTypeId; // メモ種類ID
            div.layerID = layerId;       // レイヤーID
            div.colorID = colorId;		 // カラーID
            
            div.radioColor    = 0;	// 色分けラジオボタンの初期状態(0:リボン)
            div.radioMemoType = 0;	// レイヤー＆メモ種別ラジオボタンの初期状態(0:表示)

            div.moveTo         = function (x, y){
                div.style.left = x + "px";
                div.style.top  = y + "px";
            }
            div.setBounds      = function (a, b, c, d){
                div.minX = a;
                div.minY = b;
                div.maxX = c;
                div.maxY = d;
                div.boundEnabled = true;
            }
            div.onmouseout     = function (e){ 

                if(!clickElement) return
                selLay=document.getElementById(clickElement);
                
                //ドラッグ中止
                setDraging2false(selLay);
        
                //xyエラー時の類推追跡用xyセット
                x =  recx2+=recxOffset;
                y =  recy2+=recyOffset;
                dofollow(x,y);
                x =  recx2+=recxOffset;
                y =  recy2+=recyOffset;
                setTimeout('"dofollow('+x+','+y+')"',10);

//                div.style.zIndex = zcount++;

				// ドラッグ状態保持フラグOFF
                rangeSelectFlag = false;

                return false 
            }
            div.onselectstart  = function (e){ return false }

            div.onmouseover    = function (e){ return false }

            div.onmousedown    = function (e)
            {
                div.draging = true;
                div.dragcnt++;
                selLay = div;
                clickElement = selLay.id;

				// ドラッグ状態ON
				rangeSelectFlag = true;

                //DIVのleft,topからカーソル位置までのオフセットをキャプチャ
                if (selLay){    
                    selLay.offLeft = getMouseX(e) - getLEFT(selLay.id)
                    selLay.offTop  = getMouseY(e) - getTOP(selLay.id)
                } 
                return false
            }
            
            div.onmouseup    = function (e)
            {
// 2006-08-04 S.komukai Add (S)
//    alert("save")
				// DB更新処理
			    updateMemoColorAndPostion(div);
			    // 選択メモ保持配列をを初期化
				selectedFloatId = [];           
// 2006-08-04 S.komukai Add (E)
				return false;
			}
       
            div.onclick    = function (e)
            {
            	return false;
            }

            // メモ詳細のウィンドウを表示する
            div.ondblclick    = function (e)
            {
                // 詳細ウィンドウオープン
				subWindow = window.open('./memodetail.php?memoId=' + memoId, 'memoWindow', 'width=690, height=640, scrollbars=yes');

            }

        dragableFloatId[div.id] = div.id;//windowへ登録
        div.index++;
        return div;
    }

    //マウス移動時の動作
    document.onmousemove  = function (e)
    {
        recTimeOffset(e) //rec
        follow(e)
        //return false
    }
    
    //マウスアップ時の動作
    document.onmouseup  = function (e)
    {
        if(!clickElement) return
        selLay=document.getElementById(clickElement);
        
        //ドラッグ中なのにはずれちゃった場合
        follow(e)
        
        //ドラッグ中止
        setDraging2false(selLay);

        //画面内のオフセットleft,top位置をキャプチャ
        if (selLay){
            var sl = parseInt(canvas.scrollLeft,10)
            var st = parseInt(canvas.scrollTop,10)
            selLay.pageOffLeft = getLEFT(selLay.id)-sl
            selLay.pageOffTop  = getTOP(selLay.id)-st
        }

        return false
    }

    //ドラッグ失敗時の類推追跡
    function follow(e)
    {
        if(!clickElement) return
        selLay=document.getElementById(clickElement);

        //マウス位置取得
        var x = getMouseX(e)
        var y = getMouseY(e)

        //xyエラー時の類推追跡用xyセット
        x = (x == -1)? recx2+=recxOffset : x ;
        y = (y == -1)? recy2+=recyOffset : y ;
        if(x == -1 && y == -1)setTimeout('follow('+e+')',100)

        dofollow(x,y)
    }

    //マウス追跡
    function dofollow(x,y)
    {

        if(!clickElement) return
        selLay = document.getElementById(clickElement);
        if(!chkBounds(selLay)){
            return
        }else{
            if(selLay.draging){
                //オフセットを引いて追随
                movetoX = x - selLay.offLeft
                movetoY = y - selLay.offTop

                // 移動距離算出のため移動前の位置プロパティを変数に待避
                baseLayLeft = selLay.style.left; // 移動前のLeft
                baseLayTop = selLay.style.top;   // 移動前のTop

                selLay.style.left = parseInt(movetoX,10) +"px"
                selLay.style.top  = parseInt(movetoY,10) +"px"

                if(selLay.selectingFlag){
                    // 範囲選択されている他のオブジェクトも同時移動
                    for(i in selectedFloatId){ 
                        var selDiv = document.getElementById(selectedFloatId[i]) ;
                        
                        // 選択されているDIVは移動済みのため移動しない
                        if(selDiv.getAttribute("id") == clickElement) continue;

                        if(selDiv.selectingFlag){
                            //オフセットを引いて追随
                            movetoDivLeft = parseInt(selDiv.style.left,10) + (parseInt(selLay.style.left,10) - parseInt(baseLayLeft,10));
                            movetoDivTop = parseInt(selDiv.style.top,10) + (parseInt(selLay.style.top,10) - parseInt(baseLayTop,10));
                            selDiv.style.left = parseInt(movetoDivLeft,10) +"px";
                            selDiv.style.top  = parseInt(movetoDivTop,10) +"px";
                        }
                    }
                }
            }
        }
    }

    //マウス位置を記録
    function recTimeOffset(e)
    {
        if(x == -1 || y == -1)return 
        recx2= recx1
        recy2= recy1
        recx1= getMouseX(e)
        recy1= getMouseY(e)
        recxOffset= recx1 - recx2
        recyOffset= recy1 - recy2
        
    }
    
    //指定領域内かどうかをチェック
    function chkBounds(oj){

      var layName = oj.id
      if(oj.boundEnabled){
      
        //現在位置取得
        var nowX = getLEFT(layName);
        var nowY = getTOP(layName);
        //チェック
        if( 
          nowX >= oj.minX &&
          nowY >= oj.minY &&
          nowX <= oj.maxX &&
          nowY <= oj.maxY
        ){
          return true //指定領域内ならtrue
        } else {
          returnPOS(nowX,nowY,oj)
          return false
        }
      } else {
        return true
      }
    }

    //ドラッグ中止フラグ
    function setDraging2false(selLay){
        selLay.draging   = false ;
        selLay.style.zIndex = zcount++
    }

    //領域内へ戻す
    function returnPOS(nowX,nowY,oj){
      if(nowX < oj.minX) oj.style.left = oj.minX +"px"
      if(nowY < oj.minY) oj.style.top  = oj.minY +"px"
      if(nowX > oj.maxX) oj.style.left = oj.maxX +"px"
      if(nowY > oj.maxY) oj.style.top  = oj.maxY +"px"
    }
    
    //マウスX座標get 
    function getMouseX(e)
    {
        if(document.all)               //e4,e5,e6用
            return canvas.scrollLeft+event.clientX
        else if(document.getElementById)    //n6,n7,m1,o7,s1用
            return e.pageX
    }

    //マウスY座標get 
    function getMouseY(e)
    {
        if(document.all)               //e4,e5,e6用
            return canvas.scrollTop+event.clientY
        else if(document.getElementById)    //n6,n7,m1,o7,s1用
            return e.pageY
    }


    //レイヤ－左辺X座標get 
    function getLEFT(layName){
        //デバック
        //document.getElementById('aaa').innerHTML+=layName+'<BR>'
        
        if(document.all)                    //e4,e5,e6,o6,o7用
            return document.all(layName).style.pixelLeft
        else if(document.getElementById)    //n6,n7,m1,s1用
            return (document.getElementById(layName).style.left!="")
                ?parseInt(document.getElementById(layName).style.left):""
    }

    //レイヤ－上辺Y座標get 
    function getTOP(layName){
        if(document.all)                    //e4,e5,e6,o6,o7用
            return document.all(layName).style.pixelTop
        else if(document.getElementById)    //n6,n7,m1,s1用
            return (document.getElementById(layName).style.top!="")
                    ?parseInt(document.getElementById(layName).style.top):""
    }

    return this.mkDiv(id) ;
        
}



/**
* 関数概要：ドラッグモードイベント開始
* 処理詳細：明示的にドラッグモードイベントを開始させるための関数
*
* @引数： なし
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function startOfDrow(){

    if(rangeSelectFlag) return false;


    // 選択状態の解除
    for(i in dragableFloatId){ 
        var oj = document.getElementById(dragableFloatId[i]) ;
        oj.style.backgroundColor = oj.beforeBackgroundColor;
        oj.style.color = oj.beforeColor;
        oj.selectingFlag = false;
    }

    document.getElementById('DragArea').style.visibility = "visible";
    document.getElementById('DragArea').style.zIndex = 1;
    // 透明レイヤーだと下のレイヤーのイベントを拾ってしまう
    document.body.style.cursor = "crosshair"

    // クリックイベント設定
    if(document.all){    
        // IE
        document.getElementById('DragArea').onmousedown = function (e)
        {
            var offsetX = event.x;
            var offsetY = event.y;

            // MacIEの座標補正
            if (navigator.userAgent.indexOf("Mac") != -1) {
                offsetX += document.body.scrollLeft;
                offsetY += document.body.scrollTop;
                offsetX -= document.getElementById('mapParent').offsetLeft;
                offsetY -= document.getElementById('mapParent').offsetTop;
            }

            _mousedownX = offsetX;
            _mousedownY = offsetY;
            flgDrag = true;
            setStart();

            return false;
        }

        document.getElementById('DragArea').onmousemove = function (e)
        {
            if(!flgDrag) return false;

//            var offsetX = event.offsetX;
//            var offsetY = event.offsetY;
            var offsetX = event.x;
            var offsetY = event.y;

            // MacIEの座標補正
            if (navigator.userAgent.indexOf("Mac") != -1) {
                offsetX += document.body.scrollLeft;
                offsetY += document.body.scrollTop;
                offsetX -= document.getElementById('mapParent').offsetLeft;
                offsetY -= document.getElementById('mapParent').offsetTop;
            }

            _mousemoveX = offsetX;
            _mousemoveY = offsetY;
            setMoveLine();

        }
        
        document.getElementById('DragArea').onmouseup= function (e){
            flgDrag = false;
            document.body.style.cursor = "auto"
            removeRectangle();
        }

    }else if ( (document.layers || document.getElementById) && !document.all) {
        // NN7,Safari,Firefox
        document.getElementById('DragArea').onmousedown= function (e){

//            var offsetX = e.layerX;
//            var offsetY = e.layerY;
            var offsetX = e.pageX - document.getElementById('mapParent').offsetLeft;
            var offsetY = e.pageY - document.getElementById('mapParent').offsetTop;

            _mousedownX = offsetX;
            _mousedownY = offsetY;
            flgDrag = true;
            setStart();

            return false;
        }
        document.getElementById('DragArea').onmousemove= function (e){
            if(!flgDrag) return false;

//            var offsetX = e.layerX;
//            var offsetY = e.layerY;
            var offsetX = e.pageX - document.getElementById('mapParent').offsetLeft;
            var offsetY = e.pageY - document.getElementById('mapParent').offsetTop;

            _mousemoveX = offsetX;
            _mousemoveY = offsetY;
            setMoveLine();
        }
        document.getElementById('DragArea').onmouseup= function (e){
            flgDrag = false;
            document.body.style.cursor = "auto"
            removeRectangle();
        }
    }

}

/**
* 関数概要：ドラッグモードイベント終了
* 処理詳細：明示的にドラッグモードイベントを終了させるための関数
*
* @引数： なし
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function endOfDrow(){

    for(i in dragableFloatId){ 
        var oj = document.getElementById(dragableFloatId[i]) ;
        if(oj.selectingFlag){
            // 元に戻す
            oj.style.backgroundColor = oj.beforeBackgroundColor;
            oj.style.color = oj.beforeColor;
            oj.selectingFlag = false;
        }
    }
    document.getElementById('DragArea').onmousedown= function (e){ return false }
    document.getElementById('DragArea').onmousemove= function (e){ return false }
    document.getElementById('DragArea').onmouseup= function (e){ return false }
    flgDrag = false;
    removeRectangle();
}
    
/**
* 関数概要：onmousedown 選択範囲描画
* 処理詳細：onmousedown 時の選択範囲(開始点)を描画する
*
* @引数： なし
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function setStart()
{
    document.getElementById('RubberBand').style.visibility = "visible";

    if(document.all){    
        // IE
        document.getElementById('RubberBand').style.pixelTop  = _mousedownY;
        document.getElementById('RubberBand').style.pixelLeft = _mousedownX;
        document.getElementById('RubberBand').style.pixelWidth  = 1;
        document.getElementById('RubberBand').style.pixelHeight  = 1;
    }else if ( (document.layers || document.getElementById) && !document.all) {
        // NN7,Safari,Firefox
        document.getElementById('RubberBand').style.top  = _mousedownY;
        document.getElementById('RubberBand').style.left = _mousedownX;
        document.getElementById('RubberBand').style.width  = 1;
        document.getElementById('RubberBand').style.height  = 1;
    }

}

/**
* 関数概要：onmousemove 選択範囲描画
* 処理詳細：onmousemove 時の選択範囲(矩形)を描画する
*
* @引数： なし
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function setMoveLine()
{
    var baseX; // 描画開始点のX座標
    var baseY; // 描画開始点のY座標
    var farX;  // 描画終点のX座標
    var farY;  // 描画終点のY座標

    if(_mousedownX < _mousemoveX){
        if(_mousedownY < _mousemoveY){
            baseX = _mousedownX;
            baseY = _mousedownY;
            farX = _mousemoveX;
            farY = _mousemoveY;
        }else{
            baseX = _mousedownX;
            baseY = _mousemoveY;
            farX = _mousemoveX;
            farY = _mousedownY;
        }
    }else{
        if(_mousedownY < _mousemoveY){
            baseX = _mousemoveX;
            baseY = _mousedownY;
            farX = _mousedownX;
            farY = _mousemoveY;
        }else{
            baseX = _mousemoveX;
            baseY = _mousemoveY;
            farX = _mousedownX;
            farY = _mousedownY;
        }
    }

    if(document.all){    
        // IE
        document.getElementById('RubberBand').style.pixelTop  = baseY;
        document.getElementById('RubberBand').style.pixelLeft = baseX;
        document.getElementById('RubberBand').style.pixelWidth  = farX - baseX;
        document.getElementById('RubberBand').style.pixelHeight  = farY - baseY;
    }else if ( (document.layers || document.getElementById) && !document.all) {
        // NN7,Safari,Firefox
        document.getElementById('RubberBand').style.top  = baseY;
        document.getElementById('RubberBand').style.left = baseX;
        document.getElementById('RubberBand').style.width  = farX - baseX;
        document.getElementById('RubberBand').style.height  = farY - baseY;
    }

    selectedFloatId = new Object();
    for(i in dragableFloatId){ 
        var oj = document.getElementById(dragableFloatId[i]) ;
        if(parseInt(oj.style.top,10) > baseY && parseInt(oj.style.top,10) < farY
            && parseInt(oj.style.left,10) > baseX && parseInt(oj.style.left,10) < farX){
            oj.style.backgroundColor = "#316AC5";
            oj.style.color = "#FFFFFF";
            oj.selectingFlag = true;
            selectedFloatId[i] = oj.getAttribute("id");
        }else{
            // 元に戻す
            oj.style.backgroundColor = oj.beforeBackgroundColor;
            oj.style.color = oj.beforeColor;
            oj.selectingFlag = false;
        }
    }

}

/**
* 関数概要：メモ色反映処理
* 処理詳細：渡されたメモ色へメモ種類を変更する
*
* @引数： colorid     - string カラーID
*         icon        - string アイコンパス
*         colornumber - string 色のRGB値
*         radiotype   - int    色分けラジオボタン状態
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function setColor(colorid, icon, colornumber, radiotype){

    for(i in dragableFloatId){ 
        var oj = document.getElementById(dragableFloatId[i]) ;

        if(oj.selectingFlag){
            htmlString="<img id='icon' src='" + icon + "' width=12 height=12 border=0>";
            cssColorString  = colornumber;

			oj.innerHTML = htmlString + " " + "<span style='display:inline;'>" + oj.getElementsByTagName("span")[0].innerHTML + "</span>";
            oj.style.backgroundColor = cssColorString;
            oj.style.color ="#000000"
            oj.style.padding ="0px";
            oj.style.fontSize = "12px";
            oj.style.whiteSpace = "nowrap"; 

            oj.colorID = colorid;
            oj.beforeBackgroundColor = oj.style.backgroundColor;
            oj.beforeColor = oj.style.color;
            oj.selectingFlag = false;
            
            // メモの表示状態を反映
            imiDisplaySwitch(radiotype, 0, '', '', oj.colorID);

// 2006-08-04 S.komukai Add (S)
//		    alert("save")
			// DB更新処理
		    updateMemoColorAndPostion(oj);
// 2006-08-04 S.komukai Add (E)
        }
    }
// 2006-08-04 S.komukai Add (S)
    // 選択メモ保持配列をを初期化（DB更新完了）
	selectedFloatId = [];           
// 2006-08-04 S.komukai Add (E)
}

// ドラッグエリアの初期化
function removeRectangle(){
    document.getElementById('DragArea').style.visibility = "hidden";
    document.getElementById('DragArea').style.zIndex = -1;
    document.getElementById('RubberBand').style.visibility = "hidden";
    
}

/**
* 関数概要：メモ表示切り替え処理
* 処理詳細：渡された表示モードへメモ表示を変更する
*
* @引数： mode - int (0:リボン 1:ピン 2:非表示)
* @引数： layerId    - string レイヤーID
* @引数： memoTypeId - string メモ種類ID
* @引数： categoryId - ※改良予定
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function memoDisplaySwitch(mode, layerId, memoTypeId){

	switch(mode){
		case 0:	// リボン
			for(i in dragableFloatId){ 
				var oj = document.getElementById(dragableFloatId[i]) ;
				if(oj.layerID != layerId) continue;
				if(oj.memoTypeID != memoTypeId) continue;
				oj.style.display = "inline";
				oj.style.borderWidth = "1px";
				oj.style.borderStyle = "outset";
				oj.DispMode = 0;
				oj.style.backgroundColor = oj.beforeBackgroundColor;
				oj.getElementsByTagName("span")[0].style.display = "inline";
			}
			break;
		case 1:	// ピン
			for(i in dragableFloatId){ 
				var oj = document.getElementById(dragableFloatId[i]) ;
				if(oj.layerID != layerId) continue;
				if(oj.memoTypeID != memoTypeId) continue;
				oj.style.display = "inline";
				oj.style.borderWidth = "0px";
				oj.style.borderStyle = "none";
				oj.DispMode = 1;
				oj.style.backgroundColor = ""
				oj.getElementsByTagName("span")[0].style.display = "none";
			}
			break;
		case 2:	// 非表示
			for(i in dragableFloatId){ 
				var oj = document.getElementById(dragableFloatId[i]) ;
				if(oj.layerID != layerId) continue;
				if(oj.memoTypeID != memoTypeId) continue;
				oj.style.display = "none";
				oj.DispMode = 2;
			}
			break;
		dafault:
			alert("error!!");
	}

}

/**
* 関数概要：ドラッガブルDIVのイベント停止
* 処理詳細：全ドラッガブルDIVのイベントを停止する。
*
* @引数： なし
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function disabledDragableFloat(){

	for(i in dragableFloatId){ 
		var oj = document.getElementById(dragableFloatId[i]) ;
	    oj.onmousedown = function (e){ return false }
	    oj.onmouseout  = function (e){ return false }
	    oj.onmouseup   = function (e){ return false }
	}
}

/**
* 関数概要：スライダーイベント登録
* 処理詳細：スライダーイベントの登録をする
*
* @引数： なし
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function sliderSet(){

    document.getElementById('scrollArrow').style.top = 10;
    document.getElementById('per').innerHTML= "0%"
    
    var div = document.getElementById('scrollBase');

    div.onmousedown = function (e)
    {
        flgSlider = true;

        if(document.all){    
            // IE
            setArrowPosition(event.y);
        }else if ( (document.layers || document.getElementById) && !document.all) {
            // NN7,Safari,Firefox
            setArrowPosition(e.pageY - document.getElementById('scrollBase').offsetTop);
        }
    }

    div.onmousemove = function (e){ 
        if(!flgSlider) return false;

        if(document.all){
            // IE
            setArrowPosition(event.y);
        }else if ( (document.layers || document.getElementById) && !document.all) {
            // NN7,Safari,Firefox
            setArrowPosition(e.pageY - document.getElementById('scrollBase').offsetTop);
        }
    }

    div.onmouseup = function (e){ 
        if(!flgSlider) return false;

        if(document.all){    
            // IE
            setArrowPosition(event.y);
        }else if ( (document.layers || document.getElementById) && !document.all) {
            // NN7,Safari,Firefox
            setArrowPosition(e.pageY - document.getElementById('scrollBase').offsetTop);
        }
        flgSlider = false;
    }

    div.onmouseout = function (e){ 
    }
}

/**
* 関数概要：カーソル位置設定
* 処理詳細：カーソル位置の設定をする
*
* @引数： なし
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function setArrowPosition(arrowTop)
{
    if(arrowTop < 10 || arrowTop > 380) return false;

    if(document.all){    
        // IE
        document.getElementById('scrollArrow').style.pixelTop  = arrowTop;
    }else if ( (document.layers || document.getElementById) && !document.all) {
        // NN7,Safari,Firefox
        document.getElementById('scrollArrow').style.top  = arrowTop;
    }

    document.getElementById('per').innerHTML= 
        Math.floor(((arrowTop - 10) / (parseInt(document.getElementById('scrollBase').style.height, 10) - 30)) * 100) + "%";

}



/**
* 関数概要：Ctrlキー、コマンドキーの押下状態取得
* 処理詳細：Windows(Ctrlキー)、Mcintosh(コマンドキー)の押下状態を取得する
*
* @引数： e:イベント(NN7,Safari,Firefox)
* @戻値： true:押下　false：ニュートラル
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getCtrlKeyStatus(e){

    var osname = navigator.userAgent.toUpperCase();  // OS名
	var keyPushFlag = false;

    if(osname.indexOf("WIN") >= 0){
        if(document.all){
            // IE
            if(event.ctrlKey){
                keyPushFlag = true;
            }else{
                keyPushFlag = false;
            }
        }else if ( (document.layers || document.getElementById) && !document.all) {
            // NN7,Safari,Firefox
            if(e.ctrlKey){
                keyPushFlag = true;
            }else{
                keyPushFlag = false;
            }
        }    
    }else if(osname.indexOf("MAC") >= 0){
        if(document.all){
            // IE
            if(event.metaKey){
                keyPushFlag = true;
            }else{
                keyPushFlag = false;
            }
        }else if ( (document.layers || document.getElementById) && !document.all) {
            // NN7,Safari,Firefox
            if(e.metaKey){
                keyPushFlag = true;
            }else{
                keyPushFlag = false;
            }
        }
    }else{
        alert("This OS is not supported!!");
    }

    return keyPushFlag;
}

/**
* 関数概要：メモ投稿付箋の状態設定
* 処理詳細：onLoadイベント後にメモ投稿付箋の状態設定をする
*
* @引数： なし
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function onLoadSetting(){

	// NowLoading対応
	document.getElementById('nowLoading').style.visibility='hidden';
	document.getElementById('contentsBody').style.visibility='visible';
	
}


/**
* 関数概要：意味空間メモ表示切り替え処理(意味空間専用ロジック)
* 処理詳細：渡された表示モードへメモ表示を変更する
*
* @引数： mode - int (0:リボン 1:ピン 2:非表示)
* @引数： radioType - int (0:色分けラジオボタン 1:メモ種別ラジオボタン)
* @引数： layerId    - レイヤーID
* @引数： memoTypeId - メモ種類ID
* @引数： colorId    - カラーID
* @戻値： なし
*
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function imiDisplaySwitch(mode, radioType, layerId, memoTypeId, colorId){

	// ラジオボタン状態をメモのプロパティへ設定
	if(radioType == 0){
		for(i in dragableFloatId){
			var oj = document.getElementById(dragableFloatId[i]);
			if(oj.colorID == colorId){
				oj.radioColor = mode;
			}
		}
	}else{
		for(i in dragableFloatId){
			var oj = document.getElementById(dragableFloatId[i]);
			if(oj.layerID == layerId && oj.memoTypeID == memoTypeId){
				oj.radioMemoType = mode;
			}
		}
	}

	// メモの表示形式を決定
	for(i in dragableFloatId){ 
		var oj = document.getElementById(dragableFloatId[i]) ;
		if(oj.radioColor == 2 || oj.radioMemoType == 2){
			// 非表示
			if(layerId != ""    && oj.layerID != layerId) continue;
			if(memoTypeId != "" && oj.memoTypeID != memoTypeId) continue;
			if(colorId != ""    && oj.colorID != colorId) continue;
			oj.style.display = "none";
			oj.DispMode = 2;
		}else if(oj.radioColor == 0 && oj.radioMemoType != 2){
			// リボン
			if(layerId != ""    && oj.layerID != layerId) continue;
			if(memoTypeId != "" && oj.memoTypeID != memoTypeId) continue;
			if(colorId != ""    && oj.colorID != colorId) continue;
			oj.style.display = "inline";
			oj.style.borderWidth = "1px";
			oj.style.borderStyle = "outset";
			oj.DispMode = 0;
			oj.style.backgroundColor = oj.beforeBackgroundColor;
			oj.getElementsByTagName("span")[0].style.display = "inline";
		}else if(oj.radioColor == 1 && oj.radioMemoType != 2){
			// ピン
			if(layerId != ""    && oj.layerID != layerId) continue;
			if(memoTypeId != "" && oj.memoTypeID != memoTypeId) continue;
			if(colorId != ""    && oj.colorID != colorId) continue;
			oj.style.display = "inline";
			oj.style.borderWidth = "0px";
			oj.style.borderStyle = "none";
			oj.DispMode = 1;
			oj.style.backgroundColor = ""
			oj.getElementsByTagName("span")[0].style.display = "none";
		}
	}

}

/**
 * 関数概要：メモ情報更新処理(意味空間専用ロジック)
 * 処理詳細：メモ情報の更新処理を行う（AJAX）
 *
 * @引数： (I) currentOj      - カレントのメモオブジェクト
 * @戻値： なし
 * @作成日/作成者：2006/09/01 (IIS)S.Komukai
 * @更新日/更新者：
 * @更新内容：
 */
function updateMemoColorAndPostion(currentOj){

	updateMemoList = new Array();	// UPDATEリスト

	if(rangeSelectFlag == true){
		// 範囲選択の状態の場合
		for(i in selectedFloatId){
			var oj = document.getElementById(selectedFloatId[i]);
			if(oj != currentOj){
				updateMemoList.push(createOneRecord(oj));
			}
		}
		updateMemoList.push(createOneRecord(currentOj));
	}else{
		// 単一選択の場合
		updateMemoList.push(createOneRecord(currentOj));
	}
	
	//postする値の設定(JSON)
	postval = '&jsonData=' + '[' +updateMemoList.toString() + ']'
			+ '&mapext=' + document.kakikoFromMap.mapext.value
			+ '&scale=' + document.kakikoFromMap.scale.value
			+ '&m_num=' + document.kakikoFromMap.m_num.value
			+ '&area_height=' + document.kakikoFromMap.area_height.value
			+ '&area_width=' + document.kakikoFromMap.area_width.value;
//alert(postval);
	//リクエストの送信
	sendRequest(onUpdated, postval, 'POST', './imimemoinfoupdate.php', true, true);

	// サブファンクション（JSON形式で1レコード生成）
	function createOneRecord(oj){
		jsonString = "{\"memoID\":\"" + oj.memoID + "\""
		           + ",\"coordinateX\":\"" + parseInt(oj.style.left,10) + "\""
		           + ",\"coordinateY\":\"" + parseInt(oj.style.top,10) + "\""
		           + ",\"colorID\":\"" + oj.colorID + "\""
		           + ",\"layerID\":\"" + oj.layerID + "\""
		           + ",\"memoTypeID\":\"" + oj.memoTypeID + "\"}";
		
		return jsonString;
	}

	// サブファンクション（リクエストの結果受信）
	function onUpdated(res){}
}