/**
* 処理概要：コンテンツ系画面動作スクリプト
* @パッケージ：-
* @作者：
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/


function submit_url(url){ 

submitFlag = 0;
    if(submitFlag == 0){
        submitFlag = 1;
    }
	document.form.method="post";
	document.form.action=url;
	document.form.submit(); 
}

function submit_url_ex(position, url){ 

submitFlag = 0;
    if(submitFlag == 0){
        submitFlag = 1;
    }
	position.method="post";
	position.action=url;
	position.submit(); 
}

/**
 * 関数概要：SELECTタグ間データ処理
 * 処理詳細：SELECTタグ間にてデータの移動を行う
 *
 * @引数： (I) orgSelect - 移動元のSELECTタグ名
 *      ： (I) cpySelect - 移動先のSELECTタグ名
 * @戻値： なし
 * @作成日/作成者：2006/09/01 (IIS)H.Keta
 * @更新日/更新者：
 * @更新内容：
 */
function OptionMove(orgSelect, cpySelect){

	// 移動元で選択している項目取得
	selIndex = orgSelect.selectedIndex;
	if(selIndex == -1){
		return;
	}

	// 移動する項目情報を取得
	sValue = orgSelect.options[selIndex].value;
	sText = orgSelect.options[selIndex].text;
	
	// 移動先の項目数を取得
	movIndex = cpySelect.options.length;
	
	// 移動先に項目を追加
	cpySelect.options[movIndex] = new Option(sText, sValue);
	// 選択状態にする
	cpySelect.selectedIndex = movIndex;
	
	// 移動元の項目を削除
	orgSelect.options[selIndex] = null;
	// 移動元の項目選択
	if(selIndex == orgSelect.options.length){
		orgSelect.selectedIndex = selIndex-1;
	}else if(selIndex >= 0){
		orgSelect.selectedIndex = selIndex;
	}

}

/**
 * 関数概要：SELECTタグ内項目取得
 * 処理詳細：SELECTタグ内の項目をHIDDEN(配列)として全て出力
 *
 * @引数： (I) myForm   - HIDDEN出力先
 *      ： (I) mySelect - 対象のSELECTタグ名
 *      ： (I) myList   - 出力name
 * @戻値： 正常 : true
 * @作成日/作成者：2006/09/01 (IIS)H.Keta
 * @更新日/更新者：
 * @更新内容：
 */
function addHidden(myForm, mySelect, myList){

	// 項目数を取得
	len = mySelect.options.length;

	// 全ての項目を出力
	for(i = 1; i <= len; i++) {
		input = document.createElement("input");
		input.type = "hidden";
		input.name = myList + "[" + i + "]";
		input.value = String(mySelect.options[i-1].value);
		myForm.appendChild(input);
	}

	return true;
}

/**
 * 関数概要：SELECTタグ内項目取得
 * 処理詳細：右側/左側のSELECTタグ内の項目をHIDDEN(配列)として全て出力
 *
 * @引数： (I) myForm    - HIDDEN出力先
 *      ： (I) mySelectL - 対象のSELECTタグ名(左側)
 *      ： (I) myListL   - 出力name(左側)
 *      ： (I) mySelectR - 対象のSELECTタグ名(右側)
 *      ： (I) myListR   - 出力name(右側)
 * @戻値： 正常 : true
 * @作成日/作成者：2006/09/01 (IIS)H.Keta
 * @更新日/更新者：
 * @更新内容：
 */
function selectOutput(myForm, mySelectL, myListL, mySelectR, myListR){

	addHidden(myForm, mySelectL, myListL);
	addHidden(myForm, mySelectR, myListR);

	return true;
}

/**
 * 関数概要：サブウィンドウの表示(FORMのsubmit無し)
 * 処理詳細：サブウィンドウを表示し中央表示する
 *
 * @引数： (I) url     - 表示するウィンドウへのパス
 *      ： (I) wName   - ウィンドウ名
 *      ： (I) wWidth  - ウィンドウの幅
 *      ： (I) wHeight - ウィンドウの高さ
 * @戻値： なし
 * @作成日/作成者：2006/09/01 (IIS)S.Komukai
 * @更新日/更新者：
 * @更新内容：
 */
function open_subwindow_nonsubmit(url, wName, wWidth, wHeight) {

	// 画面中央の座標をもとめる
	sWidth = screen.availWidth;
	sHeight = screen.availHeight;
	x = (sWidth - wWidth) / 2;
	y = (sHeight - wHeight) / 2;

	// サブウィンドウを表示	
	subWin = window.open(url, wName, "width="+wWidth+",height="+wHeight);

}

/**
 * 関数概要：サブウィンドウの表示
 * 処理詳細：サブウィンドウを表示し中央表示する
 *
 * @引数： (I) url     - 表示するウィンドウへのパス
 *      ： (I) myForm  - form名
 *      ： (I) myName  - ウィンドウ名
 *      ： (I) wHeight - ウィンドウの高さ
 *      ： (I) wWidth  - ウィンドウの幅
 * @戻値： なし
 * @作成日/作成者：2006/09/01 (IIS)H.Keta
 * @更新日/更新者：
 * @更新内容：
 */
function open_subwindow(url, myForm, myName, wWidth, wHeight) {

	// 画面中央の座標をもとめる
	sWidth = screen.availWidth;
	sHeight = screen.availHeight;
	x = (sWidth - wWidth) / 2;
	y = (sHeight - wHeight) / 2;

	// サブウィンドウを表示	
	subWin = window.open("about:blank", myName, "width="+wWidth+",height="+wHeight);
//	subWin.moveTo(x,y);
	myForm.target = myName;
	myForm.method = "post";
	myForm.action = url;
	myForm.submit();

}

/**
 * 関数概要：サブウィンドウを閉じる
 * 処理詳細：サブウィンドウを閉じる
 *
 * @引数： なし
 * @戻値： なし
 * @作成日/作成者：2006/09/01 (IIS)H.Keta
 * @更新日/更新者：
 * @更新内容：
 */
function close_window() {
	window.close();
}

/**
 * 関数概要：サブウィンドウを閉じる
 * 処理詳細：メインウィンドウをリロードしサブウィンドウを閉じる
 *
 *   ※注意 親画面に必ず「postback」という名前のfromタグを作成しておくこと
 *          ここにPOSTする情報を記述しておいて画面を再表示する
 *
 * @引数： なし
 * @戻値： なし
 * @作成日/作成者：2006/09/01 (IIS)H.Keta
 * @更新日/更新者：
 * @更新内容：
 */
function close_reload() {
	opener.document.forms["postback"].submit();
	window.close();
}

/**
 * 関数概要：色見本ウィンドウの表示
 * 処理詳細：色見本ウィンドウを表示し中央表示する
 *
 * @引数： (I) url     - 表示するウィンドウへのパス
 *      ： (I) myForm  - form名
 *      ： (I) myName  - ウィンドウ名
 *      ： (I) wHeight - ウィンドウの高さ
 *      ： (I) wWidth  - ウィンドウの幅
 *      ： (I) fName   - RGB値をセットするform名
 *      ： (I) eName   - RGB値をセットするformのelement名
 * @戻値： なし
 * @作成日/作成者：2006/09/01 (IIS)H.Keta
 * @更新日/更新者：
 * @更新内容：
 */
function open_colorsample(url, myForm, myName, wWidth, wHeight, fName, eName) {

	// 画面中央の座標をもとめる
	sWidth = screen.availWidth;
	sHeight = screen.availHeight;
	x = (sWidth - wWidth) / 2;
	y = (sHeight - wHeight) / 2;

	// RGB値をセットする為の情報(form名)
	input = document.createElement("input");
	input.type = "hidden";
	input.name = "formName";
	input.value = fName;
	myForm.appendChild(input);
	// RGB値をセットする為の情報(element名)
	input = document.createElement("input");
	input.type = "hidden";
	input.name = "elemName";
	input.value = eName;
	myForm.appendChild(input);

	// サブウィンドウを表示
	subWin = window.open("about:blank", myName, "width="+wWidth+",height="+wHeight);
//	subWin.moveTo(x,y);

	// formの状態を保存
	wk_target = myForm.target;
	wk_method = myForm.method;
	wk_action = myForm.action;

	// 新しいウィンドウを表示
	myForm.target = myName;
	myForm.method = "post";
	myForm.action = url;
	myForm.submit();

	// formの状態を復元
	myForm.target = wk_target;
	myForm.method = wk_method;
	myForm.action = wk_action;

}

/**
 * 関数概要：色見本専用処理
 * 処理詳細：[onMouseOrver]時の処理
 *
 * @引数： (I) col     - 対象カラー
 * @戻値： なし
 * @作成日/作成者：2006/09/01 (IIS)H.Keta
 * @更新日/更新者：
 * @更新内容：
 */
function MouseOrver(col){
	document.getElementById("sel_col").color = col; 
	document.getElementById("sel_inf").innerHTML = col;
}

/**
 * 関数概要：色見本専用処理
 * 処理詳細：[onClick]時の処理
 *
 * @引数： (I) col     - 対象カラー
 * @戻値： なし
 * @作成日/作成者：2006/09/01 (IIS)H.Keta
 * @更新日/更新者：
 * @更新内容：
 */
function MouseClick(col){
	fName = document.getElementById("formName").value;
	eName = document.getElementById("elemName").value;
	opener.document.forms[fName].elements[eName].value = col.replace("#","");
	window.close();
}

/**
 * 関数概要：メモ種類アイコン種選択用
 * 処理詳細：[onChange]時の処理
 *
 * @引数： なし
 * @戻値： なし
 * @作成日/作成者：2006/09/01 (IIS)H.Keta
 * @更新日/更新者：
 * @更新内容：
 */
function chengeicon(mySel){
	selIndex = mySel.icontype.selectedIndex;
	if(selIndex==0){
		document.getElementById("selecticon0_ttl").style.display = "inline";
		document.getElementById("selecticon1_ttl").style.display = "none";
		document.getElementById("selecticon0_inp").style.display = "inline";
		document.getElementById("selecticon1_inp").style.display = "none";
	}else{
		document.getElementById("selecticon0_ttl").style.display = "none";
		document.getElementById("selecticon1_ttl").style.display = "inline";
		document.getElementById("selecticon0_inp").style.display = "none";
		document.getElementById("selecticon1_inp").style.display = "inline";
	}
}

/**
 * 関数概要：確認ダイアログ付きSubmit処理
 * 処理詳細：確認ダイアログを表示し、OKの場合Submitを実行する
 *
 * @引数： (I) position     - formタグ
 *         (I) url          - Submit action
 *         (I) CheckMessage - 確認ダイアログに表示するメッセージ
 * @戻値： なし
 * @作成日/作成者：2006/09/01 (IIS)H.Keta
 * @更新日/更新者：
 * @更新内容：
 */
function ChkDlgSubmit(position, url, CheckMessage){

	if(window.confirm(CheckMessage)==false){ return(0); }

	submitFlag = 0;
    if(submitFlag == 0){
        submitFlag = 1;
    }

	position.method="post";
	position.action=url;
	position.submit(); 

}

/* 二重送信判定フラグ初期値 */
sent = false;

/**
 * 関数概要：二重送信防止処理
 * 処理詳細：Submit時の二重送信を防止する
 *
 * @引数： なし
 * @戻値： なし
 * @作成日/作成者：2006/09/01 (IIS)H.Keta
 * @更新日/更新者：
 * @更新内容：
 */
function send_check(){
	if(sent){
		return false;
	}else{
		sent = true;
		return true;
	}
}

/**
 * 関数概要：ファイルアップロードウィンドウの表示
 * 処理詳細：ファイルアップロードウィンドウの表示
 *
 * @引数： (I) url     - 表示するウィンドウへのパス
 *      ： (I) myForm  - form名
 *      ： (I) myName  - ウィンドウ名
 *      ： (I) wHeight - ウィンドウの高さ
 *      ： (I) wWidth  - ウィンドウの幅
 *      ： (I) fName   - 値をセットするform名
 *      ： (I) mapno   - 値をセットする地図番号(0はGISとして使用)
 * @戻値： なし
 * @作成日/作成者：2006/09/01 (IIS)H.Keta
 * @更新日/更新者：
 * @更新内容：
 */
function open_fileupload(url, myForm, myName, wWidth, wHeight, fName, mapno) {

	// 値をセットする為の情報(form名)
	input = document.createElement("input");
	input.type = "hidden";
	input.name = "formName";
	input.value = fName;
	myForm.appendChild(input);
	// 値をセットする為の情報(地図番号)
	input = document.createElement("input");
	input.type = "hidden";
	input.name = "mapNo";
	input.value = mapno;
	myForm.appendChild(input);

	// サブウィンドウを表示
	subWin = window.open("about:blank", myName, "width="+wWidth+",height="+wHeight);

	// formの状態を保存
	wk_target = myForm.target;
	wk_method = myForm.method;
	wk_action = myForm.action;

	// 新しいウィンドウを表示
	myForm.target = myName;
	myForm.method = "post";
	myForm.action = url;
	myForm.submit();

	// formの状態を復元
	myForm.target = wk_target;
	myForm.method = wk_method;
	myForm.action = wk_action;

}
