<?php
//require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");    // ユーザ用設定ファイル
//require_once("kakikomap/require/common/xxxxxx_settingRead.php");    // ユーザ用設定ファイル
require_once("class/db/dbaccess/ImiCalcMemoPositionAccess.class.php");
require_once("class/db/dbaccess/ImiCalcMemoPositionAccess.class.php");
require_once("kakikomap/ImiDef.php");                 // 意味空間定数


/**
* ImiCalcPosition.class.php 意味空間用メモ位置算出クラス
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS) N.Soma
* @作成日/作成者：2006/09/01 (IIS)N.Soma
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
class ImiCalcPosition {

	//メンバ変数
	var $mapType;		//マップタイプ		
	var $directryname ;//ディレクトリ名
	
	var $positionMinX;	//メモ位置X座標最小
	var $positionMinY;	//メモ位置Y座標最小
	var $positionMaxX;	//メモ位置X座標最大
	var $positionMaxY;	//メモ位置Y座標最大
	var $lengthX;		//X座標の最大メモとX座標の最小メモの距離
	var $lengthY;		//X座標の最大メモとX座標の最小メモの距離
	var $mapWidth;		//地図のX方向のピクセル数
	var $mapHeight;		//地図のY方向のピクセル数
	
	var $pixPerLengthX;	//X方向の長さ１あたりのピクセル数
	var $pixPerLengthY;	//Y方向の長さ１あたりのピクセル数
	
	var $maxRibbonNumForY; //メモを整列配置する時の、Y方向に並べるリボンの最大数
	
	var $imiMemoPositionX;	//X方向の意味空間用メモ算出結果
	var $imiMemoPositionY;	//Y方向の意味空間用メモ算出結果
	
	
	/**
	 * コンストラクタ
	 */
    function ImiCalcPosition($directryname) {
		$this->positionMinX = 0.0;
		$this->positionMinY = 0.0;
		$this->positionMaxX = 0.0;
		$this->positionMaxY = 0.0;
		$this->lengthX = 0.0;
		$this->lengthY = 0.0;
		$this->pixPerLengthX = 0;
		$this->pixPerLengthY = 0;
		$this->directryname = $directryname;
		// ユーザ用設定ファイル
		require_once("kakikomap/require/common/".$this->directryname."_settingRead.php");    
		$this->mapWidth = MAP_WIDTH;
		$this->mapHeight = MAP_HEIGHT;
		$this->mapType = MAP_TYPE;
		
    }
    
   /**
    * 関数名：算出用情報の設定
    * @引数：(I) $db    		- DBオブジェクト
    *        (I) $userId	- 対象意味空間ID
    *        (I) $imiLayerDataList[]	- 意味空間使用レイヤーデータオブジェクト配列    
    * @戻値：$bool		- true/false
	* @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */	 
	function initCalcBaseInfo($db, $userId, $imiLayerDataList){

		// レイヤー状態フラグ
        $status_array = array(KAKIKOMAP_STATUSFLG_ON);
		//対象データselect
		$table_access = new ImiCalcMemoPositionAccess($this->directryname);
		$rtn = $table_access->selectMaxMinMemoPosition($db, $userId, $status_array, $imiLayerDataList);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error("意味空間メモ位置算出設定に失敗しました。", E_USER_ERROR);
			return false;
		}
		$retdata = $table_access->getOneData();
		if (is_null($retdata->getMaxX()) == true || is_null($retdata->getMinX()) == true ||
			is_null($retdata->getMaxY()) == true || is_null($retdata->getMinY()) == true){ 		
			return false;
		}
		$this->positionMinX = $retdata->getMinX();
		$this->positionMinY = $retdata->getMinY();
		$this->positionMaxX = $retdata->getMaxX();
		$this->positionMaxY = $retdata->getMaxY();

		// それぞれの軸の長さを算出
		$this->lengthX = $this->positionMaxX - $this->positionMinX;
		$this->lengthY = $this->positionMaxY - $this->positionMinY;

		
		// 長さ1あたりのピクセル数を算出
		if ($this->lengthX != 0){
			$this->pixPerLengthX = (MAP_WIDTH - IMI_CALC_MARGIN * 2) / $this->lengthX;	//左右の余白を除いて算出			
		}else{
			//ここに来るのはX軸が同一あるいはメモがひとつしかない場合
			$this->pixPerLengthX = 0;
		}
		if ($this->lengthY != 0){		
			$this->pixPerLengthY = (MAP_HEIGHT- IMI_CALC_MARGIN * 2) / $this->lengthY;//上下の余白を除いて算出
		}else{
			//ここに来るのはY軸が同一あるいはメモがひとつしかない場合
			$this->pixPerLengthY = 0;			
		}
			
		// メモを整列配置する時の、Y方向に並べられるメモの最大数を算出
		$this->maxRibbonNumForY = (int)(($this->mapHeight - IMI_CALC_MARGIN * 2) / IMI_CALC_LINE_MARGIN) ;//上下の余白を考慮
		return true;
	}    


   /**
    * 関数名：意味空間メモ座標算出
    * @引数：(I) $db    - DBオブジェクト
	*        (I) $db    - DBオブジェクト
    * @戻値：$bool		- true/false
	* @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */	 
	function calcImiMemoPosition($positionX, $positionY){
		//最小の座標を基準とする
		$baseX = $positionX - $this->positionMinX;
		//マップの種別により、Y方向の基準を入れ替える
		if ($this->mapType == KAKIKOMAP_USEGIS_ON){
			$baseY = $this->positionMaxY - $positionY;
		}else{
			$baseY = $positionY - $this->positionMinY;		
		}

		//意味空間メモ座標計算
		if ($this->pixPerLengthX != 0){
			$this->imiMemoPositionX = $baseX * $this->pixPerLengthX + IMI_CALC_MARGIN;	//X方向の余白を考慮		
		}else{
			//ここに来るのはX軸が同一あるいはメモがひとつしかない場合
			//表示エリアの真ん中の座標とする
			$this->imiMemoPositionX = $this->mapWidth / 2;
		}
		if ($this->pixPerLengthY != 0){
			$this->imiMemoPositionY = $baseY * $this->pixPerLengthY + IMI_CALC_MARGIN;	//Y方向の余白を考慮
		}else{
			//ここに来るのはY軸が同一あるいはメモがひとつしかない場合
			//表示エリアの真ん中の座標とする
			$this->imiMemoPositionY = $this->mapHeight / 2;
		}
		return ;
	}    

 
    //GETTER
    /**
    * 関数名：意味空間用メモ位置X座標取得
    * @引数：なし
	* @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function getImiMemoPositionX(){
        return $this->imiMemoPositionX;
    }

    /**
    * 関数名：意味空間用メモ位置Y座標取得
    * @引数：なし
	* @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function getImiMemoPositionY(){
        return $this->imiMemoPositionY;
    }

    /**
    * 関数名：メモを整列配置する時の、Y方向に並べるリボンの最大数の取得
    * @引数：なし
	* @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function getMaxRibbonNumForY(){
        return $this->maxRibbonNumForY;
    }

}
?>