<?php
require_once("kakikomap/ImiDef.php");                 // 意味空間定数
/**
* ImiMapController.class.php 意味空間座標コントロールクラス
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
class ImiMapController {

    var $_minX;		// minx
    var $_minY;		// miny
    var $_maxX;		// maxx
    var $_maxY;		// maxy
    
    var $_width;	// width
    var $_height;	// height
    
    var $_mapNumber;	// マップNO

    var $_moveDistance;	// 地図の移動距離
    var $_moveX;		// X方向への移動距離
    var $_moveY;		// Y方向への移動距離

	/**
	* 関数概要：コンストラクタ
	* 処理詳細：インスタンスを生成し、初期化します。
	*
    * @引数： (I) $_minX   - float 地図左下のX座標
    *  　　： (I) $_minY   - float 地図左下のY座標
    *  　　： (I) $_maxX   - float 地図左下のX座標
    *  　　： (I) $_maxY   - float 地図左下のY座標
	* @戻値： なし
	* @作成日/作成者：2006/09/01 (IIS)S.Komukai
	* @更新日/更新者：
	* @更新内容：
	*/
    function ImiMapController($_minX, $_minY, $_maxX, $_maxY, $_width, $_height) {
		$this->_minX   = $_minX;
		$this->_minY   = $_minY;
		$this->_maxX   = $_maxX;
		$this->_maxY   = $_maxY;

		$this->_width  = $_width;
		$this->_height = $_height;

		// 移動画面数
		$this->_moveDistance = 1;
		
		// 移動距離を取得
		$this->_moveX = ($this->_maxX - $this->_minX) * $this->_moveDistance;
		$this->_moveY = ($this->_maxY - $this->_minY) * $this->_moveDistance;
    }

	/**
	 * getter メソッド群
	 */	
	function get_minX(){
		return $this->_minX;
	}
	function get_minY(){
		return $this->_minY;
	}
	function get_maxX(){
		return $this->_maxX;
	}
	function get_maxY(){
		return $this->_maxY;
	}

	/**
	 * setter メソッド群
	 */	
	function set_minX($_minX){
		$this->_minX = $_minX;
	}
	function set_minY($_minY){
		$this->_minY = $_minY;
	}
	function set_maxX($_maxX){
		$this->_maxX = $_maxX;
	}
	function set_maxY($_maxY){
		$this->_maxY = $_maxY;
	}
	function set_mapNumber($_mapNumber){
		$this->_mapNumber = $_mapNumber;
	}
    
    /** MapServer MAPEXT引数取得 */
    function get_mapextString(){
		return null;
	}
	
    /** 左上矢印 MAPEXT引数取得 */
    function get_mapextLeftUpString(){
    	$mapext = "&mapext="
    		.($this->_minX - $this->_moveX)."+".($this->_minY - $this->_moveY)."+"
    		.($this->_maxX - $this->_moveX)."+".($this->_maxY - $this->_moveY);
    	return($mapext);
    }
    /** 上矢印 MAPEXT引数取得 */
    function get_mapextUpString(){
		$mapext = "&mapext="
			.$this->_minX."+".($this->_minY - $this->_moveY)."+"
			.$this->_maxX."+".($this->_maxY - $this->_moveY);
    	return($mapext);
	}
    /** 右上矢印 MAPEXT引数取得 */
    function get_mapextRightUpString(){
    	$mapext = "&mapext="
    		.($this->_minX + $this->_moveX)."+".($this->_minY - $this->_moveY)."+"
    		.($this->_maxX + $this->_moveX)."+".($this->_maxY - $this->_moveY);
    	return($mapext);
	}
    /** 左矢印 MAPEXT引数取得 */
    function get_mapextLeftString(){
		$mapext = "&mapext="
			.($this->_minX - $this->_moveX)."+".($this->_minY)."+"
			.($this->_maxX - $this->_moveX)."+".($this->_maxY);
    	return($mapext);
	}
    /** 右矢印 MAPEXT引数取得 */
    function get_mapextRightString(){
		$mapext = "&mapext="
			.($this->_minX + $this->_moveX)."+".($this->_minY)."+"
			.($this->_maxX + $this->_moveX)."+".($this->_maxY);
    	return($mapext);
	}
    /** 左下矢印 MAPEXT引数取得 */
    function get_mapextLeftDownString(){
    	$mapext = "&mapext="
    		.($this->_minX - $this->_moveX)."+".($this->_minY + $this->_moveY)."+"
    		.($this->_maxX - $this->_moveX)."+".($this->_maxY + $this->_moveY);
    	return($mapext);
	}
    /** 下矢印 MAPEXT引数取得 */
    function get_mapextDownString(){
    	$mapext = "&mapext="
    		.$this->_minX."+".($this->_minY + $this->_moveY)."+"
    		.$this->_maxX."+".($this->_maxY + $this->_moveY);
    	return($mapext);
	}
    /** 右下矢印 MAPEXT引数取得 */
    function get_mapextRightDownString(){
    	$mapext = "&mapext="
    		.($this->_minX + $this->_moveX)."+".($this->_minY + $this->_moveY)."+"
    		.($this->_maxX + $this->_moveX)."+".($this->_maxY + $this->_moveY);
    	return($mapext);
	}

	/**
	* 関数概要：地図切り替えリンク生成(意味空間マップ)
	* 処理詳細：意味空間マップの地図切り替えリンクを生成します。
	*
    * @引数： (I) $scale        - int 現在表示されている地図のスケール
    *         (I) $addGETString - 追加するGETString文字列(省略可)
	* @戻値： (O) 地図の範囲リンクの配列
	* @作成日/作成者：2006/09/01 (IIS)S.Komukai
	* @更新日/更新者：
	* @更新内容：
	*/	 
    function get_mapextRangeArray($scale, $addGETString=""){

		$scaleString = array();

		// 全体図
		$oneData = null;
		$oneData['mapNumber'] = "0";
		if($scale == "0"){
			$oneData['getString'] = "";
		}else{
			$oneData['getString'] = $_SERVER['PHP_SELF']."?mode=imi&mapext=0+0+".$this->_width."+".$this->_height."&scale=0&m_num=1".$addGETString;
		}
		array_push($scaleString, $oneData);
		
		// 拡大図
		$oneData = null;
		$oneData['mapNumber'] = "1";
		if($scale == "1"){
			$oneData['getString'] = "";
		}else{
			$oneData['getString'] = $_SERVER['PHP_SELF']."?mode=imi&mapext=0+0+".($this->_width / 2)."+".($this->_height / 2)."&scale=1&m_num=1".$addGETString;
		}
		array_push($scaleString, $oneData);
//print_r($scaleString);

		return $scaleString; 
	}

	/**
	* 関数概要：意味空間座標算出
	* 処理詳細：Javascriptの座標から意味空間のX,Y座標を算出
	*
    * @引数： (I) $longitude - float JavascriptのX座標
    *  　　： (I) $latitude  - float JavascriptのY座標
    * @引数： (I) $scale     - int 現在表示されている地図のスケール
	* @戻値： (O) 経度、緯度の配列
	* @作成日/作成者：2006/09/01 (IIS)S.Komukai
	* @更新日/更新者：
	* @更新内容：
	*/
    function get_changeCoordinatesFromJs($js_x, $js_y){

		$coordinates = array();		// x, y
		
		// 表示座標の距離を算出
		$dispX = $this->_maxX - $this->_minX;
		$dispY = $this->_maxY - $this->_minY;
		
		$updateX = $this->_minX + ($dispX * ( $js_x / $this->_width));
		$updateY = $this->_minY + ($dispY * ( $js_y / $this->_height));
		// 編集可能座標外の場合は座標補正する
		if($updateX < (0 + IMI_CALC_MARGIN)){
			$updateX = IMI_CALC_MARGIN;
		}else if($updateX > ($this->_width - IMI_CALC_MARGIN)){
			$updateX = $this->_width - IMI_CALC_MARGIN;
		}
		if($updateY < (0 + IMI_CALC_MARGIN)){
			$updateY = IMI_CALC_MARGIN;
		}else if($updateY > ($this->_height - IMI_CALC_MARGIN)){
			$updateY = $this->_height - IMI_CALC_MARGIN;
		}

		array_push($coordinates, $updateX);
		array_push($coordinates, $updateY);

		return($coordinates);
    }
    
	/**
	* 関数概要：JavaScript座標算出
	* 処理詳細：経度・緯度(またはメートル)の座標からJavaScriptの座標を算出
	*
    * @引数： (I) $x   - float メモのX座標
    *  　　： (I) $y    - float メモのY座標
	* @戻値： (O) JavascriptのX座標、Y座標の配列
	* @作成日/作成者：2006/09/01 (IIS)S.Komukai
	* @更新日/更新者：
	* @更新内容：
	*/
	function get_JsFromCoordinates($x, $y){

		$coordinates = array();		
		
		// 表示Map座標の距離を算出
		$dispX = $this->_maxX - $this->_minX;
		$dispY = $this->_maxY - $this->_minY;
		
		// 非GIS版
		$memoX = $x - $this->_minX;
		$memoY = $y - $this->_minY;
    		
		// JavaScriptでの座標（X,Y）をそれぞれ算出し配列へ
		array_push($coordinates, round(($this->_width * $memoX ) / $dispX));
		array_push($coordinates, round(($this->_height * $memoY ) / $dispY));

		return($coordinates);
	}

}
?>
