<?php

/**
* MapController.class.php 地図座標コントロールクラス
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
class MapController {

    var $_minX;		// minx
    var $_minY;		// miny
    var $_maxX;		// maxx
    var $_maxY;		// maxy
	var $mapType;	// maptype
    
    var $_moveDistance;	// 地図の移動距離
    var $_moveX;		// X方向への移動距離
    var $_moveY;		// Y方向への移動距離
    var $_centerX;		// 地図の中心のX座標
    var $_centerY;		// 地図の中心のY座標

	var $_kakikoPath = array();	// カキコエンジン用Directory配列
	var $_kakikoName = array();	// カキコエンジン用表示名称配列
	var $_kakikoPixel = array();	// カキコエンジン用Pixel数配列
	var $_kakikoCnt;				// カキコエンジン用地図イメージ数

	/**
	* 関数概要：コンストラクタ
	* 処理詳細：インスタンスを生成し、初期化します。
	*
    * @引数： (I) $_minX   - float 地図左下のX座標
    *  　　： (I) $_minY   - float 地図左下のY座標
    *  　　： (I) $_maxX   - float 地図左下のX座標
    *  　　： (I) $_maxY   - float 地図左下のY座標
    *  　　： (I) $mapType - int   使用地図タイプ (0:GIS 1:IMG)
	* @戻値： なし
	* @作成日/作成者：2006/09/01 (IIS)S.Komukai
	* @更新日/更新者：
	* @更新内容：
	*/
    function MapController($_minX, $_minY, $_maxX, $_maxY, $mapType) {

		$this->_minX   = $_minX;
		$this->_minY   = $_minY;
		$this->_maxX   = $_maxX;
		$this->_maxY   = $_maxY;
		$this->mapType = $mapType;
		
		// 地図の移動距離
		$this->_moveDistance = MAP_MOVE;


		// 移動距離を取得
		$this->_moveX = ($this->_maxX - $this->_minX) * $this->_moveDistance;
		$this->_moveY = ($this->_maxY - $this->_minY) * $this->_moveDistance;

		// カキコエンジン設定値取得
		if ($this->mapType == KAKIKOMAP_USEGIS_OFF){
			$this->_kakikoPath = explode(",", KAKIKO_DIR_PATH);
			$this->_kakikoName = explode(",", KAKIKO_LINK_NAME);
			$this->_kakikoPixel = explode(",", KAKIKO_MOVE_PIXEL);
			$this->_kakikoCnt = count($this->_kakikoPath);
		}

		// 地図の中心座標を取得
		$this->_centerX = $this->_minX + (($this->_maxX - $this->_minX) / 2);
		$this->_centerY = $this->_minY + (($this->_maxY - $this->_minY) / 2);
/*
print("_centerX".$this->_centerX."<br>");
print("_centerY".$this->_centerY."<br>");
*/

    }

	/**
	 * getter メソッド群
	 */	
	function get_minX(){
		return $this->_minX;
	}
	function get_minY(){
		return $this->_minY;
	}
	function get_maxX(){
		return $this->_maxX;
	}
	function get_maxY(){
		return $this->_maxY;
	}

	/**
	 * setter メソッド群
	 */	
	function set_minX($_minX){
		$this->_minX = $_minX;
	}
	function set_minY($_minY){
		$this->_minY = $_minY;
	}
	function set_maxX($_maxX){
		$this->_maxX = $_maxX;
	}
	function set_maxY($_maxY){
		$this->_maxY = $_maxY;
	}
    
    /** MapServer MAPEXT引数取得 */
    function get_mapextString(){
    	$mapext = "&mapext="
			.$this->_minX."+".$this->_minY."+"
			.$this->_maxX."+".$this->_maxY;
    	return($mapext);
	}
    /** 左上矢印 MAPEXT引数取得 */
    function get_mapextLeftUpString(){
		$mapext = "";
    	if($this->mapType == 0){
	    	$mapext = "&mapext="
	    		.($this->_minX - $this->_moveX)."+".($this->_minY + $this->_moveY)."+"
	    		.($this->_maxX - $this->_moveX)."+".($this->_maxY + $this->_moveY);
    	}else{
		    	$mapext = "&mapext="
		    		.($this->_minX - $this->_moveX)."+".($this->_minY - $this->_moveY)."+"
		    		.($this->_maxX - $this->_moveX)."+".($this->_maxY - $this->_moveY);
    	}
    	return($mapext);
    }
    /** 上矢印 MAPEXT引数取得 */
    function get_mapextUpString(){
		$mapext = "";
    	if($this->mapType == 0){
	    	$mapext = "&mapext="
	    		.$this->_minX."+".($this->_minY + $this->_moveY)."+"
	    		.$this->_maxX."+".($this->_maxY + $this->_moveY);
    	}else{
			$mapext = "&mapext="
				.$this->_minX."+".($this->_minY - $this->_moveY)."+"
				.$this->_maxX."+".($this->_maxY - $this->_moveY);
    	}
    	return($mapext);
	}
    /** 右上矢印 MAPEXT引数取得 */
    function get_mapextRightUpString(){
		$mapext = "";
    	if($this->mapType == 0){
	    	$mapext = "&mapext="
	    		.($this->_minX + $this->_moveX)."+".($this->_minY + $this->_moveY)."+"
	    		.($this->_maxX + $this->_moveX)."+".($this->_maxY + $this->_moveY);
    	}else{
	    	$mapext = "&mapext="
	    		.($this->_minX + $this->_moveX)."+".($this->_minY - $this->_moveY)."+"
	    		.($this->_maxX + $this->_moveX)."+".($this->_maxY - $this->_moveY);
    	}
    	return($mapext);
	}
    /** 左矢印 MAPEXT引数取得 */
    function get_mapextLeftString(){
		$mapext = "&mapext="
			.($this->_minX - $this->_moveX)."+".($this->_minY)."+"
			.($this->_maxX - $this->_moveX)."+".($this->_maxY);
    	return($mapext);
	}
    /** 右矢印 MAPEXT引数取得 */
    function get_mapextRightString(){
		$mapext = "&mapext="
			.($this->_minX + $this->_moveX)."+".($this->_minY)."+"
			.($this->_maxX + $this->_moveX)."+".($this->_maxY);
    	return($mapext);
	}
    /** 左下矢印 MAPEXT引数取得 */
    function get_mapextLeftDownString(){
		$mapext = "";
    	if($this->mapType == 0){
	    	$mapext = "&mapext="
	    		.($this->_minX - $this->_moveX)."+".($this->_minY - $this->_moveY)."+"
	    		.($this->_maxX - $this->_moveX)."+".($this->_maxY - $this->_moveY);
    	}else{
	    	$mapext = "&mapext="
	    		.($this->_minX - $this->_moveX)."+".($this->_minY + $this->_moveY)."+"
	    		.($this->_maxX - $this->_moveX)."+".($this->_maxY + $this->_moveY);
    	}
    	return($mapext);
	}
    /** 下矢印 MAPEXT引数取得 */
    function get_mapextDownString(){
		$mapext = "";
    	if($this->mapType == 0){
			$mapext = "&mapext="
				.$this->_minX."+".($this->_minY - $this->_moveY)."+"
				.$this->_maxX."+".($this->_maxY - $this->_moveY);
    	}else{
	    	$mapext = "&mapext="
	    		.$this->_minX."+".($this->_minY + $this->_moveY)."+"
	    		.$this->_maxX."+".($this->_maxY + $this->_moveY);
    	}
    	return($mapext);
	}
    /** 右下矢印 MAPEXT引数取得 */
    function get_mapextRightDownString(){
		$mapext = "";
    	if($this->mapType == 0){
	    	$mapext = "&mapext="
	    		.($this->_minX + $this->_moveX)."+".($this->_minY - $this->_moveY)."+"
	    		.($this->_maxX + $this->_moveX)."+".($this->_maxY - $this->_moveY);
    	}else{
	    	$mapext = "&mapext="
	    		.($this->_minX + $this->_moveX)."+".($this->_minY + $this->_moveY)."+"
	    		.($this->_maxX + $this->_moveX)."+".($this->_maxY + $this->_moveY);
    	}
    	return($mapext);
	}


	/**
	 * 地図の範囲切り替えリンクの配列
	 */
    function get_mapextRangeArray($scale, $addGETString=""){
    	
		$scaleString = array();
		
    	if($this->mapType == 0){
    		// GIS版
			$scaleString = $this->create_mapextRangeArrayGIS($scale, $addGETString);
    	}else{
			// 非GIS版
			$scaleString = $this->create_mapextRangeArrayNonGIS($scale , $addGETString);
    	}

    	return($scaleString);
	}

	/**
	* 関数概要：経度・緯度(またはメートル)座標算出
	* 処理詳細：Javascriptの座標から緯度・経度(またはメートル)の座標を算出
	*
    * @引数： (I) $area_width  - int 地図表示エリアのwidth
    *  　　： (I) $area_height - int 地図表示エリアのheight
    *  　　： (I) $longitude   - float JavascriptのX座標
    *  　　： (I) $latitude    - float JavascriptのY座標
	* @戻値： (O) 経度、緯度の配列
	* @作成日/作成者：2006/09/01 (IIS)S.Komukai
	* @更新日/更新者：
	* @更新内容：
	*/
    function get_changeCoordinatesFromJs($area_width, $area_height, $js_x, $js_y){

		$coordinates = array();		// x, y
		
		// 表示座標の距離を算出
		$dispX = $this->_maxX - $this->_minX;
		$dispY = $this->_maxY - $this->_minY;

    	if($this->mapType == 0){
    		// GIS版
			array_push($coordinates, $this->_minX + ($dispX * ( $js_x / $area_width)));
			array_push($coordinates, $this->_maxY - ($dispY * ( $js_y / $area_height)));
    	}else{
			// 非GIS版
			array_push($coordinates, $this->_minX + ($dispX * ( $js_x / $area_width)));
			array_push($coordinates, $this->_minY + ($dispY * ( $js_y / $area_height)));
    	}
		
		return($coordinates);
	
    }
    
	/**
	* 関数概要：JavaScript座標算出
	* 処理詳細：経度・緯度(またはメートル)の座標からJavaScriptの座標を算出
	*
    * @引数： (I) $area_width  - int 地図表示エリアのwidth
    *  　　： (I) $area_height - int 地図表示エリアのheight
    *  　　： (I) $longitude   - float メモの経度（またはメートルのX座標）
    *  　　： (I) $latitude    - float メモの緯度（またはメートルのY座標）
	* @戻値： (O) JavascriptのX座標、Y座標の配列
	* @作成日/作成者：2006/09/01 (IIS)S.Komukai
	* @更新日/更新者：
	* @更新内容：
	*/
	function get_JsFromCoordinates($area_width, $area_height, $longitude, $latitude){

		$coordinates = array();		
		
		// 表示Map座標の距離を算出(緯度・経度 or メートル基準)
		$dispX = $this->_maxX - $this->_minX;
		$dispY = $this->_maxY - $this->_minY;
		
		// 画面左上からのメモまでの距離を算出（JavaScriptの座標系に対応するため）
    	if($this->mapType == 0){
    		// GIS版
			$memoX = $longitude - $this->_minX;
			$memoY = $this->_maxY - $latitude;
    	}else{
			// 非GIS版
			$memoX = $longitude - $this->_minX;
			$memoY = $latitude  - $this->_minY;
    		
    	}

		// JavaScriptでの座標（X,Y）をそれぞれ算出し配列へ
		array_push($coordinates, round(($area_width * $memoX ) / $dispX));
		array_push($coordinates, round(($area_height * $memoY ) / $dispY));

		return($coordinates);
	}


	/**
	* 関数概要：地図切り替えリンク生成(GIS)
	* 処理詳細：GIS版の地図切り替えリンクを生成します。
	*
    * @引数： (I) $scale  - int 現在表示されている地図のスケール
    *         (I) $addGETString - 追加するGETString文字列(省略可)
	* @戻値： (O) 地図の範囲リンクの配列
	* @作成日/作成者：2006/09/01 (IIS)S.Komukai
	* @更新日/更新者：
	* @更新内容：
	*/
    function create_mapextRangeArrayGIS($scale, $addGETString=""){
    	
    	$scaleString = array();
		
		$crateX = 0;
		$crateY = 0;

    	$base_minX = 0;		// 計算基準とするminX
    	$base_minY = 0;		// 計算基準とするminy
    	$base_maxX = 0;		// 計算基準とするmaxx
    	$base_maxY = 0;		// 計算基準とするmaxy
		
		$calc_scale = "";
		if($scale == ""){
			$calc_scale = 1;
		}else{
			$calc_scale = $scale;
		}

		// スケール計算時に基準となるX方向の距離
	    $DistanceX = $this->_centerX - $this->_minX;	
	    // スケール計算時に基準となるY方向の距離
	    $DistanceY = $this->_centerY - $this->_minY;	
		$dispString ="";

		// 地図範囲リンク算出のベースとなる座標
		$base_minX = $this->_centerX - $DistanceX;
		$base_minY = $this->_centerY - $DistanceY;
		$base_maxX = $this->_centerX + $DistanceX;
		$base_maxY = $this->_centerY + $DistanceY;
		
		for($i=0; $i<3; $i++){

			$mapext = "&scale=".$i."&mapext=";
			// 地図生成基準となる左下の座標を求める
			switch ($i){
				case 0:
					// 1/2
					$crateX = $this->_centerX - (($this->_centerX - $base_minX) * 2);
					$crateY = $this->_centerY - (($this->_centerY - $base_minY) * 2);
			    	$mapext = $mapext.$crateX."+".$crateY."+"
			    		.($crateX +(($base_maxX - $base_minX) * 2)."+".($crateY + (($base_maxY - $base_minY) * 2)));
			    	$dispString = "－";
					break;
				case 1:
					// 1
					$crateX = $this->_centerX - ($this->_centerX - $base_minX);
					$crateY = $this->_centerY - ($this->_centerY - $base_minY);
			    	$mapext = $mapext.$crateX."+".$crateY."+"
			    		.($crateX +($base_maxX - $base_minX)."+".($crateY + ($base_maxY - $base_minY)));
			    	$dispString = "初期表示";
					break;
				case 2:
					// 2
					$crateX = $this->_centerX - ($this->_centerX - $base_minX) / 2;
					$crateY = $this->_centerY - ($this->_centerY - $base_minY) / 2;
			    	$mapext = $mapext.$crateX."+".$crateY."+"
			    		.($crateX +(($base_maxX - $base_minX) / 2)."+".($crateY + (($base_maxY - $base_minY) / 2)));
			    	$dispString = "＋";
					break;
				default:
			}

			$link = "";
			if($i==1){
				$link = "<a onclick=\"mapArrowLink('".$_SERVER['PHP_SELF']."?reset=1&mode=map".$mapext.$addGETString."')\" class=\"fs12_black\" href=\"#\">".$dispString."</a>&nbsp;";

			}else{
				$link = "<a onclick=\"mapArrowLink('".$_SERVER['PHP_SELF']."?mode=map".$mapext.$addGETString."')\" class=\"fs12_black\" href=\"#\" >".$dispString."</a>&nbsp;";
			}
			array_push($scaleString, $link);
		}
		
		return $scaleString; 
    }
	
	/**
	* 関数概要：地図切り替えリンク生成(非GIS)
	* 処理詳細：非GIS版の地図切り替えリンクを生成します。
	*
    * @引数： (I) $scale        - int 現在表示されている地図画像の種類名（フォルダ名）
    *         (I) $addGETString - 追加するGETString文字列(省略可)
	* @戻値： (O) 地図の範囲リンクの配列
	* @作成日/作成者：2006/09/01 (IIS)S.Komukai
	* @更新日/更新者：
	* @更新内容：
	*/
	function create_mapextRangeArrayNonGIS($scale, $addGETString=""){

    	$scaleString = array();

		$calc_scale = "";
		for($idx=0; $idx<$this->_kakikoCnt; $idx++){

			// スケール計算時に基準となるX方向の距離
		    $DistanceX = $this->_centerX - $this->_minX;
		    // スケール計算時に基準となるY方向の距離
		    $DistanceY = $this->_centerY - $this->_minY;	
			$dispString ="";

			// １メートルあたりのピクセル数
			$pixpermer = $this->_kakikoPixel[$idx];

			// 倍率１のときの距離算出（現在のスケールの１メートルあたりのピクセル数を使用）
			$DistanceX = $DistanceX * $this->_kakikoPixel[array_search($scale, $this->_kakikoPath)];
			$DistanceY = $DistanceY * $this->_kakikoPixel[array_search($scale, $this->_kakikoPath)];

			// 地図範囲リンク算出のベースとなる座標
			$base_minX = $this->_centerX - ($DistanceX / $pixpermer);
			$base_minY = $this->_centerY - ($DistanceY / $pixpermer);
			$base_maxX = $this->_centerX + ($DistanceX / $pixpermer);
			$base_maxY = $this->_centerY + ($DistanceY / $pixpermer);

			$base_minX = round($base_minX);
			$base_minY = round($base_minY);
			$base_maxX = round($base_maxX);
			$base_maxY = round($base_maxY);


			$mapext = "&mapext=";

	    	$mapext = $mapext.$base_minX."+".$base_minY."+".$base_maxX."+".$base_maxY;
	    	$dispString = $this->_kakikoName[$idx];
			$calc_scale = $this->_kakikoPath[$idx];
/*
$LOG無効です。
$LOG->debug("_centerX : ".$this->_centerX."<br>");
$LOG->debug("_centerY : ".$this->_centerY."<br>");
$LOG->debug("pixpermer : ".$pixpermer."<br>");
$LOG->debug("DistanceX : ".$DistanceX."<br>");
$LOG->debug("base_minX : ".$base_minX."<br>");
$LOG->debug("base_maxX : ".$base_maxX."<br>");
$LOG->debug("crateX : ".$crateX."<br>");
$LOG->debug("mapext : ".$mapext."<br><BR>");
*/
			$link = "";
			if($calc_scale == $scale){
				$link = $dispString;
			}else{
				$link = "<a onclick=\"mapArrowLink('".$_SERVER['PHP_SELF']."?mode=map".$mapext."&scale=".$calc_scale.$addGETString."')\" class=\"fs12_black\" href=\"#\">".$dispString."</a>&nbsp;";
			}
				
			array_push($scaleString, $link);
		}

		return $scaleString; 
	}
	
	/**
	* 関数概要：地図拡大 MAPEXT引数取得(GIS版)
	* 処理詳細：GIS版の地図拡大用のMAPEXT引数を取得します
	*
    * @引数：なし
	* @戻値：(O) 拡大後のmapext引数
	* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
	* @更新日/更新者：
	* @更新内容：
	*/
    function get_mapextZoomInStringGIS(){
    	
    	$scaleString = array();
		
		$crateX = 0;
		$crateY = 0;

    	$base_minX = 0;		// 計算基準とするminX
    	$base_minY = 0;		// 計算基準とするminy
    	$base_maxX = 0;		// 計算基準とするmaxx
    	$base_maxY = 0;		// 計算基準とするmaxy
		
		// スケール計算時に基準となるX方向の距離
	    $DistanceX = $this->_centerX - $this->_minX;	
	    // スケール計算時に基準となるY方向の距離
	    $DistanceY = $this->_centerY - $this->_minY;	
		$dispString ="";

		// 地図範囲リンク算出のベースとなる座標
		$base_minX = $this->_centerX - $DistanceX;
		$base_minY = $this->_centerY - $DistanceY;
		$base_maxX = $this->_centerX + $DistanceX;
		$base_maxY = $this->_centerY + $DistanceY;
		
		// 2
		$crateX = $this->_centerX - ($this->_centerX - $base_minX) / 2;
		$crateY = $this->_centerY - ($this->_centerY - $base_minY) / 2;
    	$mapext = "&mapext=".$crateX."+".$crateY."+"
    		.($crateX +(($base_maxX - $base_minX) / 2)."+".($crateY + (($base_maxY - $base_minY) / 2)));

		return $mapext; 
    }
	/**
	* 関数概要：地図縮小 MAPEXT引数取得(GIS版)
	* 処理詳細：GIS版の地図縮小用のMAPEXT引数を取得します
	*
    * @引数：なし
	* @戻値：(O) 縮小後のmapext引数
	* @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
	* @更新日/更新者：
	* @更新内容：
	*/
    function get_mapextZoomOutStringGIS(){
    	
    	$scaleString = array();
		
		$crateX = 0;
		$crateY = 0;

    	$base_minX = 0;		// 計算基準とするminX
    	$base_minY = 0;		// 計算基準とするminy
    	$base_maxX = 0;		// 計算基準とするmaxx
    	$base_maxY = 0;		// 計算基準とするmaxy
		
		// スケール計算時に基準となるX方向の距離
	    $DistanceX = $this->_centerX - $this->_minX;	
	    // スケール計算時に基準となるY方向の距離
	    $DistanceY = $this->_centerY - $this->_minY;	
		$dispString ="";

		// 地図範囲リンク算出のベースとなる座標
		$base_minX = $this->_centerX - $DistanceX;
		$base_minY = $this->_centerY - $DistanceY;
		$base_maxX = $this->_centerX + $DistanceX;
		$base_maxY = $this->_centerY + $DistanceY;
		
		// 1/2
		$crateX = $this->_centerX - (($this->_centerX - $base_minX) * 2);
		$crateY = $this->_centerY - (($this->_centerY - $base_minY) * 2);
    	$mapext = "&mapext=".$crateX."+".$crateY."+"
    		.($crateX +(($base_maxX - $base_minX) * 2)."+".($crateY + (($base_maxY - $base_minY) * 2)));

		return $mapext; 
    }
	
}
?>
