<?php
/**
* KakikoDb.php 処理概要：カキコまっぷ用DBクラス
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @作成日/作成者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/
require_once("DB.php");								// PEAR::DB
require_once("function/KakikoLog.php");				// ログ


class KakikoDb {

	// connection 情報
	var $db;	

	// connect 実行時オプション
	var $option = array(
//			"autofree" => true,
			"autofree" => false,
			"persistent" => false,
			"debug" => 1,
//			"portability" => DB_PORTABILITY_ALL
			"portability" => DB_PORTABILITY_NONE
		);

	/**
	 * コンストラクタ
	 * DBへの接続を実行します。
	 * @param $dbhost	接続先ホスト（ホスト名[:ポート番号]）
	 * @param $dbname	データベース名
	 * @param $dbuser	ユーザ名
	 * @param $dbpass	パスワード
	 * @param $dbtype	使用するデータベースの種類
	 */
    function KakikoDb($dbhost, $dbname, $dbuser, $dbpass, $dbtype) {

		global  $LOG;

		// 接続文字列
		$dsn=$dbtype."://".$dbuser.":".$dbpass."@".$dbhost."/".$dbname;

		// DBへ接続
		$this->db=DB::connect($dsn, $this->option);
		if(DB::isError($this->db)){
			$LOG->err("Database Connection Open failed [DBHOST:".$dbhost."][DBNAME:".$dbname."]:".$this->db->getMessage());
			$LOG->err(debug_backtrace());
		}

    }
    
    /**
     * DBコネクションをクローズする
     */
    function disconnect() {

		global  $LOG;
		
		// コネクションクローズ
		$this->db->disconnect;
		if(DB::isError($this->db)){
			$LOG->err("Database Connection Close failed :".$this->db->getMessage());
			$LOG->err(debug_backtrace());
		}
    }
    
    /**
     * クエリの実行を行う
     * @param 	$sql	SQL文
     * @return $rs		レコードセット
     */
    function executeQuery($sql){

		global $LOG;

		$rs=$this->db->query($sql);
		if(DB::isError($this->db)){
			$LOG->err("SQL Error :".$this->db->getMessage());
			$LOG->err(debug_backtrace());
		}
		// SQLログ
		$LOG->info("sql: $sql");
		return $rs;
    }

    /**
     * 実行するためのクエリを事前準備する
     * @param 	$sql	SQL文
     * @return 	$stmt	ステートメント
     */
    function setPrepare($sql){
		global $LOG;
		
		$stmt=$this->db->prepare($sql);
		if(DB::isError($stmt)){
			$LOG->err("SQL Sentence Error :".$this->db->getMessage());
			$LOG->err(debug_backtrace());
		}
		return $stmt;
    }

    /**
     * 事前準備クエリの実行する
     * @param 	$stmt	ステートメント
     * @param 	$params	パラメータ
     * @return $rs		レコードセット
     */
    function executePrepare($stmt, $params){
		global $LOG;
		
		$rs=$this->db->execute($stmt, $params);
		if(DB::isError($rs)){
			$LOG->err("SQL Error :".$this->db->getMessage());
			$LOG->err(debug_backtrace());
		}
		return $rs;
    }

    /**
     * 自動コミットの有効／無効設定を行う
     * @param	$bool	on/off
     */
    function autoCommit($bool) {
		$rtn = $this->db->autoCommit($bool);
		if ($rtn != DB_OK) {
			$LOG->err("Auto Commit Setting Error");
		}
    }

    /**
     * トランザクションコミットを行う
     */
    function commit(){
		$rtn = $this->db->commit();
		if ($rtn != DB_OK) {
			$LOG->err("Transaction Commit Error");
		}
    }

    /**
     * トランザクションロールバックを行う
     */
    function rollback(){
		$rtn = $this->db->rollback();
		if ($rtn != DB_OK) {
			$LOG->err("Transaction Rollback Error");
		}
    }

    /**
     * SQLインジェクション対応クォート処理
     * @param	$str	文字列
     */
	function quoteSQL($str) {
		return $this->db->quoteSmart($str);
	}

}
?>
