<?php
/**
* AdminUserJoinMapTableAccess.class.php adminuser_join_maptableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：K.Shimomura
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/AdminUser_MapData.class.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class AdminUserJoinMapTableAccess extends TableAccess {

	/**
	 *	コンストラクタ
	 */
    function AdminUserJoinMapTableAccess() {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName("adminusertable");		// メインテーブル名を設定
    	$this->setRecordSet(null);
    }

    /**
    * 関数概要：マップ管理者ユーザ一覧データ取得クエリ発行
    * 処理詳細：マップ管理者ユーザ一覧データの取得クエリを生成する
    *
    * @引数： (I) db       - object DBオブジェクト
    *      ： (I) usertype - string ユーザ種別
    * @戻値： boolean true :正常
    *      ：         false:異常
    * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
    * @更新日/更新者：
    * @更新内容：
    */
	function selectMapAdminUserListData($db, $usertype) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd('adminusertable.userid');
		$dba->dba_fieldAdd('adminusertable.username');
		$dba->dba_fieldAdd('maptable.contentsname');
		$dba->dba_fieldAdd('maptable.directryname');
		$dba->dba_fieldAdd('adminusertable.mailaddress');
		$dba->dba_fieldAdd('adminusertable.adddatetime as adddatetime_a');
		$dba->dba_fieldAdd('adminusertable.statusflg');

		// 条件指定
		$dba->dba_whereAdd("", "adminusertable.usertype = ".$dba->query_str_convert($usertype));

		// ソート指定
		$dba->dba_orderAdd("adminusertable.userid");

		// サブクエリ指定(INNER JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_INNER, 
			'maptable ON adminusertable.userid = maptable.userid');
		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D1_001_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
    * 関数概要：コンテンツ一覧データ取得クエリ発行
    * 処理詳細：コンテンツ一覧データの取得クエリを生成する
    *
    * @引数： (I) db       - object DBオブジェクト
    *      ： (I) usertype - string ユーザ種別
    * @戻値： boolean true :正常
    *      ：         false:異常
    * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
    * @更新日/更新者：
    * @更新内容：
    */
	function selectContentsListData($db, $usertype) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd('adminusertable.userid');
		$dba->dba_fieldAdd('adminusertable.username');
		$dba->dba_fieldAdd('maptable.publiccontents');
		$dba->dba_fieldAdd('maptable.contentsname');
		$dba->dba_fieldAdd('maptable.directryname');
		$dba->dba_fieldAdd('adminusertable.adddatetime as adddatetime_a');

		// 条件指定
		$dba->dba_whereAdd("", "adminusertable.usertype = ".$dba->query_str_convert($usertype));

		// ソート指定
		$dba->dba_orderAdd("adminusertable.userid");

		// サブクエリ指定(INNER JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_INNER, 
			'maptable ON adminusertable.userid = maptable.userid');

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D1_002_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
    * 関数概要：ディレクトリ指定ユーザ情報取得
    * @引数： (I) db       - object DBオブジェクト
    *      ： (I) $directoryName - string ディレクトリ名
    * @戻値： boolean true :正常
    *      ：         false:異常
    * @作成日/作成者：2006/09/01IIS) N.Soma
    * @更新日/更新者：
    * @更新内容：
    */
	function selectMapUserDataByDirectoryname($db, $directoryName) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd('adminusertable.userid');
		$dba->dba_fieldAdd('adminusertable.username');
		$dba->dba_fieldAdd('adminusertable.mailaddress');
		$dba->dba_fieldAdd('maptable.contentsname');
		$dba->dba_fieldAdd('maptable.directryname');

		// 条件指定
		$dba->dba_whereAdd("", "maptable.directryname = ".$dba->query_str_convert($directoryName));

		// サブクエリ指定(INNER JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_INNER, 
			'maptable ON adminusertable.userid = maptable.userid');

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D1_003_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}


    /**
    * 関数概要：一覧データ取得
    * 処理詳細：レコードセットより、管理者ユーザリンクマップリストを生成する
    *
    * @引数： 
    * @戻値： array   管理者ユーザリンクマップリスト
    * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
    * @更新日/更新者：
    * @更新内容：
    */
    function getDataList() {
        
		$adminusermap_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$adminusermapdata = new AdminUser_MapData();

			// usertypeは両テーブルで同名なので、使用する場合は、Aliasで指定してください。
			// AdminUserのusertypeは、usertype_a、Mapのusertypeはusertype_mで使用すること。
			// 同様にadddatetime、updatedatetimeもadddatetime_a、updatedatetime_a、
			// adddatetime_m、updatedatetime_mで使用すること。 

			$adminusermapdata->setUserID_AdminUser(isset($row['userid'])?$row['userid']:null);
			$adminusermapdata->setUserType_AdminUser(isset($row['usertype_a'])?$row['usertype_a']:null);
			$adminusermapdata->setMailAddress_AdminUser(isset($row['mailaddress'])?$row['mailaddress']:null);
			$adminusermapdata->setUserName_AdminUser(isset($row['username'])?$row['username']:null);
			$adminusermapdata->setPassword_AdminUser(isset($row['password'])?$row['password']:null);
			$adminusermapdata->setStatusFlg_AdminUser(isset($row['statusflg'])?$row['statusflg']:null);
			$adminusermapdata->setAddDateTime_AdminUser(isset($row['adddatetime_a'])?$row['adddatetime_a']:null);
			$adminusermapdata->setUpdateDateTime_AdminUser(isset($row['updatedatetime_a'])?$row['updatedatetime_a']:null);

			$adminusermapdata->setDirectryName_Map(isset($row['directryname'])?$row['directryname']:null);
			$adminusermapdata->setPublicContents_Map(isset($row['publiccontents'])?$row['publiccontents']:null);
			$adminusermapdata->setPublicContentsDateTime_Map(isset($row['publiccontentsdatetime'])?$row['publiccontentsdatetime']:null);
			$adminusermapdata->setAddAttestLayer_Map(isset($row['addattestlayer'])?$row['addattestlayer']:null);
			$adminusermapdata->setUserType_Map(isset($row['usertype_m'])?$row['usertype_m']:null);
			$adminusermapdata->setContentsName_Map(isset($row['contentsname'])?$row['contentsname']:null);
			$adminusermapdata->setAutoLogin_Map(isset($row['autologin'])?$row['autologin']:null);
			$adminusermapdata->setLayerCount_Map(isset($row['layercount'])?$row['layercount']:null);
			$adminusermapdata->setMemoTypeCount_Map(isset($row['memotypecount'])?$row['memotypecount']:null);
			$adminusermapdata->setAddDateTime_Map(isset($row['adddatetime_m'])?$row['adddatetime_m']:null);
			$adminusermapdata->setUpdateDateTime_Map(isset($row['updatedatetime_m'])?$row['updatedatetime_m']:null);

			array_push($adminusermap_array, $adminusermapdata);
		}
 		return $adminusermap_array;
    }
    /**
    * 関数概要：一件のマップ・ユーザ取得
    * 処理詳細：レコードセットより、管理者ユーザリンクマップデータを生成する
    *
    * @引数： 
    * @戻値： array   管理者ユーザリンクマップリスト
    * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
    * @更新日/更新者：
    * @更新内容：
    */
    function getOneData() {
        

		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

			$adminusermapdata = new AdminUser_MapData();

			// usertypeは両テーブルで同名なので、使用する場合は、Aliasで指定してください。
			// AdminUserのusertypeは、usertype_a、Mapのusertypeはusertype_mで使用すること。
			// 同様にadddatetime、updatedatetimeもadddatetime_a、updatedatetime_a、
			// adddatetime_m、updatedatetime_mで使用すること。 

			$adminusermapdata->setUserID_AdminUser(isset($row['userid'])?$row['userid']:null);
			$adminusermapdata->setUserType_AdminUser(isset($row['usertype_a'])?$row['usertype_a']:null);
			$adminusermapdata->setMailAddress_AdminUser(isset($row['mailaddress'])?$row['mailaddress']:null);
			$adminusermapdata->setUserName_AdminUser(isset($row['username'])?$row['username']:null);
			$adminusermapdata->setPassword_AdminUser(isset($row['password'])?$row['password']:null);
			$adminusermapdata->setStatusFlg_AdminUser(isset($row['statusflg'])?$row['statusflg']:null);
			$adminusermapdata->setAddDateTime_AdminUser(isset($row['adddatetime_a'])?$row['adddatetime_a']:null);
			$adminusermapdata->setUpdateDateTime_AdminUser(isset($row['updatedatetime_a'])?$row['updatedatetime_a']:null);

			$adminusermapdata->setDirectryName_Map(isset($row['directryname'])?$row['directryname']:null);
			$adminusermapdata->setPublicContents_Map(isset($row['publiccontents'])?$row['publiccontents']:null);
			$adminusermapdata->setPublicContentsDateTime_Map(isset($row['publiccontentsdatetime'])?$row['publiccontentsdatetime']:null);
			$adminusermapdata->setAddAttestLayer_Map(isset($row['addattestlayer'])?$row['addattestlayer']:null);
			$adminusermapdata->setUserType_Map(isset($row['usertype_m'])?$row['usertype_m']:null);
			$adminusermapdata->setContentsName_Map(isset($row['contentsname'])?$row['contentsname']:null);
			$adminusermapdata->setAutoLogin_Map(isset($row['autologin'])?$row['autologin']:null);
			$adminusermapdata->setLayerCount_Map(isset($row['layercount'])?$row['layercount']:null);
			$adminusermapdata->setMemoTypeCount_Map(isset($row['memotypecount'])?$row['memotypecount']:null);
			$adminusermapdata->setAddDateTime_Map(isset($row['adddatetime_m'])?$row['adddatetime_m']:null);
			$adminusermapdata->setUpdateDateTime_Map(isset($row['updatedatetime_m'])?$row['updatedatetime_m']:null);

 		return $adminusermapdata;
    }
    
}
?>