<?php
/**
* AdminUserTableAccess.class.php adminusertableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：K.Shimomura
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/

//データクラス
require_once("class/db/tabledata/UserData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class AdminUserTableAccess extends TableAccess {

	/**
	 *	クラス変数
	 */


	/**
	 *	コンストラクタ
	 */
    function AdminUserTableAccess() {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName("adminusertable");
    	$this->setRecordSet(null);
    }

    /**
     * 関数概要：管理者ユーザテーブルデータ全件取得クエリ発行
     * 処理詳細：管理者ユーザテーブルデータの全件取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D2_001_01"), E_USER_ERROR);
			return false;
		}
		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：管理者ユーザテーブルキー指定データ取得クエリ発行
     * 処理詳細：管理者ユーザテーブルキー指定データの取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key      - string キー内容(ユーザID)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectFindByKeyData($db, $key) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "userid = ".$dba->query_str_convert($key));

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D2_002_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：管理者ユーザテーブルデータ挿入
     * 処理詳細：管理者ユーザテーブルデータの挿入クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) dataobj  - object ユーザデータオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function insertData($db, $dataobj) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if (is_object($dataobj) && get_class($dataobj) == USER_DATAOBJ) {

			// ユーザID
			$dataobj->setUserID(
				$dba->query_str_convert($dataobj->getUserID()));
			// ユーザ種別
			$dataobj->setUserType(
				$dba->query_str_convert($dataobj->getUserType()));
			// メールアドレス
			$dataobj->setMailAddress(
				$dba->query_str_convert($dataobj->getMailAddress()));
			// ユーザ名称
			if (is_null($dataobj->getUserName()) != true) {
				$dataobj->setUserName(
					$dba->query_str_convert($dataobj->getUserName()));
			}
			// パスワード
			$dataobj->setPassword(
				$dba->query_str_convert($dataobj->getPassword()));
			// 状態フラグ
			$dataobj->setStatusFlg(
				$dba->query_str_convert($dataobj->getStatusFlg()));
			// 登録日時
			$dataobj->setAddDateTime(
				$dba->query_str_convert($dataobj->getAddDateTime()));
			// 更新日時
			$dataobj->setUpdateDateTime(
				$dba->query_str_convert($dataobj->getUpdateDateTime()));

			if ($dba->dba_insert($dataobj) != true) {
				trigger_error($this->o_resource->getValue("D2_003_01"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D2_003_02"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

	/**
	 *	関数名：管理者ユーザテーブルキー指定データ更新
     * @引数：(I) $db               - DBオブジェクト
     *        (I) $targetDataobj    - 対象列(条件列/更新列)指定用データオブジェクト
     *        (I) $valDataobj       - 設定値(条件値/更新値)指定用データオブジェクト
     * @戻値：$bool			- true/false
     * @作成日/作成者：2006/09/01 (IIS) K.Shimomura
     * @更新日/更新者：
     * @使用方法：whereキーとして使用したい列は$targetDataobjの該当変数をWHERE_KEYに指定し、条件値を$valDataobjの該当変数に使用する。
	 *            (プライマリキー以外にWHERE_KEYを指定しても無視されます)
     *            更新したい列は$targetDataobjの該当変数をVAL_TARGETに指定し、更新値を$valDataobjの該当変数に使用する。
     *            NULLで更新したい時は$valDataobjの該当変数にNULL_CHARを指定する。
     */
	function updateByKeyData($db, $targetDataobj, $valDataobj) {

		$whereflg = false;
		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ((is_object($targetDataobj) && get_class($targetDataobj) == USER_DATAOBJ) && 
			(is_object($valDataobj) && get_class($valDataobj) == USER_DATAOBJ)) {

			// 条件および更新内容指定
			// ユーザID
			if ($targetDataobj->getUserID() === WHERE_KEY) {
				$dba->dba_whereAdd("", "userid = ".$dba->query_str_convert($valDataobj->getUserID()));
				$whereflg = true;
			} elseif ($targetDataobj->getUserID() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"userid = "
							.$dba->query_str_convert($valDataobj->getUserID()));
			}
			// ユーザ種別
			if ($targetDataobj->getUserType() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"usertype = "
							.$dba->query_str_convert($valDataobj->getUserType()));
			}
			// メールアドレス
			if ($targetDataobj->getMailAddress() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"mailaddress = "
							.$dba->query_str_convert($valDataobj->getMailAddress()));
			}
			// ユーザ名称
			if ($targetDataobj->getUserName() === VAL_TARGET) {
				if ($valDataobj->getUserName() === NULL_CHAR) {
					$dba->dba_updateAdd("username = null");
				} else {
					$dba->dba_updateAdd(
							"username = "
								.$dba->query_str_convert($valDataobj->getUserName()));
				}
			}
			// パスワード
			if ($targetDataobj->getPassword() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"password = "
							.$dba->query_str_convert($valDataobj->getPassword()));
			}
			// 状態フラグ
			if ($targetDataobj->getStatusFlg() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"statusflg = "
							.$dba->query_str_convert($valDataobj->getStatusFlg()));
			}
			// 登録日時
			if ($targetDataobj->getAddDateTime() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"adddatetime = "
							.$dba->query_str_convert($valDataobj->getAddDateTime()));
			}
			// 更新日時
			if ($targetDataobj->getUpdateDateTime() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"updatedatetime = "
							.$dba->query_str_convert($valDataobj->getUpdateDateTime()));
			}
			
			// 条件指定確認
			if ($whereflg == false) {
				trigger_error($this->o_resource->getValue("D2_004_01"), E_USER_ERROR);
				return false;
			}
			//SQL実行
			if ($dba -> dba_update() != true) {
				trigger_error($this->o_resource->getValue("D2_004_02"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D2_004_03"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;

	}

    /**
     * 関数概要：管理者ユーザテーブルキー指定データ削除
     * 処理詳細：管理者ユーザテーブルキー指定データの削除クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key      - string キー内容(ユーザID)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function deleteByKeyData($db, $key) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "userid = ".$dba->query_str_convert($key));

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D2_005_01"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：一覧データ取得
     * 処理詳細：レコードセットより、管理者ユーザリストを生成する
     *
     * @引数： 
     * @戻値： array   管理者ユーザリンクマップリスト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getDataList() {
        
		$adminuser_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$adminuserdata = new UserData();

			$adminuserdata->setUserID(isset($row['userid'])?$row['userid']:null);
			$adminuserdata->setUserType(isset($row['usertype'])?$row['usertype']:null);
			$adminuserdata->setMailAddress(isset($row['mailaddress'])?$row['mailaddress']:null);
			$adminuserdata->setUserName(isset($row['username'])?$row['username']:null);
			$adminuserdata->setPassword(isset($row['password'])?$row['password']:null);
			$adminuserdata->setStatusFlg(isset($row['statusflg'])?$row['statusflg']:null);
			$adminuserdata->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);
			$adminuserdata->setUpdateDateTime(isset($row['updatedatetime'])?$row['updatedatetime']:null);

			array_push($adminuser_array, $adminuserdata);
		}
 		return $adminuser_array;
    }

    /**
     * 関数概要：単体データ取得
     * 処理詳細：レコードセットより、一件の管理者ユーザデータを生成する
     *
     * @引数： 
     * @戻値： array   管理者ユーザデータ型オブジェクト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getOneData() {

		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$adminuserdata = new UserData();

		$adminuserdata->setUserID(isset($row['userid'])?$row['userid']:null);
		$adminuserdata->setUserType(isset($row['usertype'])?$row['usertype']:null);
		$adminuserdata->setMailAddress(isset($row['mailaddress'])?$row['mailaddress']:null);
		$adminuserdata->setUserName(isset($row['username'])?$row['username']:null);
		$adminuserdata->setPassword(isset($row['password'])?$row['password']:null);
		$adminuserdata->setStatusFlg(isset($row['statusflg'])?$row['statusflg']:null);
		$adminuserdata->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);
		$adminuserdata->setUpdateDateTime(isset($row['updatedatetime'])?$row['updatedatetime']:null);

 		return $adminuserdata;
 	}

    /**
     * 関数概要：管理者ユーザテーブルキー指定重複チェック
     * 処理詳細：管理者ユーザテーブルデータをキー指定で重複しているかをチェック
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key      - string キー内容(ユーザID)
     * @戻値： boolean true :データなし
     *      ：         false:データあり
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function checkFindByKeyData($db, $key) {

		$rtn = true;

		// キー指定データの取得
		$this->selectFindByKeyData($db, $key);

		if ($this->getRecordCount() > 0) {
			$rtn = false;	
		}

		return $rtn;
	}
}
?>