<?php
/**
* AdminUserJoinMapTableAccess.class.php adminuser_join_maptableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：K.Shimomura
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：2007/03/01 (IIS) N.Soma 携帯機能追加
* @バージョン：1.1.0
*
* Copyright (c) 2006-2007 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/BaseMap_MapDetailData.class.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");

class BaseMapJoinMapDetailTableAccess extends TableAccess {

	/**
	 *	コンストラクタ
	 */
    function BaseMapJoinMapDetailTableAccess() {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName("basemaptable");		// メインテーブル名を設定
    	$this->setRecordSet(null);

    }

    /**
     * 関数概要：マップ・マップ詳細一覧データ取得クエリ発行
     * 処理詳細：マップ・マップ詳細一覧データの取得クエリを生成する
     *
     * @引数： (I) db             - object DBオブジェクト
     *      ： (I) directryname   - string ディレクトリ名称
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：2007/03/01 (IIS) N.Soma 携帯機能追加
     * @更新内容：
     */
	function selectMapLinkMapDetailListData($db, $directryname) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd('basemaptable.usegis');
		$dba->dba_fieldAdd('basemaptable.startx');
		$dba->dba_fieldAdd('basemaptable.starty');
		$dba->dba_fieldAdd('basemaptable.endx');
		$dba->dba_fieldAdd('basemaptable.endy');
		$dba->dba_fieldAdd('basemaptable.mapsizehorizontal');
		$dba->dba_fieldAdd('basemaptable.mapsizevertical');
		$dba->dba_fieldAdd('basemaptable.diffx');
		$dba->dba_fieldAdd('basemaptable.diffy');
		$dba->dba_fieldAdd('basemaptable.mapsizehorizontalmobile');
		$dba->dba_fieldAdd('basemaptable.mapsizeverticalmobile');
		$dba->dba_fieldAdd('basemaptable.diffxmobile');
		$dba->dba_fieldAdd('basemaptable.diffymobile');
		$dba->dba_fieldAdd('basemaptable.movemapsphere');
		$dba->dba_fieldAdd('mapdetailtable.mapnumber');
		$dba->dba_fieldAdd('mapdetailtable.listname');
		$dba->dba_fieldAdd('mapdetailtable.initiallist');
		$dba->dba_fieldAdd('mapdetailtable.outsidereference');
		$dba->dba_fieldAdd('mapdetailtable.pixel');

		// 条件指定
		$dba->dba_whereAdd("", "basemaptable.directryname = ".$dba->query_str_convert($directryname));

		// ソート指定
		$dba->dba_orderAdd("mapdetailtable.mapnumber");

		// サブクエリ指定(LEFT JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_LEFT, 
			'mapdetailtable ON basemaptable.directryname = mapdetailtable.directryname');
		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D22_001_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：マップ・マップ詳細データ取得クエリ発行（マップ番号指定）
     *
     * @引数： (I) db             - object DBオブジェクト
     *      ： (I) directryname   - string ディレクトリ名称
     *      ： (I) mapnumber      -
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS) N.Soma
     * @更新日/更新者：
     * @更新内容：
     */
	function selectMapLinkMapDetailOneData($db, $directryname, $mapnumber) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd('basemaptable.usegis');
		$dba->dba_fieldAdd('basemaptable.startx');
		$dba->dba_fieldAdd('basemaptable.starty');
		$dba->dba_fieldAdd('basemaptable.endx');
		$dba->dba_fieldAdd('basemaptable.endy');
		$dba->dba_fieldAdd('basemaptable.mapsizehorizontal');
		$dba->dba_fieldAdd('basemaptable.mapsizevertical');
		$dba->dba_fieldAdd('basemaptable.diffx');
		$dba->dba_fieldAdd('basemaptable.diffy');
		$dba->dba_fieldAdd('basemaptable.mapsizehorizontalmobile');
		$dba->dba_fieldAdd('basemaptable.mapsizeverticalmobile');
		$dba->dba_fieldAdd('basemaptable.diffxmobile');
		$dba->dba_fieldAdd('basemaptable.diffymobile');
		$dba->dba_fieldAdd('basemaptable.movemapsphere');
		$dba->dba_fieldAdd('mapdetailtable.mapnumber');
		$dba->dba_fieldAdd('mapdetailtable.listname');
		$dba->dba_fieldAdd('mapdetailtable.initiallist');
		$dba->dba_fieldAdd('mapdetailtable.outsidereference');
		$dba->dba_fieldAdd('mapdetailtable.pixel');

		// 条件指定
		$dba->dba_whereAdd("", "basemaptable.directryname = ".$dba->query_str_convert($directryname));
		if (is_null($mapnumber) == false){
			$dba->dba_whereAdd("AND", "mapdetailtable.mapnumber = ".$dba->query_str_convert($mapnumber));		
		}

		// ソート指定
		$dba->dba_orderAdd("mapdetailtable.mapnumber");

		// サブクエリ指定(LEFT JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_LEFT, 
			'mapdetailtable ON basemaptable.directryname = mapdetailtable.directryname');
		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D22_001_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：一覧データ取得
     * 処理詳細：レコードセットより、管理者ユーザリンクマップリストを生成する
     *
     * @引数： 
     * @戻値： array   管理者ユーザリンクマップリスト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：2007/03/01 (IIS) N.Soma 携帯機能追加
     * @更新内容：
     */
    function getDataList() {
        
		$join_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$joindata = new BaseMap_MapDetailData();

			// adddatetime、updatedatetimeは両テーブルで同名なので、使用する場合は、Aliasで指定してください。
			// BaseMapでのadddatetime、updatedatetimeはadddatetime_b、updatedatetime_b、
			// MapDetailでのadddatetime、updatedatetimeはadddatetime_m、updatedatetime_mで使用すること。 

			$joindata->setDirectryName_BaseMap(isset($row['directryname'])?$row['directryname']:null);
			$joindata->setUseGIS_BaseMap(isset($row['usegis'])?$row['usegis']:null);
			$joindata->setStartX_BaseMap(isset($row['startx'])?$row['startx']:null);
			$joindata->setStartY_BaseMap(isset($row['starty'])?$row['starty']:null);
			$joindata->setEndX_BaseMap(isset($row['endx'])?$row['endx']:null);
			$joindata->setEndY_BaseMap(isset($row['endy'])?$row['endy']:null);
			$joindata->setMapSizeHorizontal_BaseMap(isset($row['mapsizehorizontal'])?$row['mapsizehorizontal']:null);
			$joindata->setMapSizeVertical_BaseMap(isset($row['mapsizevertical'])?$row['mapsizevertical']:null);
			$joindata->setDiffX_BaseMap(isset($row['diffx'])?$row['diffx']:null);
			$joindata->setDiffY_BaseMap(isset($row['diffy'])?$row['diffy']:null);
			$joindata->setMapSizeHorizontalMobile_BaseMap(isset($row['mapsizehorizontalmobile'])?$row['mapsizehorizontalmobile']:null);
			$joindata->setMapSizeVerticalMobile_BaseMap(isset($row['mapsizeverticalmobile'])?$row['mapsizeverticalmobile']:null);
			$joindata->setDiffXMobile_BaseMap(isset($row['diffxmobile'])?$row['diffxmobile']:null);
			$joindata->setDiffYMobile_BaseMap(isset($row['diffymobile'])?$row['diffymobile']:null);
			$joindata->setMoveMapSphere_BaseMap(isset($row['movemapsphere'])?$row['movemapsphere']:null);
			$joindata->setAddDateTime_BaseMap(isset($row['adddatetime_b'])?$row['adddatetime_b']:null);
			$joindata->setUpdateDateTime_BaseMap(isset($row['updatedatetime_b'])?$row['updatedatetime_b']:null);

			$joindata->setMapNumber_MapDetail(isset($row['mapnumber'])?$row['mapnumber']:null);
			$joindata->setListName_MapDetail(isset($row['listname'])?$row['listname']:null);
			$joindata->setInitialList_MapDetail(isset($row['initiallist'])?$row['initiallist']:null);
			$joindata->setOutsideReference_MapDetail(isset($row['outsidereference'])?$row['outsidereference']:null);
			$joindata->setPixel_MapDetail(isset($row['pixel'])?$row['pixel']:null);
			$joindata->setAddDateTime_MapDetail(isset($row['adddatetime_m'])?$row['adddatetime_m']:null);
			$joindata->setUpdateDateTime_MapDetail(isset($row['updatedatetime_m'])?$row['updatedatetime_m']:null);

			array_push($join_array, $joindata);
		}
 		return $join_array;
    }

    /**
     * 関数概要：１件データ取得
     * 処理詳細：レコードセットより、マップ情報データを生成する
     *
     * @引数： 
     * @戻値： array   マップ情報データ
     * @作成日/作成者：2006/09/01 (IIS) N.Soma
     * @更新日/更新者：2007/03/01 (IIS) N.Soma 携帯機能追加
     * @更新内容：
     */
    function getOneData() {

		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

			$joindata = new BaseMap_MapDetailData();

			// adddatetime、updatedatetimeは両テーブルで同名なので、使用する場合は、Aliasで指定してください。
			// BaseMapでのadddatetime、updatedatetimeはadddatetime_b、updatedatetime_b、
			// MapDetailでのadddatetime、updatedatetimeはadddatetime_m、updatedatetime_mで使用すること。 

			$joindata->setDirectryName_BaseMap(isset($row['directryname'])?$row['directryname']:null);
			$joindata->setUseGIS_BaseMap(isset($row['usegis'])?$row['usegis']:null);
			$joindata->setStartX_BaseMap(isset($row['startx'])?$row['startx']:null);
			$joindata->setStartY_BaseMap(isset($row['starty'])?$row['starty']:null);
			$joindata->setEndX_BaseMap(isset($row['endx'])?$row['endx']:null);
			$joindata->setEndY_BaseMap(isset($row['endy'])?$row['endy']:null);
			$joindata->setMapSizeHorizontal_BaseMap(isset($row['mapsizehorizontal'])?$row['mapsizehorizontal']:null);
			$joindata->setMapSizeVertical_BaseMap(isset($row['mapsizevertical'])?$row['mapsizevertical']:null);
			$joindata->setDiffX_BaseMap(isset($row['diffx'])?$row['diffx']:null);
			$joindata->setDiffY_BaseMap(isset($row['diffy'])?$row['diffy']:null);
			$joindata->setMapSizeHorizontalMobile_BaseMap(isset($row['mapsizehorizontalmobile'])?$row['mapsizehorizontalmobile']:null);
			$joindata->setMapSizeVerticalMobile_BaseMap(isset($row['mapsizeverticalmobile'])?$row['mapsizeverticalmobile']:null);
			$joindata->setDiffXMobile_BaseMap(isset($row['diffxmobile'])?$row['diffxmobile']:null);
			$joindata->setDiffYMobile_BaseMap(isset($row['diffymobile'])?$row['diffymobile']:null);
			$joindata->setMoveMapSphere_BaseMap(isset($row['movemapsphere'])?$row['movemapsphere']:null);
			$joindata->setAddDateTime_BaseMap(isset($row['adddatetime_b'])?$row['adddatetime_b']:null);
			$joindata->setUpdateDateTime_BaseMap(isset($row['updatedatetime_b'])?$row['updatedatetime_b']:null);

			$joindata->setMapNumber_MapDetail(isset($row['mapnumber'])?$row['mapnumber']:null);
			$joindata->setListName_MapDetail(isset($row['listname'])?$row['listname']:null);
			$joindata->setInitialList_MapDetail(isset($row['initiallist'])?$row['initiallist']:null);
			$joindata->setOutsideReference_MapDetail(isset($row['outsidereference'])?$row['outsidereference']:null);
			$joindata->setPixel_MapDetail(isset($row['pixel'])?$row['pixel']:null);
			$joindata->setAddDateTime_MapDetail(isset($row['adddatetime_m'])?$row['adddatetime_m']:null);
			$joindata->setUpdateDateTime_MapDetail(isset($row['updatedatetime_m'])?$row['updatedatetime_m']:null);

 		return $joindata;
    }
}
?>