<?php
/**
* ImiBaseInfoTableAccess.class.php 処理概要 ImiBaseInfoTableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS) N.Soma
* @作成日/作成者：2006/09/01 N.Soma
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/ImiBaseInfo_UserData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class ImiBaseInfoJoinUserTableAccess extends TableAccess{

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス


	/**
	 *	コンストラクタ
	 *	@param	$directryname	ディレクトリ名称
	 */
    function ImiBaseInfoJoinUserTableAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName($directryname."_imibaseinfotable");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }


   /**
    * 関数名：意味基本情報・ユーザテーブルキー指定データ取得
    * @引数：(I) $db	- DBオブジェクト
    * @引数：(I) $key	- キー内容(空間ID)    
    * @戻値：$bool		- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function selectFindByKeyData($db, $key) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "imispaceid = ".$dba->query_str_convert($key));
		
		// サブクエリ指定(INNER JOIN/ユーザ)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_usertable ON "
				.$this->prefix."_imibaseinfotable.userid = "
				.$this->prefix."_usertable.userid"
				);

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D23_001_02"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味基本情報テーブルキー指定データ取得（一般ユーザ用）
    * @引数：(I) $db		- DBオブジェクト
    * @引数：(I) $userId	- ユーザID（一般）
    * @戻値：$bool		- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    * @注意事項：一般ユーザの場合は所有空間と他人作成閲覧可能空間を取得
    */
	function selectFindByKeyDataNormalMember($db, $userId) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		//一覧取得用ＳＱＬ（一般ユーザ用）
		$sql = " (SELECT ".$this->prefix."_imibaseinfotable.imispacename, username,".$this->prefix."_imibaseinfotable.userid,"
				." memochangeflg,memodeletewarnflg, imispaceid, viewmode"
				." FROM ".$this->prefix."_imibaseinfotable, ".$this->prefix."_usertable"
				." WHERE ".$this->prefix."_imibaseinfotable.userid = ".$this->prefix."_usertable.userid"
				." AND ".$this->prefix."_imibaseinfotable.userid = '".$userId."'"
				." ORDER BY ".$this->prefix."_imibaseinfotable.imispaceid)"
				." UNION ALL "
				." (SELECT ".$this->prefix."_imibaseinfotable.imispacename, username, ".$this->prefix."_imibaseinfotable.userid"
				.",memochangeflg,memodeletewarnflg, imispaceid, viewmode"
				." FROM ".$this->prefix."_imibaseinfotable, ".$this->prefix."_usertable"
				." WHERE ".$this->prefix."_imibaseinfotable.userid = ".$this->prefix."_usertable.userid"
				."  AND ".$this->prefix."_imibaseinfotable.publicdivision = '".KAKIKOMAP_IMIPUBLIC_ON."'" 
				."  AND ".$this->prefix."_imibaseinfotable.userid <> '".$userId."'"
				." ORDER BY ".$this->prefix."_imibaseinfotable.imispaceid)";
		$ret = $dba->dba_executeQuery($sql);
		if ($ret != true) {
			trigger_error($this->o_resource->getValue("D23_001_03"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味基本情報テーブルキー指定データ取得（マップ管理ユーザ用）
    * @引数：(I) $db		- DBオブジェクト
    * @引数：(I) $userId	- ユーザID(マップ管理者)
    * @戻値：$bool		- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    * @注意事項：マップ管理者の場合は所有空間と他人作成全空間を取得
    */
	function selectFindByKeyDataMapAdmin($db, $userId) {

		$dba = new KakikoDBAccess($db, $this->getTablename());


		//一覧取得用ＳＱＬ（マップ管理者用）
		$sql = " (SELECT ".$this->prefix."_imibaseinfotable.imispacename, username,".$this->prefix."_imibaseinfotable.userid,"
				." memochangeflg,memodeletewarnflg, imispaceid, viewmode"
				." FROM ".$this->prefix."_imibaseinfotable, ".$this->prefix."_usertable"
				." WHERE ".$this->prefix."_imibaseinfotable.userid = ".$this->prefix."_usertable.userid"
				." AND ".$this->prefix."_imibaseinfotable.userid = '".$userId."'"
				." ORDER BY ".$this->prefix."_imibaseinfotable.imispaceid)"
				." UNION ALL "
				." (SELECT ".$this->prefix."_imibaseinfotable.imispacename, username, ".$this->prefix."_imibaseinfotable.userid"
				.",memochangeflg,memodeletewarnflg, imispaceid, viewmode"
				." FROM ".$this->prefix."_imibaseinfotable, ".$this->prefix."_usertable"
				." WHERE ".$this->prefix."_imibaseinfotable.userid = ".$this->prefix."_usertable.userid"
				."  AND ".$this->prefix."_imibaseinfotable.userid <> '".$userId."'"
				." ORDER BY ".$this->prefix."_imibaseinfotable.imispaceid)";
		$ret = $dba->dba_executeQuery($sql);
		if ($ret != true) {
			trigger_error($this->o_resource->getValue("D23_001_04"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}




   /**
    * 関数名：レコードセットより、意味基本情報・ユーザリストを生成する。
    * @戻値：意味基本情報リスト
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
    function getDataList() {
        
		$imibaseinfo_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$imibaseinfouserdata = new ImiBaseInfo_UserData();

			$imibaseinfouserdata->setImiSpaceID($row['imispaceid']);
			$imibaseinfouserdata->setImiSpaceName($row['imispacename']);
			$imibaseinfouserdata->setUserID($row['userid']);
			$imibaseinfouserdata->setPublicDivision($row['publicdivision']);
			$imibaseinfouserdata->setViewMode($row['viewmode']);
			$imibaseinfouserdata->setMemoChangeFlg($row['memochangeflg']);
			$imibaseinfouserdata->setMemoDeleteWarnFlg($row['memodeletewarnflg']);
			$imibaseinfouserdata->setAddDateTime($row['adddatetime']);
			$imibaseinfouserdata->setTakememoDatetime($row['takememodatetime']);
			$imibaseinfouserdata->setUpdateDateTime($row['updatedatetime']);

			$imibaseinfouserdata->setUserName($row['username']);

			array_push($imibaseinfo_array, $imibaseinfouserdata);
		}
 		return $imibaseinfo_array;
    }

   /**
    * 関数名：レコードセットより、一件の意味基本情報・ユーザデータを生成する。
    * @戻値：意味基本情報・ユーザデータ型オブジェクト
     * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
     function getOneData() {
        
		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$imibaseinfouserdata = new ImiBaseInfo_UserData();

			$imibaseinfouserdata->setImiSpaceID($row['imispaceid']);
			$imibaseinfouserdata->setImiSpaceName($row['imispacename']);
			$imibaseinfouserdata->setUserID($row['userid']);
			$imibaseinfouserdata->setPublicDivision($row['publicdivision']);
			$imibaseinfouserdata->setViewMode($row['viewmode']);
			$imibaseinfouserdata->setMemoChangeFlg($row['memochangeflg']);
			$imibaseinfouserdata->setMemoDeleteWarnFlg($row['memodeletewarnflg']);
			$imibaseinfouserdata->setAddDateTime($row['adddatetime']);
			$imibaseinfouserdata->setTakememoDatetime($row['takememodatetime']);
			$imibaseinfouserdata->setUpdateDateTime($row['updatedatetime']);

			$imibaseinfouserdata->setUserName($row['username']);

 		return $imibaseinfouserdata;
    }
}
?>