<?php
/**
* ImiLayerTableAccess.class.php 処理概要 ImiLayerTableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS) N.Soma
* @作成日/作成者：2006/09/01 N.Soma
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/ImiLayerData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class ImiLayerTableAccess extends TableAccess{

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス


	/**
	 *	コンストラクタ
	 *	@param	$directryname	ディレクトリ名称
	 */
    function ImiLayerTableAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName($directryname."_imilayertable");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }

   /**
    * 関数名：意味レイヤーテーブルデータ全件取得
    * @引数：(I) $db    - DBオブジェクト
    * @戻値：$bool		- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */	 
	function selectAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D29_001_01"), E_USER_ERROR);				
			return false;
		}
		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味レイヤーテーブルキー指定データ取得
    * @引数：(I) $db	- DBオブジェクト
    *        (I) $keyImispaceID	キー内容(色ID)
    *        (I) $keyLayerID	キー内容(レイヤーID)
    * @戻値：$bool		- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
	* @注意事項： キーは２つあるが、片方は省略可
    */	 
	function selectFindByKeyData($db, $keyImispaceID, $keyLayerID) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		if(( $keyImispaceID == "") && ( $keyLayerID == "")) {
			$this->getAllData();
		}elseif(	( $keyImispaceID != "") && ( $keyLayerID != "")){
			$dba->dba_whereAdd("", "imispaceid = ".$dba->query_str_convert($keyImispaceID));
			$dba->dba_whereAdd("and", "layerid = ".$dba->query_str_convert($keyLayerID));
		}elseif	( $keyImispaceID != ""){
			$dba->dba_whereAdd("", "imispaceid = ".$dba->query_str_convert($keyImispaceID));				
		}elseif	( $keyLayerID != ""){
			$dba->dba_whereAdd("", "layerid = ".$dba->query_str_convert($keyLayerID));
		}
		
		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D29_001_02"), E_USER_ERROR);				
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
	*	意味レイヤーテーブルデータ挿入
	* @引数：(I) $db		- DBオブジェクト
    *        (I) $dataobj	- データオブジェクト
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function insertData($db, $dataobj) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if (is_object($dataobj) && get_class($dataobj) == IMILAYER_DATAOBJ) {

			// 空間ID
			$dataobj->setImiSpaceID(
				$dba->query_str_convert($dataobj->getImiSpaceID()));
			// レイヤーID
			$dataobj->setLayerID(
				$dba->query_str_convert($dataobj->getLayerID()));
			// 登録日時
			$dataobj->setAddDateTime(
				$dba->query_str_convert($dataobj->getAddDateTime()));
			// 更新日時
			$dataobj->setUpdateDateTime(
				$dba->query_str_convert($dataobj->getUpdateDateTime()));

			if ($dba->dba_insert($dataobj) != true) {
				trigger_error($this->o_resource->getValue("D29_001_03"), E_USER_ERROR);				
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D29_001_04"), E_USER_ERROR);				
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味レイヤーテーブルキー指定データ更新
    * @引数：(I) $db		- DBオブジェクト
    *        (I) $targetDataobj	- 対象列(条件列/更新列)指定用データオブジェクト
    *        (I) $valDataobj	- 設定値(条件値/更新値)指定用データオブジェクト
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    * @使用方法：whereキーとして使用したい列は$targetDataobjの該当変数をWHERE_KEYに指定し、条件値を$valDataobjの該当変数に使用する。
	*            (プライマリキー以外にWHERE_KEYを指定しても無視されます。２種類以上の条件はand比較します)
    *            更新したい列は$targetDataobjの該当変数をVAL_TARGETに指定し、更新値を$valDataobjの該当変数に使用する。
    *            NULLで更新したい時は$valDataobjの該当変数にNULL_CHARを指定する。
    */
	function updateByKeyData($db, $targetDataobj, $valDataobj) {
		$whereflg = false;
		$andstr = "";		
		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ((is_object($targetDataobj) && get_class($targetDataobj) == IMILAYER_DATAOBJ) && 
			(is_object($valDataobj) && get_class($valDataobj) == IMILAYER_DATAOBJ)){

			// 更新内容指定
			// 空間ID
			if ($targetDataobj->getImiSpaceID() === WHERE_KEY){
				$dba->dba_whereAdd("", "imispaceid = ".$dba->query_str_convert($valDataobj->getImiSpaceID()));
				$whereflg = true;
				$andstr = "and";
			}elseif ($targetDataobj->getImiSpaceID() === VAL_TARGET){
				$dba->dba_updateAdd("imispaceid = ".$dba->query_str_convert($valDataobj->getImiSpaceID()));	
			}
			// レイヤーID
			if ($targetDataobj->getLayerID() === WHERE_KEY){
				$dba->dba_whereAdd($andstr, "layerid = ".$dba->query_str_convert($valDataobj->getLayerID()));
				$whereflg = true;
				$andstr = "and";
			}elseif ($targetDataobj->getLayerID() === VAL_TARGET){
				$dba->dba_updateAdd("layerid = ".$dba->query_str_convert($valDataobj->getLayerID()));	
			}
			// 登録日時
			if ($targetDataobj->getAddDateTime() === VAL_TARGET){
				$dba->dba_updateAdd("adddatetime = ".$dba->query_str_convert($valDataobj->getAddDateTime()));
			}
			// 更新日時
			if ($targetDataobj->getUpdateDateTime() === VAL_TARGET){
				$dba->dba_updateAdd("updatedatetime = ".$dba->query_str_convert($valDataobj->getUpdateDateTime()));
			}

			// 条件指定確認
			if ($whereflg == false){
				trigger_error($this->o_resource->getValue("D29_001_05"), E_USER_ERROR);								
				return false;
			
			}
			if ($dba -> dba_update() != true) {
				trigger_error($this->o_resource->getValue("D29_001_06"), E_USER_ERROR);								
				return false;
			}
		} else {
				trigger_error($this->o_resource->getValue("D29_001_04"), E_USER_ERROR);								
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味レイヤーテーブル全データ削除
    * @引数：(I) $db		- DBオブジェクト
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function deleteAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D29_001_07"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
    * 関数名：意味レイヤーテーブルキー指定データ削除
    * @引数：(I) $db		- DBオブジェクト
    * @引数：(I) $keyImispaceID		- キー内容(空間ID)
    *        (I) $keyLayerID		- キー内容(レイヤーID)
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function deleteByKeyData($db, $keyImispaceID, $keyLayerID) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		if(( $keyImispaceID == "") && ( $keyLayerID == "")) {
		}elseif(	( $keyImispaceID != "") && ( $keyLayerID != "")){
			$dba->dba_whereAdd("", "imispaceid = ".$dba->query_str_convert($keyImispaceID));
			$dba->dba_whereAdd("and", "layerid = ".$dba->query_str_convert($keyLayerID));
		}elseif	( $keyImispaceID != ""){
			$dba->dba_whereAdd("", "imispaceid = ".$dba->query_str_convert($keyImispaceID));				
		}elseif	( $keyLayerID != ""){
			$dba->dba_whereAdd("", "layerid = ".$dba->query_str_convert($keyLayerID));
		}

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D29_001_08"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：レコードセットより、意味レイヤーリストを生成する。
    * @戻値：意味レイヤーリスト
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
    function getDataList() {
        
		$imiLayer_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$imilayerdata = new ImiLayerData();

			$imilayerdata->setImiSpaceID($row['imispaceid']);
			$imilayerdata->setLayerID($row['layerid']);
			$imilayerdata->setAddDateTime($row['adddatetime']);
			$imilayerdata->setUpdateDateTime($row['updatedatetime']);

			array_push($imiLayer_array, $imilayerdata);
		}
 		return $imiLayer_array;
    }

   /**
    * 関数名：レコードセットより、一件の意味レイヤーデータを生成する。
    * @戻値：意味レイヤーデータ型オブジェクト
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
    function getOneData() {
        
		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$imilayerdata = new ImiLayerData();

			$imilayerdata->setImiSpaceID($row['imispaceid']);
			$imilayerdata->setLayerID($row['layerid']);
			$imilayerdata->setAddDateTime($row['adddatetime']);
			$imilayerdata->setUpdateDateTime($row['updatedatetime']);

 		return $imilayerdata;
    }
}
?>