<?php
/**
* ImiMemoPositionTableAccess.class.php 処理概要 ImiMemoPositionTableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS) N.Soma
* @作成日/作成者：2006/09/01 N.Soma
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/ImiMemoPositionData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class ImiMemoPositionTableAccess extends TableAccess{

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス


	/**
	 *	コンストラクタ
	 *	@param	$directryname	ディレクトリ名称
	 */
    function ImiMemoPositionTableAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName($directryname."_imimemopositiontable");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }

   /**
    * 関数名：意味メモ位置テーブルデータ全件取得
    * @引数：(I) $db    - DBオブジェクト
    * @戻値：$bool		- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */	 
	function selectAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D30_001_01"), E_USER_ERROR);				
			return false;
		}
		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味メモ位置テーブルキー指定データ取得
    * @引数：(I) $db	- DBオブジェクト
    *        (I) $keyImispaceID	- キー内容(空間ID)
    *        (I) $keyMemoID		- キー内容(メモID)
    * @戻値：$bool		- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
	* @注意事項： キーは２つあるが、片方は省略可
    */	 	 
	function selectFindByKeyData($db, $keyImispaceID ="", $keyMemoID = "") {

		$dba = new KakikoDBAccess($db, $this->getTablename());
			
		// 条件指定
		if(( $keyImispaceID == "") && ( $keyMemoID == "")) {
			$this->getAllData();
		}elseif(	( $keyImispaceID != "") && ( $keyMemoID != "")){
			$dba->dba_whereAdd("", "imispaceid = ".$dba->query_str_convert($keyImispaceID));
			$dba->dba_whereAdd("and", "memoid = ".$dba->query_str_convert($keyMemoID));
		}elseif	( $keyImispaceID != ""){
			$dba->dba_whereAdd("", "imispaceid = ".$dba->query_str_convert($keyImispaceID));				
		}elseif	( $keyMemoID != ""){
			$dba->dba_whereAdd("", "memoid = ".$dba->query_str_convert($keyMemoID));
		}	

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D30_001_02"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味メモ位置テーブルデータ取得（メモ種類指定）
    * @引数：(I) $db	- DBオブジェクト
    *        (I) $memoTypeId	- 対象メモ種類ID
    * @戻値：$bool		- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
	* @注意事項： キーは２つあるが、片方は省略可
    */	 	 
	function selectFindDataByMemoTypeID($db, $memoTypeId) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 重複データ除き指定(DISTINCT)
		$dba->dba_distinct(true);

		// カラムフィールド指定		
		$dba->dba_fieldAdd($this->prefix."_imimemopositiontable.memotypeid");
		
		// 条件指定
		$dba->dba_whereAdd("", "memotypeid = ".$dba->query_str_convert($memoTypeId));
//		// グルーピング指定
//		$dba->dba_groupAdd($this->prefix."_imimemopositiontable.imispaceid");
		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D30_001_03"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}



   /**
	*	意味メモ位置テーブルデータ挿入
	* @引数：(I) $db		- DBオブジェクト
    *        (I) $dataobj	- データオブジェクト
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function insertData($db, $dataobj) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if (is_object($dataobj) && get_class($dataobj) == IMIMEMOPOSITION_DATAOBJ) {

			// 空間ID
			$dataobj->setImiSpaceID(
				$dba->query_str_convert($dataobj->getImiSpaceID()));
			// メモID
			$dataobj->setMemoID(
				$dba->query_str_convert($dataobj->getMemoID()));
			// 座標X
			$dataobj->setCoordinateX(
				$dba->query_str_convert($dataobj->getCoordinateX()));
			// 座標Y
			$dataobj->setCoordinateY(
				$dba->query_str_convert($dataobj->getCoordinateY()));
			// 色ID
			$dataobj->setColorID(
				$dba->query_str_convert($dataobj->getColorID()));
			// レイヤーID
			$dataobj->setLayerID(
				$dba->query_str_convert($dataobj->getLayerID()));
			// メモ種類ID
			$dataobj->setMemoTypeID($dataobj->getMemoTypeID());
			// 登録日時
			$dataobj->setAddDateTime(
				$dba->query_str_convert($dataobj->getAddDateTime()));
			// 更新日時
			$dataobj->setUpdateDateTime(
				$dba->query_str_convert($dataobj->getUpdateDateTime()));

			if ($dba->dba_insert($dataobj) != true) {
				trigger_error($this->o_resource->getValue("D30_001_04"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D30_001_05"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味メモ位置テーブルキー指定データ更新
    * @引数：(I) $db		- DBオブジェクト
    *        (I) $targetDataobj	- 対象列(条件列/更新列)指定用データオブジェクト
    *        (I) $valDataobj	- 設定値(条件値/更新値)指定用データオブジェクト
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    * @使用方法：whereキーとして使用したい列は$targetDataobjの該当変数をWHERE_KEYに指定し、条件値を$valDataobjの該当変数に使用する。
	*            (プライマリキー以外にWHERE_KEYを指定しても無視されます。２種類以上の条件はand比較します)
    *            更新したい列は$targetDataobjの該当変数をVAL_TARGETに指定し、更新値を$valDataobjの該当変数に使用する。
    *            NULLで更新したい時は$valDataobjの該当変数にNULL_CHARを指定する。
    */
	function updateByKeyData($db, $targetDataobj, $valDataobj) {
		$whereflg = false;
		$andstr = "";

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ((is_object($targetDataobj) && get_class($targetDataobj) == IMIMEMOPOSITION_DATAOBJ) && 
			(is_object($valDataobj) && get_class($valDataobj) == IMIMEMOPOSITION_DATAOBJ)){

			// 更新内容指定
			// 空間ID
			if ($targetDataobj->getImiSpaceID() === WHERE_KEY){
				$dba->dba_whereAdd("", "imispaceid = ".$dba->query_str_convert($valDataobj->getImiSpaceID()));
				$whereflg = true;
				$andstr = "and";
			}elseif ($targetDataobj->getImiSpaceID() === VAL_TARGET){
				$dba->dba_updateAdd("imispaceid = ".$dba->query_str_convert($valDataobj->getImiSpaceID()));	
			}
			// メモID
			if ($targetDataobj->getMemoID() === WHERE_KEY){
				$dba->dba_whereAdd($andstr, "memoid = ".$dba->query_str_convert($valDataobj->getMemoID()));
				$whereflg = true;
				$andstr = "and";
			}elseif ($targetDataobj->getMemoID() === VAL_TARGET){
				$dba->dba_updateAdd("memoid = ".$dba->query_str_convert($valDataobj->getMemoID()));	
			}
			// 座標X			
			if ($targetDataobj->getCoordinateX() === VAL_TARGET){
				$dba->dba_updateAdd("coordinatex = ".$dba->query_str_convert($valDataobj->getCoordinateX()));	
			}
			// 座標Y			
			if ($targetDataobj->getCoordinateY() === VAL_TARGET){
				$dba->dba_updateAdd("coordinatey = ".$dba->query_str_convert($valDataobj->getCoordinateY()));	
			}	
			// 色ID			
			if ($targetDataobj->getColorID() === VAL_TARGET){
				if ($valDataobj->getColorID() === NULL_CHAR){
					$dba->dba_updateAdd("colorid = null");
				}else{
					$dba->dba_updateAdd("colorid = ".$dba->query_str_convert($valDataobj->getColorID()));	
				}	
			}
			// レイヤーID			
			if ($targetDataobj->getLayerID() === VAL_TARGET){
				$dba->dba_updateAdd("layerid = ".$dba->query_str_convert($valDataobj->getLayerID()));	
			}
			// メモ種類ID			
			if ($targetDataobj->getMemoTypeID() === VAL_TARGET){
				$dba->dba_updateAdd("memotypeid = ".$dba->query_str_convert($valDataobj->getMemoTypeID()));	
			}
			// 登録日時
			if ($targetDataobj->getAddDateTime() === VAL_TARGET){
				$dba->dba_updateAdd("adddatetime = ".$dba->query_str_convert($valDataobj->getAddDateTime()));
			}
			// 更新日時
			if ($targetDataobj->getUpdateDateTime() === VAL_TARGET){
				$dba->dba_updateAdd("updatedatetime = ".$dba->query_str_convert($valDataobj->getUpdateDateTime()));
			}
			
			// 条件指定確認
			if ($whereflg == false){
				trigger_error($this->o_resource->getValue("D30_001_06"), E_USER_ERROR);
				return false;			
			}
			if ($dba -> dba_update() != true) {
				trigger_error($this->o_resource->getValue("D30_001_07"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D30_001_05"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味メモ位置テーブルレイヤーID一括更新
    * 関数概要：指定の意味メモ位置データののレイヤーIDを一括で更新する
    * @引数：(I) $db		- DBオブジェクト
    *        (I) $targetMemoId	- 対象のメモID
    *        (I) $layerId		- 設定するレイヤーID
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function updateDataSetLayerId($db, $targetMemoId, $layerId) {
		$whereflg = false;
		$andstr = "";

		$dba = new KakikoDBAccess($db, $this->getTablename());

		$dba->dba_updateAdd("layerid = ".$dba->query_str_convert($layerId));	
		$dba->dba_whereAdd("", "memoid = ".$dba->query_str_convert($targetMemoId));
		
			
		if ($dba -> dba_update() != true) {
			trigger_error($this->o_resource->getValue("D30_001_08"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味メモ位置テーブルメモ種類ID一括更新
    * 関数概要：指定の意味メモ位置データののメモ種類IDを一括で更新する
    * @引数：(I) $db			- DBオブジェクト
    *        (I) $targetMemoId	- 対象のメモID
    *        (I) $memoTypeId	- 設定するメモ種類ID
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function updateDataSetMemotypeId($db, $targetMemoId, $memoTypeId) {
		$whereflg = false;
		$andstr = "";

		$dba = new KakikoDBAccess($db, $this->getTablename());

		$dba->dba_updateAdd("memotypeid = ".$dba->query_str_convert($memoTypeId));	
		$dba->dba_whereAdd("", "memoid = ".$dba->query_str_convert($targetMemoId));
			
		if ($dba -> dba_update() != true) {
			trigger_error($this->o_resource->getValue("D30_001_09"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}


   /**
    * 関数名：意味メモ位置テーブル全データ削除
    * @引数：(I) $db		- DBオブジェクト
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function deleteAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D30_001_10"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味メモ位置テーブルキー指定データ削除
    * @引数：(I) $db		- DBオブジェクト
    * @引数：(I) $keyImispaceID		- キー内容(空間ID)
    *        (I) $keyMemoID			- キー内容(メモID)
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */	 
	function deleteByKeyData($db, $keyImispaceID, $keyMemoID) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		if(( $keyImispaceID == "") && ( $keyMemoID == "")) {
		}elseif(	( $keyImispaceID != "") && ( $keyMemoID != "")){
			$dba->dba_whereAdd("", "imispaceid = ".$dba->query_str_convert($keyImispaceID));
			$dba->dba_whereAdd("and", "memoid = ".$dba->query_str_convert($keyMemoID));
		}elseif	( $keyImispaceID != ""){
			$dba->dba_whereAdd("", "imispaceid = ".$dba->query_str_convert($keyImispaceID));				
		}elseif	( $keyMemoID != ""){
			$dba->dba_whereAdd("", "memoid = ".$dba->query_str_convert($keyMemoID));
		}	

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D30_001_11"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味メモ位置テーブルデータ削除（レイヤー指定）
    * @引数：(I) $db		- DBオブジェクト
    * @引数：(I) $layerId	- レイヤーID
    * @戻値：$bool			- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */	 
	function deleteDataByLayer($db, $layerId) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "layerid = ".$dba->query_str_convert($layerId));
		
		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D30_001_12"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味メモ位置テーブルデータ削除（メモ種類指定）
    * @引数：(I) $db			- DBオブジェクト
    * @引数：(I) $memoTypeId	- メモ種類ID
    * @戻値：$bool				- true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */	 
	function deleteDataByMemotype($db, $memoTypeId) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "memotypeid = ".$dba->query_str_convert($memoTypeId));
		
		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D30_001_13"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}


   /**
    * 関数名：レコードセットより、意味メモ位置リストを生成する。
    * @戻値：意味メモ位置リスト
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
    function getDataList() {
        
		$imimemoposition_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$imimemoposition = new ImiMemoPositionData();

			$imimemoposition->setImiSpaceID(isset($row['imispaceid'])?$row['imispaceid']:null);
			$imimemoposition->setMemoID(isset($row['memoid'])?$row['memoid']:null);
			$imimemoposition->setCoordinateX(isset($row['coordinatex'])?$row['coordinatex']:null);
			$imimemoposition->setCoordinateY(isset($row['coordinatey'])?$row['coordinatey']:null);
			$imimemoposition->setColorID(isset($row['colorid'])?$row['colorid']:null);
			$imimemoposition->setLayerID(isset($row['layerid'])?$row['layerid']:null);
			$imimemoposition->setMemoTypeID(isset($row['memotypeid'])?$row['memotypeid']:null);
			$imimemoposition->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);
			$imimemoposition->setUpdateDateTime(isset($row['updatedatetime'])?$row['updatedatetime']:null);
						
			array_push($imimemoposition_array, $imimemoposition);
		}
 		return $imimemoposition_array;
    }

   /**
    * 関数名：レコードセットより、一件の意味メモ位置データを生成する。
    * @戻値：意味メモ位置データ型オブジェクト
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
    function getOneData() {
        
		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$imimemoposition = new ImiMemoPositionData();

		$imimemoposition->setImiSpaceID(isset($row['imispaceid'])?$row['imispaceid']:null);
		$imimemoposition->setMemoID(isset($row['memoid'])?$row['memoid']:null);
		$imimemoposition->setCoordinateX(isset($row['coordinatex'])?$row['coordinatex']:null);
		$imimemoposition->setCoordinateY(isset($row['coordinatey'])?$row['coordinatey']:null);
		$imimemoposition->setColorID(isset($row['colorid'])?$row['colorid']:null);
		$imimemoposition->setLayerID(isset($row['layerid'])?$row['layerid']:null);
		$imimemoposition->setMemoTypeID(isset($row['memotypeid'])?$row['memotypeid']:null);
		$imimemoposition->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);
		$imimemoposition->setUpdateDateTime(isset($row['updatedatetime'])?$row['updatedatetime']:null);
		

 		return $imimemoposition;
    }
}
?>