<?php
/**
* ImiMemoViewAccess.class.php 処理概要 意味空間メモ情報取得DAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS) N.Soma
* @作成日/作成者：2006/09/01 N.Soma
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/ImiMemoViewData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");

class ImiMemoViewAccess extends TableAccess{

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス

	/**
	 *	コンストラクタ
	 *	@param	$directryname	ディレクトリ名称
	 */
    function ImiMemoViewAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName($directryname."_layertable");//ベースはレイヤーテーブル
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }
    
   /**
    * 関数名：意味空間用指定ユーザ閲覧可能全メモ取得（右フレーム/付加情報つき）
    * @引数：(I) $db 		- DBオブジェクト
    *        (I) $userid 	- ログインユーザID
    *        (I) $imiSpaceId - 意味空間ID  
    *        (I) $statusflg - レイヤー状態フラグ(配列)	
    *        (I) $searchKey				-　検索条件
    *              $searchKey['limit']	- 最新取得件数
    *              $searchKey['from']	- 対象期間（from）
    *              $searchKey['to']		- 対象期間（to）
    *              $searchKey['word']	- 語句
    *              $searchKey['minx']	- 範囲座標（X緯度最小）
    *              $searchKey['maxx']	- 範囲座標（X緯度最大）
    *              $searchKey['miny']	- 範囲座標（Y経度最小）
    *              $searchKey['maxy']	- 範囲座標（Y経度最大）
    * @戻値：$bool true/false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    * @概要：指定されたユーザが閲覧できる意味空間のメモのリストを取得する
    */
	function selectImiMemoViewData($db, $userId, $imiSpaceId, $statusflg, $searchKey) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_layertable.layerid");
		$dba->dba_fieldAdd($this->prefix."_layertable.layername");
		$dba->dba_fieldAdd($this->prefix."_layertable.userid as userid_l");
		$dba->dba_fieldAdd($this->prefix."_layertable.publiclayer ");

		$dba->dba_fieldAdd($this->prefix."_userpersonalinfotable.layerliststate ");
		$dba->dba_fieldAdd($this->prefix."_userpersonalinfotable.layerpriorityorder ");

		$dba->dba_fieldAdd($this->prefix."_layerprioritytable.priorityorder ");

		$dba->dba_fieldAdd($this->prefix."_memotypetable.memotypeid ");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.memotypename ");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.icontype ");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.icon ");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.ribboncolor ");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.publicmemotype ");
		
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.memoid ");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.memotitle ");

		$dba->dba_fieldAdd($this->prefix."_memopositiontable.longitude ");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.latitude ");

		$dba->dba_fieldAdd($this->prefix."_imimemopositiontable.coordinatex ");
		$dba->dba_fieldAdd($this->prefix."_imimemopositiontable.coordinatey ");
		$dba->dba_fieldAdd($this->prefix."_imimemopositiontable.colorid ");

		$dba->dba_fieldAdd("imicolormaster.colornumber ");
		$dba->dba_fieldAdd("imicolormaster.colorname ");
		$dba->dba_fieldAdd("imicolormaster.piniconname ");


		// 条件指定	
		$dba->dba_whereAdd("", "((".$this->prefix."_layertable.publiclayer = '0'");
		$dba->dba_whereAdd("AND", "(".$this->prefix."_memotypetable.publicmemotype = '0'");
		$dba->dba_whereAdd("OR", $this->prefix."_memotypetable.publicmemotype = '1'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.statusflg = '0'");		
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid = '".$userId."'))");		
		$dba->dba_whereAdd("OR", "(".$this->prefix."_layertable.publiclayer = '1'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid is not null");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.statusflg  = '0' )");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.publiclayer  = '9'");
		$dba->dba_whereAdd("AND", $this->prefix."_layertable.userid  = '".$userId."')");
		if (is_array($statusflg)) {
			$buf = $this->prefix."_layertable.statusflg IN (";
			for ($i = 0; $i < count($statusflg); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= $dba->query_str_convert($statusflg[$i]);
			}
			$buf .= ")";
			$dba->dba_whereAdd("AND", $buf);
		}
		$dba->dba_whereAdd("AND", "(".$this->prefix."_userpersonalinfotable.layerliststate = '0'");
		$dba->dba_whereAdd("OR", $this->prefix."_userpersonalinfotable.layerliststate is null)");
		//条件指定（メモ種類公開の設定）
		$dba->dba_whereAdd("AND", "(".$this->prefix."_layertable.userid <> '".$userId."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.publicmemotype <> '9'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid = '".$userId."'");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid = '".$userId."'");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid <> '".$userId."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.publicmemotype = '0'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid is null )");		
		//条件指定（意味空間）
		$dba->dba_whereAdd("AND", $this->prefix."_imimemopositiontable.imispaceid = ".$imiSpaceId);	
		//条件指定（意味空間で使用されているメモの設定）
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.memotypeid IN (SELECT distinct memotypeid FROM "
								.$this->prefix."_imimemopositiontable WHERE imispaceid = ".$imiSpaceId.")");
		//条件指定（意味空間使用レイヤー）
		$dba->dba_whereAdd("AND", $this->prefix."_imimemopositiontable.layerid IN "
									."(SELECT layerid FROM ".$this->prefix."_imilayertable WHERE ".$this->prefix."_imilayertable.imispaceid =".$imiSpaceId.")");		
		// 条件指定（削除状態）
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.deleteflg = '".KAKIKOMAP_DELETEFLG_OFF."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memodetailtable.deleteflg = '".KAKIKOMAP_DELETEFLG_OFF."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memopositiontable.deleteflg = '".KAKIKOMAP_DELETEFLG_OFF."'");
		// 条件指定（有効期限）
		$dba->dba_whereAdd("AND", "(".$this->prefix."_memotypetable.effectiveterm >= '".date('Y-m-d H:i:s')."'");
		$dba->dba_whereAdd("OR", $this->prefix."_memotypetable.effectiveterm is null )");
		
		// 検索条件指定
		if (is_null($searchKey) == false){
			//最新件数
			if (is_null($searchKey['limit']) == false){
				//リミット句を追加する
				$dba->dba_limit($searchKey['limit']);
			}
			if (is_null($searchKey['from']) == false){
				//投稿日fromを追加する
				$dba->dba_whereAdd("AND", $this->prefix."_memodetailtable.adddatetime >= '".$searchKey['from']." 00:00:00'");
			}
			if (is_null($searchKey['to']) == false){
				//投稿日toを追加する
				$dba->dba_whereAdd("AND", $this->prefix."_memodetailtable.adddatetime <= '".$searchKey['to']." 23:59:59'");
			}
			if (is_null($searchKey['word']) == false){
				//語句を追加する
				$dba->dba_whereAdd("AND", "(".$this->prefix."_memodetailtable.memotitle like '%".$searchKey['word']."%'");
				$dba->dba_whereAdd("OR", $this->prefix."_memodetailtable.memotext like '%".$searchKey['word']."%' )");
			}
			if (is_null($searchKey['minx']) == false){
				//緯度最小を追加する
				$dba->dba_whereAdd("AND", $this->prefix."_imimemopositiontable.coordinatex >=".$searchKey['minx']);
			}
			if (is_null($searchKey['maxx']) == false){
				//緯度最大を追加する
				$dba->dba_whereAdd("AND", $this->prefix."_imimemopositiontable.coordinatex <=".$searchKey['maxx']);
			}
			if (is_null($searchKey['miny']) == false){
				//経度最小を追加する
				$dba->dba_whereAdd("AND", $this->prefix."_imimemopositiontable.coordinatey >=".$searchKey['miny']);
			}
			if (is_null($searchKey['maxy']) == false){
				//経度最大を追加する
				$dba->dba_whereAdd("AND", $this->prefix."_imimemopositiontable.coordinatey <=".$searchKey['maxy']);
			}

		}

		// サブクエリ指定(INNER JOIN/ユーザ)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_usertable ON "
				.$this->prefix."_layertable.userid = "
				.$this->prefix."_usertable.userid"
				);
		// サブクエリ指定(INNER JOIN/意味メモ位置)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_imimemopositiontable ON "
				.$this->prefix."_imimemopositiontable.layerid = "
				.$this->prefix."_layertable.layerid"
				);
		// サブクエリ指定(INNER JOIN/メモ詳細)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_memodetailtable ON "
				.$this->prefix."_imimemopositiontable.memoid = "
				.$this->prefix."_memodetailtable.memoid"
				);
		// サブクエリ指定(INNER JOIN/メモ位置)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_memopositiontable ON "
				.$this->prefix."_memodetailtable.memoid = "
				.$this->prefix."_memopositiontable.memoid"
				);
		// サブクエリ指定(INNER JOIN/メモ種類)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_memotypetable ON "
				.$this->prefix."_memotypetable.memotypeid = "
				.$this->prefix."_imimemopositiontable.memotypeid"
				);
		// サブクエリ指定(INNER JOIN/色マスタ)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				"imicolormaster ON "
				.$this->prefix."_imimemopositiontable.colorid = "
				."imicolormaster.colorid"
				);
		// サブクエリ指定(LEFT JOIN/レイヤーユーザ)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerusertable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerusertable.layerid"
				." AND ".$this->prefix."_layerusertable.userid = "
				."'".$userId."'"
				);
		// サブクエリ指定(LEFT JOIN/個人情報)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_userpersonalinfotable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_userpersonalinfotable.layerid"
				." AND ".$this->prefix."_userpersonalinfotable.userid = "
				."'".$userId."'"
				);
		// サブクエリ指定(LEFT JOIN/コンテンツレイヤー)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerprioritytable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerprioritytable.layerid"
				);
		
		// ソート指定
		$dba->dba_orderAdd($this->prefix."_memodetailtable.adddatetime desc");
/*		
		if (is_null($searchKey) == false){
			//最新件数
			if (is_null($searchKey['limit']) == false){
				$dba->dba_orderAdd($this->prefix."_memodetailtable.adddatetime desc");
			}else{
				$dba->dba_orderAdd($this->prefix."_userpersonalinfotable.layerpriorityorder");
				$dba->dba_orderAdd($this->prefix."_layerprioritytable.priorityorder");
				$dba->dba_orderAdd($this->prefix."_layertable.layerid");
				$dba->dba_orderAdd($this->prefix."_memotypetable.memotypeid");
				$dba->dba_orderAdd($this->prefix."_memodetailtable.memoid");
			}
		}else{
			$dba->dba_orderAdd($this->prefix."_userpersonalinfotable.layerpriorityorder");
			$dba->dba_orderAdd($this->prefix."_layerprioritytable.priorityorder");
			$dba->dba_orderAdd($this->prefix."_layertable.layerid");
			$dba->dba_orderAdd($this->prefix."_memotypetable.memotypeid");
			$dba->dba_orderAdd($this->prefix."_memodetailtable.memoid");
		}		
*/

		if ($dba->dba_select() != true) {
			trigger_error($this->o_resource->getValue("D31_001_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
    
    }
    
   /**
    * 関数名：レコードセットより、一件の意味空間メモ表示情報データを生成する。
    * @戻値：意味基本情報データ型オブジェクト
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
     function getOneData() {
        
		if ($this->getRecordCount() == 0){
			return null;
		}
		
		$rs = $this->getRecordSet();
		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$imimemoviewdata = new ImiMemoViewData();

		// 多テーブルで同一名のカラムが存在している場合、データの混同を避けるために別名を用いている。詳細は下記
		//   レイヤーテーブルのuseridをuserid_l
		$imimemoviewdata->setLayerID(isset($row['layerid'])?$row['layerid']:null);
		$imimemoviewdata->setLayerName(isset($row['layername'])?$row['layername']:null);
		$imimemoviewdata->setUserID_l(isset($row['userid_l'])?$row['userid_l']:null);
		$imimemoviewdata->setPublicLayer(isset($row['publiclayer'])?$row['publiclayer']:null);

		$imimemoviewdata->setLayerListState(isset($row['layerliststate'])?$row['layerliststate']:null);
		$imimemoviewdata->setLayerPriorityOrder(isset($row['layerpriorityorder'])?$row['layerpriorityorder']:null);

		$imimemoviewdata->setPriorityOrder(isset($row['priorityorder'])?$row['priorityorder']:null);
		
		$imimemoviewdata->setMemoTypeID(isset($row['memotypeid'])?$row['memotypeid']:null);
		$imimemoviewdata->setMemoTypeName(isset($row['memotypename'])?$row['memotypename']:null);
		$imimemoviewdata->setIconType(isset($row['icontype'])?$row['icontype']:null);
		$imimemoviewdata->setIcon(isset($row['icon'])?$row['icon']:null);
		$imimemoviewdata->setRibbonColor(isset($row['ribboncolor'])?$row['ribboncolor']:null);
		$imimemoviewdata->setPublicMemoType(isset($row['publicmemotype'])?$row['publicmemotype']:null);

		$imimemoviewdata->setMemoID(isset($row['memoid'])?$row['memoid']:null);
		$imimemoviewdata->setMemoTitle(isset($row['memotitle'])?$row['memotitle']:null);
		$imimemoviewdata->setLongitude(isset($row['longitude'])?$row['longitude']:null);
		$imimemoviewdata->setLatitude(isset($row['latitude'])?$row['latitude']:null);
		
		$imimemoviewdata->setCoordinateX(isset($row['coordinatex'])?$row['coordinatex']:null);
		$imimemoviewdata->setCoordinateY(isset($row['coordinatey'])?$row['coordinatey']:null);
		$imimemoviewdata->setColorID(isset($row['colorid'])?$row['colorid']:null);

		$imimemoviewdata->setColorNumber(isset($row['colornumber'])?$row['colornumber']:null);
		$imimemoviewdata->setColorName(isset($row['colorname'])?$row['colorname']:null);
		$imimemoviewdata->setPinIconName(isset($row['piniconname'])?$row['piniconname']:null);
		
 		return $imimemoviewdata;
    }

   /**
    * 関数名：レコードセットより、意味空間メモ表示情報データリストを生成する。
    * @戻値：意味空間メモ表示情報データレイヤーリスト
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
    function getDataList() {
    
		$imimemoviewlist = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$imimemoviewdata = new ImiMemoViewData();

			// 多テーブルで同一名のカラムが存在している場合、データの混同を避けるために別名を用いている。詳細は下記
			//   レイヤーテーブルのuseridをuserid_l
			$imimemoviewdata->setLayerID(isset($row['layerid'])?$row['layerid']:null);
			$imimemoviewdata->setLayerName(isset($row['layername'])?$row['layername']:null);
			$imimemoviewdata->setUserID_l(isset($row['userid_l'])?$row['userid_l']:null);
			$imimemoviewdata->setPublicLayer(isset($row['publiclayer'])?$row['publiclayer']:null);
	
			$imimemoviewdata->setLayerListState(isset($row['layerliststate'])?$row['layerliststate']:null);
			$imimemoviewdata->setLayerPriorityOrder(isset($row['layerpriorityorder'])?$row['layerpriorityorder']:null);
	
			$imimemoviewdata->setPriorityOrder(isset($row['priorityorder'])?$row['priorityorder']:null);
			
			$imimemoviewdata->setMemoTypeID(isset($row['memotypeid'])?$row['memotypeid']:null);
			$imimemoviewdata->setMemoTypeName(isset($row['memotypename'])?$row['memotypename']:null);
			$imimemoviewdata->setIconType(isset($row['icontype'])?$row['icontype']:null);
			$imimemoviewdata->setIcon(isset($row['icon'])?$row['icon']:null);
			$imimemoviewdata->setRibbonColor(isset($row['ribboncolor'])?$row['ribboncolor']:null);
			$imimemoviewdata->setPublicMemoType(isset($row['publicmemotype'])?$row['publicmemotype']:null);
	
			$imimemoviewdata->setMemoID(isset($row['memoid'])?$row['memoid']:null);
			$imimemoviewdata->setMemoTitle(isset($row['memotitle'])?$row['memotitle']:null);
			$imimemoviewdata->setLongitude(isset($row['longitude'])?$row['longitude']:null);
			$imimemoviewdata->setLatitude(isset($row['latitude'])?$row['latitude']:null);
			
			$imimemoviewdata->setCoordinateX(isset($row['coordinatex'])?$row['coordinatex']:null);
			$imimemoviewdata->setCoordinateY(isset($row['coordinatey'])?$row['coordinatey']:null);
			$imimemoviewdata->setColorID(isset($row['colorid'])?$row['colorid']:null);
	
			$imimemoviewdata->setColorNumber(isset($row['colornumber'])?$row['colornumber']:null);
			$imimemoviewdata->setColorName(isset($row['colorname'])?$row['colorname']:null);
			$imimemoviewdata->setPinIconName(isset($row['piniconname'])?$row['piniconname']:null);
			
			array_push($imimemoviewlist, $imimemoviewdata);
		}
		return $imimemoviewlist;

	}
}
?>