<?php
/**
* LayerJoinUserAndLayerUserAndPersonalAndPriorityTableAccess.class.php 
*								layer_join_user_layeruser_personal_layerprioritytableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：K.Shimomura
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/Layer_User_LayerUser_Personal_PriorityData.class.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class LayerJoinUserAndLayerUserAndPersonalAndPriorityTableAccess extends TableAccess {

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス

	/**
	 * コンストラクタ
	 * @引数： (I) directryname  - string ディレクトリ名称
	 */
    function LayerJoinUserAndLayerUserAndPersonalAndPriorityTableAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

		// メインテーブル名を設定
    	$this->setTableName($directryname."_layertable");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }

    /**
     * 関数概要：レイヤー表示設定一覧データ取得クエリ発行
     * 処理詳細：レイヤー表示設定一覧データの取得クエリを生成する
     *
     * @引数： (I) db          - object  DBオブジェクト
     *      ： (I) userid      - string  ユーザID
     *      ： (I) statusflg   - array  状態フラグ(配列)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectLayerListData($db, $userid, $statusflg) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_layertable.userid");
		$dba->dba_fieldAdd($this->prefix."_layertable.layerid");
		$dba->dba_fieldAdd($this->prefix."_layertable.layername");
		$dba->dba_fieldAdd($this->prefix."_layertable.publiclayer");
		$dba->dba_fieldAdd($this->prefix."_layertable.adddatetime");
		$dba->dba_fieldAdd($this->prefix."_usertable.username");
		$dba->dba_fieldAdd($this->prefix."_userpersonalinfotable.layerliststate");		
		$dba->dba_fieldAdd($this->prefix."_userpersonalinfotable.layerpriorityorder");

		// 条件指定
/*		$dba->dba_whereAdd("", "(".$this->prefix."_layertable.publiclayer = '0'");
		$dba->dba_whereAdd("OR", "(".$this->prefix."_layertable.publiclayer = '1'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid is not null))");
*/		
		$dba->dba_whereAdd("", "(".$this->prefix."_layertable.publiclayer = '0'");
		$dba->dba_whereAdd("OR", "(".$this->prefix."_layertable.publiclayer = '1'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid is not null");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.statusflg  = '0' )");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.publiclayer  = '9'");
		$dba->dba_whereAdd("AND", $this->prefix."_layertable.userid  = '".$userid."')");		
		
		if (is_array($statusflg)) {
			$buf = $this->prefix."_layertable.statusflg IN (";
			for ($i = 0; $i < count($statusflg); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= $dba->query_str_convert($statusflg[$i]);
			}
			$buf .= ")";
			$dba->dba_whereAdd("AND", $buf);
		}

		// ソート指定
		$dba->dba_orderAdd($this->prefix."_layerprioritytable.priorityorder");
		$dba->dba_orderAdd($this->prefix."_layertable.publiclayer");
		$dba->dba_orderAdd($this->prefix."_layertable.layerid");

		// サブクエリ指定(INNER JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_usertable ON "
				.$this->prefix."_layertable.userid = "
				.$this->prefix."_usertable.userid"
				);

		// サブクエリ指定(LEFT JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerusertable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerusertable.layerid"
				." AND ".$this->prefix."_layerusertable.userid = "
				.$dba->query_str_convert($userid)
				);

		// サブクエリ指定(LEFT JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_userpersonalinfotable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_userpersonalinfotable.layerid"
				." AND ".$this->prefix."_userpersonalinfotable.userid = "
				.$dba->query_str_convert($userid)
				);

		// サブクエリ指定(LEFT JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerprioritytable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerprioritytable.layerid"
				);

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D6_001_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

   /**
    * 関数名：意味空間使用可能レイヤーリスト取得（管理者/一般）
    * @引数：(I) $db 		- DBオブジェクト
    *        (I) $userid 	- ユーザID
    *        (I) $statusflg - 状態フラグ(配列)	
    * @戻値：$bool true/false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    * @概要：ユーザが意味空間で選択可能であるレイヤーを取得する
    * @注意事項：レイヤー表示設定上非表示であっても、レイヤー参加権があるレイヤーは使用可能である
    */
	function selectViewLayerListData($db, $userid, $statusflg) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_layertable.userid");
		$dba->dba_fieldAdd($this->prefix."_layertable.layerid");
		$dba->dba_fieldAdd($this->prefix."_layertable.layername");
		$dba->dba_fieldAdd($this->prefix."_layertable.publiclayer");
		$dba->dba_fieldAdd($this->prefix."_layertable.adddatetime");
		$dba->dba_fieldAdd($this->prefix."_usertable.username");
		$dba->dba_fieldAdd($this->prefix."_userpersonalinfotable.layerliststate");		
		$dba->dba_fieldAdd($this->prefix."_userpersonalinfotable.layerpriorityorder");
		$dba->dba_fieldAdd($this->prefix."_layerprioritytable.priorityorder");
		// 条件指定
		$dba->dba_whereAdd("", "(".$this->prefix."_layertable.publiclayer = '0'");
		$dba->dba_whereAdd("OR", "(".$this->prefix."_layertable.publiclayer = '1'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid is not null");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.statusflg  = '0' )");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.publiclayer  = '9'");
		$dba->dba_whereAdd("AND", $this->prefix."_layertable.userid  = '".$userid."')");
		if (is_array($statusflg)) {
			$buf = $this->prefix."_layertable.statusflg IN (";
			for ($i = 0; $i < count($statusflg); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= $dba->query_str_convert($statusflg[$i]);
			}
			$buf .= ")";
			$dba->dba_whereAdd("AND", $buf);
		}
//		$dba->dba_whereAdd("AND", "(".$this->prefix."_userpersonalinfotable.layerliststate = '0'");
//		$dba->dba_whereAdd("OR", $this->prefix."_userpersonalinfotable.layerliststate is null)");

		// ソート指定
		$dba->dba_orderAdd($this->prefix."_userpersonalinfotable.layerpriorityorder");
		$dba->dba_orderAdd($this->prefix."_layerprioritytable.priorityorder");
		$dba->dba_orderAdd($this->prefix."_layertable.publiclayer");
		$dba->dba_orderAdd($this->prefix."_layertable.layerid");

		// サブクエリ指定(INNER JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_usertable ON "
				.$this->prefix."_layertable.userid = "
				.$this->prefix."_usertable.userid"
				);

		// サブクエリ指定(LEFT JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerusertable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerusertable.layerid"
				." AND ".$this->prefix."_layerusertable.userid = "
				.$dba->query_str_convert($userid)
				);

		// サブクエリ指定(LEFT JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_userpersonalinfotable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_userpersonalinfotable.layerid"
				." AND ".$this->prefix."_userpersonalinfotable.userid = "
				.$dba->query_str_convert($userid)
				);

		// サブクエリ指定(LEFT JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerprioritytable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerprioritytable.layerid"
				);

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D6_001_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}


   /**
    * 関数名：マップコントロール用レイヤー取得（参加要求込み・一般）
    * @引数：(I) $db 		- DBオブジェクト
    *        (I) $userid 	- ユーザID
    *        (I) $statusflg - 状態フラグ(配列)	
    * @戻値：$bool true/false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    * @概要：一般ユーザのマップコントロールで表示されるレイヤーを取得する。参加要求可能なレイヤーである
    */
	function selectMapControllLayerDataByUser($db, $userid, $statusflg) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_layertable.userid");
		$dba->dba_fieldAdd($this->prefix."_layertable.layerid");
		$dba->dba_fieldAdd($this->prefix."_layertable.layername");
		$dba->dba_fieldAdd($this->prefix."_layertable.publiclayer");
		$dba->dba_fieldAdd($this->prefix."_layertable.adddatetime");
//		$dba->dba_fieldAdd($this->prefix."_usertable.username");
		$dba->dba_fieldAdd($this->prefix."_userpersonalinfotable.layerliststate");		
		$dba->dba_fieldAdd($this->prefix."_userpersonalinfotable.layerpriorityorder");
		$dba->dba_fieldAdd($this->prefix."_layerprioritytable.priorityorder");
		// 条件指定
		$dba->dba_whereAdd("", "(".$this->prefix."_layertable.publiclayer = '0'");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.publiclayer = '1'");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.publiclayer = '9'");
		$dba->dba_whereAdd("AND", $this->prefix."_layertable.userid  = '".$userid."')");
		if (is_array($statusflg)) {
			$buf = $this->prefix."_layertable.statusflg IN (";
			for ($i = 0; $i < count($statusflg); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= $dba->query_str_convert($statusflg[$i]);
			}
			$buf .= ")";
			$dba->dba_whereAdd("AND", $buf);
		}
		$dba->dba_whereAdd("AND", "(".$this->prefix."_userpersonalinfotable.layerliststate = '0'");
		$dba->dba_whereAdd("OR", $this->prefix."_userpersonalinfotable.layerliststate is null)");

		// ソート指定
		$dba->dba_orderAdd($this->prefix."_userpersonalinfotable.layerpriorityorder");
		$dba->dba_orderAdd($this->prefix."_layerprioritytable.priorityorder");
		$dba->dba_orderAdd($this->prefix."_layertable.publiclayer");
		$dba->dba_orderAdd($this->prefix."_layertable.layerid");

		// サブクエリ指定(LEFT JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerusertable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerusertable.layerid"
				." AND ".$this->prefix."_layerusertable.userid = "
				.$dba->query_str_convert($userid)
				);

		// サブクエリ指定(LEFT JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_userpersonalinfotable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_userpersonalinfotable.layerid"
				." AND ".$this->prefix."_userpersonalinfotable.userid = "
				.$dba->query_str_convert($userid)
				);

		// サブクエリ指定(LEFT JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerprioritytable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerprioritytable.layerid"
				);

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D6_001_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}



    /**
     * 関数概要：一覧データ取得
     * 処理詳細：レコードセットより、レイヤーリンクユーザリンクレイヤーユーザリンク個人情報リンクレイヤー優先順位リストを生成する
     *
     * @引数： 
     * @戻値： array   レイヤーリンクユーザリンクレイヤーユーザリンク個人情報リンクレイヤー優先順位リスト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getDataList() {

		$join_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$joindata = new Layer_User_LayerUser_Personal_PriorityData();

			$joindata->setUserID_Layer(isset($row['userid'])?$row['userid']:null);
			$joindata->setLayerID_Layer(isset($row['layerid'])?$row['layerid']:null);
			$joindata->setLayerName_Layer(isset($row['layername'])?$row['layername']:null);
			$joindata->setPublicLayer_Layer(isset($row['publiclayer'])?$row['publiclayer']:null);
			$joindata->setAddDateTime_Layer(isset($row['adddatetime'])?$row['adddatetime']:null);

			$joindata->setUserType_User(isset($row['usertype'])?$row['usertype']:null);
			$joindata->setUserName_User(isset($row['username'])?$row['username']:null);

			$joindata->setLayerListState_UserPersonal(isset($row['layerliststate'])?$row['layerliststate']:null);
			$joindata->setLayerPriorityOrder_UserPersonal(isset($row['layerpriorityorder'])?$row['layerpriorityorder']:null);

			$joindata->setPriorityOrder_LayerPriority(isset($row['priorityorder'])?$row['priorityorder']:null);

			array_push($join_array, $joindata);
		}
 		return $join_array;
    }

}
?>