<?php
/**
* MapJoinMapDetailAccess.class.php maptableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：K.Shimomura
* @作成日/作成者：2006/09/01 (IIS)N.Soma
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/Map_MapDetailData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class MapJoinMapDetailAccess extends TableAccess {

	/**
	 *	クラス変数
	 */


    /**
     * コンストラクタ
     */
    function MapJoinMapDetailAccess() {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName("maptable");
    	$this->setRecordSet(null);
    }

    /**
     * 関数概要：マップテーブル・マップ詳細テーブル結合データ取得クエリ発行
     * 処理詳細：マップテーブルデータの全件取得クエリを生成する
     *
     * @引数： (I) db       		- object DBオブジェクト
     *         (I) $directryName    - ディレクトリ名
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)N.Soma
     * @更新日/更新者：
     * @更新内容：
     */
	function selectFindMapJoinMapDetailByKey($db, $directryName) {
		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd("maptable.userid");
		$dba->dba_fieldAdd("maptable.directryname");
		$dba->dba_fieldAdd("maptable.publiccontents");
		$dba->dba_fieldAdd("maptable.publiccontentsdatetime");
		$dba->dba_fieldAdd("maptable.addattestlayer");
		$dba->dba_fieldAdd("maptable.usertype");
		$dba->dba_fieldAdd("maptable.contentsname");
		$dba->dba_fieldAdd("maptable.autologin");
		$dba->dba_fieldAdd("maptable.layercount");
		$dba->dba_fieldAdd("maptable.memotypecount");
		$dba->dba_fieldAdd("maptable.adddatetime as adddatetime_map");
		$dba->dba_fieldAdd("maptable.updatedatetime as updatedatetime_map");
		
		$dba->dba_fieldAdd("mapdetailtable.mapnumber");
		$dba->dba_fieldAdd("mapdetailtable.listname");
		$dba->dba_fieldAdd("mapdetailtable.initiallist");
		$dba->dba_fieldAdd("mapdetailtable.outsidereference");
		$dba->dba_fieldAdd("mapdetailtable.pixel");
		$dba->dba_fieldAdd("mapdetailtable.adddatetime as adddatetime_detail");
		$dba->dba_fieldAdd("mapdetailtable.updatedatetime as updatedatetime_detail");
		
		// 条件指定
		$dba->dba_whereAdd("", "maptable.directryname = ".$dba->query_str_convert($directryName));
		
		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				"mapdetailtable ON "
				."maptable.directryname = "
				."mapdetailtable.directryname"
				);

		// ソート指定
		$dba->dba_orderAdd("mapnumber");

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D33_001_01"), E_USER_ERROR);
			return false;
		}
		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}


    /**
     * 関数概要：一覧データ取得
     * 処理詳細：レコードセットより、マップリストを生成する
     *
     * @引数： 
     * @戻値： array   マップリスト
     * @作成日/作成者：2006/09/01 (IIS)N.Soma
     * @更新日/更新者：
     * @更新内容：
     */
    function getDataList() {
        
		$map_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$mapdata = new Map_MapDetailData();

			$mapdata->setUserid(isset($row['userid'])?$row['userid']:null);
			$mapdata->setDirectryName(isset($row['directryname'])?$row['directryname']:null);
			$mapdata->setPublicContents(isset($row['publiccontents'])?$row['publiccontents']:null);
			$mapdata->setPublicContentsDateTime(isset($row['publiccontentsdatetime'])?$row['publiccontentsdatetime']:null);
			$mapdata->setAddAttestLayer(isset($row['addattestlayer'])?$row['addattestlayer']:null);
			$mapdata->setUserType(isset($row['usertype'])?$row['usertype']:null);
			$mapdata->setContentsName(isset($row['contentsname'])?$row['contentsname']:null);
			$mapdata->setAutoLogin(isset($row['autologin'])?$row['autologin']:null);
			$mapdata->setLayerCount(isset($row['layercount'])?$row['layercount']:null);
			$mapdata->setMemoTypeCount(isset($row['memotypecount'])?$row['memotypecount']:null);
			$mapdata->setAddDateTime_map(isset($row['adddatetime_map'])?$row['adddatetime_map']:null);
			$mapdata->setUpdateDateTime_map(isset($row['updatedatetime_map'])?$row['updatedatetime_map']:null);

			$mapdata->setMapNumber(isset($row['mapnumber'])?$row['mapnumber']:null);
			$mapdata->setListName(isset($row['listname'])?$row['listname']:null);
			$mapdata->setInitialList(isset($row['initiallist'])?$row['initiallist']:null);
			$mapdata->setOutsideReference(isset($row['outsidereference'])?$row['outsidereference']:null);
			$mapdata->setPixel(isset($row['pixel'])?$row['pixel']:null);
			$mapdata->setAddDateTime_detail(isset($row['adddatetime_detail'])?$row['adddatetime_detail']:null);
			$mapdata->setUpdateDateTime_detail(isset($row['updatedatetime_detail'])?$row['updatedatetime_detail']:null);

			array_push($map_array, $mapdata);
		}
 		return $map_array;
    }

    /**
     * 関数概要：単体データ取得
     * 処理詳細：レコードセットより、一件のマップデータを生成する
     *
     * @引数： 
     * @戻値： array   マップデータ型オブジェクト
     * @作成日/作成者：2006/09/01 (IIS)N.Soma
     * @更新日/更新者：
     * @更新内容：
     */
    function getOneData() {

		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$mapdata = new Map_MapDetailData();

		$mapdata->setUserid(isset($row['userid'])?$row['userid']:null);
		$mapdata->setDirectryName(isset($row['directryname'])?$row['directryname']:null);
		$mapdata->setPublicContents(isset($row['publiccontents'])?$row['publiccontents']:null);
		$mapdata->setPublicContentsDateTime(isset($row['publiccontentsdatetime'])?$row['publiccontentsdatetime']:null);
		$mapdata->setAddAttestLayer(isset($row['addattestlayer'])?$row['addattestlayer']:null);
		$mapdata->setUserType(isset($row['usertype'])?$row['usertype']:null);
		$mapdata->setContentsName(isset($row['contentsname'])?$row['contentsname']:null);
		$mapdata->setAutoLogin(isset($row['autologin'])?$row['autologin']:null);
		$mapdata->setLayerCount(isset($row['layercount'])?$row['layercount']:null);
		$mapdata->setMemoTypeCount(isset($row['memotypecount'])?$row['memotypecount']:null);
		$mapdata->setAddDateTime_map(isset($row['adddatetime_map'])?$row['adddatetime_map']:null);
		$mapdata->setUpdateDateTime_map(isset($row['updatedatetime_map'])?$row['updatedatetime_map']:null);

		$mapdata->setMapNumber(isset($row['mapnumber'])?$row['mapnumber']:null);
		$mapdata->setListName(isset($row['listname'])?$row['listname']:null);
		$mapdata->setInitialList(isset($row['initiallist'])?$row['initiallist']:null);
		$mapdata->setOutsideReference(isset($row['outsidereference'])?$row['outsidereference']:null);
		$mapdata->setPixel(isset($row['pixel'])?$row['pixel']:null);
		$mapdata->setAddDateTime_detail(isset($row['adddatetime_detail'])?$row['adddatetime_detail']:null);
		$mapdata->setUpdateDateTime_detail(isset($row['updatedatetime_detail'])?$row['updatedatetime_detail']:null);

 		return $mapdata;
    }


}
?>