<?php
/**
* MapTableAccess.class.php maptableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：K.Shimomura
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/MapData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class MapTableAccess extends TableAccess {

	/**
	 *	クラス変数
	 */


    /**
     * コンストラクタ
     */
    function MapTableAccess() {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName("maptable");
    	$this->setRecordSet(null);
    }

    /**
     * 関数概要：マップテーブルデータ全件取得クエリ発行
     * 処理詳細：マップテーブルデータの全件取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D12_001_01"), E_USER_ERROR);
			return false;
		}
		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：マップテーブルキー指定データ取得クエリ発行
     * 処理詳細：マップテーブルキー指定データの取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key      - string キー内容(ユーザID)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectFindByKeyData($db, $key) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "userid = ".$dba->query_str_convert($key));

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D12_002_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：マップテーブルディレクトリ名称キー指定データ取得クエリ発行
     * 処理詳細：マップテーブルディレクトリ名称キー指定データの取得クエリを生成する
     *
     * @引数： (I) db           - object DBオブジェクト
     *      ： (I) directryname - string ディレクトリ名称
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectDirectryNameKeyData($db, $directryname) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "directryname = ".$dba->query_str_convert($directryname));

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D12_003_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：マップテーブルデータ挿入
     * 処理詳細：マップテーブルデータの挿入クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) dataobj  - object マップデータオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function insertData($db, $dataobj) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if (is_object($dataobj) && get_class($dataobj) == MAP_DATAOBJ) {

			// ユーザID
			$dataobj->setUserID(
				$dba->query_str_convert($dataobj->getUserID()));
			// ディレクトリ名称
			$dataobj->setDirectryName(
				$dba->query_str_convert($dataobj->getDirectryName()));
			// コンテンツ公開区分
			$dataobj->setPublicContents(
				$dba->query_str_convert($dataobj->getPublicContents()));

			// コンテンツ公開日付
			if (is_null($dataobj->getPublicContentsDateTime()) != true) {
				$dataobj->setPublicContentsDateTime(
					$dba->query_str_convert($dataobj->getPublicContentsDateTime()));
			}

			// レイヤー登録認証区分
			$dataobj->setAddAttestLayer(
				$dba->query_str_convert($dataobj->getAddAttestLayer()));
			// ユーザ種別
			$dataobj->setUserType(
				$dba->query_str_convert($dataobj->getUserType()));
			// コンテンツ名称
			$dataobj->setContentsName(
				$dba->query_str_convert($dataobj->getContentsName()));
			// 自動ログイン区分
			$dataobj->setAutoLogin(
				$dba->query_str_convert($dataobj->getAutoLogin()));
			// レイヤー数
			$dataobj->setLayerCount(
				$dba->query_str_convert($dataobj->getLayerCount()));
			// メモ種類数
			$dataobj->setMemoTypeCount(
				$dba->query_str_convert($dataobj->getMemoTypeCount()));
			// 登録日時
			$dataobj->setAddDateTime(
				$dba->query_str_convert($dataobj->getAddDateTime()));
			// 更新日時
			$dataobj->setUpdateDateTime(
				$dba->query_str_convert($dataobj->getUpdateDateTime()));

			if ($dba->dba_insert($dataobj) != true) {
				trigger_error($this->o_resource->getValue("D12_004_01"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D12_004_02"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

	/**
	 *	関数名：マップテーブルキー指定データ更新
     * @引数：(I) $db               - DBオブジェクト
     *        (I) $targetDataobj    - 対象列(条件列/更新列)指定用データオブジェクト
     *        (I) $valDataobj       - 設定値(条件値/更新値)指定用データオブジェクト
     * @戻値：$bool			- true/false
     * @作成日/作成者：2006/09/01 (IIS) K.Shimomura
     * @更新日/更新者：
     * @使用方法：whereキーとして使用したい列は$targetDataobjの該当変数をWHERE_KEYに指定し、条件値を$valDataobjの該当変数に使用する。
	 *            (プライマリキー以外にWHERE_KEYを指定しても無視されます)
     *            更新したい列は$targetDataobjの該当変数をVAL_TARGETに指定し、更新値を$valDataobjの該当変数に使用する。
     *            NULLで更新したい時は$valDataobjの該当変数にNULL_CHARを指定する。
     */
	function updateByKeyData($db, $targetDataobj, $valDataobj) {

		$whereflg = false;
		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ((is_object($targetDataobj) && get_class($targetDataobj) == MAP_DATAOBJ) && 
			(is_object($valDataobj) && get_class($valDataobj) == MAP_DATAOBJ)) {

			// 条件および更新内容指定
			// ユーザID
			if ($targetDataobj->getUserID() === WHERE_KEY) {
				$dba->dba_whereAdd("", "userid = ".$dba->query_str_convert($valDataobj->getUserID()));
				$whereflg = true;
			} elseif ($targetDataobj->getUserID() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"userid = "
							.$dba->query_str_convert($valDataobj->getUserID()));
			}
			// ディレクトリ名称
			if ($targetDataobj->getDirectryName() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"directryname = "
							.$dba->query_str_convert($valDataobj->getDirectryName()));
			}
			// コンテンツ公開区分
			if ($targetDataobj->getPublicContents() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"publiccontents = "
							.$dba->query_str_convert($valDataobj->getPublicContents()));
			}
			// コンテンツ公開日付
			if ($targetDataobj->getPublicContentsDateTime() === VAL_TARGET) {
				if ($valDataobj->getPublicContentsDateTime() === NULL_CHAR) {
					$dba->dba_updateAdd("publiccontentsdatetime = null");
				} else {
					$dba->dba_updateAdd(
							"publiccontentsdatetime = "
								.$dba->query_str_convert($valDataobj->getPublicContentsDateTime()));
				}
			}
			// レイヤー登録認証区分
			if ($targetDataobj->getAddAttestLayer() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"addattestlayer = "
							.$dba->query_str_convert($valDataobj->getAddAttestLayer()));
			}
			// ユーザ種別
			if ($targetDataobj->getUserType() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"usertype = "
							.$dba->query_str_convert($valDataobj->getUserType()));
			}
			// コンテンツ名称
			if ($targetDataobj->getContentsName() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"contentsname = "
							.$dba->query_str_convert($valDataobj->getContentsName()));
			}
			// 自動ログイン区分
			if ($targetDataobj->getAutoLogin() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"autologin = "
							.$dba->query_str_convert($valDataobj->getAutoLogin()));
			}
			// レイヤー数
			if ($targetDataobj->getLayerCount() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"layercount = "
							.$valDataobj->getLayerCount());
			}
			// メモ種類数
			if ($targetDataobj->getMemoTypeCount() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"memotypecount = "
							.$valDataobj->getMemoTypeCount());
			}
			// 登録日時
			if ($targetDataobj->getAddDateTime() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"adddatetime = "
							.$dba->query_str_convert($valDataobj->getAddDateTime()));
			}
			// 更新日時
			if ($targetDataobj->getUpdateDateTime() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"updatedatetime = "
							.$dba->query_str_convert($valDataobj->getUpdateDateTime()));
			}

			// 条件指定確認
			if ($whereflg == false) {
				trigger_error($this->o_resource->getValue("D12_005_01"), E_USER_ERROR);
				return false;
			}
			//SQL実行
			if ($dba -> dba_update() != true) {
				trigger_error($this->o_resource->getValue("D12_005_02"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D12_005_03"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;

	}

    /**
     * 関数概要：マップテーブルキー指定データ削除
     * 処理詳細：マップテーブルキー指定データの削除クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key      - string キー内容(ユーザID)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function deleteByKeyData($db, $key) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "userid = ".$dba->query_str_convert($key));

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D12_006_01"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：一覧データ取得
     * 処理詳細：レコードセットより、マップリストを生成する
     *
     * @引数： 
     * @戻値： array   マップリスト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getDataList() {
        
		$map_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$mapdata = new MapData();

			$mapdata->setUserid(isset($row['userid'])?$row['userid']:null);
			$mapdata->setDirectryName(isset($row['directryname'])?$row['directryname']:null);
			$mapdata->setPublicContents(isset($row['publiccontents'])?$row['publiccontents']:null);
			$mapdata->setPublicContentsDateTime(isset($row['publiccontentsdatetime'])?$row['publiccontentsdatetime']:null);
			$mapdata->setAddAttestLayer(isset($row['addattestlayer'])?$row['addattestlayer']:null);
			$mapdata->setUserType(isset($row['usertype'])?$row['usertype']:null);
			$mapdata->setContentsName(isset($row['contentsname'])?$row['contentsname']:null);
			$mapdata->setAutoLogin(isset($row['autologin'])?$row['autologin']:null);
			$mapdata->setLayerCount(isset($row['layercount'])?$row['layercount']:null);
			$mapdata->setMemoTypeCount(isset($row['memotypecount'])?$row['memotypecount']:null);
			$mapdata->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);
			$mapdata->setUpdateDateTime(isset($row['updatedatetime'])?$row['updatedatetime']:null);

			array_push($map_array, $mapdata);
		}
 		return $map_array;
    }

    /**
     * 関数概要：単体データ取得
     * 処理詳細：レコードセットより、一件のマップデータを生成する
     *
     * @引数： 
     * @戻値： array   マップデータ型オブジェクト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getOneData() {

		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$mapdata = new MapData();

		$mapdata->setUserid(isset($row['userid'])?$row['userid']:null);
		$mapdata->setDirectryName(isset($row['directryname'])?$row['directryname']:null);
		$mapdata->setPublicContents(isset($row['publiccontents'])?$row['publiccontents']:null);
		$mapdata->setPublicContentsDateTime(isset($row['publiccontentsdatetime'])?$row['publiccontentsdatetime']:null);
		$mapdata->setAddAttestLayer(isset($row['addattestlayer'])?$row['addattestlayer']:null);
		$mapdata->setUserType(isset($row['usertype'])?$row['usertype']:null);
		$mapdata->setContentsName(isset($row['contentsname'])?$row['contentsname']:null);
		$mapdata->setAutoLogin(isset($row['autologin'])?$row['autologin']:null);
		$mapdata->setLayerCount(isset($row['layercount'])?$row['layercount']:null);
		$mapdata->setMemoTypeCount(isset($row['memotypecount'])?$row['memotypecount']:null);
		$mapdata->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);
		$mapdata->setUpdateDateTime(isset($row['updatedatetime'])?$row['updatedatetime']:null);

 		return $mapdata;
    }

    /**
     * 関数概要：マップテーブルキー指定重複チェック
     * 処理詳細：マップテーブルデータをキー指定で重複しているかをチェック
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key      - string キー内容(ユーザID)
     * @戻値： boolean true :データなし
     *      ：         false:データあり
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function checkFindByKeyData($db, $key) {

		$rtn = true;

		// キー指定データの取得
		$this->selectFindByKeyData($db, $key);

		if ($this->getRecordCount() > 0) {
			$rtn = false;	
		}

		return $rtn;
	}

    /**
     * 関数概要：マップテーブルディレクトリ名称指定重複チェック
     * 処理詳細：マップテーブルデータをディレクトリ名称キー指定で重複しているかをチェック
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key      - string キー内容(ディレクトリ名称)
     * @戻値： boolean true :データなし
     *      ：         false:データあり
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function checkFindByDirectryNameData($db, $key) {

		$rtn = true;

		// キー指定データの取得
		$this->selectDirectryNameKeyData($db, $key);

		if ($this->getRecordCount() > 0) {
			$rtn = false;	
		}

		return $rtn;
	}
}
?>