<?php
/**
* MemoDetailJoinPositionJoinTypeTableAccess.class.php 
* 							MemoDetailJoinPositionJoinTypeTableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：K.Shimomura
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/MemoDetailPositionTypeData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class MemoDetailJoinPositionJoinTypeTableAccess extends TableAccess {

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス

	/**
	 *	コンストラクタ
	 *	@param	$directryname	ディレクトリ名称
	 */
    function MemoDetailJoinPositionJoinTypeTableAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

		// メインテーブル名を設定
    	$this->setTableName($directryname."_memodetailtable");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }

    /**
    * 関数名：メモ詳細情報（付加情報つき）キー指定クエリ発行
    * @引数：(I) $db    	- DBオブジェクト
    *        (I) $memoId    - メモID
    * @戻値：true/false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function selectMemoDetailPositionTypeDataByKey($db, $memoId = "") {
	
		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.memoid");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.memotypeid");		

		$dba->dba_fieldAdd($this->prefix."_memodetailtable.username as username_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.memotitle");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.memotext");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.mailaddress as mailaddress_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.releteurl as releteurl_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.imagefile as imagefile_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.updatedeletepassword as updatedeletepassword_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.accesscount as accesscount_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.deleteflg as deleteflg_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.adddatetime as adddatetime_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.updatedatetime as updatedatetime_d");

		$dba->dba_fieldAdd($this->prefix."_memopositiontable.longitude");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.latitude");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.deleteflg as deleteflg_p");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.adddatetime as adddatetime_p");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.updatedatetime as updatedatetime_p");

		$dba->dba_fieldAdd($this->prefix."_memotypetable.layerid");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.memotypename");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.publicmemotype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.authoritymemotype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.icontype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.icon");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.ribboncolor");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.listtype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.effectiveterm");

		$dba->dba_fieldAdd($this->prefix."_layertable.layername");

		// 条件指定
		if ($memoId != "") {
			$buf = $this->prefix."_memodetailtable.memoid =".$dba->query_str_convert($memoId);
			$dba->dba_whereAdd("", $buf);
			$buf = $this->prefix."_memodetailtable.memoid =".$this->prefix."_memopositiontable.memoid";
			$dba->dba_whereAdd("AND", $buf);
			$buf = $this->prefix."_memotypetable.memotypeid =".$this->prefix."_memopositiontable.memotypeid";
			$dba->dba_whereAdd("AND", $buf);
			$buf = $this->prefix."_memotypetable.memotypeid =".$this->prefix."_memodetailtable.memotypeid";
			$dba->dba_whereAdd("AND", $buf);
			$buf = $this->prefix."_layertable.layerid =".$this->prefix."_memotypetable.layerid";
			$dba->dba_whereAdd("AND", $buf);
			
		}

		// テーブル指定
		$dba->dba_tableAdd($this->prefix."_memopositiontable");
		$dba->dba_tableAdd($this->prefix."_memotypetable");
		$dba->dba_tableAdd($this->prefix."_layertable");

		
		// ソート指定
		$dba->dba_orderAdd($this->prefix."_memodetailtable.memoid");


		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D14_001_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
    * 関数名：メモ詳細情報（ユーザによる表示権限/付加情報つき）キー指定クエリ発行
    * @引数：(I) $db    	- DBオブジェクト
    *        (I) $memoId    - メモID
    *        (I) $userId    - ユーザID
    *        (I) $statusflg - レイヤー状態フラグ(配列)	
    * @戻値：true/false
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function selectMemoDetailPositionTypeDataByKeyAuth($db, $memoId = "", $userId, $statusflg) {
	
		//取得テーブルの主をlaytertableに変更する
		$this->setTableName($this->prefix."_layertable");
	
		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.memoid");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.memotypeid");		

		$dba->dba_fieldAdd($this->prefix."_memodetailtable.username as username_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.memotitle");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.memotext");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.mailaddress as mailaddress_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.releteurl as releteurl_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.imagefile as imagefile_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.updatedeletepassword as updatedeletepassword_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.accesscount as accesscount_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.deleteflg as deleteflg_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.adddatetime as adddatetime_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.updatedatetime as updatedatetime_d");

		$dba->dba_fieldAdd($this->prefix."_memopositiontable.longitude");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.latitude");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.deleteflg as deleteflg_p");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.adddatetime as adddatetime_p");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.updatedatetime as updatedatetime_p");

		$dba->dba_fieldAdd($this->prefix."_memotypetable.layerid");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.memotypename");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.publicmemotype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.authoritymemotype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.icontype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.icon");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.ribboncolor");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.listtype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.effectiveterm");

		$dba->dba_fieldAdd($this->prefix."_layertable.layername");

		// 条件指定
		if ($memoId != "") {
			$buf = $this->prefix."_memodetailtable.memoid =".$dba->query_str_convert($memoId);
			$dba->dba_whereAdd("", $buf);
			$buf = $this->prefix."_memodetailtable.memoid =".$this->prefix."_memopositiontable.memoid";
			$dba->dba_whereAdd("AND", $buf);
			$buf = $this->prefix."_memotypetable.memotypeid =".$this->prefix."_memopositiontable.memotypeid";
			$dba->dba_whereAdd("AND", $buf);
			$buf = $this->prefix."_memotypetable.memotypeid =".$this->prefix."_memodetailtable.memotypeid";
			$dba->dba_whereAdd("AND", $buf);
			$buf = $this->prefix."_layertable.layerid =".$this->prefix."_memotypetable.layerid";
			$dba->dba_whereAdd("AND", $buf);
			
		}

		// 条件指定
		$dba->dba_whereAdd("AND", "((".$this->prefix."_layertable.publiclayer = '0'");
		$dba->dba_whereAdd("AND", "(".$this->prefix."_memotypetable.publicmemotype = '0'");
		$dba->dba_whereAdd("OR", $this->prefix."_memotypetable.publicmemotype = '1'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.statusflg = '0'");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid = '".$userId."'))");		
		$dba->dba_whereAdd("OR", "(".$this->prefix."_layertable.publiclayer = '1'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid is not null");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.statusflg  = '0' )");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.publiclayer  = '9'");
		$dba->dba_whereAdd("AND", $this->prefix."_layertable.userid  = '".$userId."')");
		if (is_array($statusflg)) {
			$buf = $this->prefix."_layertable.statusflg IN (";
			for ($i = 0; $i < count($statusflg); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= $dba->query_str_convert($statusflg[$i]);
			}
			$buf .= ")";
			$dba->dba_whereAdd("AND", $buf);
		}
		//条件指定（個人ごとのレイヤー表示設定）
		$dba->dba_whereAdd("AND", "(".$this->prefix."_userpersonalinfotable.layerliststate = '0'");
		$dba->dba_whereAdd("OR", $this->prefix."_userpersonalinfotable.layerliststate is null)");
		//条件指定（メモ種類公開の設定）
		$dba->dba_whereAdd("AND", "(".$this->prefix."_layertable.userid <> '".$userId."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.publicmemotype <> '9'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid = '".$userId."'");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid = '".$userId."'");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid <> '".$userId."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.publicmemotype = '0'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid is null )");		
		// 条件指定（削除状態）
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.deleteflg = '".KAKIKOMAP_DELETEFLG_OFF."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memodetailtable.deleteflg = '".KAKIKOMAP_DELETEFLG_OFF."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memopositiontable.deleteflg = '".KAKIKOMAP_DELETEFLG_OFF."'");
		// 条件指定（有効期限）
		$dba->dba_whereAdd("AND", "(".$this->prefix."_memotypetable.effectiveterm >= '".date('Y-m-d H:i:s')."'");
		$dba->dba_whereAdd("OR", $this->prefix."_memotypetable.effectiveterm is null )");
		
		
		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_usertable ON "
				.$this->prefix."_layertable.userid = "
				.$this->prefix."_usertable.userid"
				);
		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_memotypetable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_memotypetable.layerid"
				);
		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_memodetailtable ON "
				.$this->prefix."_memotypetable.memotypeid = "
				.$this->prefix."_memodetailtable.memotypeid"
				);
		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_memopositiontable ON "
				.$this->prefix."_memodetailtable.memoid = "
				.$this->prefix."_memopositiontable.memoid"
				);
		// サブクエリ指定(LEFT JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerusertable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerusertable.layerid"
				." AND ".$this->prefix."_layerusertable.userid = "
				."'".$userId."'"
				);
		// サブクエリ指定(LEFT JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_userpersonalinfotable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_userpersonalinfotable.layerid"
				." AND ".$this->prefix."_userpersonalinfotable.userid = "
				."'".$userId."'"
				);
		// サブクエリ指定(LEFT JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerprioritytable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerprioritytable.layerid"
				);

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D14_001_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}



	
    /**
    * 関数名：コメント詳細情報（付加情報つき）キー指定クエリ発行
    * @引数：(I) $db    	- DBオブジェクト
    *        (I) $commentId - コメントID
    * @戻値：true/false
    * @作成日/作成者：2006/09/01 (IIS)S.Komukai
    * @更新日/更新者：
    */
	function selectCommentPositionTypeDataByKey($db, $commentId = "") {
	
		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.memoid");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.memotypeid");		

		$dba->dba_fieldAdd($this->prefix."_commenttable.commentid");
		$dba->dba_fieldAdd($this->prefix."_commenttable.username as username_c");
		$dba->dba_fieldAdd($this->prefix."_commenttable.commenttitle");		
		$dba->dba_fieldAdd($this->prefix."_commenttable.commenttext");		
		$dba->dba_fieldAdd($this->prefix."_commenttable.mailaddress as mailaddress_c");
		$dba->dba_fieldAdd($this->prefix."_commenttable.releteurl as releteurl_c");
		$dba->dba_fieldAdd($this->prefix."_commenttable.imagefile as imagefile_c");
		$dba->dba_fieldAdd($this->prefix."_commenttable.updatedeletepassword as updatedeletepassword_c");
		$dba->dba_fieldAdd($this->prefix."_commenttable.accesscount as accesscount_c");
		$dba->dba_fieldAdd($this->prefix."_commenttable.deleteflg as deleteflg_c");
		$dba->dba_fieldAdd($this->prefix."_commenttable.adddatetime as adddatetime_c");
		$dba->dba_fieldAdd($this->prefix."_commenttable.updatedatetime as updatedatetime_c");
		
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.longitude");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.latitude");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.deleteflg as deleteflg_p");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.adddatetime as adddatetime_p");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.updatedatetime as updatedatetime_p");

		$dba->dba_fieldAdd($this->prefix."_memotypetable.layerid");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.memotypename");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.publicmemotype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.authoritymemotype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.icontype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.icon");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.ribboncolor");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.listtype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.effectiveterm");

		$dba->dba_fieldAdd($this->prefix."_layertable.layername");

		// 条件指定
		if ($commentId != "") {
			$buf = $this->prefix."_commenttable.commentid =".$dba->query_str_convert($commentId);
			$dba->dba_whereAdd("", $buf);
			$buf = $this->prefix."_commenttable.memoid =".$this->prefix."_memopositiontable.memoid";
			$dba->dba_whereAdd("AND", $buf);
			$buf = $this->prefix."_memodetailtable.memoid =".$this->prefix."_memopositiontable.memoid";
			$dba->dba_whereAdd("AND", $buf);
			$buf = $this->prefix."_memotypetable.memotypeid =".$this->prefix."_memopositiontable.memotypeid";
			$dba->dba_whereAdd("AND", $buf);
			$buf = $this->prefix."_memotypetable.memotypeid =".$this->prefix."_memodetailtable.memotypeid";
			$dba->dba_whereAdd("AND", $buf);
			$buf = $this->prefix."_layertable.layerid =".$this->prefix."_memotypetable.layerid";
			$dba->dba_whereAdd("AND", $buf);
		}
		// テーブル指定
		$dba->dba_tableAdd($this->prefix."_commenttable");
		$dba->dba_tableAdd($this->prefix."_memopositiontable");
		$dba->dba_tableAdd($this->prefix."_memotypetable");
		$dba->dba_tableAdd($this->prefix."_layertable");

		
		// ソート指定
		$dba->dba_orderAdd($this->prefix."_commenttable.commentid");


		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D14_001_02"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}


    /**
    * 関数名：指定ユーザ閲覧可能全メモ情報取得（付加情報つき/管理者・一般用）
    * @引数：(I) $db 				- DBオブジェクト
    *        (I) $userid 			- ユーザID
    *        (I) $statusflg 		- レイヤー状態フラグ(配列)	
    *        (I) $targetLayerId 	- 取得したいレイヤーID（意味レイヤークラス配列。nullの時は全レイヤー）
    *        (I) $targetDatetime	- 区切りとなる更新日（この時間以降のデータが対象。nullの時は全日時対象）
    *        (I) $userMode			- 使用モード（1:位置空間用、2:意味空間データ作成用） 
    *        (I) $searchKey				-　検索条件
    *              $searchKey['limit']	- 最新取得件数
    *              $searchKey['from']	- 対象期間（from）
    *              $searchKey['to']		- 対象期間（to）
    *              $searchKey['word']	- 語句
    *              $searchKey['minx']	- 範囲座標（X緯度最小）
    *              $searchKey['maxx']	- 範囲座標（X緯度最大）
    *              $searchKey['miny']	- 範囲座標（Y経度最小）
    *              $searchKey['maxy']	- 範囲座標（Y経度最大）
    * @戻値：$bool true/false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    * @概要：指定されたユーザが閲覧できるメモのリストを取得する
    */
	function selectViewMemoDetailPositionTypeDataByUser($db, $userId, $statusflg, $targetLayerId, $targetDatetime, $useMode, $searchKey) {
	
		//取得テーブルの主をlaytertableに変更する
		$this->setTableName($this->prefix."_layertable");
		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_layertable.layername");

		$dba->dba_fieldAdd($this->prefix."_memodetailtable.memoid");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.memotypeid");		

		$dba->dba_fieldAdd($this->prefix."_memodetailtable.username as username_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.memotitle");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.memotext");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.mailaddress as mailaddress_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.releteurl as releteurl_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.imagefile as imagefile_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.updatedeletepassword as updatedeletepassword_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.accesscount as accesscount_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.deleteflg as deleteflg_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.adddatetime as adddatetime_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.updatedatetime as updatedatetime_d");

		$dba->dba_fieldAdd($this->prefix."_memopositiontable.longitude");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.latitude");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.deleteflg as deleteflg_p");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.adddatetime as adddatetime_p");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.updatedatetime as updatedatetime_p");

		$dba->dba_fieldAdd($this->prefix."_memotypetable.layerid");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.memotypename");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.publicmemotype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.authoritymemotype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.icontype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.icon");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.ribboncolor");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.listtype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.effectiveterm");


		// 条件指定
		$dba->dba_whereAdd("", "((".$this->prefix."_layertable.publiclayer = '0'");
		$dba->dba_whereAdd("AND", "(".$this->prefix."_memotypetable.publicmemotype = '0'");
		$dba->dba_whereAdd("OR", $this->prefix."_memotypetable.publicmemotype = '1'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.statusflg = '0'");		
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid = '".$userId."'))");		
		$dba->dba_whereAdd("OR", "(".$this->prefix."_layertable.publiclayer = '1'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid is not null");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.statusflg  = '0' )");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.publiclayer  = '9'");
		$dba->dba_whereAdd("AND", $this->prefix."_layertable.userid  = '".$userId."')");
		if (is_array($statusflg)) {
			$buf = $this->prefix."_layertable.statusflg IN (";
			for ($i = 0; $i < count($statusflg); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= $dba->query_str_convert($statusflg[$i]);
			}
			$buf .= ")";
			$dba->dba_whereAdd("AND", $buf);
		}
		//条件指定（個人ごとのレイヤー表示設定）
		if ($useMode == 1){
			//位置空間のみの条件。意味空間のデータ作成では表示設定に関わらず対象となる
			$dba->dba_whereAdd("AND", "(".$this->prefix."_userpersonalinfotable.layerliststate = '0'");
			$dba->dba_whereAdd("OR", $this->prefix."_userpersonalinfotable.layerliststate is null)");
		}
		//条件指定（メモ種類公開の設定）
		$dba->dba_whereAdd("AND", "(".$this->prefix."_layertable.userid <> '".$userId."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.publicmemotype <> '9'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid = '".$userId."'");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid = '".$userId."'");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid <> '".$userId."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.publicmemotype = '0'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid is null )");		
		// 条件指定（削除状態）
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.deleteflg = '".KAKIKOMAP_DELETEFLG_OFF."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memodetailtable.deleteflg = '".KAKIKOMAP_DELETEFLG_OFF."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memopositiontable.deleteflg = '".KAKIKOMAP_DELETEFLG_OFF."'");
		// 条件指定（有効期限）
		$dba->dba_whereAdd("AND", "(".$this->prefix."_memotypetable.effectiveterm >= '".date('Y-m-d H:i:s')."'");
		$dba->dba_whereAdd("OR", $this->prefix."_memotypetable.effectiveterm is null )");
		
		//レイヤー指定がある場合
		if (is_array($targetLayerId) == true){
			$buf = $this->prefix."_layertable.layerid IN (";
			for ($i = 0; $i < count($targetLayerId); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= "'".$targetLayerId[$i]->getLayerID()."'";
			}
			$buf .= ")";
			$dba->dba_whereAdd("AND", $buf);
		}
		//日付指定がある場合
		if (is_null($targetDatetime) == false){
			$dba->dba_whereAdd("AND", $this->prefix."_memodetailtable.updatedatetime > '".$targetDatetime."'");
		}

		// 検索条件指定
		if (is_null($searchKey) == false){
			//最新件数
			if (is_null($searchKey['limit']) == false){
				//リミット句を追加する
				$dba->dba_limit($searchKey['limit']);
			}
			if (is_null($searchKey['from']) == false){
				//投稿日fromを追加する
				$dba->dba_whereAdd("AND", $this->prefix."_memodetailtable.adddatetime >= '".$searchKey['from']." 00:00:00'");
			}
			if (is_null($searchKey['to']) == false){
				//投稿日toを追加する
				$dba->dba_whereAdd("AND", $this->prefix."_memodetailtable.adddatetime <= '".$searchKey['to']." 23:59:59'");
			}
			if (is_null($searchKey['word']) == false){
				//語句を追加する
				$dba->dba_whereAdd("AND", "(".$this->prefix."_memodetailtable.memotitle like '%".$searchKey['word']."%'");
				$dba->dba_whereAdd("OR", $this->prefix."_memodetailtable.memotext like '%".$searchKey['word']."%' )");
			}
			if (is_null($searchKey['minx']) == false){
				//緯度最小を追加する
				$dba->dba_whereAdd("AND", $this->prefix."_memopositiontable.longitude >=".$searchKey['minx']);
			}
			if (is_null($searchKey['maxx']) == false){
				//緯度最大を追加する
				$dba->dba_whereAdd("AND", $this->prefix."_memopositiontable.longitude <=".$searchKey['maxx']);
			}
			if (is_null($searchKey['miny']) == false){
				//経度最小を追加する
				$dba->dba_whereAdd("AND", $this->prefix."_memopositiontable.latitude >=".$searchKey['miny']);
			}
			if (is_null($searchKey['maxy']) == false){
				//経度最大を追加する
				$dba->dba_whereAdd("AND", $this->prefix."_memopositiontable.latitude <=".$searchKey['maxy']);
			}
		}
		
		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_usertable ON "
				.$this->prefix."_layertable.userid = "
				.$this->prefix."_usertable.userid"
				);
		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_memotypetable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_memotypetable.layerid"
				);
		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_memodetailtable ON "
				.$this->prefix."_memotypetable.memotypeid = "
				.$this->prefix."_memodetailtable.memotypeid"
				);
		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_memopositiontable ON "
				.$this->prefix."_memodetailtable.memoid = "
				.$this->prefix."_memopositiontable.memoid"
				);
		// サブクエリ指定(LEFT JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerusertable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerusertable.layerid"
				." AND ".$this->prefix."_layerusertable.userid = "
				."'".$userId."'"
				);
		// サブクエリ指定(LEFT JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_userpersonalinfotable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_userpersonalinfotable.layerid"
				." AND ".$this->prefix."_userpersonalinfotable.userid = "
				."'".$userId."'"
				);
		// サブクエリ指定(LEFT JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerprioritytable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerprioritytable.layerid"
				);
		
		// ソート指定（地図に表示するオブジェクトの生成順の関係で、各ソート条件を逆順で指定する）
		if (is_null($searchKey) == false){
			//最新件数
			if (is_null($searchKey['limit']) == false){
				$dba->dba_orderAdd($this->prefix."_memodetailtable.adddatetime desc");
			}else{
				$dba->dba_orderAdd($this->prefix."_userpersonalinfotable.layerpriorityorder desc");
				$dba->dba_orderAdd($this->prefix."_layerprioritytable.priorityorder desc");
				$dba->dba_orderAdd($this->prefix."_layertable.layerid desc");
				$dba->dba_orderAdd($this->prefix."_memodetailtable.memoid");
			}
		}else{
			$dba->dba_orderAdd($this->prefix."_userpersonalinfotable.layerpriorityorder desc");
			$dba->dba_orderAdd($this->prefix."_layerprioritytable.priorityorder desc");
			$dba->dba_orderAdd($this->prefix."_layertable.layerid desc");
			$dba->dba_orderAdd($this->prefix."_memodetailtable.memoid");
		}


		if ($dba->dba_select() != true) {
			trigger_error($this->o_resource->getValue("D14_001_03"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
    * 関数名：閲覧可能全メモ情報取得（付加情報つき/ゲスト用）
    * @引数：(I) $db 		- DBオブジェクト
    *        (I) $statusflg - レイヤー状態フラグ(配列)	
    *        (I) $searchKey				-　検索条件
    *              $searchKey['limit']	- 最新取得件数
    *              $searchKey['from']	- 対象期間（from）
    *              $searchKey['to']		- 対象期間（to）
    *              $searchKey['word']	- 語句
    *              $searchKey['minx']	- 範囲座標（X緯度最小）
    *              $searchKey['maxx']	- 範囲座標（X緯度最大）
    *              $searchKey['miny']	- 範囲座標（Y経度最小）
    *              $searchKey['maxy']	- 範囲座標（Y経度最大）
    * @戻値：$bool true/false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    * @概要：ゲストが閲覧できるメモのリストを取得する。右フレーム
    */
	function selectViewMemoDetailPositionTypeDataGuest($db,  $statusflg, $searchKey) {
	
		//取得テーブルの主をlaytertableに変更する
		$this->setTableName($this->prefix."_layertable");
		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_layertable.layername");

		$dba->dba_fieldAdd($this->prefix."_memodetailtable.memoid");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.memotypeid");		

		$dba->dba_fieldAdd($this->prefix."_memodetailtable.username as username_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.memotitle");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.memotext");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.mailaddress as mailaddress_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.releteurl as releteurl_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.imagefile as imagefile_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.updatedeletepassword as updatedeletepassword_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.accesscount as accesscount_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.deleteflg as deleteflg_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.adddatetime as adddatetime_d");
		$dba->dba_fieldAdd($this->prefix."_memodetailtable.updatedatetime as updatedatetime_d");

		$dba->dba_fieldAdd($this->prefix."_memopositiontable.longitude");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.latitude");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.deleteflg as deleteflg_p");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.adddatetime as adddatetime_p");
		$dba->dba_fieldAdd($this->prefix."_memopositiontable.updatedatetime as updatedatetime_p");

		$dba->dba_fieldAdd($this->prefix."_memotypetable.layerid");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.memotypename");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.publicmemotype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.authoritymemotype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.icontype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.icon");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.ribboncolor");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.listtype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.effectiveterm");


		// 条件指定
		$dba->dba_whereAdd("", $this->prefix."_layertable.publiclayer = '0'");
		if (is_array($statusflg)) {
			$buf = $this->prefix."_layertable.statusflg IN (";
			for ($i = 0; $i < count($statusflg); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= $dba->query_str_convert($statusflg[$i]);
			}
			$buf .= ")";
			$dba->dba_whereAdd("AND", $buf);
		}
		//条件指定（メモ種類公開の設定）
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.publicmemotype = '0'");
		// 条件指定（削除状態）
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.deleteflg = '".KAKIKOMAP_DELETEFLG_OFF."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memodetailtable.deleteflg = '".KAKIKOMAP_DELETEFLG_OFF."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memopositiontable.deleteflg = '".KAKIKOMAP_DELETEFLG_OFF."'");
		// 条件指定（有効期限）
		$dba->dba_whereAdd("AND", "(".$this->prefix."_memotypetable.effectiveterm >= '".date('Y-m-d H:i:s')."'");
		$dba->dba_whereAdd("OR", $this->prefix."_memotypetable.effectiveterm is null )");
		
		// 検索条件指定
		if (is_null($searchKey) == false){
			//最新件数
			if (is_null($searchKey['limit']) == false){
				//リミット句を追加する
				$dba->dba_limit($searchKey['limit']);
			}
			if (is_null($searchKey['from']) == false){
				//投稿日fromを追加する
				$dba->dba_whereAdd("AND", $this->prefix."_memodetailtable.adddatetime >= '".$searchKey['from']." 00:00:00'");
			}
			if (is_null($searchKey['to']) == false){
				//投稿日toを追加する
				$dba->dba_whereAdd("AND", $this->prefix."_memodetailtable.adddatetime <= '".$searchKey['to']." 23:59:59'");
			}
			if (is_null($searchKey['word']) == false){
				//語句を追加する
				$dba->dba_whereAdd("AND", "(".$this->prefix."_memodetailtable.memotitle like '%".$searchKey['word']."%'");
				$dba->dba_whereAdd("OR", $this->prefix."_memodetailtable.memotext like '%".$searchKey['word']."%' )");
			}
			if (is_null($searchKey['minx']) == false){
				//緯度最小を追加する
				$dba->dba_whereAdd("AND", $this->prefix."_memopositiontable.longitude >=".$searchKey['minx']);
			}
			if (is_null($searchKey['maxx']) == false){
				//緯度最大を追加する
				$dba->dba_whereAdd("AND", $this->prefix."_memopositiontable.longitude <=".$searchKey['maxx']);
			}
			if (is_null($searchKey['miny']) == false){
				//経度最小を追加する
				$dba->dba_whereAdd("AND", $this->prefix."_memopositiontable.latitude >=".$searchKey['miny']);
			}
			if (is_null($searchKey['maxy']) == false){
				//経度最大を追加する
				$dba->dba_whereAdd("AND", $this->prefix."_memopositiontable.latitude <=".$searchKey['maxy']);
			}
		}


		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_usertable ON "
				.$this->prefix."_layertable.userid = "
				.$this->prefix."_usertable.userid"
				);
		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_memotypetable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_memotypetable.layerid"
				);
		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_memodetailtable ON "
				.$this->prefix."_memotypetable.memotypeid = "
				.$this->prefix."_memodetailtable.memotypeid"
				);
		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_memopositiontable ON "
				.$this->prefix."_memodetailtable.memoid = "
				.$this->prefix."_memopositiontable.memoid"
				);
		// サブクエリ指定(LEFT JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerprioritytable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerprioritytable.layerid"
				);
		
		// ソート指定（地図に表示するオブジェクトの生成順の関係で、各ソート条件を逆順で指定する）		
		if (is_null($searchKey) == false){
			//最新件数
			if (is_null($searchKey['limit']) == false){
				$dba->dba_orderAdd($this->prefix."_memodetailtable.adddatetime desc");
			}else{
				$dba->dba_orderAdd($this->prefix."_layerprioritytable.priorityorder desc");
				$dba->dba_orderAdd($this->prefix."_layertable.layerid desc");
				$dba->dba_orderAdd($this->prefix."_memodetailtable.memoid");
			}
		}else{
			$dba->dba_orderAdd($this->prefix."_layerprioritytable.priorityorder desc");
			$dba->dba_orderAdd($this->prefix."_layertable.layerid desc");
			$dba->dba_orderAdd($this->prefix."_memodetailtable.memoid");
		}		


		if ($dba->dba_select() != true) {
			trigger_error($this->o_resource->getValue("D14_001_04"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}


    /**
    * 関数名：指定ユーザ閲覧可能全レイヤーメモ種類取得（付加情報つきマップコントロール/管理者・一般用）
    * @引数：(I) $db 		- DBオブジェクト
    *        (I) $userid 	- ログインユーザID
    *        (I) $statusflg - レイヤー状態フラグ(配列)	
    *        (I) $mode 		- 取得する際の対象権限
	*                          1:閲覧権限で検索
	*                          2:投稿権限で検索
    * @戻値：$bool true/false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    * @概要：管理者・一般が閲覧できるレイヤー・メモ種類のリストを取得する
    */
	function selectMapControllLayerMemotypeDataByUser($db, $userId, $statusflg, $mode) {
	
		//取得テーブルの主をlaytertableに変更する
		$this->setTableName($this->prefix."_layertable");
		$dba = new KakikoDBAccess($db, $this->getTablename());


		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_layertable.layerid");
		$dba->dba_fieldAdd($this->prefix."_layertable.layername");
		$dba->dba_fieldAdd($this->prefix."_layertable.userid");
		$dba->dba_fieldAdd($this->prefix."_userpersonalinfotable.layerliststate");
		$dba->dba_fieldAdd($this->prefix."_userpersonalinfotable.layerpriorityorder");
		$dba->dba_fieldAdd($this->prefix."_layerprioritytable.priorityorder");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.memotypeid");		
		$dba->dba_fieldAdd($this->prefix."_memotypetable.memotypename");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.authoritymemotype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.publicmemotype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.icontype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.icon");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.ribboncolor");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.listtype");


		// 条件指定
		$dba->dba_whereAdd("", "((".$this->prefix."_layertable.publiclayer = '0'");
		$dba->dba_whereAdd("AND", "(".$this->prefix."_memotypetable.publicmemotype = '0'");
		$dba->dba_whereAdd("OR", $this->prefix."_memotypetable.publicmemotype = '1'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.statusflg = '0'");		
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid = '".$userId."'))");		
		$dba->dba_whereAdd("OR", "(".$this->prefix."_layertable.publiclayer = '1'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid is not null");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.statusflg  = '0' )");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.publiclayer  = '9'");
		$dba->dba_whereAdd("AND", $this->prefix."_layertable.userid  = '".$userId."')");
		if (is_array($statusflg)) {
			$buf = $this->prefix."_layertable.statusflg IN (";
			for ($i = 0; $i < count($statusflg); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= $dba->query_str_convert($statusflg[$i]);
			}
			$buf .= ")";
			$dba->dba_whereAdd("AND", $buf);
		}

		if ($mode == 1){
			//条件指定（メモ種類公開の設定）
			$dba->dba_whereAdd("AND", "(".$this->prefix."_layertable.userid <> '".$userId."'");
			$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.publicmemotype <> '9'");
			$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid = '".$userId."'");
			$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid = '".$userId."'");
			$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid <> '".$userId."'");
			$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.publicmemotype = '0'");
			$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid is null )");		
		}elseif ($mode == 2){
			//条件指定（メモ種類書き込み権限の設定）
			$dba->dba_whereAdd("AND", "(".$this->prefix."_layertable.userid <> '".$userId."'");
			$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.authoritymemotype <> '9'");
			$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid = '".$userId."'");
			$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid = '".$userId."'");
			$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.authoritymemotype <> '9'");
			$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid <> '".$userId."'");
			$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.authoritymemotype = '0'");
			$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid is null )");		
		}
		//条件指定（個人ごとのレイヤー表示設定）
		$dba->dba_whereAdd("AND", "(".$this->prefix."_userpersonalinfotable.layerliststate = '0'");
		$dba->dba_whereAdd("OR", $this->prefix."_userpersonalinfotable.layerliststate is null)");		
		// 条件指定（有効期限）
		$dba->dba_whereAdd("AND", "(".$this->prefix."_memotypetable.effectiveterm >= '".date('Y-m-d H:i:s')."'");
		$dba->dba_whereAdd("OR", $this->prefix."_memotypetable.effectiveterm is null )");


		// 条件指定（削除状態）
		$dba->dba_whereAdd("AND",$this->prefix."_memotypetable.deleteflg = '".KAKIKOMAP_DELETEFLG_OFF."'");
		
		// サブクエリ指定(INNER JOIN/ユーザ)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_usertable ON "
				.$this->prefix."_layertable.userid = "
				.$this->prefix."_usertable.userid"
				);
		// サブクエリ指定(INNER JOIN/メモ種類)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_memotypetable ON "
				.$this->prefix."_memotypetable.layerid = "
				.$this->prefix."_layertable.layerid"
				);
		// サブクエリ指定(LEFT JOIN/ユーザレイヤー)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerusertable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerusertable.layerid"
				." AND ".$this->prefix."_layerusertable.userid = "
				."'".$userId."'"
				);
		// サブクエリ指定(LEFT JOIN/個人情報)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_userpersonalinfotable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_userpersonalinfotable.layerid"
				." AND ".$this->prefix."_userpersonalinfotable.userid = "
				."'".$userId."'"
				);
		// サブクエリ指定(LEFT JOIN/コンテンツレイヤー)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerprioritytable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerprioritytable.layerid"
				);
		
		// ソート指定
		$dba->dba_orderAdd($this->prefix."_userpersonalinfotable.layerpriorityorder");
		$dba->dba_orderAdd($this->prefix."_layerprioritytable.priorityorder");
		$dba->dba_orderAdd($this->prefix."_layertable.publiclayer");		
		$dba->dba_orderAdd($this->prefix."_layertable.layerid");
		$dba->dba_orderAdd($this->prefix."_memotypetable.memotypeid");


		if ($dba->dba_select() != true) {
			trigger_error($this->o_resource->getValue("D14_001_05"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;

	}

    /**
    * 関数名：閲覧可能全レイヤーメモ種類取得（付加情報つきマップコントロール/ゲスト用）
    * @引数：(I) $db 		- DBオブジェクト
    *        (I) $statusflg - レイヤー状態フラグ(配列)	
    *        (I) $mode 		- 取得する際の対象権限
	*                          1:閲覧権限で検索
	*                          2:投稿権限で検索
    * @戻値：$bool true/false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    * @概要：ゲストが閲覧できるレイヤー・メモ種類のリストを取得する
    */
	function selectMapControllLayerMemotypeDataGuest($db, $statusflg, $mode) {
	
		//取得テーブルの主をlaytertableに変更する
		$this->setTableName($this->prefix."_layertable");
		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_layertable.layerid");
		$dba->dba_fieldAdd($this->prefix."_layertable.layername");
		$dba->dba_fieldAdd($this->prefix."_layerprioritytable.priorityorder");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.memotypeid");		
		$dba->dba_fieldAdd($this->prefix."_memotypetable.memotypename");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.authoritymemotype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.icontype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.icon");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.ribboncolor");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.listtype");


		// 条件指定
		$dba->dba_whereAdd("", $this->prefix."_layertable.publiclayer = '0'");
		if (is_array($statusflg)) {
			$buf = $this->prefix."_layertable.statusflg IN (";
			for ($i = 0; $i < count($statusflg); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= $dba->query_str_convert($statusflg[$i]);
			}
			$buf .= ")";
			$dba->dba_whereAdd("AND", $buf);
		}
		if ($mode == 1){
			//条件指定（メモ種類公開の設定）
			$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.publicmemotype = '0'");
		}elseif ($mode == 2){
			//条件指定（メモ種類書き込み権限の設定）
			$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.authoritymemotype = '0'");		
		}
		// 条件指定（削除状態）
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.deleteflg = '".KAKIKOMAP_DELETEFLG_OFF."'");
		// 条件指定（有効期限）
		$dba->dba_whereAdd("AND", "(".$this->prefix."_memotypetable.effectiveterm >= '".date('Y-m-d H:i:s')."'");
		$dba->dba_whereAdd("OR", $this->prefix."_memotypetable.effectiveterm is null )");

		// サブクエリ指定(INNER JOIN/ユーザ)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_usertable ON "
				.$this->prefix."_layertable.userid = "
				.$this->prefix."_usertable.userid"
				);
		// サブクエリ指定(INNER JOIN/メモ種類)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_memotypetable ON "
				.$this->prefix."_memotypetable.layerid = "
				.$this->prefix."_layertable.layerid"
				);
		// サブクエリ指定(LEFT JOIN/コンテンツレイヤー)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerprioritytable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerprioritytable.layerid"
				);
		
		// ソート指定
		$dba->dba_orderAdd($this->prefix."_layerprioritytable.priorityorder");
		$dba->dba_orderAdd($this->prefix."_layertable.publiclayer");		
		$dba->dba_orderAdd($this->prefix."_layertable.layerid");
		$dba->dba_orderAdd($this->prefix."_memotypetable.memotypeid");


		if ($dba->dba_select() != true) {
			trigger_error($this->o_resource->getValue("D14_001_06"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;

	}

	/**
	* 関数概要：指定レイヤーRSS情報取得
	* 処理詳細：指定されたレイヤーのRSS情報を取得する。
	*
	* @引数： (I) $db 		     - DBオブジェクト
	*  　　　 (I) $targetLayerId - 取得対象のレイヤーID
	*  　　　 (I) $authMemoType  - ゲストユーザ制限
	*              　　　　　　　　（true:ゲストユーザのみ, false:制限なし）
	* @戻値： $bool true/false
	* @作成日/作成者：2006/09/01 (IIS)S.Komukai
	* @更新日/更新者：
	* @更新内容：
	*/	
	function selectRSSData($db, $targetLayerId, $authMemoType){
			
		$whereAdd = "";
		if($authMemoType){
			$whereAdd = "AND ".$this->prefix."_memotypetable.publicmemotype = '0' ";
		}

		$sql = "SELECT * FROM ("
					."(SELECT " 
						.$this->prefix."_layertable.layerid, "
						.$this->prefix."_layertable.layername, "
						
						.$this->prefix."_memotypetable.memotypeid, "
						.$this->prefix."_memotypetable.memotypename, "
						
						.$this->prefix."_memopositiontable.longitude, "
						.$this->prefix."_memopositiontable.latitude, "
						
						.$this->prefix."_memodetailtable.memoid, "
						.$this->prefix."_memodetailtable.memotitle, "
						.$this->prefix."_memodetailtable.username as username_d, "
						.$this->prefix."_memodetailtable.memotext, "
						.$this->prefix."_memodetailtable.imagefile  as imagefile_d, "
						.$this->prefix."_memodetailtable.updatedatetime as updatedatetime_d, "
				
						.$this->prefix."_commenttable.commentid, "
						.$this->prefix."_commenttable.commenttitle, "
						.$this->prefix."_commenttable.username as username_c, "
						.$this->prefix."_commenttable.commenttext, "
						.$this->prefix."_commenttable.imagefile as imagefile_c, "
						.$this->prefix."_commenttable.updatedatetime as updatedatetime_c, "
				
						.$this->prefix."_commenttable.updatedatetime as sortdatetime "
					."FROM ".$this->prefix."_memodetailtable "
						."INNER JOIN ".$this->prefix."_memotypetable ON ".$this->prefix."_memotypetable.memotypeid = ".$this->prefix."_memodetailtable.memotypeid "
						."INNER JOIN ".$this->prefix."_layertable ON ".$this->prefix."_layertable.layerid = ".$this->prefix."_memotypetable.layerid "
						."INNER JOIN ".$this->prefix."_memopositiontable ON ".$this->prefix."_memodetailtable.memoid = ".$this->prefix."_memopositiontable.memoid "
						."INNER JOIN ".$this->prefix."_commenttable ON ".$this->prefix."_memodetailtable.memoid = ".$this->prefix."_commenttable.memoid "
					."WHERE ".$this->prefix."_layertable.publiclayer = '0' "
						."AND ".$this->prefix."_layertable.statusflg IN ('0') "
						."AND ".$this->prefix."_layertable.layerid = '".$targetLayerId."' "
						."AND ".$this->prefix."_memotypetable.effectiveterm >= current_date "
						.$whereAdd
				.") "
				."UNION "
					."(SELECT "
						.$this->prefix."_layertable.layerid, "
						.$this->prefix."_layertable.layername, "
				
						.$this->prefix."_memotypetable.memotypeid, "
						.$this->prefix."_memotypetable.memotypename, "
				
						.$this->prefix."_memopositiontable.longitude, "
						.$this->prefix."_memopositiontable.latitude, "
						
						.$this->prefix."_memodetailtable.memoid, "
						.$this->prefix."_memodetailtable.memotitle, "
						.$this->prefix."_memodetailtable.username as username_d, "
						.$this->prefix."_memodetailtable.memotext, "
						.$this->prefix."_memodetailtable.imagefile as imagefile_d, "
						.$this->prefix."_memodetailtable.updatedatetime as updatedatetime_d, "
						
						." null as commentid, "
						." null as commenttitle, "
						." null as username_c, "
						." null as commenttext, "
						." null as imagefile, "
						." null as updatedatetime_c, "
				
						.$this->prefix."_memodetailtable.updatedatetime as sortdatetime "
					."FROM ".$this->prefix."_memodetailtable "
							."INNER JOIN ".$this->prefix."_memotypetable ON ".$this->prefix."_memotypetable.memotypeid = ".$this->prefix."_memodetailtable.memotypeid "
							."INNER JOIN ".$this->prefix."_layertable ON ".$this->prefix."_layertable.layerid = ".$this->prefix."_memotypetable.layerid "
							."INNER JOIN ".$this->prefix."_memopositiontable ON ".$this->prefix."_memodetailtable.memoid = ".$this->prefix."_memopositiontable.memoid "

					."WHERE ".$this->prefix."_layertable.publiclayer = '0' "
						."AND ".$this->prefix."_layertable.statusflg IN ('0') "
						."AND ".$this->prefix."_layertable.layerid = '".$targetLayerId."' "
						."AND ".$this->prefix."_memotypetable.effectiveterm >= current_date "
						.$whereAdd
				.") "
			.") as rss "
			."ORDER BY sortdatetime desc, memotypeid";
		
		$this->setRecordSet($db->executeQuery($sql));
		
		return true;
		
	}



    /**
    * 関数名：意味空間用指定ユーザ閲覧可能全レイヤーメモ種類取得（付加情報つきマップコントロール）
    * @引数：(I) $db 		- DBオブジェクト
    *        (I) $userid 	- ログインユーザID
    *        (I) $imiSpaceId - 意味空間ID	    
    *        (I) $statusflg - レイヤー状態フラグ(配列)	
    * @戻値：$bool true/false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    * @概要：指定されたユーザが閲覧できる意味空間のレイヤー・メモ種類のリストを取得する
    */
	function selectImiMapControllLayerMemotypeData($db, $userId, $imiSpaceId, $statusflg) {
	
		//取得テーブルの主をlaytertableに変更する
		$this->setTableName($this->prefix."_layertable");
		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_layertable.layername");

		$dba->dba_fieldAdd($this->prefix."_memotypetable.memotypeid");		
		$dba->dba_fieldAdd($this->prefix."_memotypetable.layerid");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.memotypename");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.authoritymemotype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.icontype");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.icon");
		$dba->dba_fieldAdd($this->prefix."_memotypetable.ribboncolor");


		// 条件指定
		$dba->dba_whereAdd("", "((".$this->prefix."_layertable.publiclayer = '0'");
		$dba->dba_whereAdd("AND", "(".$this->prefix."_memotypetable.publicmemotype = '0'");
		$dba->dba_whereAdd("OR", $this->prefix."_memotypetable.publicmemotype = '1'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.statusflg = '0'");		
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid = '".$userId."'))");		
		$dba->dba_whereAdd("OR", "(".$this->prefix."_layertable.publiclayer = '1'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid is not null");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.statusflg  = '0' )");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.publiclayer  = '9'");
		$dba->dba_whereAdd("AND", $this->prefix."_layertable.userid  = '".$userId."')");
		if (is_array($statusflg)) {
			$buf = $this->prefix."_layertable.statusflg IN (";
			for ($i = 0; $i < count($statusflg); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= $dba->query_str_convert($statusflg[$i]);
			}
			$buf .= ")";
			$dba->dba_whereAdd("AND", $buf);
		}
		$dba->dba_whereAdd("AND", "(".$this->prefix."_userpersonalinfotable.layerliststate = '0'");
		$dba->dba_whereAdd("OR", $this->prefix."_userpersonalinfotable.layerliststate is null)");
		//条件指定（メモ種類公開の設定）
		$dba->dba_whereAdd("AND", "(".$this->prefix."_layertable.userid <> '".$userId."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.publicmemotype <> '9'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid = '".$userId."'");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid = '".$userId."'");
		$dba->dba_whereAdd("OR", $this->prefix."_layertable.userid <> '".$userId."'");
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.publicmemotype = '0'");
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.userid is null )");		
		//条件指定（意味空間で使用されているメモの設定）
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.memotypeid IN (SELECT distinct memotypeid FROM "
								.$this->prefix."_imimemopositiontable WHERE imispaceid = ".$imiSpaceId.")");
		//条件指定（意味空間で使用されているレイヤーの設定）
		$dba->dba_whereAdd("AND", $this->prefix."_layertable.layerid IN (SELECT layerid FROM "
								.$this->prefix."_imilayertable WHERE imispaceid = ".$imiSpaceId.")");
		// 条件指定（削除状態）
		$dba->dba_whereAdd("AND", $this->prefix."_memotypetable.deleteflg = '".KAKIKOMAP_DELETEFLG_OFF."'");
		// 条件指定（有効期限）
		$dba->dba_whereAdd("AND", "(".$this->prefix."_memotypetable.effectiveterm >= '".date('Y-m-d H:i:s')."'");
		$dba->dba_whereAdd("OR", $this->prefix."_memotypetable.effectiveterm is null )");

		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_usertable ON "
				.$this->prefix."_layertable.userid = "
				.$this->prefix."_usertable.userid"
				);
		// サブクエリ指定(INNER JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_memotypetable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_memotypetable.layerid"
				);
		// サブクエリ指定(LEFT JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerusertable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerusertable.layerid"
				." AND ".$this->prefix."_layerusertable.userid = "
				."'".$userId."'"
				);
		// サブクエリ指定(LEFT JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_userpersonalinfotable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_userpersonalinfotable.layerid"
				." AND ".$this->prefix."_userpersonalinfotable.userid = "
				."'".$userId."'"
				);
		// サブクエリ指定(LEFT JOIN)
		$dba->dba_subQueryAdd(KAKIKO_DBA_LEFT, 
				$this->prefix."_layerprioritytable ON "
				.$this->prefix."_layertable.layerid = "
				.$this->prefix."_layerprioritytable.layerid"
				);
		
		// ソート指定
		$dba->dba_orderAdd($this->prefix."_userpersonalinfotable.layerpriorityorder");
		$dba->dba_orderAdd($this->prefix."_layerprioritytable.priorityorder");
		$dba->dba_orderAdd($this->prefix."_layertable.publiclayer");		
		$dba->dba_orderAdd($this->prefix."_layertable.layerid");
		$dba->dba_orderAdd($this->prefix."_memotypetable.memotypeid");


		if ($dba->dba_select() != true) {
			trigger_error($this->o_resource->getValue("D14_001_07"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;

	}



   /**
    * 関数名：レコードセットより、一件の意味基本情報データを生成する。
    * @戻値：意味基本情報データ型オブジェクト
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
     function getOneData() {
        
		if ($this->getRecordCount() == 0){
			return null;
		}
		
		$rs = $this->getRecordSet();
		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$memoDetailPositonTypedata = new MemoDetailPositionTypeData();

		// カラム名が同名のためstatusflg、adddatetime、updatedatetimeを
		// メモ詳細テーブルの上記カラム名をstatusflg_d、adddatetime_d、updatedatetime_d、
		// メモ位置テーブルの上記カラム名をstatusflg_p、adddatetime_p、updatedatetime_dで使用すること。

		$memoDetailPositonTypedata->setMemoID(isset($row['memoid'])?$row['memoid']:null);
		$memoDetailPositonTypedata->setMemoTypeID(isset($row['memotypeid'])?$row['memotypeid']:null);
		
		$memoDetailPositonTypedata->setUserName_d(isset($row['username_d'])?$row['username_d']:null);
		$memoDetailPositonTypedata->setMemoTitle(isset($row['memotitle'])?$row['memotitle']:null);
		$memoDetailPositonTypedata->setMemoText(isset($row['memotext'])?$row['memotext']:null);
		$memoDetailPositonTypedata->setMailAddress_d(isset($row['mailaddress_d'])?$row['mailaddress_d']:null);
		$memoDetailPositonTypedata->setReleteURL_d(isset($row['releteurl_d'])?$row['releteurl_d']:null);
		$memoDetailPositonTypedata->setImageFile_d(isset($row['imagefile_d'])?$row['imagefile_d']:null);
		$memoDetailPositonTypedata->setUpdateDeletePassword_d(isset($row['updatedeletepassword_d'])?$row['updatedeletepassword_d']:null);
		$memoDetailPositonTypedata->setAccessCount_d(isset($row['accesscount_d'])?$row['accesscount_d']:null);
		$memoDetailPositonTypedata->setDeleteFlg_d(isset($row['deleteflg_d'])?$row['deleteflg_d']:null);
		$memoDetailPositonTypedata->setAddDateTime_d(isset($row['adddatetime_d'])?$row['adddatetime_d']:null);
		$memoDetailPositonTypedata->setUpdateDateTime_d(isset($row['updatedatetime_d'])?$row['updatedatetime_d']:null);

		$memoDetailPositonTypedata->setLongitude(isset($row['longitude'])?$row['longitude']:null);
		$memoDetailPositonTypedata->setLatitude(isset($row['latitude'])?$row['latitude']:null);
		$memoDetailPositonTypedata->setDeleteFlg_p(isset($row['deleteflg_p'])?$row['deleteflg_p']:null);
		$memoDetailPositonTypedata->setAddDateTime_p(isset($row['adddatetime_p'])?$row['adddatetime_p']:null);
		$memoDetailPositonTypedata->setUpdateDateTime_p(isset($row['updatedatetime_p'])?$row['updatedatetime_p']:null);

		$memoDetailPositonTypedata->setLayerID(isset($row['layerid'])?$row['layerid']:null);
		$memoDetailPositonTypedata->setMemoTypeName(isset($row['memotypename'])?$row['memotypename']:null);
		$memoDetailPositonTypedata->setPublicMemoType(isset($row['publicmemotype'])?$row['publicmemotype']:null);
		$memoDetailPositonTypedata->setAuthorityMemoType(isset($row['authoritymemotype'])?$row['authoritymemotype']:null);
		$memoDetailPositonTypedata->setIconType(isset($row['icontype'])?$row['icontype']:null);
		$memoDetailPositonTypedata->setIcon(isset($row['icon'])?$row['icon']:null);
		$memoDetailPositonTypedata->setRibbonColor(isset($row['ribboncolor'])?$row['ribboncolor']:null);
		$memoDetailPositonTypedata->setListType(isset($row['listtype'])?$row['listtype']:null);
		$memoDetailPositonTypedata->setEffectiveTerm(isset($row['effectiveterm'])?$row['effectiveterm']:null);

		$memoDetailPositonTypedata->setLayerName(isset($row['layername'])?$row['layername']:null);

		$memoDetailPositonTypedata->setCommentID(isset($row['commentid'])?$row['commentid']:null);
		$memoDetailPositonTypedata->setUserName_c(isset($row['username_c'])?$row['username_c']:null);
		$memoDetailPositonTypedata->setCommentTitle(isset($row['commenttitle'])?$row['commenttitle']:null);
		$memoDetailPositonTypedata->setCommentText(isset($row['commenttext'])?$row['commenttext']:null);
		$memoDetailPositonTypedata->setMailAddress_c(isset($row['mailaddress_c'])?$row['mailaddress_c']:null);
		$memoDetailPositonTypedata->setReleteURL_c(isset($row['releteurl_c'])?$row['releteurl_c']:null);
		$memoDetailPositonTypedata->setImageFile_c(isset($row['imagefile_c'])?$row['imagefile_c']:null);
		$memoDetailPositonTypedata->setUpdateDeletePassword_c(isset($row['updatedeletepassword_c'])?$row['updatedeletepassword_c']:null);
		$memoDetailPositonTypedata->setAccessCount_c(isset($row['accesscount_c'])?$row['accesscount_c']:null);
		$memoDetailPositonTypedata->setDeleteFlg_c(isset($row['deleteflg_c'])?$row['deleteflg_c']:null);
		$memoDetailPositonTypedata->setAddDateTime_c(isset($row['adddatetime_c'])?$row['adddatetime_c']:null);
		$memoDetailPositonTypedata->setUpdateDateTime_c(isset($row['updatedatetime_c'])?$row['updatedatetime_c']:null);

 		return $memoDetailPositonTypedata;
    }

    /**
     * 関数概要：一覧データ取得
     * 処理詳細：レコードセットより、ユーザリンクレイヤーユーザ、レイヤーリストを生成する
     *
     * @引数： 
     * @戻値： array   ユーザリンクレイヤーユーザ、レイヤーリスト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getDataList() {
        
		$memoDetailPositonTypedata_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$memoDetailPositonTypedata = new MemoDetailPositionTypeData();
	
			// カラム名が同名のためstatusflg、adddatetime、updatedatetimeを
			// メモ詳細テーブルの上記カラム名をstatusflg_d、adddatetime_d、updatedatetime_d、
			// メモ位置テーブルの上記カラム名をstatusflg_p、adddatetime_p、updatedatetime_dで使用すること。
	
			$memoDetailPositonTypedata->setMemoID(isset($row['memoid'])?$row['memoid']:null);
			$memoDetailPositonTypedata->setMemoTypeID(isset($row['memotypeid'])?$row['memotypeid']:null);
			
			$memoDetailPositonTypedata->setUserName_d(isset($row['username_d'])?$row['username_d']:null);
			$memoDetailPositonTypedata->setMemoTitle(isset($row['memotitle'])?$row['memotitle']:null);
			$memoDetailPositonTypedata->setMemoText(isset($row['memotext'])?$row['memotext']:null);
			$memoDetailPositonTypedata->setMailAddress_d(isset($row['mailaddress_d'])?$row['mailaddress_d']:null);
			$memoDetailPositonTypedata->setReleteURL_d(isset($row['releteurl_d'])?$row['releteurl_d']:null);
			$memoDetailPositonTypedata->setImageFile_d(isset($row['imagefile_d'])?$row['imagefile_d']:null);
			$memoDetailPositonTypedata->setUpdateDeletePassword_d(isset($row['updatedeletepassword_d'])?$row['updatedeletepassword_d']:null);
			$memoDetailPositonTypedata->setAccessCount_d(isset($row['accesscount_d'])?$row['accesscount_d']:null);
			$memoDetailPositonTypedata->setDeleteFlg_d(isset($row['deleteflg_d'])?$row['deleteflg_d']:null);
			$memoDetailPositonTypedata->setAddDateTime_d(isset($row['adddatetime_d'])?$row['adddatetime_d']:null);
			$memoDetailPositonTypedata->setUpdateDateTime_d(isset($row['updatedatetime_d'])?$row['updatedatetime_d']:null);
			
			$memoDetailPositonTypedata->setLongitude(isset($row['longitude'])?$row['longitude']:null);
			$memoDetailPositonTypedata->setLatitude(isset($row['latitude'])?$row['latitude']:null);
			$memoDetailPositonTypedata->setDeleteFlg_p(isset($row['deleteflg_p'])?$row['deleteflg_p']:null);
			$memoDetailPositonTypedata->setAddDateTime_p(isset($row['adddatetime_p'])?$row['adddatetime_p']:null);
			$memoDetailPositonTypedata->setUpdateDateTime_p(isset($row['updatedatetime_p'])?$row['updatedatetime_p']:null);
	
			$memoDetailPositonTypedata->setLayerID(isset($row['layerid'])?$row['layerid']:null);
			$memoDetailPositonTypedata->setMemoTypeName(isset($row['memotypename'])?$row['memotypename']:null);
			$memoDetailPositonTypedata->setPublicMemoType(isset($row['publicmemotype'])?$row['publicmemotype']:null);
			$memoDetailPositonTypedata->setAuthorityMemoType(isset($row['authoritymemotype'])?$row['authoritymemotype']:null);
			$memoDetailPositonTypedata->setIconType(isset($row['icontype'])?$row['icontype']:null);
			$memoDetailPositonTypedata->setIcon(isset($row['icon'])?$row['icon']:null);
			$memoDetailPositonTypedata->setRibbonColor(isset($row['ribboncolor'])?$row['ribboncolor']:null);
			$memoDetailPositonTypedata->setListType(isset($row['listtype'])?$row['listtype']:null);
			$memoDetailPositonTypedata->setEffectiveTerm(isset($row['effectiveterm'])?$row['effectiveterm']:null);

			$memoDetailPositonTypedata->setLayerName(isset($row['layername'])?$row['layername']:null);

			$memoDetailPositonTypedata->setCommentID(isset($row['commentid'])?$row['commentid']:null);
			$memoDetailPositonTypedata->setUserName_c(isset($row['username_c'])?$row['username_c']:null);
			$memoDetailPositonTypedata->setCommentTitle(isset($row['commenttitle'])?$row['commenttitle']:null);
			$memoDetailPositonTypedata->setCommentText(isset($row['commenttext'])?$row['commenttext']:null);
			$memoDetailPositonTypedata->setMailAddress_c(isset($row['mailaddress_c'])?$row['mailaddress_c']:null);
			$memoDetailPositonTypedata->setReleteURL_c(isset($row['releteurl_c'])?$row['releteurl_c']:null);
			$memoDetailPositonTypedata->setImageFile_c(isset($row['imagefile_c'])?$row['imagefile_c']:null);
			$memoDetailPositonTypedata->setUpdateDeletePassword_c(isset($row['updatedeletepassword_c'])?$row['updatedeletepassword_c']:null);
			$memoDetailPositonTypedata->setAccessCount_c(isset($row['accesscount_c'])?$row['accesscount_c']:null);
			$memoDetailPositonTypedata->setDeleteFlg_c(isset($row['deleteflg_c'])?$row['deleteflg_c']:null);
			$memoDetailPositonTypedata->setAddDateTime_c(isset($row['adddatetime_c'])?$row['adddatetime_c']:null);
			$memoDetailPositonTypedata->setUpdateDateTime_c(isset($row['updatedatetime_c'])?$row['updatedatetime_c']:null);

			array_push($memoDetailPositonTypedata_array, $memoDetailPositonTypedata);
		}
 		return $memoDetailPositonTypedata_array;
    }
}
?>