<?php
/**
* MemoTypeTableAccess.class.php memotypetableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：K.Shimomura
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/MemoTypeData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class MemoTypeTableAccess extends TableAccess {

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス


    /**
     * コンストラクタ
     * @引数： (I) directryname  - string ディレクトリ名称
     */
    function MemoTypeTableAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName($directryname."_memotypetable");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }

    /**
     * 関数概要：メモ種類データ全件取得クエリ発行
     * 処理詳細：メモ種類テーブルデータの全件取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D17_001_01"), E_USER_ERROR);
			return false;
		}
		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：メモ種類キー指定データ取得クエリ発行
     * 処理詳細：メモ種類テーブルキー指定データの取得クエリを生成する
     *
     * @引数： (I) db       - object  DBオブジェクト
     *      ： (I) key      - integer キー内容(メモ種類ID)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectFindByKeyData($db, $key) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "memotypeid = ".$key);

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D17_002_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：メモ種類一覧データ取得クエリ発行
     * 処理詳細：メモ種類一覧データの取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) layerid  - string レイヤーID
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectMemoTypeListData($db, $layerid) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "layerid = ".$dba->query_str_convert($layerid));

		// ソート指定
		$dba->dba_orderAdd("memotypeid");

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D17_003_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：メモ種類データ挿入
     * 処理詳細：メモ種類テーブルデータの挿入クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) dataobj  - object メモ種類データオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function insertData($db, $dataobj) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if (is_object($dataobj) && get_class($dataobj) == MEMOTYPE_DATAOBJ) {

			// メモ種類ID
			$dataobj->setMemoTypeID('default');
			// レイヤーID
			$dataobj->setLayerID(
				$dba->query_str_convert($dataobj->getLayerID()));
			// メモ種類名称
			$dataobj->setMemoTypeName(
				$dba->query_str_convert($dataobj->getMemoTypeName()));
			// メモ種類公開区分
			$dataobj->setPublicMemoType(
				$dba->query_str_convert($dataobj->getPublicMemoType()));
			// メモ種類権限区分
			$dataobj->setAuthorityMemoType(
				$dba->query_str_convert($dataobj->getAuthorityMemoType()));
			// アイコン種別
			$dataobj->setIconType(
				$dba->query_str_convert($dataobj->getIconType()));
			// アイコン
			if (is_null($dataobj->getIcon()) != true) {
				$dataobj->setIcon(
					$dba->query_str_convert($dataobj->getIcon()));
			}
			// リボン色
			if (is_null($dataobj->getRibbonColor()) != true) {
				$dataobj->setRibbonColor(
					$dba->query_str_convert($dataobj->getRibbonColor()));
			}
			// 表示種別
			$dataobj->setListType(
				$dba->query_str_convert($dataobj->getListType()));
			// 有効期限
			$dataobj->setEffectiveTerm(
				$dba->query_str_convert($dataobj->getEffectiveTerm()));
			// 削除フラグ
			$dataobj->setDeleteFlg(
				$dba->query_str_convert($dataobj->getDeleteFlg()));
			// 登録日時
			$dataobj->setAddDateTime(
				$dba->query_str_convert($dataobj->getAddDateTime()));
			// 更新日時
			$dataobj->setUpdateDateTime(
				$dba->query_str_convert($dataobj->getUpdateDateTime()));

			if ($dba->dba_insert($dataobj) != true) {
				trigger_error($this->o_resource->getValue("D17_004_01"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D17_004_02"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

	/**
	 *	関数名：メモ種類テーブルキー指定データ更新
     * @引数：(I) $db               - DBオブジェクト
     *        (I) $targetDataobj    - 対象列(条件列/更新列)指定用データオブジェクト
     *        (I) $valDataobj       - 設定値(条件値/更新値)指定用データオブジェクト
     * @戻値：$bool			- true/false
     * @作成日/作成者：2006/09/01 (IIS) K.Shimomura
     * @更新日/更新者：
     * @使用方法：whereキーとして使用したい列は$targetDataobjの該当変数をWHERE_KEYに指定し、条件値を$valDataobjの該当変数に使用する。
	 *            (プライマリキー以外にWHERE_KEYを指定しても無視されます)
     *            更新したい列は$targetDataobjの該当変数をVAL_TARGETに指定し、更新値を$valDataobjの該当変数に使用する。
     *            NULLで更新したい時は$valDataobjの該当変数にNULL_CHARを指定する。
     */
	function updateByKeyData($db, $targetDataobj, $valDataobj) {

		$whereflg = false;
		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ((is_object($targetDataobj) && get_class($targetDataobj) == MEMOTYPE_DATAOBJ) && 
			(is_object($valDataobj) && get_class($valDataobj) == MEMOTYPE_DATAOBJ)) {

			// 条件および更新内容指定

			// メモ種類ID
			if ($targetDataobj->getMemoTypeID() === WHERE_KEY) {
				$dba->dba_whereAdd("", "memotypeid = ".$dba->query_str_convert($valDataobj->getMemoTypeID()));
				$whereflg = true;
			} elseif ($targetDataobj->getMemoTypeID() === VAL_TARGET) {
				// メモ種類IDはDBでのシーケンスナンバーを使用しているので
				// 変えられると困る
//				$dba->dba_updateAdd(
//						"memotypeid = "
//							.$dba->query_str_convert($valDataobj->getMemoTypeID()));
			}
			// レイヤーID
			if ($targetDataobj->getLayerID() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"layerid = "
							.$dba->query_str_convert($valDataobj->getLayerID()));
			}
			// メモ種類名称
			if ($targetDataobj->getMemoTypeName() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"memotypename = "
							.$dba->query_str_convert($valDataobj->getMemoTypeName()));
			}
			// メモ種類公開区分
			if ($targetDataobj->getPublicMemoType() === VAL_TARGET){
				$dba->dba_updateAdd(
						"publicmemotype = "
							.$dba->query_str_convert($valDataobj->getPublicMemoType()));
			}
			// メモ種類権限区分
			if ($targetDataobj->getAuthorityMemoType() === VAL_TARGET){
				$dba->dba_updateAdd(
						"authoritymemotype = "
							.$dba->query_str_convert($valDataobj->getAuthorityMemoType()));
			}
			// アイコン種別
			if ($targetDataobj->getIconType() === VAL_TARGET){
				$dba->dba_updateAdd(
						"icontype = "
							.$dba->query_str_convert($valDataobj->getIconType()));
			}
			// アイコン
			if ($targetDataobj->getIcon() === VAL_TARGET) {
				if ($valDataobj->getIcon() === NULL_CHAR) {
					$dba->dba_updateAdd("icon = null");
				} else {
					$dba->dba_updateAdd(
							"icon = "
								.$dba->query_str_convert($valDataobj->getIcon()));
				}
			}
			// リボン色
			if ($targetDataobj->getRibbonColor() === VAL_TARGET) {
				if ($valDataobj->getRibbonColor() === NULL_CHAR) {
					$dba->dba_updateAdd("ribboncolor = null");
				} else {
					$dba->dba_updateAdd(
							"ribboncolor = "
								.$dba->query_str_convert($valDataobj->getRibbonColor()));
				}
			}
			// 表示種別
			if ($targetDataobj->getListType() === VAL_TARGET){
				$dba->dba_updateAdd(
						"listtype = "
							.$dba->query_str_convert($valDataobj->getListType()));
			}
			// 有効期限
			if ($targetDataobj->getEffectiveTerm() === VAL_TARGET) {
				if ($valDataobj->getEffectiveTerm() === NULL_CHAR) {
					$dba->dba_updateAdd("effectiveterm = null");
				} else {
					$dba->dba_updateAdd(
							"effectiveterm = "
								.$dba->query_str_convert($valDataobj->getEffectiveTerm()));
				}
			}
			// 削除フラグ
			if ($targetDataobj->getDeleteFlg() === VAL_TARGET) {
					$dba->dba_updateAdd(
							"deleteflg = "
								.$dba->query_str_convert($valDataobj->getDeleteFlg()));
			}
			// 登録日時
			if ($targetDataobj->getAddDateTime() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"adddatetime = "
							.$dba->query_str_convert($valDataobj->getAddDateTime()));
			}
			// 更新日時
			if ($targetDataobj->getUpdateDateTime() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"updatedatetime = "
							.$dba->query_str_convert($valDataobj->getUpdateDateTime()));
			}

			// 条件指定確認
			if ($whereflg == false) {
				trigger_error($this->o_resource->getValue("D17_005_01"), E_USER_ERROR);
				return false;
			}
			//SQL実行
			if ($dba -> dba_update() != true) {
				trigger_error($this->o_resource->getValue("D17_005_02"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D17_005_03"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;

	}

    /**
     * 関数概要：メモ種類キー指定データ削除
     * 処理詳細：メモ種類テーブルキー指定データの削除クエリを生成する
     *
     * @引数： (I) db       - object  DBオブジェクト
     *      ： (I) key      - integer キー内容(メモ種類ID)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function deleteByKeyData($db, $key) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "memotypeid = ".$key);

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D17_006_01"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：一覧データ取得
     * 処理詳細：レコードセットより、メモ種類リストを生成する
     *
     * @引数： 
     * @戻値： array   メモ種類リスト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getDataList() {
        
		$memotype_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$memotypedata = new MemoTypeData();

			$memotypedata->setMemoTypeID(isset($row['memotypeid'])?$row['memotypeid']:null);
			$memotypedata->setLayerID(isset($row['layerid'])?$row['layerid']:null);
			$memotypedata->setMemoTypeName(isset($row['memotypename'])?$row['memotypename']:null);
			$memotypedata->setPublicMemoType(isset($row['publicmemotype'])?$row['publicmemotype']:null);
			$memotypedata->setAuthorityMemoType(isset($row['authoritymemotype'])?$row['authoritymemotype']:null);
			$memotypedata->setIconType(isset($row['icontype'])?$row['icontype']:null);
			$memotypedata->setIcon(isset($row['icon'])?$row['icon']:null);
			$memotypedata->setRibbonColor(isset($row['ribboncolor'])?$row['ribboncolor']:null);
			$memotypedata->setListType(isset($row['listtype'])?$row['listtype']:null);
			$memotypedata->setEffectiveTerm(isset($row['effectiveterm'])?$row['effectiveterm']:null);
			$memotypedata->setDeleteFlg(isset($row['deleteflg'])?$row['deleteflg']:null);
			$memotypedata->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);
			$memotypedata->setUpdateDateTime(isset($row['updatedatetime'])?$row['updatedatetime']:null);

			array_push($memotype_array, $memotypedata);
		}
 		return $memotype_array;
    }

    /**
     * 関数概要：単体データ取得
     * 処理詳細：レコードセットより、一件のメモ種類リストを生成する
     *
     * @引数： 
     * @戻値： array   メモ種類データ型オブジェクト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getOneData() {

		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$memotypedata = new MemoTypeData();

		$memotypedata->setMemoTypeID(isset($row['memotypeid'])?$row['memotypeid']:null);
		$memotypedata->setLayerID(isset($row['layerid'])?$row['layerid']:null);
		$memotypedata->setMemoTypeName(isset($row['memotypename'])?$row['memotypename']:null);
		$memotypedata->setPublicMemoType(isset($row['publicmemotype'])?$row['publicmemotype']:null);
		$memotypedata->setAuthorityMemoType(isset($row['authoritymemotype'])?$row['authoritymemotype']:null);
		$memotypedata->setIconType(isset($row['icontype'])?$row['icontype']:null);
		$memotypedata->setIcon(isset($row['icon'])?$row['icon']:null);
		$memotypedata->setRibbonColor(isset($row['ribboncolor'])?$row['ribboncolor']:null);
		$memotypedata->setListType(isset($row['listtype'])?$row['listtype']:null);
		$memotypedata->setEffectiveTerm(isset($row['effectiveterm'])?$row['effectiveterm']:null);
		$memotypedata->setDeleteFlg(isset($row['deleteflg'])?$row['deleteflg']:null);
		$memotypedata->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);
		$memotypedata->setUpdateDateTime(isset($row['updatedatetime'])?$row['updatedatetime']:null);

 		return $memotypedata;
    }

    /**
     * 関数概要：メモ種類テーブルキー指定重複チェック
     * 処理詳細：メモ種類テーブルデータをキー指定で重複しているかをチェック
     *
     * @引数： (I) db       - object  DBオブジェクト
     *      ： (I) key      - integer キー内容(メモ種類ID)
     * @戻値： boolean true :データなし
     *      ：         false:データあり
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function checkFindByKeyData($db, $key) {

		$rtn = true;

		// キー指定データの取得
		$this->selectFindByKeyData($db, $key);

		if ($this->getRecordCount() > 0) {
			$rtn = false;	
		}

		return $rtn;
	}
}
?>