<?php
/**
* TableAccess.class.php テーブルアクセス基本クラス
* PHP versions：4.4.2
* @パッケージ：-
* @作者：K.Shimomura
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/

require_once("class/xml/ReadResource.class.php");  // リソースファイル読込み
require_once("function/KakikoErrorHandler.php");   // エラートラップ
require_once("kakikomap/DBColumnDef.php");         // カキコまっぷ定数(DB)

class TableAccess {

	/**
	 *	クラス変数
	 */
	var $tablename;			// テーブル名称
	var $rs;				// レコードセット
	var $o_resource;		// リソースオブジェクト

    /**
     * コンストラクタ
     */
    function TableAccess() {
		$this->tablename = null;
		$this->rs = null;

		// リソースファイル読込みインスタンス
		$this->o_resource = new ReadResource(RESOURCE_SYSTEM);
    }

    /**
     * 関数概要：解放処理
     * 処理詳細：クラス変数のメモリ解放を行う
     *
     * @引数： 
     * @戻値： 
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function free() {
		$this->tablename = null;
		if ($this->rs != null) {
			$this->rs->free();
		}
	}

    /**
     * 関数概要：レコードセット設定
     * 処理詳細：レコードセットの設定
     *
     * @引数： (I) rs  - object レコードセット
     * @戻値： 
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function setRecordSet($rs) {
		$this->rs = $rs;
	}

    /**
     * 関数概要：テーブル名設定
     * 処理詳細：テーブル名の設定
     *
     * @引数： (I) table  - string テーブル名称
     * @戻値： 
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function setTableName($table) {
		$this->tablename = $table;
	}

    /**
     * 関数概要：レコードセット取得
     * 処理詳細：レコードセットの取得
     *
     * @引数： 
     * @戻値： object レコードセット
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function getRecordSet() {
		return $this->rs;
	}

    /**
     * 関数概要：テーブル名取得
     * 処理詳細：テーブル名の取得
     *
     * @引数： 
     * @戻値： string テーブル名称
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function getTablename() {
		return $this->tablename;
	}

    /**
     * 関数概要：レコードカウント取得
     * 処理詳細：レコードカウントの取得
     *
     * @引数： 
     * @戻値： integer レコードカウント
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function getRecordCount() {
		return $this->rs->numRows();
	}

}
?>