<?php
/**
* UserJoinLayerTableAccess.class.php user_join_layertableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：K.Shimomura
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/User_LayerData.class.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class UserJoinLayerTableAccess extends TableAccess {

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス

    /**
     * コンストラクタ
     * @引数： (I) directryname  - string ディレクトリ名称
     */
    function UserJoinLayerTableAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

		// メインテーブル名を設定
    	$this->setTableName($directryname."_usertable");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }

    /**
     * 関数概要：管理用ユーザレイヤー一覧データ取得クエリ発行
     * 処理詳細：管理用ユーザレイヤー一覧データの取得クエリを生成する
     *
     * @引数： (I) db        - object DBオブジェクト
     *      ： (I) statusflg - array  状態フラグ(配列)
     *      ： (I) layername - string レイヤー名称
     *      ： (I) username  - string ユーザ名称
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectAdminUserLayerListData($db, $statusflg, $layername = "", $username = "") {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_usertable.userid");
		$dba->dba_fieldAdd($this->prefix."_usertable.username");
		$dba->dba_fieldAdd($this->prefix."_usertable.mailaddress");
		$dba->dba_fieldAdd($this->prefix."_layertable.layerid");
		$dba->dba_fieldAdd($this->prefix."_layertable.layername");
		$dba->dba_fieldAdd($this->prefix."_layertable.adddatetime as adddatetime_l");
		$dba->dba_fieldAdd($this->prefix."_layertable.statusflg as statusflg_l");

		// 条件指定
		if (is_array($statusflg)) {
			$buf = $this->prefix."_layertable.statusflg IN (";
			for ($i = 0; $i < count($statusflg); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= $dba->query_str_convert($statusflg[$i]);
			}
			$buf .= ")";
			$dba->dba_whereAdd("", $buf);
		}

		if ($layername != "") {
			$buf = $this->prefix."_layertable.layername LIKE ";
			$buf .= $dba->query_str_convert("%".$layername."%");
			$dba->dba_whereAdd("AND", $buf);
		}

		if ($username != "") {
			$buf = $this->prefix."_usertable.username LIKE ";
			$buf .= $dba->query_str_convert("%".$username."%");
			$dba->dba_whereAdd("AND", $buf);
		}

		// ソート指定
		$dba->dba_orderAdd($this->prefix."_usertable.userid");
		$dba->dba_orderAdd($this->prefix."_layertable.layerid");

		// サブクエリ指定(INNER JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_layertable ON "
				.$this->prefix."_usertable.userid = "
				.$this->prefix."_layertable.userid"
				);

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D18_001_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}


    /**
     * 関数概要：レイヤーおよび作者の情報取得
     * @引数： (I) db        - object DBオブジェクト
     *      ： (I) layerId - string レイヤーID
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS) N.Soma
     * @更新日/更新者：
     * @更新内容：
     */
	function selectLayerAndLayerMaker($db, $layerId) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_usertable.userid");
		$dba->dba_fieldAdd($this->prefix."_usertable.username");
		$dba->dba_fieldAdd($this->prefix."_usertable.mailaddress");
		$dba->dba_fieldAdd($this->prefix."_layertable.layerid");
		$dba->dba_fieldAdd($this->prefix."_layertable.layername");

		// 条件指定
		$dba->dba_whereAdd("", $this->prefix."_layertable.layerid = ".$dba->query_str_convert($layerId));

		// サブクエリ指定(INNER JOIN)
		$dba -> dba_subQueryAdd(KAKIKO_DBA_INNER, 
				$this->prefix."_layertable ON "
				.$this->prefix."_usertable.userid = "
				.$this->prefix."_layertable.userid"
				);

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D18_001_02"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：一覧データ取得
     * 処理詳細：レコードセットより、ユーザリンクレイヤーリストを生成する
     *
     * @引数： 
     * @戻値： array   ユーザリンクレイヤーリスト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getDataList() {
        
		$userlayer_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$userlayerdata = new User_LayerData();

			// カラム名が同名のためstatusflg、adddatetime、updatedatetimeを
			// ユーザテーブルの上記カラム名をstatusflg_u、adddatetime_u、updatedatetime_u、
			// レイヤーテーブルの上記カラム名をstatusflg_l、adddatetime_l、updatedatetime_lで使用すること。 

			$userlayerdata->setUserID_User(isset($row['userid'])?$row['userid']:null);
			$userlayerdata->setUserType_User(isset($row['usertype'])?$row['usertype']:null);
			$userlayerdata->setMailAddress_User(isset($row['mailaddress'])?$row['mailaddress']:null);
			$userlayerdata->setUserName_User(isset($row['username'])?$row['username']:null);
			$userlayerdata->setPassword_User(isset($row['password'])?$row['password']:null);
			$userlayerdata->setStatusFlg_User(isset($row['statusflg_u'])?$row['statusflg_u']:null);
			$userlayerdata->setAddDateTime_User(isset($row['adddatetime_u'])?$row['adddatetime_u']:null);
			$userlayerdata->setUpdateDateTime_User(isset($row['updatedatetime_u'])?$row['updatedatetime_u']:null);

			$userlayerdata->setLayerID_Layer(isset($row['layerid'])?$row['layerid']:null);
			$userlayerdata->setLayerName_Layer(isset($row['layername'])?$row['layername']:null);
			$userlayerdata->setLayerNote_Layer(isset($row['layernote'])?$row['layernote']:null);
			$userlayerdata->setPublicLayer_Layer(isset($row['publiclayer'])?$row['publiclayer']:null);
			$userlayerdata->setReceiptLayer_Layer(isset($row['receiptlayer'])?$row['receiptlayer']:null);
			$userlayerdata->setAddAttestUser_Layer(isset($row['addattestuser'])?$row['addattestuser']:null);
			$userlayerdata->setDirectLink_Layer(isset($row['directlink'])?$row['directlink']:null);
			$userlayerdata->setInitScale_Layer(isset($row['initscale'])?$row['initscale']:null);
			$userlayerdata->setStartX_Layer(isset($row['startx'])?$row['startx']:null);
			$userlayerdata->setStartY_Layer(isset($row['starty'])?$row['starty']:null);
			$userlayerdata->setEndX_Layer(isset($row['endx'])?$row['endx']:null);
			$userlayerdata->setEndY_Layer(isset($row['endy'])?$row['endy']:null);
			$userlayerdata->setCenterScale_Layer(isset($row['centerscale'])?$row['centerscale']:null);
			$userlayerdata->setDiffX_Layer(isset($row['diffx'])?$row['diffx']:null);
			$userlayerdata->setDiffY_Layer(isset($row['diffy'])?$row['diffy']:null);
			$userlayerdata->setRssFileName_Layer(isset($row['rssfilename'])?$row['rssfilename']:null);
			$userlayerdata->setStatusFlg_Layer(isset($row['statusflg_l'])?$row['statusflg_l']:null);
			$userlayerdata->setAddDateTime_Layer(isset($row['adddatetime_l'])?$row['adddatetime_l']:null);
			$userlayerdata->setUpdateDateTime_Layer(isset($row['updatedatetime_l'])?$row['updatedatetime_l']:null);

			array_push($userlayer_array, $userlayerdata);
		}
 		return $userlayer_array;
    }

    /**
     * 関数概要：一レコードデータ取得
     * 処理詳細：レコードセットより、ユーザリンクレイヤーデータを生成する
     *
     * @引数： 
     * @戻値： User_LayerData   ユーザリンクレイヤーデータ
     * @作成日/作成者：2006/09/01 (IIS) N.Soma
     * @更新日/更新者：
     * @更新内容：
     */
    function getOneData() {
        
		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

			$userlayerdata = new User_LayerData();

			// カラム名が同名のためstatusflg、adddatetime、updatedatetimeを
			// ユーザテーブルの上記カラム名をstatusflg_u、adddatetime_u、updatedatetime_u、
			// レイヤーテーブルの上記カラム名をstatusflg_l、adddatetime_l、updatedatetime_lで使用すること。 

			$userlayerdata->setUserID_User(isset($row['userid'])?$row['userid']:null);
			$userlayerdata->setUserType_User(isset($row['usertype'])?$row['usertype']:null);
			$userlayerdata->setMailAddress_User(isset($row['mailaddress'])?$row['mailaddress']:null);
			$userlayerdata->setUserName_User(isset($row['username'])?$row['username']:null);
			$userlayerdata->setPassword_User(isset($row['password'])?$row['password']:null);
			$userlayerdata->setStatusFlg_User(isset($row['statusflg_u'])?$row['statusflg_u']:null);
			$userlayerdata->setAddDateTime_User(isset($row['adddatetime_u'])?$row['adddatetime_u']:null);
			$userlayerdata->setUpdateDateTime_User(isset($row['updatedatetime_u'])?$row['updatedatetime_u']:null);

			$userlayerdata->setLayerID_Layer(isset($row['layerid'])?$row['layerid']:null);
			$userlayerdata->setLayerName_Layer(isset($row['layername'])?$row['layername']:null);
			$userlayerdata->setLayerNote_Layer(isset($row['layernote'])?$row['layernote']:null);
			$userlayerdata->setPublicLayer_Layer(isset($row['publiclayer'])?$row['publiclayer']:null);
			$userlayerdata->setReceiptLayer_Layer(isset($row['receiptlayer'])?$row['receiptlayer']:null);
			$userlayerdata->setAddAttestUser_Layer(isset($row['addattestuser'])?$row['addattestuser']:null);
			$userlayerdata->setDirectLink_Layer(isset($row['directlink'])?$row['directlink']:null);
			$userlayerdata->setInitScale_Layer(isset($row['initscale'])?$row['initscale']:null);
			$userlayerdata->setStartX_Layer(isset($row['startx'])?$row['startx']:null);
			$userlayerdata->setStartY_Layer(isset($row['starty'])?$row['starty']:null);
			$userlayerdata->setEndX_Layer(isset($row['endx'])?$row['endx']:null);
			$userlayerdata->setEndY_Layer(isset($row['endy'])?$row['endy']:null);
			$userlayerdata->setCenterScale_Layer(isset($row['centerscale'])?$row['centerscale']:null);
			$userlayerdata->setDiffX_Layer(isset($row['diffx'])?$row['diffx']:null);
			$userlayerdata->setDiffY_Layer(isset($row['diffy'])?$row['diffy']:null);
			$userlayerdata->setRssFileName_Layer(isset($row['rssfilename'])?$row['rssfilename']:null);
			$userlayerdata->setStatusFlg_Layer(isset($row['statusflg_l'])?$row['statusflg_l']:null);
			$userlayerdata->setAddDateTime_Layer(isset($row['adddatetime_l'])?$row['adddatetime_l']:null);
			$userlayerdata->setUpdateDateTime_Layer(isset($row['updatedatetime_l'])?$row['updatedatetime_l']:null);

		
 		return $userlayerdata;
    }

}
?>