<?php
/**
* UserTableAccess.class.php usertableDAO
* PHP versions：4.4.2
* @パッケージ：-
* @作者：K.Shimomura
* @作成日/作成者：2006/09/01 (IIS)K.Shimomura
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
//データクラス
require_once("class/db/tabledata/UserData.class.php");
//データオブジェクト定義
require_once("class/db/dbaccess/DataObject.php");
//データアクセスクラス
require_once("class/db/dbaccess/KakikoDbAccess.class.php");
//継承テーブルアクセスクラス
require_once("class/db/dbaccess/TableAccess.class.php");


class UserTableAccess extends TableAccess {

	/**
	 *	クラス変数
	 */
	var $prefix;				// プレフィックス


    /**
     * コンストラクタ
     * @引数： (I) directryname  - string ディレクトリ名称
     */
    function UserTableAccess($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->TableAccess();

    	$this->setTableName($directryname."_usertable");
    	$this->setRecordSet(null);

		// プレフィックス設定
		$this->prefix = $directryname;
    }

    /**
     * 関数概要：ユーザテーブルデータ全件取得クエリ発行
     * 処理詳細：ユーザテーブルデータの全件取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectAllData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D21_001_01"), E_USER_ERROR);
			return false;
		}
		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：ユーザテーブルキー指定データ取得クエリ発行
     * 処理詳細：ユーザテーブルキー指定データの取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key      - string キー内容(ユーザID)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectFindByKeyData($db, $key) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "userid = ".$dba->query_str_convert($key));

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D21_002_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：レイヤーユーザデータ付加ユーザ一覧データ取得クエリ発行
     * 処理詳細：レイヤーユーザデータ付加ユーザ一覧データの取得クエリを生成する
     *
     * @引数： (I) db        - object DBオブジェクト
     *      ： (I) userid    - string ユーザID
     *      ： (I) layerid   - string レイヤーID
     *      ： (I) usertype  - array  ユーザ種別(配列)
     *      ： (I) statusflg - array  状態フラグ(配列)
     *      ： (I) username  - string ユーザ名称
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectUserDataInLayerUserData($db, $userid, $layerid, $usertype, $statusflg, $username = "") {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// カラムフィールド指定
		$dba->dba_fieldAdd($this->prefix."_usertable.userid");
		$dba->dba_fieldAdd($this->prefix."_usertable.username");
		$dba->dba_fieldAdd($this->prefix."_usertable.mailaddress");
		//ユーザデータオブジェクトのadddatetime枠に収める
		$dba->dba_fieldAdd($this->prefix."_layerusertable.adddatetime");
		//ユーザデータオブジェクトのstatusflg枠に収める
		$dba->dba_fieldAdd($this->prefix."_layerusertable.statusflg");

		// 付加テーブル指定
		$dba->dba_tableAdd($this->prefix."_layerusertable");

		// 条件指定 
		$dba->dba_whereAdd("", 
					$this->prefix."_usertable.userid = "
						.$this->prefix."_layerusertable.userid");

		//ユーザ種別
		if (is_array($usertype)) {

			$buf = $this->prefix."_usertable.usertype IN (";
			for ($i = 0; $i < count($usertype); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= $dba->query_str_convert($usertype[$i]);
			}
			$buf .= ")";
			$dba->dba_whereAdd("AND", $buf);
		}
		//状態フラグ
		if (is_array($statusflg)) {

			$buf = $this->prefix."_layerusertable.statusflg IN (";
			for ($i = 0; $i < count($statusflg); $i++) {
				if ($i != 0) {
					$buf .= ",";
				} 
				$buf .= $dba->query_str_convert($statusflg[$i]);
			}
			$buf .= ")";
			$dba->dba_whereAdd("AND", $buf);
		}
		//レイヤーID
		$dba->dba_whereAdd("AND", $this->prefix."_layerusertable.layerid = ".$dba->query_str_convert($layerid));
		//ユーザID(自分以外)
		$dba->dba_whereAdd("AND", $this->prefix."_usertable.userid != ".$dba->query_str_convert($userid));
		//ユーザ名称
		if ($username != "") {
			$buf = $this->prefix."_usertable.username LIKE ";
			$buf .= $dba->query_str_convert("%".$username."%");
			$dba->dba_whereAdd("AND", $buf);
		}

		// ソート指定
		$dba->dba_orderAdd($this->prefix."_usertable.userid");

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D21_003_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：ユーザテーブルデータ挿入
     * 処理詳細：ユーザテーブルデータの挿入クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) dataobj  - object ユーザデータオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function insertData($db, $dataobj) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		if (is_object($dataobj) && get_class($dataobj) == USER_DATAOBJ) {

			// ユーザID
			$dataobj->setUserID(
				$dba->query_str_convert($dataobj->getUserID()));
			// ユーザ種別
			$dataobj->setUserType(
				$dba->query_str_convert($dataobj->getUserType()));
			// メールアドレス
			$dataobj->setMailAddress(
				$dba->query_str_convert($dataobj->getMailAddress()));
			// ユーザ名称
			if (is_null($dataobj->getUserName()) != true) {
				$dataobj->setUserName(
					$dba->query_str_convert($dataobj->getUserName()));
			}
			// パスワード
			$dataobj->setPassword(
				$dba->query_str_convert($dataobj->getPassword()));
			// 状態フラグ
			$dataobj->setStatusFlg(
				$dba->query_str_convert($dataobj->getStatusFlg()));
			// 登録日時
			$dataobj->setAddDateTime(
				$dba->query_str_convert($dataobj->getAddDateTime()));
			// 更新日時
			$dataobj->setUpdateDateTime(
				$dba->query_str_convert($dataobj->getUpdateDateTime()));

			if ($dba->dba_insert($dataobj) != true) {
				trigger_error($this->o_resource->getValue("D21_004_01"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D21_004_02"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}


	/**
	 *	関数名：ユーザテーブルキー指定データ更新
     * @引数：(I) $db               - DBオブジェクト
     *        (I) $targetDataobj    - 対象列(条件列/更新列)指定用データオブジェクト
     *        (I) $valDataobj       - 設定値(条件値/更新値)指定用データオブジェクト
     * @戻値：$bool			- true/false
     * @作成日/作成者：2006/09/01 (IIS) K.Shimomura
     * @更新日/更新者：
     * @使用方法：whereキーとして使用したい列は$targetDataobjの該当変数をWHERE_KEYに指定し、条件値を$valDataobjの該当変数に使用する。
	 *            (プライマリキー以外にWHERE_KEYを指定しても無視されます)
     *            更新したい列は$targetDataobjの該当変数をVAL_TARGETに指定し、更新値を$valDataobjの該当変数に使用する。
     *            NULLで更新したい時は$valDataobjの該当変数にNULL_CHARを指定する。
     */
	function updateByKeyData($db, $targetDataobj, $valDataobj) {

		$whereflg = false;
		$dba = new KakikoDBAccess($db, $this->getTablename());

		if ((is_object($targetDataobj) && get_class($targetDataobj) == USER_DATAOBJ) && 
			(is_object($valDataobj) && get_class($valDataobj) == USER_DATAOBJ)) {

			// 条件および更新内容指定
			// ユーザID
			if ($targetDataobj->getUserID() === WHERE_KEY) {
				$dba->dba_whereAdd("", "userid = ".$dba->query_str_convert($valDataobj->getUserID()));
				$whereflg = true;
			} elseif ($targetDataobj->getUserID() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"userid = "
							.$dba->query_str_convert($valDataobj->getUserID()));
			}
			// ユーザ種別
			if ($targetDataobj->getUserType() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"usertype = "
							.$dba->query_str_convert($valDataobj->getUserType()));
			}
			// メールアドレス
			if ($targetDataobj->getMailAddress() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"mailaddress = "
							.$dba->query_str_convert($valDataobj->getMailAddress()));
			}
			// ユーザ名称
			if ($targetDataobj->getUserName() === VAL_TARGET) {
				if ($valDataobj->getUserName() === NULL_CHAR) {
					$dba->dba_updateAdd("username = null");
				} else {
					$dba->dba_updateAdd(
							"username = "
								.$dba->query_str_convert($valDataobj->getUserName()));
				}
			}
			// パスワード
			if ($targetDataobj->getPassword() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"password = "
							.$dba->query_str_convert($valDataobj->getPassword()));
			}
			// 状態フラグ
			if ($targetDataobj->getStatusFlg() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"statusflg = "
							.$dba->query_str_convert($valDataobj->getStatusFlg()));
			}
			// 登録日時
			if ($targetDataobj->getAddDateTime() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"adddatetime = "
							.$dba->query_str_convert($valDataobj->getAddDateTime()));
			}
			// 更新日時
			if ($targetDataobj->getUpdateDateTime() === VAL_TARGET) {
				$dba->dba_updateAdd(
						"updatedatetime = "
							.$dba->query_str_convert($valDataobj->getUpdateDateTime()));
			}

			// 条件指定確認
			if ($whereflg == false) {
				trigger_error($this->o_resource->getValue("D21_005_01"), E_USER_ERROR);
				return false;
			}
			//SQL実行
			if ($dba -> dba_update() != true) {
				trigger_error($this->o_resource->getValue("D21_005_02"), E_USER_ERROR);
				return false;
			}
		} else {
			trigger_error($this->o_resource->getValue("D21_005_03"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;

	}

    /**
     * 関数概要：ユーザテーブルキー指定データ削除
     * 処理詳細：ユーザテーブルキー指定データの削除クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key      - string キー内容(ユーザID)
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function deleteByKeyData($db, $key) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "userid = ".$dba->query_str_convert($key));

		if ($dba -> dba_delete() != true) {
			trigger_error($this->o_resource->getValue("D21_006_01"), E_USER_ERROR);
			return false;
		}

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：ユーザテーブルマップ管理者データ取得クエリ発行
     * 処理詳細：ユーザテーブルマップ管理者データの取得クエリを生成する
     *
     * @引数： (I) db       - object DBオブジェクト
     * @戻値： boolean true :正常
     *      ：         false:異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function selectMapAdminData($db) {

		$dba = new KakikoDBAccess($db, $this->getTablename());

		// 条件指定
		$dba->dba_whereAdd("", "usertype = ".$dba->query_str_convert(KAKIKOMAP_USERTYPE_MAP));

		if ($dba -> dba_select() != true) {
			trigger_error($this->o_resource->getValue("D21_007_01"), E_USER_ERROR);
			return false;
		}

		$this->setRecordSet($dba->dba_getRecordSet());

		// 解放
		$dba->dba_free();

		return true;
	}

    /**
     * 関数概要：一覧データ取得
     * 処理詳細：レコードセットより、ユーザリストを生成する
     *
     * @引数： 
     * @戻値： array   ユーザリスト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getDataList() {
        
		$user_array = array();

		$rs = $this->getRecordSet();

		while($row = $rs->fetchrow(DB_FETCHMODE_ASSOC)) {

			$userdata = new UserData();

			$userdata->setUserID(isset($row['userid'])?$row['userid']:null);
			$userdata->setUserType(isset($row['usertype'])?$row['usertype']:null);
			$userdata->setMailAddress(isset($row['mailaddress'])?$row['mailaddress']:null);
			$userdata->setUserName(isset($row['username'])?$row['username']:null);
			$userdata->setPassword(isset($row['password'])?$row['password']:null);
			$userdata->setStatusFlg(isset($row['statusflg'])?$row['statusflg']:null);
			$userdata->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);
			$userdata->setUpdateDateTime(isset($row['updatedatetime'])?$row['updatedatetime']:null);

			array_push($user_array, $userdata);
		}
 		return $user_array;
    }

    /**
     * 関数概要：単体データ取得
     * 処理詳細：レコードセットより、一件のユーザデータを生成する
     *
     * @引数： 
     * @戻値： array   ユーザデータ型オブジェクト
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
    function getOneData() {

		$rs = $this->getRecordSet();

		$row = $rs->fetchrow(DB_FETCHMODE_ASSOC);

		$userdata = new UserData();

		$userdata->setUserID(isset($row['userid'])?$row['userid']:null);
		$userdata->setUserType(isset($row['usertype'])?$row['usertype']:null);
		$userdata->setMailAddress(isset($row['mailaddress'])?$row['mailaddress']:null);
		$userdata->setUserName(isset($row['username'])?$row['username']:null);
		$userdata->setPassword(isset($row['password'])?$row['password']:null);
		$userdata->setStatusFlg(isset($row['statusflg'])?$row['statusflg']:null);
		$userdata->setAddDateTime(isset($row['adddatetime'])?$row['adddatetime']:null);
		$userdata->setUpdateDateTime(isset($row['updatedatetime'])?$row['updatedatetime']:null);

 		return $userdata;
    }

    /**
     * 関数概要：ユーザテーブルキー指定重複チェック
     * 処理詳細：ユーザテーブルデータをキー指定で重複しているかをチェック
     *
     * @引数： (I) db       - object DBオブジェクト
     *      ： (I) key      - string キー内容(ユーザID)
     * @戻値： boolean true :データなし
     *      ：         false:データあり
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
     * @更新内容：
     */
	function checkFindByKeyData($db, $key) {

		$rtn = true;

		// キー指定データの取得
		$this->selectFindByKeyData($db, $key);

		if ($this->getRecordCount() > 0) {
			$rtn = false;	
		}

		return $rtn;
	}
}
?>