<?php
/**
* ContentsViewService.php コンテンツ表示系DBアクセスサービス
* PHP versions：4.4.2
* @パッケージ：-
* @作者：N.Soma
* @作成日/作成者：2006/09/01 N.Soma
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/

require_once("Date.php");
//require_once("kakikomap/DBColumnDef.php");
require_once("class/db/dbaccess/MemoCommentTreeAccess.class.php");
require_once("class/db/tabledata/TreeDataController.class.php");
//require_once("class/db/tabledata/TreeNodeData.class.php");
require_once("class/db/dbaccess/MemoDetailJoinPositionJoinTypeTableAccess.class.php");
require_once("class/db/dbaccess/MemoDetailTableAccess.class.php");
require_once("class/db/dbaccess/CommentTableAccess.class.php");
require_once("class/db/dbaccess/MemoPositionTableAccess.class.php");
require_once("class/db/dbaccess/LayerJoinUserAndLayerPriorityTableAccess.class.php");
require_once("class/db/dbaccess/LayerJoinUserAndLayerUserAndPersonalAndPriorityTableAccess.class.php");
require_once("class/db/dbaccess/LayerTableAccess.class.php");
require_once("class/db/dbaccess/UserPersonalInfoTableAccess.class.php");
require_once("class/db/service/KakikoService.class.php");
require_once("class/db/tabledata/UserPersonalInfoData.class.php");
require_once("class/db/dbaccess/ImiBaseInfoTableAccess.class.php");
require_once("class/db/dbaccess/ImiLayerTableAccess.class.php");
require_once("class/db/dbaccess/ImiMemoPositionTableAccess.class.php");
require_once("class/db/dbaccess/UserTableAccess.class.php");
require_once("class/db/dbaccess/LayerUserTableAccess.class.php");
require_once("class/db/dbaccess/MapDetailTableAccess.class.php");
require_once("class/db/dbaccess/MemoTypeTableAccess.class.php");
require_once("class/db/dbaccess/MapJoinMapDetailAccess.class.php");
require_once("class/db/dbaccess/BaseMapJoinMapDetailTableAccess.class.php");
require_once("class/db/dbaccess/MapTableAccess.class.php");




class ContentsViewService extends KakikoService {

	/**
	 *	コンストラクタ
	 */
    function ContentsViewService($directryname) {

		// 基底クラスのコンストラクタ呼び出し
    	$this->KakikoService($directryname);
		// DB接続情報の設定
		$this->setDBConnectInfo();

    }

   /**
    * 関数名：全閲覧可能メモ・コメントツリー取得
    * @引数：(I) $userId 	- ログインユーザ
    *        (I) $searchKey				-　検索条件
    *              $searchKey['limit']	- 最新取得件数
    *              $searchKey['from']	- 対象期間（from）
    *              $searchKey['to']		- 対象期間（to）
    *              $searchKey['word']	- 語句
    *              $searchKey['minx']	- 範囲座標（X緯度最小）
    *              $searchKey['maxx']	- 範囲座標（X緯度最大）
    *              $searchKey['miny']	- 範囲座標（Y経度最小）
    *              $searchKey['maxy']	- 範囲座標（Y経度最大）
    * @戻値：TreeNodeData配列
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    * @注意事項：内部でユーザの閲覧権限を考慮しています。searchKeyは省略可能です。
    */
	function getAllMemoCommentTreeData($userId, $searchKey = null) {

		// DBオブジェクトの生成
		$this->createDBObject();

		$tree_access = new MemoCommentTreeAccess($this->directryname);
		//全閲覧可能ツリーデータ取得
		$treelist = $tree_access->selectMemoCommentTreeData($this->o_db, $userId,  $searchKey);
		$treectr = $tree_access->getAllMemoTreeData();
		if($treectr != null){
			$tmp = $treectr->getAllNodeList();
			//表示用に再構成
			$array_data = $tree_access->getTreeViewData($tmp, $searchKey);
		}else{
			$array_data = array();
		}

		$tree_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return $array_data;
	}

   /**
    * 関数名：特定メモ・コメントツリー取得
    * @引数：(I) $memoId 	- 取得対象メモID 
    * @戻値：TreeNodeData配列
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function getAllMemoCommentTreeDataByKey($memoId) {
		// DBオブジェクトの生成
		$this->createDBObject();

		$tree_access = new MemoCommentTreeAccess($this->directryname);
		//全閲覧可能ツリーデータ取得
		$treelist = $tree_access->selectMemoCommentTreeDataByKey($this->o_db, $memoId);
		$treectr = $tree_access->getAllMemoTreeData();
		if($treectr != null){			
			$tmp = $treectr->getAllNodeList();
			//表示用に再構成
			$array_data = $tree_access->getTreeViewData($tmp, null);
		}else{
			$array_data = array();
		}
		$tree_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return $array_data;
	}

   /**
    * 関数名：メモ詳細表示用情報取得
    * @引数：(I) $memoId 	- メモID
    * @戻値：MemoDetailData
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function getOneMemoDetailViewData($memoId) {
	
		// DBオブジェクトの生成
		$this->createDBObject();

		// メモ詳細（付加情報つき）テーブルDBアクセス
		$table_access = new MemoDetailJoinPositionJoinTypeTableAccess($this->directryname);

		// クエリー発行
		$rtn =  $table_access->selectMemoDetailPositionTypeDataByKey($this->o_db, $memoId);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_02"), E_USER_ERROR);
			return null;
		}
		if ($table_access->getRecordCount() == 0){
			return null;
		}

		// データオブジェクトの取得
		$data = $table_access->getOneData();

		// 解放
		$table_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return $data;
	
	}

   /**
    * 関数名：メモ詳細表示用情報取得(表示権限精査)
    * @引数：(I) $memoId 	- メモID
    *        (I) $userId 	- ユーザID
    * @戻値：MemoDetailData
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function getOneMemoDetailViewDataAuth($memoId, $userId) {
	
		// DBオブジェクトの生成
		$this->createDBObject();

		// メモ詳細（付加情報つき）テーブルDBアクセス
		$table_access = new MemoDetailJoinPositionJoinTypeTableAccess($this->directryname);

        // レイヤー状態フラグ
        $status_array = array(KAKIKOMAP_STATUSFLG_ON);

		// クエリー発行
		$rtn =  $table_access->selectMemoDetailPositionTypeDataByKeyAuth($this->o_db, $memoId, $userId, $status_array);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_02"), E_USER_ERROR);
			return null;
		}
		if ($table_access->getRecordCount() == 0){
			return null;
		}

		// データオブジェクトの取得
		$data = $table_access->getOneData();

		// 解放
		$table_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return $data;
	
	}


   /**
    * 関数名：レイヤー表示設定表示情報取得(管理者/一般ユーザ)
    * @引数：(I) $userid 	- ユーザID
    * @戻値：array $data    - DBエラーの場合はnull
    * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
    * @更新日/更新者：
    */
	function getLayerListData($userid) {

        // DBオブジェクトの生成
        $this->createDBObject();

        // レイヤー・ユーザ・レイヤーユーザ・個人情報・レイヤー優先順位ジョインテーブルDBアクセス
		$table_access = new LayerJoinUserAndLayerUserAndPersonalAndPriorityTableAccess($this->directryname);

        // レイヤー状態フラグ
        $status_array = array(KAKIKOMAP_STATUSFLG_ON);

        // クエリー発行
		$rtn = $table_access->selectLayerListData($this->o_db, $userid, $status_array);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_03"), E_USER_ERROR);
			return null;
		}

        // データオブジェクトの取得
		$data = $table_access->getDataList();

        // 解放
        $table_access->free();

        // DB接続の切断
        $this->disconnectDB();

        return $data;

	}

   /**
    * 関数名：レイヤー表示設定表示情報取得(ゲスト)
    * @引数：
    * @戻値：array $data    - DBエラーの場合はnull
    * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
    * @更新日/更新者：
    */
	function getLayerListData_Guest() {

		// DBオブジェクトの生成
		$this->createDBObject();

        // レイヤー・ユーザ・レイヤー優先順位ジョインテーブルDBアクセス
		$table_access = new LayerJoinUserAndLayerPriorityTableAccess($this->directryname);

        // レイヤー公開区分
        $publiclayer_array = array(KAKIKOMAP_PUBLICLAYER_GUEST);

        // レイヤー状態フラグ
        $status_array = array(KAKIKOMAP_STATUSFLG_ON);

        // クエリー発行
		$rtn = $table_access->selectLayerListData($this->o_db, $publiclayer_array, $status_array);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_03"), E_USER_ERROR);
			return null;
		}

        // データオブジェクトの取得
		$data = $table_access->getDataList();

        // 解放
        $table_access->free();

        // DB接続の切断
        $this->disconnectDB();

        return $data;

	}

   /**
    * 関数名：レイヤー表示順設定表示情報取得
    * @引数：(I) $userid 	- ユーザID
    * @戻値：array $data    - DBエラーの場合はnull
    * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
    * @更新日/更新者：
    */
	function getIndicateLayerData($userid) {

		// DBオブジェクトの生成
		$this->createDBObject();

        // 戻り値データ
        $rtn_data = array();

        // レイヤーテーブルDBアクセス
		$table_access = new LayerTableAccess($this->directryname);

        // レイヤー表示区分
        $layerliststate_array = array(KAKIKOMAP_LAYERLISTSTATE_DISP);

        // クエリー発行
		$rtn = $table_access->selectLayerIndicateData($this->o_db, $userid, $layerliststate_array);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_04"), E_USER_ERROR);
			return null;
		}

        // データオブジェクトの取得
		$data = $table_access->getDataList();

        // 解放
        $table_access->free();

        // DB接続の切断
        $this->disconnectDB();

        return $data;

    }

   /**
    * 関数名：レイヤー表示順設定表示情報取得(ゲスト)
    * @引数：(I) $cookie_data 	- クッキーデータ(配列)
    * @戻値：array $data    - DBエラーの場合はnull
    * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
    * @更新日/更新者：
    */
	function getIndicateLayerData_Guest($cookie_data) {

		// DBオブジェクトの生成
		$this->createDBObject();

        // 戻り値データ
        $rtn_data = array();

        // レイヤーテーブルDBアクセス
		$table_access = new LayerTableAccess($this->directryname);

        foreach ($cookie_data as $key=>$value) {

            // クエリー発行
            $rtn = $table_access->selectLayerIDKeyData($this->o_db, $value);
            if ($rtn != true) {
                $table_access->free();
                $this->disconnectDB();
				trigger_error($this->o_resource->getValue("S4_001_04"), E_USER_ERROR);
                return null;
            }
            // データオブジェクトの取得
            $data = $table_access->getOneData();
            if (count($data) <> 0) {
			    $rtn_data[$value] = $data->getLayerName();
		    }
        }

        // 解放
        $table_access->free();

        // DB接続の切断
        $this->disconnectDB();

        return $rtn_data;

    }

	/**
	 *	関数名：メモ新規登録
     * @引数：(I) $memoDetailDataobj        - メモ詳細用データオブジェクト
     *        (I) $memoPositionDataobj	   - メモ位置用データオブジェクト
     * @戻値：$bool			- true  正常登録
     *                      - false 異常
     * @作成日/作成者：2006/09/01 (IIS) N.Soma
     * @更新日/更新者：
     * @使用方法：ユーザ登録を行います。
	 *            
     */
	function insertMemo($memoDetailDataobj, $memoPositionDataobj) {

		// DBオブジェクトの生成
		$this->createDBObject();

		// トランザクション開始
		$this->o_db->autoCommit(false);

		// -----------------------------------------------
		// メモ位置テーブルへ新規にレコードを追加
		// -----------------------------------------------
		$memoposition_access = new MemoPositionTableAccess($this->directryname);
		// データ追加
		$rtn = $memoposition_access->insertData($this->o_db, $memoPositionDataobj);
		if ($rtn != true) {
			$this->o_db->rollback();
			$memodetail_access->free();
			$memoposition_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_05"), E_USER_ERROR);
			return false;
		}

		// -----------------------------------------------
		// 発行したメモIDをシーケンスから取得
		// -----------------------------------------------
		//select currval('xxxxxx_memopositiontable_memoid_seq') as memoid_seq
		$dba = new KakikoDBAccess($this->o_db, 'dummy');
		$dba->dba_executeQuery("select currval('".$this->directryname."_memopositiontable_memoid_seq') as memoid_seq");		
		while($row = $dba->rs->fetchrow(DB_FETCHMODE_ASSOC)) {
			$memoid_seq = isset($row['memoid_seq'])?$row['memoid_seq']:null;
		}
			
		// -----------------------------------------------
		// メモ詳細テーブルへ新規にレコードを追加
		// -----------------------------------------------
		$memodetail_access = new MemoDetailTableAccess($this->directryname);
		$memoDetailDataobj->setMemoID($memoid_seq);
		// データ追加
		$rtn = $memodetail_access->insertData($this->o_db, $memoDetailDataobj);
		if ($rtn != true) {
			$this->o_db->rollback();
			$memodetail_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_06"), E_USER_ERROR);
			return false;
		}

		// -----------------------------------------------------------
		// 登録されたレイヤーを使用している意味空間に警告フラグを立てる
		// -----------------------------------------------------------
		//メモ種類からレイヤーIDを取得
		$memotype_access = new MemoTypeTableAccess($this->directryname);
		$rtn = $memotype_access->selectFindByKeyData($this->o_db, $memoDetailDataobj->getMemoTypeID());
		if ($rtn != true) {
			$this->o_db->rollback();
			$memotype_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_06"), E_USER_ERROR);
			return false;
		}
		$memotypdata = $memotype_access->getOneData();
		$memotype_access->free();
		//指定のレイヤーの意味空間での使用状況と更新
		$rtn = $this->checkAndUpdateImiBaseInfo($memotypdata->getLayerID(),null,null, 1);
		if ($rtn != true) {
			$this->o_db->rollback();
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_06"), E_USER_ERROR);
			return false;
		}

		// 解放
		$memodetail_access->free();
		$memoposition_access->free();

		// トランザクションコミット
		$this->o_db->commit();

		// DB接続の切断
		$this->disconnectDB();

		return true;

	}

	/**
	 *	関数名：メモ新規登録(携帯用)
     * @引数：(I) $memoDetailDataobj        - メモ詳細用データオブジェクト
     *        (I) $memoPositionDataobj	   	- メモ位置用データオブジェクト
     *        (O) $newMemoId	  			- 新規発行されたメモID
     *        (O) $updDate	   				- 更新された日時
     *      * @戻値：$bool			- true  正常登録
     *                      - false 異常
     * @作成日/作成者：2006/09/01 (IIS) N.Soma
     * @更新日/更新者：
     * @使用方法：ユーザ登録を行います。
	 *            
     */
	function insertMemoMobile($memoDetailDataobj, $memoPositionDataobj, &$newMemoId, &$updDate) {

		// DBオブジェクトの生成
		$this->createDBObject();

		// トランザクション開始
		$this->o_db->autoCommit(false);

		// -----------------------------------------------
		// メモ位置テーブルへ新規にレコードを追加
		// -----------------------------------------------
		$memoposition_access = new MemoPositionTableAccess($this->directryname);
		// データ追加
		$rtn = $memoposition_access->insertData($this->o_db, $memoPositionDataobj);
		if ($rtn != true) {
			$this->o_db->rollback();
			$memodetail_access->free();
			$memoposition_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_05"), E_USER_ERROR);
			return false;
		}

		// -----------------------------------------------
		// 発行したメモIDをシーケンスから取得
		// -----------------------------------------------
		//select currval('xxxxxx_memopositiontable_memoid_seq') as memoid_seq
		$dba = new KakikoDBAccess($this->o_db, 'dummy');
		$dba->dba_executeQuery("select currval('".$this->directryname."_memopositiontable_memoid_seq') as memoid_seq");		
		while($row = $dba->rs->fetchrow(DB_FETCHMODE_ASSOC)) {
			$memoid_seq = isset($row['memoid_seq'])?$row['memoid_seq']:null;
		}
		// -----------------------------------------------
		// メモ詳細テーブルへ新規にレコードを追加
		// -----------------------------------------------
		$memodetail_access = new MemoDetailTableAccess($this->directryname);
		$memoDetailDataobj->setMemoID($memoid_seq);
		// データ追加
		$rtn = $memodetail_access->insertData($this->o_db, $memoDetailDataobj);
		if ($rtn != true) {
			$this->o_db->rollback();
			$memodetail_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_06"), E_USER_ERROR);
			return false;
		}

		// -----------------------------------------------------------
		// 登録されたレイヤーを使用している意味空間に警告フラグを立てる
		// -----------------------------------------------------------
		//メモ種類からレイヤーIDを取得
		$memotype_access = new MemoTypeTableAccess($this->directryname);
		$rtn = $memotype_access->selectFindByKeyData($this->o_db, $memoDetailDataobj->getMemoTypeID());
		if ($rtn != true) {
			$this->o_db->rollback();
			$memotype_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_06"), E_USER_ERROR);
			return false;
		}
		$memotypdata = $memotype_access->getOneData();
		$memotype_access->free();
		//指定のレイヤーの意味空間での使用状況と更新
		$rtn = $this->checkAndUpdateImiBaseInfo($memotypdata->getLayerID(),null,null, 1);
		if ($rtn != true) {
			$this->o_db->rollback();
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_06"), E_USER_ERROR);
			return false;
		}

		// 解放
		$memodetail_access->free();
		$memoposition_access->free();

		// トランザクションコミット
		$this->o_db->commit();

		// DB接続の切断
		$this->disconnectDB();

		//返却値の設定
		$newMemoId = $memoid_seq;
		$updDate = $memoDetailDataobj->getUpdateDateTime();

		return true;

	}


	/**
	 *	関数名：メモ詳細更新処理
     * @引数：(I) $targetDataobj    - 対象列(条件列/更新列)指定用データオブジェクト
     *        (I) $valDataobj       - 設定値(条件値/更新値)指定用データオブジェクト
     *        (I) $layerId			- 更新後のレイヤーID
     * @戻値：$bool			- true  正常更新
     *                      - false 異常
     * @作成日/作成者：2006/09/01 (IIS)N.Soma
     * @更新日/更新者：
	 *            
     */
	function updateMemoDetailDataByKey($targetDataobj, $valDataobj) {

		// DBオブジェクトの生成
		$this->createDBObject();

		// トランザクション開始
		$this->o_db->autoCommit(false);

		// メモ詳細DBアクセスインスタンス生成
		$table_access = new MemoDetailTableAccess($this->directryname);
				
		// 意味空間の更新必要を確認するために現在のデータを取得
			$rtn = $table_access->selectFindByKeyData($this->o_db, $valDataobj->getMemoID());
			if ($rtn != true) {
				$this->o_db->rollback();
				$table_access->free();
				$this->disconnectDB();
				trigger_error($this->o_resource->getValue("S4_001_07"), E_USER_ERROR);
				return false;
			}
			$memodata = $table_access->getOneData();
			
			if ($memodata->getMemoTypeID() != $valDataobj->getMemoTypeID()){
				//指定のメモの意味空間での使用状況と更新
				$rtn = $this->checkAndUpdateImiBaseInfo(null,null,$memodata->getMemoID(), 2);
				if ($rtn != true) {
					$this->o_db->rollback();
					$table_access->free();
					$this->disconnectDB();
					trigger_error($this->o_resource->getValue("S4_001_08"), E_USER_ERROR);
					return false;
				}
				// 意味空間の全ての対象メモのメモ種類IDを更新
				$imimemoposition_access = new ImiMemoPositionTableAccess($this->directryname);
				$rtn = $imimemoposition_access->updateDataSetMemotypeId($this->o_db, $valDataobj->getMemoID(), $valDataobj->getMemoTypeID());
				if ($rtn != true) {
					$this->o_db->rollback();
					$imimemoposition_access->free();
					$table_access->free();
					$this->disconnectDB();
					trigger_error($this->o_resource->getValue("S4_001_08"), E_USER_ERROR);
					return false;
				}
				$imimemoposition_access->free();
				
			}
			//メモ種類からレイヤーIDを取得して意味メモテーブルのレイヤーIDを更新
			$memotype_access = new MemoTypeTableAccess($this->directryname);
			$rtn = $memotype_access->selectFindByKeyData($this->o_db, $memodata->getMemoTypeID());
			if ($rtn != true) {
				$this->o_db->rollback();
				$table_access->free();
				$this->disconnectDB();
				trigger_error($this->o_resource->getValue("S4_001_08"), E_USER_ERROR);
				return false;
			}
			$memotypdata = $memotype_access->getOneData();
			
			//対象のメモIDで意味メモ位置のデータをどれかselectし、そのレコードのレイヤーIDを取得する
			//そのレイヤーIDと、現時点のメモ種類→レイヤーIDを比較する
			$imimemoposition_access = new ImiMemoPositionTableAccess($this->directryname);	
			$rtn = $imimemoposition_access->selectFindByKeyData($this->o_db, "", $valDataobj->getMemoID());
			if ($rtn != true) {
				$this->o_db->rollback();
				$imimemoposition_access->free();
				$table_access->free();
				$this->disconnectDB();
				trigger_error($this->o_resource->getValue("S4_001_08"), E_USER_ERROR);
				return false;
			}
			if ($imimemoposition_access->getRecordCount() != 0){
				$imimemopositiondatalist = $imimemoposition_access->getDataList();					
				if ($memotypdata->getLayerID() != $imimemopositiondatalist[0]->getLayerID()){	//レイヤーIDはどのレコードでも同じ
					//指定のメモの意味空間での使用状況と更新
					$rtn = $this->checkAndUpdateImiBaseInfo(null,null,$memodata->getMemoID(), 2);
					if ($rtn != true) {
						$this->o_db->rollback();
						$table_access->free();
						$this->disconnectDB();
						trigger_error($this->o_resource->getValue("S4_001_08"), E_USER_ERROR);
						return false;
					}
					// 意味空間の全ての対象メモのレイヤーIDを更新
					$rtn = $imimemoposition_access->updateDataSetLayerId($this->o_db, $valDataobj->getMemoID(), $memotypdata->getLayerID());
					if ($rtn != true) {
						$this->o_db->rollback();
						$imimemoposition_access->free();
						$table_access->free();
						$this->disconnectDB();
						trigger_error($this->o_resource->getValue("S4_001_08"), E_USER_ERROR);
						return false;
					}
				}
			}
			$imimemoposition_access->free();
			
/*		
			if ($memotypdata->getLayerID() != $valDataobj->getLayerID()){
				//指定のメモの意味空間での使用状況と更新
				$rtn = $this->checkAndUpdateImiBaseInfo(null,null,$memodata->getMemoID());
				if ($rtn != true) {
					$this->o_db->rollback();
					$table_access->free();
					$this->disconnectDB();
					trigger_error($this->o_resource->getValue("S4_001_08"), E_USER_ERROR);
					return false;
				}
				// 意味空間の全ての対象メモのレイヤーIDを更新
				$imimemoposition_access = new ImiMemoPositionTableAccess($this->directryname);
				$rtn = $imimemoposition_access->updateDataSetLayerId($this->o_db, $valDataobj->getMemoID(), $valDataobj->getLayerID());
				if ($rtn != true) {
					$this->o_db->rollback();
					$imimemoposition_access->free();
					$table_access->free();
					$this->disconnectDB();
					trigger_error($this->o_resource->getValue("S4_001_08"), E_USER_ERROR);
					return false;
				}
				$imimemoposition_access->free();

			}
*/
		// （意味空間系処理はここまで）
		
		// メモ詳細データ更新
		$rtn = $table_access->updateByKeyData($this->o_db, $targetDataobj, $valDataobj);

		if ($rtn != true) {
			$this->o_db->rollback();
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_09"), E_USER_ERROR);
			return false;
		}

		// 解放
		$table_access->free();

		// トランザクションコミット
		$this->o_db->commit();

		// DB接続の切断
		$this->disconnectDB();
		
		return true;

	}
	
	/**
	 *	関数名：メモ位置更新処理
     * @引数：(I) $targetDataobj    - 対象列(条件列/更新列)指定用データオブジェクト
     *        (I) $valDataobj       - 設定値(条件値/更新値)指定用データオブジェクト
     * @戻値：$bool			- true  正常更新
     *                      - false 異常
     * @作成日/作成者：2006/09/01 (IIS)N.Soma
     * @更新日/更新者：
	 *            
     */
	function updateMemoPositionlDataByKey($targetDataobj, $valDataobj) {

		// DBオブジェクトの生成
		$this->createDBObject();

		// トランザクション開始
		$this->o_db->autoCommit(false);

		// メモ位置DBアクセスインスタンス生成
		$table_access = new MemoPositionTableAccess($this->directryname);

		// メモ位置データ更新
		$rtn = $table_access->updateByKeyData($this->o_db, $targetDataobj, $valDataobj);

		if ($rtn != true) {
			$this->o_db->rollback();
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_10"), E_USER_ERROR);
			return false;
		}

		// 解放
		$table_access->free();

		// トランザクションコミット
		$this->o_db->commit();

		// DB接続の切断
		$this->disconnectDB();
		
		return true;

	}

	/**
	 *	関数名：メモ／コメント更新処理
     * @引数：(I) $targetDetail		メモ詳細テーブル対象列(条件列/更新列)指定用データオブジェクト
     * @引数：(I) $targetPosition	メモ位置テーブル対象列(条件列/更新列)指定用データオブジェクト  
     * @引数：(I) $targetComment	コメントテーブル対象列(条件列/更新列)指定用データオブジェクト
     * @引数：(I) $dataArray    	設定値(条件値/更新値)指定用データオブジェクト
     * @戻値：$bool			- true  正常更新
     *                      - false 異常
     * @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
     * @更新日/更新者：
	 *            
     */
	function updateMemoCommentDataByKey($targetDetail, $targetPosition, $targetComment, $dataArray) {

		// DBオブジェクトの生成
		$this->createDBObject();

		// トランザクション開始
		$this->o_db->autoCommit(false);

		$curDate = date('Y/m/d H:i:s');

		// メモ詳細情報
		$detail = new MemoDetailData();
		$detail->setMemoID($dataArray["memoid"]);
		$detail->setMemoTypeID($dataArray["memotypeid"]);
		$detail->setUserName($dataArray["name"]);
		$detail->setMemoTitle($dataArray["title"]);
		$detail->setMemoText($dataArray["memotext"]);
		$detail->setMailAddress($dataArray["mail"]);
		$detail->setReleteURL($dataArray["url"]);
		$detail->setImageFile($dataArray["filename"]);
		$detail->setUpdateDeletePassword($dataArray["upddelpwd"]);
		$detail->setAccessCount($dataArray["count"]);
		$detail->setUpdateDateTime($curDate);

		// メモ位置情報
		$position = new MemoPositionData();
		$position->setMemoID($dataArray["memoid"]);
		$position->setMemoTypeID($dataArray["memotypeid"]);
		$position->setUpdateDateTime($curDate);

		// コメント情報
		$comment = new CommentData();
		$comment->setMemoID($dataArray["memoid"]);
		$comment->setMemoTypeID($dataArray["memotypeid"]);
		$comment->setUpdateDateTime($curDate);



		// 意味空間の更新必要を確認するために最初に現在のデータを取得
		// メモ詳細DBアクセスインスタンス生成
		$table_access_detail = new MemoDetailTableAccess($this->directryname);
			$rtn = $table_access_detail->selectFindByKeyData($this->o_db, $detail->getMemoID());
			if ($rtn != true) {
				$this->o_db->rollback();
				$table_access_detail->free();
				$this->disconnectDB();
				trigger_error($this->o_resource->getValue("S4_001_07"), E_USER_ERROR);
				return false;
			}
			$memodata = $table_access_detail->getOneData();
			
			//メモ種類が現在と異なったら、意味空間で使用されているそのメモのメモ種類を更新
			if ($memodata->getMemoTypeID() != $detail->getMemoTypeID()){
				//指定のメモの意味空間での使用状況と警告フラグ更新
				$rtn = $this->checkAndUpdateImiBaseInfo(null,null,$memodata->getMemoID(), 2);
				if ($rtn != true) {
					$this->o_db->rollback();
					$table_access->free();
					$this->disconnectDB();
					trigger_error($this->o_resource->getValue("S4_001_08"), E_USER_ERROR);
					return false;
				}
				// 意味空間の全ての対象メモのメモ種類IDを更新
				$imimemoposition_access = new ImiMemoPositionTableAccess($this->directryname);
				$rtn = $imimemoposition_access->updateDataSetMemotypeId($this->o_db, $detail->getMemoID(), $detail->getMemoTypeID());
				if ($rtn != true) {
					$this->o_db->rollback();
					$imimemoposition_access->free();
					$table_access->free();
					$this->disconnectDB();
					trigger_error($this->o_resource->getValue("S4_001_08"), E_USER_ERROR);
					return false;
				}
				$imimemoposition_access->free();
				
			}
			//新しいメモ種類から新しいレイヤーIDを取得して意味メモテーブルのレイヤーIDを更新
			$memotype_access = new MemoTypeTableAccess($this->directryname);
			$rtn = $memotype_access->selectFindByKeyData($this->o_db, $detail->getMemoTypeID());
			if ($rtn != true) {
				$this->o_db->rollback();
				$table_access->free();
				$this->disconnectDB();
				trigger_error($this->o_resource->getValue("S4_001_08"), E_USER_ERROR);
				return false;
			}
			$new_memotypdata = $memotype_access->getOneData();
			
			//対象のメモIDで意味メモ位置のデータをどれかselectし、そのレコードのレイヤーIDを取得する
			//そのレイヤーIDと、現時点のメモ種類→レイヤーIDを比較する
			$imimemoposition_access = new ImiMemoPositionTableAccess($this->directryname);	
			$rtn = $imimemoposition_access->selectFindByKeyData($this->o_db, "", $detail->getMemoID());
			if ($rtn != true) {
				$this->o_db->rollback();
				$imimemoposition_access->free();
				$table_access->free();
				$this->disconnectDB();
				trigger_error($this->o_resource->getValue("S4_001_08"), E_USER_ERROR);
				return false;
			}
			if ($imimemoposition_access->getRecordCount() != 0){
				$imimemopositiondatalist = $imimemoposition_access->getDataList();					
				if ($new_memotypdata->getLayerID() != $imimemopositiondatalist[0]->getLayerID()){	//レイヤーIDはどのレコードでも同じ
					//指定のメモの意味空間での使用状況と更新
					$rtn = $this->checkAndUpdateImiBaseInfo(null,null,$detail->getMemoID() ,2);
					if ($rtn != true) {
						$this->o_db->rollback();
						$table_access->free();
						$this->disconnectDB();
						trigger_error($this->o_resource->getValue("S4_001_08"), E_USER_ERROR);
						return false;
					}
					// 意味空間の全ての対象メモのレイヤーIDを更新
					$rtn = $imimemoposition_access->updateDataSetLayerId($this->o_db, $detail->getMemoID(), $new_memotypdata->getLayerID());
					if ($rtn != true) {
						$this->o_db->rollback();
						$imimemoposition_access->free();
						$table_access->free();
						$this->disconnectDB();
						trigger_error($this->o_resource->getValue("S4_001_08"), E_USER_ERROR);
						return false;
					}
				}
			}
			$imimemoposition_access->free();
		// （意味空間系処理はここまで）

		// メモ詳細データ更新
		$rtn = $table_access_detail->updateByKeyData($this->o_db, $targetDetail, $detail);

		if ($rtn != true) {
			$this->o_db->rollback();
			$table_access_detail->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_11"), E_USER_ERROR);
			return false;
		}

		// メモ位置情報テーブルアクセスインスタンス生成
		$table_access_position = new MemoPositionTableAccess($this->directryname);

		// メモ位置情報テーブル更新
		$rtn = $table_access_position->updateByKeyData($this->o_db, $targetPosition, $position);

		if ($rtn != true) {
			$this->o_db->rollback();
			$table_access_detail->free();
			$table_access_position->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_12"), E_USER_ERROR);
			return false;
		}

		// コメントテーブルアクセスインスタンス生成
		$table_access_comment = new CommentTableAccess($this->directryname);

		// コメントデータ更新
		$rtn = $table_access_comment->updateByMemoIdData($this->o_db, $targetComment, $comment);

		if ($rtn != true) {
			$this->o_db->rollback();
			$table_access_detail->free();
			$table_access_position->free();
			$table_access_comment->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_13"), E_USER_ERROR);
			return false;
		}

		// 解放
		$table_access_detail->free();
		$table_access_position->free();
		$table_access_comment->free();

		// トランザクションコミット
		$this->o_db->commit();

		// DB接続の切断
		$this->disconnectDB();
		
		return true;

	}

	/**
	 *	関数名：メモ／コメント更新処理(携帯用)
     * @引数：(I) $targetDetail		メモ詳細テーブル対象列(条件列/更新列)指定用データオブジェクト
     * @引数：(I) $targetPosition	メモ位置テーブル対象列(条件列/更新列)指定用データオブジェクト  
     * @引数：(I) $targetComment	コメントテーブル対象列(条件列/更新列)指定用データオブジェクト
     * @引数：(I) $dataArray    	設定値(条件値/更新値)指定用データオブジェクト
     * @引数：(O) $updDate			更新時刻
     * @戻値：$bool			- true  正常更新
     *                      - false 異常
     * @作成日/作成者：2007/03/01 (IIS)J.Fujikawa
     * @更新日/更新者：
	 *            
     */
	function updateMemoCommentDataByKeyMobile($targetDetail, $targetPosition, $targetComment, $dataArray, &$updDate) {
		//初期化
		$flg = false;
		$rtn = false;
		$memo_table_access = null;
		$memodata = null;

		//更新用メソッドを呼び出す
		$flg = $this->updateMemoCommentDataByKey($targetDetail, $targetPosition, $targetComment, $dataArray);
		
		//以下、更新時刻を取得する為にデータを取得する
		// DBオブジェクトの生成
		$this->createDBObject();
		
		$memo_table_access = new MemoDetailTableAccess($this->directryname);
		$rtn = $memo_table_access->selectFindByKeyData($this->o_db, $dataArray["memoid"]);
		if ($rtn != true) {
			$this->o_db->rollback();
			$memo_table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_07"), E_USER_ERROR);
			return false;
		}
		
		$memodata = $memo_table_access->getOneData();
		
		//更新時刻を取得
		if ($memodata != null){
			$updDate = $memodata->getUpdateDateTime();
		}
		//開放
		$memo_table_access->free();
		// DB接続の切断
		$this->disconnectDB();
		
		return $flg;
	}

	/**
	 *	関数名：レイヤー表示順設定
     * @引数：(I) $userid           - ユーザID
     *        (I) $settingList      - 設定表示順データ
     * @戻値：$bool			- true  正常更新
     *                      - false 異常
     * @作成日/作成者：2006/09/01 (IIS)K.Shimomura
     * @更新日/更新者：
	 *            
     */
	function setLayerIndicateOrder($userid, $settingList) {

		// DBオブジェクトの生成
		$this->createDBObject();

		// トランザクション開始
		$this->o_db->autoCommit(false);

        // ------------------------------
        // 個人情報管理テーブルを削除
        // ------------------------------

		// 一般ユーザ個人情報DBアクセスインスタンス生成
		$table_access = new UserPersonalInfoTableAccess($this->directryname);

		// 一般ユーザ個人情報データ削除
		$rtn = $table_access->deleteByUserID($this->o_db, $userid);
		if ($rtn != true) {
			$this->o_db->rollback();
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_14"), E_USER_ERROR);
			return false;
		}

        // -----------------------------------------
        // 個人情報管理テーブルへ更新(レイヤー一覧)
        // -----------------------------------------

        $dba = new KakikoDBAccess($this->o_db, 'dummy');

		$rtn = $dba->dba_executeQuery(
			"INSERT INTO ".$this->directryname."_userpersonalinfotable "
				."SELECT "
				.$dba->query_str_convert($userid).", "
				.$this->directryname."_layertable.layerid, "
				.$dba->query_str_convert(KAKIKOMAP_LAYERLISTSTATE_SECRET).", "
				."null, "
				.$dba->query_str_convert(date('Y/m/d H:i:s')).", "
				.$dba->query_str_convert(date('Y/m/d H:i:s'))." "
				."FROM ".$this->directryname."_layertable "
				."INNER JOIN ".$this->directryname."_usertable "
				."ON ".$this->directryname."_layertable.userid = "
				.$this->directryname."_usertable.userid "
				."LEFT JOIN ".$this->directryname."_layerusertable "
				."ON ".$this->directryname."_layertable.layerid = "
				.$this->directryname."_layerusertable.layerid "
				."AND ".$this->directryname."_layerusertable.userid = ".$dba->query_str_convert($userid)." "
				."WHERE ( ".$this->directryname."_layertable.publiclayer = ".$dba->query_str_convert(KAKIKOMAP_PUBLICLAYER_GUEST)." "
				."OR ( ".$this->directryname."_layertable.publiclayer = ".$dba->query_str_convert(KAKIKOMAP_PUBLICLAYER_NORMAL)." "
				."AND ".$this->directryname."_layerusertable.userid <> '' )) "
				."AND ".$this->directryname."_layertable.statusflg = ".$dba->query_str_convert(KAKIKOMAP_STATUSFLG_ON)
		);		
        if ($rtn != true) {
			$this->o_db->rollback();
			$dba->dba_free();
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_15"), E_USER_ERROR);
			return false;
        }
		// 解放
		$dba->dba_free();

        // -----------------------------------------
        // 個人情報管理テーブルへ更新(順位)
        // -----------------------------------------

        // 条件及びNULL等のターゲット設定
        $targetUserPersonalInfoDataObj = new UserPersonalInfoData();

        // 条件
        $targetUserPersonalInfoDataObj->setUserID(WHERE_KEY);
        $targetUserPersonalInfoDataObj->setLayerID(WHERE_KEY);

        // 更新項目ターゲット設定
        $targetUserPersonalInfoDataObj->setLayerListState(VAL_TARGET);
        $targetUserPersonalInfoDataObj->setLayerPriorityOrder(VAL_TARGET);

        // 更新項目設定
        $valUserPersonalInfoDataObj = new UserPersonalInfoData();

        $valUserPersonalInfoDataObj->setUserID($userid);
        $valUserPersonalInfoDataObj->setLayerListState(KAKIKOMAP_LAYERLISTSTATE_DISP);

        foreach ($settingList as $key=>$value) {

            $valUserPersonalInfoDataObj->setLayerPriorityOrder($key);
            $valUserPersonalInfoDataObj->setLayerID($value);

		    // 一般ユーザ個人情報データ更新
		    $rtn = $table_access->updateByKeyData($this->o_db, $targetUserPersonalInfoDataObj, $valUserPersonalInfoDataObj);
		    if ($rtn != true) {
                $this->o_db->rollback();
                $table_access->free();
                $this->disconnectDB();
				trigger_error($this->o_resource->getValue("S4_001_15"), E_USER_ERROR);
                return false;
            }
        }

		// トランザクションコミット
		$this->o_db->commit();

		// DB接続の切断
		$this->disconnectDB();
		
		return true;

	}

	/**
	 *	関数名：メモ削除処理
     * @引数：(I) $memoId   - メモID
     * @戻値：int			- -1 	論理削除成功
     *                      - -2	物理削除成功
     *                      - -3	削除対象なし 
     *                      - false	異常終了
     * @作成日/作成者：2006/09/01 (IIS)N.Soma
     * @更新日/更新者：
	 * @注意事項:削除フラグの状態により、論理削除あるいは物理削除を行います。
	 *           物理削除が行われた場合、配下のコメントも物理削除します。
	 *           メモ配下のコメントの存在はあらかじめチェックしておいてください。
     */
	function deleteMemoDataByKey($memoId) {
		$retflg = false;	

		// メモ状態の確認
		$memoviewdata = $this->getOneMemoDetailViewData($memoId);
		if (is_null($memoviewdata) == true){
			return -3;
		}

		// DBオブジェクトの生成
		$this->createDBObject();

		// メモ詳細DBアクセスインスタンス生成
		$table_access_detail = new MemoDetailTableAccess($this->directryname);
		$table_access_position = new MemoPositionTableAccess($this->directryname);
		$table_access_comment = new CommentTableAccess($this->directryname);

		// トランザクション開始
		$this->o_db->autoCommit(false);
		if (is_null($memoviewdata->getDeleteFlg_d()) == true){
			// deleteflgが立っていない時は論理削除
			//メモ詳細
			$memodetail_key = new MemoDetailData();
			$memodetail_val = new MemoDetailData();
			$memodetail_key->setMemoID(WHERE_KEY);	//where指定
			$memodetail_val->setMemoID($memoId);
			$memodetail_key->setDeleteFlg(VAL_TARGET);	//値設定
			$memodetail_val->setDeleteFlg(KAKIKOMAP_DELETEFLG_ON);	//論理削除
			$rtn = $table_access->updateByKeyData($this->o_db, $memodetail_key, $memodetail_val);		
			if ($rtn != true) {
				$this->o_db->rollback();
				$table_access_detail->free();
				$table_access_position->free();
				$table_access_comment->free();
				$this->disconnectDB();
				trigger_error($this->o_resource->getValue("S4_001_16"), E_USER_ERROR);
				return false;
			}
			//メモ位置		
			$memoposition_key = new MemoPositionData();
			$memoposition_val = new MemoPositionData();
			$memoposition_key->setMemoID(WHERE_KEY);	//where指定
			$memoposition_val->setMemoID($memoId);
			$memoposition_key->setDeleteFlg(VAL_TARGET);	//値設定
			$memoposition_val->setDeleteFlg(KAKIKOMAP_DELETEFLG_ON);	//論理削除
			$rtn = $table_access->updateByKeyData($this->o_db, $memoposition_key, $memoposition_val);		
			if ($rtn != true) {
				$this->o_db->rollback();
				$table_access_detail->free();
				$table_access_position->free();
				$table_access_comment->free();
				$this->disconnectDB();
				trigger_error($this->o_resource->getValue("S4_001_17"), E_USER_ERROR);
				return false;
			}
			$retflg = -1;//論理削除実行フラグ
		}else{
			// deleteflgが立っている時は物理削除
			//メモ詳細削除
			$rtn = $table_access_detail->deleteByKeyData($this->o_db, $memoId);	
			if ($rtn != true) {
				$this->o_db->rollback();
				$table_access_detail->free();
				$table_access_position->free();
				$table_access_comment->free();
				$this->disconnectDB();
				trigger_error($this->o_resource->getValue("S4_001_18"), E_USER_ERROR);
				return false;
			}
			//メモ位置削除
			$rtn = $table_access_position->deleteByKeyData($this->o_db, $memoId);	
			if ($rtn != true) {
				$this->o_db->rollback();
				$table_access_detail->free();
				$table_access_position->free();
				$table_access_comment->free();
				$this->disconnectDB();
				trigger_error($this->o_resource->getValue("S4_001_18"), E_USER_ERROR);
				return false;
			}
			//配下コメント全削除
			$rtn = $table_access_comment->deleteByMemoIdData($this->o_db, $memoId);	
			if ($rtn != true) {
				$this->o_db->rollback();
				$table_access_detail->free();
				$table_access_position->free();
				$table_access_comment->free();
				$this->disconnectDB();
				trigger_error($this->o_resource->getValue("S4_001_19"), E_USER_ERROR);
				return false;
			}
			$retflg = -2;//物理削除実行フラグ			
		}
		// 物理論理に関係なく意味空間で使用されているメモのチェックと削除
		$rtn = $this->checkAndUpdateImiBaseInfo(null, null, $memoId, 2);
		if ($rtn != true) {
			$this->o_db->rollback();
			$table_access_detail->free();
			$table_access_position->free();
			$table_access_comment->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_20"), E_USER_ERROR);
			return false;
		}
		$imimemoposition_access = new ImiMemoPositionTableAccess($this->directryname);
		$rtn = $imimemoposition_access->deleteByKeyData($this->o_db, null, $memoId);		
		if ($rtn != true) {
			$this->o_db->rollback();
			$table_access_detail->free();
			$table_access_position->free();
			$table_access_comment->free();
			$imimemoposition_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_20"), E_USER_ERROR);
			return false;
		}
		$imimemoposition_access->free();
		
		// 解放
		$table_access_detail->free();
		$table_access_position->free();
		$table_access_comment->free();

		// トランザクションコミット
		$this->o_db->commit();

		// DB接続の切断
		$this->disconnectDB();
		
		return $retflg;

	}
	

	/**
	 *	関数名：メモ配下コメント存在チェック
     * @引数：(I) $memoId    - 対象メモID
     * @戻値：$bool			- true  配下にコメントが存在する
     *                      - false 配下にコメントが存在しない
     * @作成日/作成者：2006/09/01 (IIS)N.Soma
     * @更新日/更新者：
     * @使用方法：メモIDの配下にコメントが存在しているか判定します。
	 *            
     */
	function checkExistChildCommentByMemoId($memoId) {

		// DBオブジェクトの生成
		$this->createDBObject();

		$adminuser_access = new CommentTableAccess($this->directryname);

		// コメントの存在チェック
		$rtn = $adminuser_access->checkFindByMemoidData($this->o_db, $memoId);

		$adminuser_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return $rtn;
	}

   /**
    * 関数名：コメント情報取得
    * @引数：(I) $commentId 	- メモID
    * @戻値：MemoDetailData
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function getOneCommentData($commentId) {
	
		// DBオブジェクトの生成
		$this->createDBObject();

		// メモ詳細（付加情報つき）テーブルDBアクセス
		$table_access = new MemoDetailJoinPositionJoinTypeTableAccess($this->directryname);

		// クエリー発行
		$rtn =  $table_access->selectCommentPositionTypeDataByKey($this->o_db, $commentId);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_21"), E_USER_ERROR);
			return null;
		}
		if ($table_access->getRecordCount() == 0){
			return null;
		}
		
		// データオブジェクトの取得
		$data = $table_access->getOneData();

		// 解放
		$table_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return $data;
	
	}

	/**
	 *	関数名：コメント新規登録
     * @引数：(I) $commmetDataobj	- ユーザテーブル用データオブジェクト
     * @戻値：$bool			- true  正常登録
     *                      - false 異常
     * @作成日/作成者：2006/09/01 (IIS) N.Soma
     * @更新日/更新者：
     */     
	function insertCommnet($commmetDataobj) {

		// DBオブジェクトの生成
		$this->createDBObject();

		// トランザクション開始
		$this->o_db->autoCommit(false);

		// ユーザDBアクセスインスタンス生成
		$comment_access = new CommentTableAccess($this->directryname);

		// データ追加
		$rtn = $comment_access->insertData($this->o_db, $commmetDataobj);
		if ($rtn != true) {
			$this->o_db->rollback();
			$comment_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_22"), E_USER_ERROR);
			return false;
		}

		// 解放
		$comment_access->free();

		// トランザクションコミット
		$this->o_db->commit();

		// DB接続の切断
		$this->disconnectDB();

		return true;
	}

	/**
	 *	関数名：コメント新規登録(携帯用)
     * @引数：(I) $commmetDataobj	- ユーザテーブル用データオブジェクト
     *        (O) $newCommentId	  			- 新規発行されたコメントID
     * @戻値：$bool			- true  正常登録
     *                      - false 異常
     * @作成日/作成者：2007/03/01 (IIS) J.Fujikawa
     * @更新日/更新者：
     */     
	function insertCommnetMobile($commmetDataobj, &$newCommentId) {

		// DBオブジェクトの生成
		$this->createDBObject();

		// トランザクション開始
		$this->o_db->autoCommit(false);

		// ユーザDBアクセスインスタンス生成
		$comment_access = new CommentTableAccess($this->directryname);

		// データ追加
		$rtn = $comment_access->insertData($this->o_db, $commmetDataobj);
		if ($rtn != true) {
			$this->o_db->rollback();
			$comment_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_22"), E_USER_ERROR);
			return false;
		}

		//初期化
		$commentid_seq = "";
		
		// -----------------------------------------------
		// 発行したコメントIDをシーケンスから取得
		// -----------------------------------------------
		//select currval('xxxxxx_commenttable_commentid_seq') as commentid_seq
		$dba = new KakikoDBAccess($this->o_db, 'dummy');
		$dba->dba_executeQuery("select currval('".$this->directryname."_commenttable_commentid_seq') as commentid_seq");		
		while($row = $dba->rs->fetchrow(DB_FETCHMODE_ASSOC)) {
			$commentid_seq = isset($row['commentid_seq'])?$row['commentid_seq']:null;
		}

		// 解放
		$comment_access->free();

		// トランザクションコミット
		$this->o_db->commit();

		// DB接続の切断
		$this->disconnectDB();
		
		// 返却値の設定
		$newCommentId = $commentid_seq;

		return true;
	}

	/**
	 *	関数名：コメント更新処理
     * @引数：(I) $targetDataobj    - 対象列(条件列/更新列)指定用データオブジェクト
     *        (I) $valDataobj       - 設定値(条件値/更新値)指定用データオブジェクト
     * @戻値：$bool			- true  正常更新
     *                      - false 異常
     * @作成日/作成者：2006/09/01 (IIS)N.Soma
     * @更新日/更新者：
	 *            
     */
	function updateCommentDataByKey($targetDataobj, $valDataobj) {

		// DBオブジェクトの生成
		$this->createDBObject();

		// トランザクション開始
		$this->o_db->autoCommit(false);

		// コメントDBアクセスインスタンス生成
		$table_access = new CommentTableAccess($this->directryname);

		// コメントデータ更新
		$rtn = $table_access->updateByKeyData($this->o_db, $targetDataobj, $valDataobj);

		if ($rtn != true) {
			$this->o_db->rollback();
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_23"), E_USER_ERROR);
			return false;
		}

		// 解放
		$table_access->free();

		// トランザクションコミット
		$this->o_db->commit();

		// DB接続の切断
		$this->disconnectDB();
		
		return true;

	}

	/**
	 *	関数名：コメント削除処理
     * @引数：(I) $commentId    - コメントID
     * @戻値：int			- -1 	論理削除成功
     *                      - -2	物理削除成功
     *                      - -3	削除対象なし 
     *                      - false	異常終了
     * @作成日/作成者：2006/09/01 (IIS)N.Soma
     * @更新日/更新者：
	 * @注意事項:削除フラグの状態により、論理削除あるいは物理削除を行います。
	 *           コメント配下のコメントの存在はあらかじめチェックしておいてください。	 
     */
	function deleteCommentDataByKey($commentId) {
		$retflg = false;

		// コメント状態の確認
		$commmentdata = $this->getOneCommentData($commentId);
		if (is_null($commmentdata) == true){
			return -3;
		}


		// DBオブジェクトの生成
		$this->createDBObject();

		// コメントDBアクセスインスタンス生成
		$table_access = new CommentTableAccess($this->directryname);

		// トランザクション開始
		$this->o_db->autoCommit(false);

		if ($commmentdata->getDeleteFlg_c() == '0'){
			// deleteflgが立っていない時は論理削除
			$commentdata_key = new CommentData();
			$commentdata_val = new CommentData();
			$commentdata_key->setCommentID(WHERE_KEY);	//where指定
			$commentdata_val->setCommentID($commentId);
			$commentdata_key->setDeleteFlg(VAL_TARGET);	//値設定
			$commentdata_val->setDeleteFlg(KAKIKOMAP_DELETEFLG_ON);		//論理削除
			$rtn = $table_access->updateByKeyData($this->o_db, $commentdata_key, $commentdata_val);	
			$retflg = -1;//論理削除実行フラグ
			
		}else{
			// deleteflgが立っている時は物理削除
			$rtn = $table_access->deleteByKeyData($this->o_db, $commentId);		
			$retflg = -2;//物理削除実行フラグ
		}
		if ($rtn != true) {
			$this->o_db->rollback();
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_24"), E_USER_ERROR);
			return false;
		}

		// 解放
		$table_access->free();

		// トランザクションコミット
		$this->o_db->commit();

		// DB接続の切断
		$this->disconnectDB();
		
		return $retflg;

	}



	/**
	 *	関数名：コメント配下コメント存在チェック
     * @引数：(I) $commentId    - 対象メモID
     * @戻値：$bool			- true  配下にコメントが存在する
     *                      - false 配下にコメントが存在しない
     * @作成日/作成者：2006/09/01 (IIS)N.Soma
     * @更新日/更新者：
     * @使用方法：メモIDの配下にコメントが存在しているか判定します。
	 *            
     */
	function checkExistChildCommentByCommentId($commentId) {

		// DBオブジェクトの生成
		$this->createDBObject();

		$adminuser_access = new CommentTableAccess($this->directryname);

		// コメントの存在チェック
		$rtn = $adminuser_access->checkFindByCommentidData($this->o_db, $commentId);

		$adminuser_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return $rtn;
	}

	/**
	* 関数概要：指定レイヤーRSS情報取得
	* 処理詳細：指定されたレイヤーのRSS情報を取得する。
	*
	* @引数： (I) $targetLayerId - 取得対象のレイヤーID
	*  　　　 (I) $authMemoType  - ゲストユーザ制限
	*              　　　　　　　　（true:ゲストユーザのみ, false:制限なし）
	* @戻値： MemoDetailPositionTypeDataの配列
	* @作成日/作成者：2006/09/01 (IIS)S.Komukai
	* @更新日/更新者：
	* @更新内容：
	*/	
	function getRSSData($targetLayerId, $authMemoType){

		// DBオブジェクトの生成
		$this->createDBObject();

		// メモ詳細（付加情報つき）テーブルDBアクセス
		$table_access = new MemoDetailJoinPositionJoinTypeTableAccess($this->directryname);

		// クエリー発行
		$rtn = $table_access->selectRSSData($this->o_db, $targetLayerId, $authMemoType);

		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_25"), E_USER_ERROR);			
			return null;
		}


		// データオブジェクトの取得
		$data = $table_access->getDataList();

		// 解放
		$table_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return $data;

	}

	/**
	* 関数概要：レイヤー管理者RSSファイル名取得
	* 処理詳細：指定されたレイヤー管理者のRSSファイル名を取得する。
	*
	* @引数： (I) $targetLayerId - 取得対象のレイヤーID
	* @戻値： LayerData
	* @作成日/作成者：2006/09/01 (IIS)S.Komukai
	* @更新日/更新者：
	* @更新内容：
	*/	
	function getLayerAdminRSSFileName($targetLayerId){

		// DBオブジェクトの生成
		$this->createDBObject();

		// メモ詳細（付加情報つき）テーブルDBアクセス
		$table_access = new LayerTableAccess($this->directryname);

		// クエリー発行
		$rtn =  $table_access->selectLayerIDKeyData($this->o_db, $targetLayerId);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_26"), E_USER_ERROR);
			return null;
		}
		if ($table_access->getRecordCount() == 0){
			return null;
		}

		// データオブジェクトの取得
		$data = $table_access->getOneData();

		// 解放
		$table_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return $data;

	}
   /**
    * 関数名：マップコントロール用レイヤー(参加要求込み)取得(管理者/一般ユーザ)
    * @引数：(I) $userid 	- ユーザID
    * @戻値：array Layer_User_LayerUser_Personal_PriorityData   - DBエラーの場合はnull
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function getMapControllLayerByUser($userid) {
        // DBオブジェクトの生成
        $this->createDBObject();
        // レイヤーテーブルDBアクセス
		$table_access = new LayerJoinUserAndLayerUserAndPersonalAndPriorityTableAccess($this->directryname);
        // レイヤー状態フラグ
        $status_array = array(KAKIKOMAP_STATUSFLG_ON);
        
        // クエリー発行
		$rtn = $table_access->selectMapControllLayerDataByUser($this->o_db, $userid, $status_array);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_41"), E_USER_ERROR);
			return null;
		}

        // データオブジェクトの取得
		$datalist = $table_access->getDataList();

        // 解放
        $table_access->free();

        // DB接続の切断
        $this->disconnectDB();

        return $datalist;
        
	
	}


   /**
    * 関数名：マップコントロール用レイヤー・メモ取得(管理者/一般ユーザ)
    * @引数：(I) $userid 	- ユーザID
    *        (I) $mode 		- 取得する際の対象権限
	*                          1:閲覧権限で検索
	*                          2:投稿権限で検索
    * @戻値：array $datalist   - DBエラーの場合はnull
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function getMapControllDataByUser($userid,$mode) {

        // DBオブジェクトの生成
        $this->createDBObject();

        // レイヤーメモ種類メモ詳細メモ位置テーブルDBアクセス
		$table_access = new MemoDetailJoinPositionJoinTypeTableAccess($this->directryname);

        // レイヤー状態フラグ
        $status_array = array(KAKIKOMAP_STATUSFLG_ON);

        // クエリー発行
		$rtn = $table_access->selectMapControllLayerMemotypeDataByUser($this->o_db, $userid, $status_array, $mode);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_27"), E_USER_ERROR);
			return null;
		}

        // データオブジェクトの取得
		$datalist = $table_access->getDataList();

        // 解放
        $table_access->free();

        // DB接続の切断
        $this->disconnectDB();

        return $datalist;

	}

   /**
    * 関数名：マップコントロール用レイヤー・メモ取得(ゲスト)
    * @引数：(I) $mode 		- 取得する際の対象権限
	*                          1:閲覧権限で検索
	*                          2:投稿権限で検索
    * @戻値：array $datalist   - DBエラーの場合はnull
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function getMapControllDataByGuest($mode) {

        // DBオブジェクトの生成
        $this->createDBObject();

        // レイヤーメモ種類メモ詳細メモ位置テーブルDBアクセス
		$table_access = new MemoDetailJoinPositionJoinTypeTableAccess($this->directryname);

        // レイヤー状態フラグ
        $status_array = array(KAKIKOMAP_STATUSFLG_ON);

        // クエリー発行
		$rtn = $table_access->selectMapControllLayerMemotypeDataGuest($this->o_db, $status_array,$mode);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_28"), E_USER_ERROR);
			return null;
		}

        // データオブジェクトの取得
		$datalist = $table_access->getDataList();

        // 解放
        $table_access->free();

        // DB接続の切断
        $this->disconnectDB();

        return $datalist;

	}

   /**
    * 関数名：地図表示用メモ取得(管理者・一般用)
    * @引数：(I) $userid 	- ユーザID
    *      ：(I) $searchKey 	- 検索条件キー（下記参照）
    * @戻値：array $datalist   - DBエラーの場合はnull
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    * @使用方法：検索キーとして使用される$searchKeyは連想配列で定義する。
    *            $searchKey["limit"]	- 最新取得件数
    *            $searchKey["from"]		- 対象期間（from）
    *            $searchKey["to"]		- 対象期間（to）
    *            $searchKey["word"]		- 語句
    *            $searchKey['minx']	- 範囲座標（X緯度最小）
    *            $searchKey['maxx']	- 範囲座標（X緯度最大）
    *            $searchKey['miny']	- 範囲座標（Y経度最小）
    *            $searchKey['maxy']	- 範囲座標（Y経度最大）
    */
	function getMapViewMemoDataByUser($userid, $searchKey) {

        // DBオブジェクトの生成
        $this->createDBObject();

        // レイヤーメモ種類メモ詳細メモ位置テーブルDBアクセス
		$table_access = new MemoDetailJoinPositionJoinTypeTableAccess($this->directryname);

        // レイヤー状態フラグ
        $status_array = array(KAKIKOMAP_STATUSFLG_ON);

        // クエリー発行
		$rtn = $table_access->selectViewMemoDetailPositionTypeDataByUser($this->o_db, $userid, $status_array, null,null,1,$searchKey);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_29"), E_USER_ERROR);
			return null;
		}

        // データオブジェクトの取得
		$datalist = $table_access->getDataList();

        // 解放
        $table_access->free();

        // DB接続の切断
        $this->disconnectDB();

        return $datalist;

	}

   /**
    * 関数名：地図表示用メモ取得(ゲスト用)
    * @引数：(I) $searchKey 	- 検索条件キー（下記参照）
    * @戻値：array $datalist   - DBエラーの場合はnull
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    * @使用方法：検索キーとして使用される$searchKeyは連想配列で定義する。
    *            $searchKey["limit"]	- 最新取得件数
    *            $searchKey["from"]		- 対象期間（from）
    *            $searchKey["to"]		- 対象期間（to）
    *            $searchKey["word"]		- 語句
    *            $searchKey['minx']	- 範囲座標（X緯度最小）
    *            $searchKey['maxx']	- 範囲座標（X緯度最大）
    *            $searchKey['miny']	- 範囲座標（Y経度最小）
    *            $searchKey['maxy']	- 範囲座標（Y経度最大）
    */ 
	function getMapViewMemoDataByGuest($searchKey) {

        // DBオブジェクトの生成
        $this->createDBObject();

        // レイヤーメモ種類メモ詳細メモ位置テーブルDBアクセス
		$table_access = new MemoDetailJoinPositionJoinTypeTableAccess($this->directryname);

        // レイヤー状態フラグ
        $status_array = array(KAKIKOMAP_STATUSFLG_ON);

        // クエリー発行
		$rtn = $table_access->selectViewMemoDetailPositionTypeDataGuest($this->o_db, $status_array,$searchKey);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_30"), E_USER_ERROR);
			return null;
		}

        // データオブジェクトの取得
		$datalist = $table_access->getDataList();

        // 解放
        $table_access->free();

        // DB接続の切断
        $this->disconnectDB();

        return $datalist;

	}

	/**
	 *	関数名：ユーザデータ取得
     * @引数：(I) $userId			- ユーザID
     * @戻値：UserDataクラス		- 正常終了
     *		  false					- 異常終了
     * @作成日/作成者：2006/09/01 (IIS) N.Soma
     * @更新日/更新者：
	 *            
     */
	function getUserDataByKey($userId) {

		// DBオブジェクトの生成
		$this->createDBObject();

		// ユーザDBアクセスインスタンス生成
		$table_access = new UserTableAccess($this->directryname);

		// ユーザデータ取得
		$rtn = $table_access->selectFindByKeyData($this->o_db, $userId);
		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_31"), E_USER_ERROR);
			return null;
		}

		// データオブジェクトの取得
		$data = $table_access->getOneData();

		// 解放
		$table_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return $data;

	}

	/**
	 *	関数名：ユーザテーブルデータキー更新
     * @引数：(I) $targetDataobj    - 対象列(条件列/更新列)指定用データオブジェクト
     *        (I) $valDataobj       - 設定値(条件値/更新値)指定用データオブジェクト
     * @戻値：$bool			- true  正常更新
     *                      - false 異常
     * @作成日/作成者：2006/09/01 (IIS) K.Shimomura
     * @更新日/更新者：
     * @使用方法：ユーザテーブルデータをキー(ユーザID)で更新を行います。
	 *            
     */
	function updateUserDataByKey($targetDataobj, $valDataobj) {

		// DBオブジェクトの生成
		$this->createDBObject();

		// トランザクション開始
		$this->o_db->autoCommit(false);

		// ユーザDBアクセスインスタンス生成
		$table_access = new UserTableAccess($this->directryname);

		// ユーザデータ更新
		$rtn = $table_access->updateByKeyData($this->o_db, $targetDataobj, $valDataobj);
		if ($rtn != true) {
			$this->o_db->rollback();
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_32"), E_USER_ERROR);

			return false;
		}

		// 解放
		$table_access->free();

		// トランザクションコミット
		$this->o_db->commit();

		// DB接続の切断
		$this->disconnectDB();
		
		return true;

	}

	/**
	 *	関数名：ユーザ削除
     * @引数：(I) $userid   - ユーザID
     * @戻値：$bool			- true  正常登録
     *                      - false 異常
     * @作成日/作成者：2006/09/01 (IIS) K.Shimomura
     * @更新日/更新者：
     * @使用方法：ユーザの削除を行います。
	 *            
     */
	function deleteUserByKey($userid) {

		// DBオブジェクトの生成
		$this->createDBObject();

		// トランザクション開始
		$this->o_db->autoCommit(false);

		// ユーザテーブルデータ削除処理
		$table_access = new UserTableAccess($this->directryname);

		$rtn = $table_access->deleteByKeyData($this->o_db, $userid);
		if ($rtn != true) {
			$this->o_db->rollback();
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_33"), E_USER_ERROR);
			return false;
		}

		// 解放
		$table_access->free();

		// トランザクションコミット
		$this->o_db->commit();

		// DB接続の切断
		$this->disconnectDB();

		return true;

	}

   /**
    * 関数名：参加要求情報取得
    * @引数：(I) $userId 	- ユーザID
    *        (I) $layerId 	- レイヤーID
    * @戻値：true		- 参加要求表示可
    *      ：false		- 参加要求表示不可
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function getLayerUserStatus($userId, $layerId) {
		// DBオブジェクトの生成
		$this->createDBObject();

		$table_access = new LayerUserTableAccess($this->directryname);
		//全閲覧可能ツリーデータ取得
		$rtn = $table_access->selectFindByKeyData($this->o_db, $userId, $layerId);
		if ($rtn != true) {
			$this->o_db->rollback();
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_35"), E_USER_ERROR);
			return false;
		}
		if ($table_access->getRecordCount() == 0){
			//データがない時は要求可
			$retdata = true;
		}else{
			$retdata = false;
		}
		$table_access->free();

		// DB接続の切断
		$this->disconnectDB();

		return $retdata;
	}

   /**
    * 関数名：RSSファイル名取得
    * @引数：(I) $userId 	- ユーザID
    *        (I) $layerId 	- レイヤーID
    * @戻値：RSSファイル名	- ユーザがレイヤー管理者orまっぷ管理者の場合or一般ユーザの場合
    *      ：null			- データが存在しない場合
    *      ：false			- 異常終了
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    */
	function getRssFileNameByUser($userId, $layerId) {
		
		//レイヤーIDがない場合は
		if ($layerId == ""){
			return null;
		}

		// DBオブジェクトの生成
		$this->createDBObject();

		//レイヤーの情報を取得
		$layer_access = new LayerTableAccess($this->directryname);
		$rtn = $layer_access->selectLayerIDKeyData($this->o_db, $layerId);
		if ($rtn != true) {
			$layer_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_36"), E_USER_ERROR);
			return false;
		}
		if ($layer_access->getRecordCount() == 0){
			$layer_access->free();
			$this->disconnectDB();		
			return null;
		}
		$layerdata = $layer_access->getOneData();
		$layer_access->free();


		if ($userId == ""){
			//ユーザIDがない場合はゲスト
			if ($layerdata->getPublicLayer() == KAKIKOMAP_PUBLICLAYER_GUEST
				&& $layerdata->getStatusFlg() == KAKIKOMAP_STATUSFLG_ON) {
				$this->disconnectDB();		
				return  $layerId;
			}else{
				$this->disconnectDB();		
				return  null;				
			}
			
		}		
		
		//ユーザ種類の取得
		$user_access = new UserTableAccess($this->directryname);
		$rtn = $user_access->selectFindByKeyData($this->o_db, $userId);
		if ($rtn != true) {
			$user_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_36"), E_USER_ERROR);
			return false;
		}
		if ($user_access->getRecordCount() == 0){
			$this->disconnectDB();		
			return null;
		}
		$userdata = $user_access->getOneData();
		$user_access->free();
		

		//まっぷ管理者かレイヤー作者の場合
		if (($userdata->getUserType() == KAKIKOMAP_USERTYPE_MAP) || ($layerdata->getUserID() == $userId)){
			if ($layerdata->getStatusFlg() == KAKIKOMAP_STATUSFLG_ON) {
				$this->disconnectDB();		
				return  $layerdata->getRssFileName();
			}else{
				$this->disconnectDB();		
				return  null;				
			}
		}
		
		//一般ユーザの場合		
		$layeruser_access = new LayerUserTableAccess($this->directryname);
		$rtn = $layeruser_access->selectFindByKeyData($this->o_db, $userId, $layerId);
		if ($rtn != true) {
			$layeruser_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_36"), E_USER_ERROR);
			return false;
		}
		if ($layeruser_access->getRecordCount() == 0){
			//一般ユーザでレイヤーユーザにないときはゲスト公開であれば許す
			if ($layerdata->getPublicLayer() == KAKIKOMAP_PUBLICLAYER_GUEST
				&& $layerdata->getStatusFlg() == KAKIKOMAP_STATUSFLG_ON) {
				$this->disconnectDB();
				return  $layerId;
			}else{
				$this->disconnectDB();		
				return  null;				
			}
		}
		$layeruserdata = $layeruser_access->getOneData();
		//レイヤーユーザで許可がされていれば許す
		if ($layerdata->getPublicLayer() == KAKIKOMAP_PUBLICLAYER_GUEST
			&& $layerdata->getStatusFlg() == KAKIKOMAP_STATUSFLG_ON
			&& $layeruserdata->getStatusFlg() == KAKIKOMAP_STATUSFLG_ON) {
			$this->disconnectDB();		
			return  $layerId;
		}else{
			$this->disconnectDB();
			return  null;				
		}
		

	}

   /**
    * 関数名：マップ詳細情報取得
    * @引数：(I) $mapnumber   		- まっぷ番号
    * @戻値：マップ詳細データ /false
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function getMapDetailData($mapnumber) {
		// DBオブジェクトの生成
		$this->createDBObject();

		//レイヤーの情報を取得
		$map_access = new MapDetailTableAccess();
		$rtn = $map_access->selectFindByKeyData($this->o_db, $this->directryname, $mapnumber);
		if ($rtn != true) {
			$map_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_37"), E_USER_ERROR);
			return false;
		}
		if ($map_access->getRecordCount() == 0){
			return null;
		}
		$mapdata = $map_access->getOneData();

		$map_access->free();
		// DB接続の切断
		$this->disconnectDB();

		return $mapdata;
	}    

   /**
    * 関数名：マップ詳細情報一覧取得
    * @引数：(I) 
    * @戻値：マップ詳細データ /false
    * @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
    * @更新日/更新者：
    */
	function getMapDetailListData() {
		// DBオブジェクトの生成
		$this->createDBObject();

		// マップ詳細情報を取得
		$map_access = new MapDetailTableAccess();
		$rtn = $map_access->selectFindByKeyData($this->o_db, $this->directryname, NULL);
		if ($rtn != true) {
			$map_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_37"), E_USER_ERROR);
			return false;
		}
		if ($map_access->getRecordCount() == 0){
			return null;
		}
		$mapDataList = $map_access->getDataList();

		$map_access->free();
		// DB接続の切断
		$this->disconnectDB();

		return $mapDataList;
	}    

   /**
    * 関数名：マップ詳細情報初期表示用イメージ取得
    * @引数：(I) 
    * @戻値：マップ詳細データ /false
    * @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
    * @更新日/更新者：
    */
	function getMapDetailInitialImage() {
		// DBオブジェクトの生成
		$this->createDBObject();

		// マップ詳細情報を取得
		$map_access = new MapDetailTableAccess();
		$rtn = $map_access->selectFindBySelectInitialListData($this->o_db, $this->directryname);
		if ($rtn != true) {
			$map_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_37"), E_USER_ERROR);
			return false;
		}
		if ($map_access->getRecordCount() == 0){
			return null;
		}
		$mapdata = $map_access->getOneData();

		$map_access->free();
		// DB接続の切断
		$this->disconnectDB();

		return $mapdata;
	}    

   /**
    * 関数名：ベースマップ詳細情報外部リンク用イメージ取得
    * @引数：(I) 
    * @戻値：マップ詳細データ /false
    * @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
    * @更新日/更新者：
    */
	function getBaseMapDetailOutSideRefImage() {
		// DBオブジェクトの生成
		$this->createDBObject();

		// マップ詳細情報を取得
		$map_access = new MapDetailTableAccess();
		$rtn = $map_access->selectFindBySelectOutsideReferenceData($this->o_db, $this->directryname);
		if ($rtn != true) {
			$map_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_37"), E_USER_ERROR);
			return false;
		}
		if ($map_access->getRecordCount() == 0){
			return null;
		}
		$mapdata = $map_access->getOneData();

		$map_access->free();
		// DB接続の切断
		$this->disconnectDB();

		return $mapdata;
	}    

   /**
    * 関数名：最優先表示レイヤー情報取得
    * @引数：(I) $userId 	- ユーザID
    * @戻値：LayerTableData	- レイヤーデータ
    *      ：null			- データが存在しない場合
    *      ：false			- 異常終了
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    * @概要：ユーザごとのレイヤー表示順を考慮して最上位のレイヤーを取得します。
    */
    function getTopPriorityLayerData($userId){
		// DBオブジェクトの生成
		$this->createDBObject();
		
        // レイヤー状態フラグ
        $status_array = array(KAKIKOMAP_STATUSFLG_ON);
		
		// 最優先レイヤー情報を取得
		$table_access = new LayerTableAccess($this->directryname);
    	$rtn = $table_access->selectViewLayerPriority($this->o_db, $userId, $status_array);
 		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_38"), E_USER_ERROR);
			return false;
		}
		if ($table_access->getRecordCount() == 0){
			return null;
		}
		$layerdata = $table_access->getOneData();

		$table_access->free();
		// DB接続の切断
		$this->disconnectDB();

		return $layerdata;
    }

   /**
    * 関数名：レイヤー１データ取得
    * @引数：(I) $layerId 	- レイヤーID
    * @戻値：LayerTableData	- レイヤーデータ
    *      ：null			- データが存在しない場合
    *      ：false			- 異常終了
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    * @概要：指定のレイヤーIDからレイヤーテーブルデータを取得する。
    */
    function getLayerOneData($layerId){
		// DBオブジェクトの生成
		$this->createDBObject();

		// 最優先レイヤー情報を取得
		$table_access = new LayerTableAccess($this->directryname);
    	$rtn = $table_access->selectLayerIDKeyData($this->o_db, $layerId);
 		if ($rtn != true) {
			$table_access->free();
			$this->disconnectDB();
			trigger_error($this->o_resource->getValue("S4_001_39"), E_USER_ERROR);
			return false;
		}
		if ($table_access->getRecordCount() == 0){
			return null;
		}
		$layerdata = $table_access->getOneData();

		$table_access->free();
		// DB接続の切断
		$this->disconnectDB();

		return $layerdata;
    }

   /**
    * 関数名：マップ・マップ詳細情報取得
    * @引数：$mapnumber - マップ番号（null指定可）
    * @戻値：Map_MapDetailData	- マップ情報
    *      ：null			- データが存在しない場合
    *      ：false			- 異常終了
    * @作成日/作成者：2006/09/01 (IIS) N.Soma
    * @更新日/更新者：
    * @概要：マップテーブル・マップ詳細テーブルからディレクトリ名でデータを取得する
    */
    function getMapJoinMapDetailData($mapnumber){
		// DBオブジェクトの生成
		$this->createDBObject();
		// マップ・マップ詳細情報を取得
		$table_access = new BaseMapJoinMapDetailTableAccess();
		if (is_null($mapnumber) == true){
			$rtn = $table_access->selectMapLinkMapDetailListData($this->o_db, $this->directryname);
		}else{
			$rtn = $table_access->selectMapLinkMapDetailOneData($this->o_db, $this->directryname, $mapnumber);
		}

		if ($table_access->getRecordCount() == 0){
			return null;
		}
		if (is_null($mapnumber) == true){
			//mapnumberがないのであれば全データ
			$mapdata = $table_access->getDataList();	
		}else{
			//mapnumberが指定されていれば１データ
			$mapdata = $table_access->getOneData();
		}

		$table_access->free();
		// DB接続の切断
		$this->disconnectDB();

		return $mapdata;
    }

   /**
    * 関数名：コンテンツ名称取得
    * @戻値：MapData		- コンテンツ名称
    *      ：null			- データが存在しない場合
    *      ：false			- 異常終了
    * @作成日/作成者：2006/09/01 (IIS) J.Hashimoto
    * @更新日/更新者：
    * @概要：マップテーブルからディレクトリ名でコンテンツ名称を取得する
    */
    function getContentsName(){
		// DBオブジェクトの生成
		$this->createDBObject();
		// マップ・マップ詳細情報を取得
		$table_access = new MapTableAccess();

		$rtn = $table_access->selectDirectryNameKeyData($this->o_db, $this->directryname);

		if ($table_access->getRecordCount() == 0){
			return null;
		}

		$mapdata  = $table_access->getOneData();

		$table_access->free();
		// DB接続の切断
		$this->disconnectDB();

		return $mapdata;
    }

//#################################################################################################
//                                        以下、サービス内使用関数定義
//#################################################################################################
	/**
	 * 関数名：意味空間情報変更通知の更新処理
     * 処理詳細：引数の何れかを元に意味空間の関連テーブルを精査し意味空間の警告表示フラグを立てる
     * @引数：(I) $layerId    	- 対象レイヤーID
     *        (I) $memoTypeId   - 対象メモ種類ID
     *        (I) $memoId   	- 対象メモID     
     *        (I) $flgType		- フラグの種類(1:メモ増加フラグ、2:メモ削除変更フラグ)
     * @戻値：$bool			- true  正常終了
     *                      - false 異常終了
     * @作成日/作成者：2006/09/01 (IIS)N.Soma
     * @更新日/更新者：
	 * @注意事項：当関数は当サービス関数内からの呼び出しを前提とし、DBの接続・切断は行っていない。
	 *          ：また、トランザクションも制御していないので、必要に応じてコール元で制御すること。
     */
	function checkAndUpdateImiBaseInfo($layerId, $memoTypeId, $memoId, $flgType){

		// 意味空間基本情報テーブルアクセス
		$imibase_access = new ImiBaseInfoTableAccess($this->directryname);

		//レイヤーIDに対するチェック
		if (is_null($layerId) == false){
			// 意味空間レイヤーテーブルDBアクセス
			$imilayer_access = new ImiLayerTableAccess($this->directryname);
			$rtn = $imilayer_access->selectFindByKeyData($this->o_db, null, $layerId);
			if ($rtn != true) {
				$imilayer_access->free();
				trigger_error($this->o_resource->getValue("S4_001_34"), E_USER_ERROR);
				return false;
			}
			$imilayerlist = $imilayer_access->getDataList();
			$imispaceid_array = array();
			foreach($imilayerlist as $currentimilayer){
				array_push($imispaceid_array, $currentimilayer->getImiSpaceID());
			}
			if (count($imispaceid_array) > 0){
				//意味空間の警告表示フラグを立てる
				if ($flgType == 1){
					$rtn = $imibase_access->updateWarnFlgLump($this->o_db, $imispaceid_array, KAKIKOMAP_IMIBASE_CHANGE_ON, $flgType);					
				}elseif ($flgType == 2){
					$rtn = $imibase_access->updateWarnFlgLump($this->o_db, $imispaceid_array, KAKIKOMAP_IMIBASE_WARN_ON, $flgType);
				}
				if ($rtn != true) {
					$imibase_access->free();
					$imilayer_access->free();
					trigger_error($this->o_resource->getValue("S4_001_34"), E_USER_ERROR);
					return false;
				}
			}
			$imilayer_access->free();
		}
		
		//メモ種類IDに対するチェック
		if (is_null($memoTypeId) == false){
			// 意味空間メモ位置テーブルDBアクセス
			$imimemoposition_access = new ImiMemoPositionTableAccess($this->directryname);
			$rtn = $imimemoposition_access->selectFindDataByMemoTypeID($this->o_db, $memoTypeId);
			if ($rtn != true) {
				$imibase_access->free();
				$imimemoposition_access->free();
				trigger_error($this->o_resource->getValue("S4_001_34"), E_USER_ERROR);
				return false;
			}
			$imimemopositionlist = $imimemoposition_access->getDataList();
			$imispaceid_array = array();
			foreach($imimemopositionlist as $currentimimemoposition){
				array_push($imispaceid_array, $currentimimemoposition->getImiSpaceID());
			}
			if (count($imispaceid_array) > 0){
				//意味空間の警告表示フラグを立てる
				if ($flgType == 1){
					$rtn = $imibase_access->updateWarnFlgLump($this->o_db, $imispaceid_array, KAKIKOMAP_IMIBASE_CHANGE_ON, $flgType);					
				}elseif ($flgType == 2){
					$rtn = $imibase_access->updateWarnFlgLump($this->o_db, $imispaceid_array, KAKIKOMAP_IMIBASE_WARN_ON, $flgType);		
				}
				if ($rtn != true) {
					$imibase_access->free();
					$imimemoposition_access->free();
					trigger_error($this->o_resource->getValue("S4_001_34"), E_USER_ERROR);
					return false;
				}
			}
			$imimemoposition_access->free();
		}

		//メモIDに対するチェック
		if (is_null($memoId) == false){
			// 意味空間メモ位置テーブルDBアクセス
			$imimemoposition_access = new ImiMemoPositionTableAccess($this->directryname);
			$rtn = $imimemoposition_access->selectFindByKeyData($this->o_db, null, $memoId);
			if ($rtn != true) {
				$imibase_access->free();
				$imimemoposition_access->free();
				trigger_error($this->o_resource->getValue("S4_001_34"), E_USER_ERROR);
				return false;
			}
			$imimemopositionlist = $imimemoposition_access->getDataList();
			$imispaceid_array = array();
			foreach($imimemopositionlist as $currentimimemoposition){
				array_push($imispaceid_array, $currentimimemoposition->getImiSpaceID());
			}
			if (count($imispaceid_array) > 0){
				//意味空間の警告表示フラグを立てる
				if ($flgType == 1){
					$rtn = $imibase_access->updateWarnFlgLump($this->o_db, $imispaceid_array, KAKIKOMAP_IMIBASE_CHANGE_ON, $flgType);					
				}elseif ($flgType == 2){
					$rtn = $imibase_access->updateWarnFlgLump($this->o_db, $imispaceid_array, KAKIKOMAP_IMIBASE_WARN_ON, $flgType);
				}
				if ($rtn != true) {
					$imibase_access->free();
					$imimemoposition_access->free();
					trigger_error($this->o_resource->getValue("S4_001_34"), E_USER_ERROR);
					return false;
				}	
			}
			$imimemoposition_access->free();
		}
		$imibase_access->free();
		
		return true;	
	}
}

?>
