<?php

/**
* TreeDataController.classs.php 処理概要:TreeNodeDataデータクラス
* PHP versions：4.4.XX
* @パッケージ：XX
* @作者：(IIS)N.Soma
* @作成日/作成者：2006/09/01 (IIS)N.Soma
* @更新日/更新者：
* @バージョン：XX.XX
* @注意事項：現在、各ノードの嫡子より下の子孫についてはたどれることを保証していない。作りかえる必要あり？
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/
//データクラス
require_once("class/db/tabledata/TreeNodeData.class.php");

class TreeDataController {

    //クラス変数 
//    var $memoNodeList;		//トップに位置するメモノード
	var $allNodeList;			//全ノードの検索用リスト
	var $treeNodeKeyMap;		//メモとコメントを一体化したツリーの通し番号検索マップ
	
    /**
    * 関数名：コンストラクタ
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function TreeDataController(){
//		$this->memoNodelist = array();
		$this->allNodeList = array();
		$this->treeNodeKeyMap = array();
    }

    /**
    * 関数名：ノード生成
    * @引数：(I) $node			- ノードデータ
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
//	function createNode($treeNodeKey, $preTreeNodeKey, TreeNodeData $node){
	function createNode($node){
		$preNode = null;
		
		//全リストに追加
		array_push($this->allNodeList, $node);
		
		//通し番号検索マップへ追加
		if ($node->getNodeType() == TREE_NODE_TYPE_MEMO){
			$this->treeNodeKeyMap["m".$node->getMemoID()] = $node->treeNodeKey;
		}else{
			$this->treeNodeKeyMap["c".$node->getCommentID()] = $node->treeNodeKey;
		}

		//親ノードキーで親ノードを取得
		if (is_null($node->getHigherCommentID()) == false) {
			if ($node->getHigherCommentID() == 0){
				$preNode = $this->getNode($node->getMemoID(),null);		//親はメモ
			
			}else{
				$preNode = $this->getNode(null,$node->getHigherCommentID());//親はコメント
			}
		}

		//親ノード存在判定
		if (($preNode == null) && ($node->getNodeType() == TREE_NODE_TYPE_MEMO)){
//			array_push($this->memoNodelist, $node);
		}elseif ($preNode == null && ($node->getNodeType() == TREE_NODE_TYPE_COMMENT)){
			print "testツリーデータがおかしい";
		}else{
			//親ノードへノード追加
			$preNode->addNode($node);
		}	
	
/*		if (is_null($preNodenum) == false){
			if (($preNodenum == 0) &&  ($node->getNodeType() == TREE_NODE_TYPE_MEMO)){
				array_push($this->memoNodelist, $node);
//			  $this->memoNodeList[0];

			}elseif (($preNodenum == 0) && ($node->getNodeType() == TREE_NODE_TYPE_COMMENT)){
				print "testツリーデータがおかしい";
			}else{
				//親ノードへノード追加
				$this->allNodeList[$preNodenum -1]->addNode($node);
			}
*/			
			//ノード親子情報調整
			if (is_null($preNode) == false){
				$tmpkey = $preNode->getTreeNodeKey();
				$this->allNodeList[$tmpkey - 1]	= $preNode;	
				$tmpkey = $node->getTreeNodeKey();
				$this->allNodeList[$tmpkey - 1]	= $node;
				$count = 0;
/*
					foreach($this->memoNodeList as $curnode){	//forだと参照できなかったので

//						$b = $this->allNodeList[$preNodenum - 1]->getTreeNodeKey();
//						if ($this->memoNodeList[$i]->getTreeNodeKey() == $this->allNodeList[$preNodenum - 1]->getTreeNodeKey()){
//							$this->memoNodeList[$i] = $this->allNodeList[$preNodenum - 1];
						if ($curnode->getTreeNodeKey() == $preNode->getTreeNodeKey()){
							$this->memoNodeList[$count] = $preNode;
						}
						$count++;
					}			
*/
			}
			
			
/*			
			if ($preNodenum !=0 ){
	//			$tmpkey = $preNode->getTreeNodeKey();
	//			$this->allNodeList[$tmpkey - 1]	= $preNode;	
				$tmpkey = $node->getTreeNodeKey();
				$this->allNodeList[$tmpkey - 1]	= $node;
				$cnt = count($this->memoNodelist);
				for($i = 0; $i < $cnt; $i++){
					$aa = $this->memoNodeList[0];
					$a = $aa->getTreeNodeKey();
					$b = $this->allNodeList[$preNodenum - 1]->getTreeNodeKey();
					if ($this->memoNodeList[$i]->getTreeNodeKey() == $this->allNodeList[$preNodenum - 1]->getTreeNodeKey()){
						$this->memoNodeList[$i] = $this->allNodeList[$preNodenum - 1];
					}
				}			
			}
*/			
//		}
	}

    /**
    * 関数名：ノード取得
    * @引数：(I) $memoid    - 検索メモID
    *        (I) $commentid - 検索コメントID    
    * @戻値：ノードデータ
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function getNode($memoid, $commentid){
		$retnode = null;
		$tmpstr = null;
		if (is_null($commentid) == true){
			//メモ検索
			//ノードの通し番号取得
			$tmpstr = "m".$memoid;
		}else{
			//コメント検索
			//ノードの通し番号取得
			$tmpstr = "c".$commentid;
		} 
		$nodenum = $this->treeNodeKeyMap[$tmpstr];	
		return $this->allNodeList[$nodenum-1];
	}

    /**
    * 関数名：ノード番号取得
    * @引数：(I) $memoid    - 検索メモID
    *        (I) $commentid - 検索コメントID    
    * @戻値：ノードデータ。該当がなければnull
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function getNodeNum($memoid, $commentid){
		$retnode = null;
		$tmpstr = null;
		if (is_null($commentid) == true){
			//メモ検索
			//ノードの通し番号取得
			$tmpstr = "m".$memoid;
		}else{
			//コメント検索
			//ノードの通し番号取得
			$tmpstr = "c".$commentid;
		} 
		$nodenum = $this->treeNodeKeyMap[$tmpstr];	
		return $nodenum ;
	}
	

	//GETTER
    /**
    * 関数名：全ノードの親子検索用リスト取得
    * @引数：なし
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */	
	function getAllNodeList(){
		return $this->allNodeList;
	}
	
    /**
    * 関数名：ツリーのユニークキーと検索用リストの関連マップの取得
    * @引数：なし
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */	
	function getTreeNodeKeyMap(){
		return $this->treeNodeKeyMap;
	}
	
/*	function createMemoList(){
		foreach($this->allNodeList as $curnode){	//forだと参照できなかったので
			if ($curnode->getTreeNodeKey() == TREE_NODE_TYPE_MEMO){
//				array_push($this->memoNodelist, $curnode);		//←これでpushされるはずなのだが、うまくいかない？？？				
			}
		}
	}
*/	
}
?>
