<?php

/**
* TreeNodeData.classs.php 処理概要:TreeNodeDataデータクラス
* PHP versions：4.4.XX
* @パッケージ：XX
* @作者：(IIS)N.Soma
* @作成日/作成者：2006/09/01 (IIS)N.Soma
* @更新日/更新者：
* @バージョン：XX.XX
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/
define("TREE_NODE_TYPE_MEMO",1);//メモ
define("TREE_NODE_TYPE_COMMENT",2);//コメント

class TreeNodeData{

    //クラス変数 
    var $treeNodeKey;		//ノードのユニークキー
    var $preNode;			//親ノード
    var $childNodeList;		//子ノードのリスト
    var $childNodeList;		//子ノードのリスト
	var $nodeLevel;			//階層の深さのレベル
    
    var $nodeType;			//ノードの種類（TREE_NODE_TYPE_MEMO:メモ、TREE_NODE_TYPE_COMMENT:コメント）
    var $title;				//ノードのタイトル（メモタイトルorコメントタイトル）
    var $userName;
    var $addDatetime;
    var $memoTypeID;
    var $memoID;
    var $ribboncolor;		//（ノードがメモのときだけ設定）
    var $iconType;			
    var $icon;				
    var $commentID;			//（ノードがコメントのときだけ設定）
	var $higherCommentID;	// (ノードがコメントのときだけ設定)
	var $authorityMemoType;	
	

    /**
    * 関数名：コンストラクタ
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function TreeNodeData(){
        $this->treeNodeKey = 0;
        $this->preNode = null;
        $this->childNodeList = array();
        $this->nodeLevel = 0;
        
        $this->nodeType = null;
        $this->title = null;
        $this->userName = null;
        $this->addDatetime = null;
        $this->memoTypeID = null;
        $this->memoID = null;
        $this->ribboncolor = null;
        $this->iconType = null;
        $this->icon = null;
        $this->commentID = null;
        $this->higherCommentID = null;
        $this->authorityMemoType = null;
    }

    /**
    * 関数名：子ノード追加
    * @引数：(I) $node    - ツリーのユニークキー
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
	function addNode(&$node){
//	function addNode($node){
		//現在のノードを親ノードへ
		$node->setPreNode($this);
		//子ノードを設定
		array_push($this->childNodeList, $node);
	}


    //SETTER
    /**
    * 関数名：ツリーのユニークキー設定
    * @引数：(I) $treeNodeKey    - ツリーのユニークキー
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function setTreeNodeKey($treeNodeKey){
        $this->treeNodeKey = $treeNodeKey;
    }

    /**
    * 関数名：親ノード設定
    * @引数：(I) $preNode    - 親ノード
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function setPreNode($preNode){
        $this->preNode = $preNode;
    }

    /**
    * 関数名：子ノードのリスト設定
    * @引数：(I) $childNodeList    - 子ノードのリスト
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function setChildNodeList($childNodeList){
        $this->childNodeList = $childNodeList;
    }
    
    /**
    * 関数名：ノードの深さレベル設定
    * @引数：(I) $nodeLevel    - 深さのレベル
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function setNodeLevel($nodeLevel){
        $this->nodeLevel = $nodeLevel;
    }   

    /**
    * 関数名：ノードの種類設定
    * @引数：(I) $nodeType    - ノードの種類
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function setNodeType($nodeType){
        $this->nodeType = $nodeType;
    }

    /**
    * 関数名：ノードのタイトル設定
    * @引数：(I) $title    - ノードのタイトル
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function setTitle($title){
        $this->title = $title;
    }

    /**
    * 関数名：ユーザ名設定
    * @引数：(I) $user名    - ユーザ名
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function setUserName($userName){
        $this->userName = $userName;
    }

    /**
    * 関数名：登録日時設定
    * @引数：(I) $addDatetime    - 登録日時
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function setAddDatetime($addDatetime){
        $this->addDatetime = $addDatetime;
    }

    /**
    * 関数名：メモ種類ID設定
    * @引数：(I) $memoTypeID    - メモ種類ID
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function setMemoTypeID($memoTypeID){
        $this->memoTypeID = $memoTypeID;
    }

    /**
    * 関数名：メモID設定
    * @引数：(I) $memoID    - メモID
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function setMemoID($memoID){
        $this->memoID = $memoID;
    }

    /**
    * 関数名：リボン色設定
    * @引数：(I) $ribboncolor    - リボン色
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function setRibboncolor($ribboncolor){
        $this->ribboncolor = $ribboncolor;
    }

    /**
    * 関数名：アイコンタイプ設定
    * @引数：(I) $iconType    - アイコンタイプ
    * @作成日/作成者：2006/09/01 (IIS)S.Komukai
    * @更新日/更新者：
    */
    function setIconType($iconType){
        $this->iconType = $iconType;
    }

    /**
    * 関数名：アイコン設定
    * @引数：(I) $icon    - アイコン
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function setIcon($icon){
        $this->icon = $icon;
    }

    /**
    * 関数名：コメントID設定
    * @引数：(I) $commentID    - コメントID
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function setCommentID($commentID){
        $this->commentID = $commentID;
    }

    /**
    * 関数名：親コメントID設定
    * @引数：(I) $commentID    - コメントID
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function setHigherCommentID($higherCommentID){
        $this->higherCommentID = $higherCommentID;
    }

    /**
    * 関数名：メモ種類権限区分設定
    * @引数：(I) $autorityMemoType    - コメントID
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function setAuthorityMemoType($authorityMemoType){
        $this->authorityMemoType = $authorityMemoType;
    }


    //GETTER
    /**
    * 関数名：ツリーのユニークキー取得
    * @引数：なし
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function getTreeNodeKey(){
        return $this->treeNodeKey;
    }

    /**
    * 関数名：親ノード取得
    * @引数：なし
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function getPreNode(){
        return $this->preNode;
    }

    /**
    * 関数名：子ノードのリスト取得
    * @引数：なし
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function getChildNodeList(){
        return $this->childNodeList;
    }
    
    /**
    * 関数名：ノードの深さレベル取得
    * @引数：なし
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function getNodeLevel(){
        return $this->nodeLevel;
    }

    /**
    * 関数名：ノードの種類取得
    * @引数：なし
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function getNodeType(){
        return $this->nodeType;
    }

    /**
    * 関数名：ノードのタイトル取得
    * @引数：なし
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function getTitle(){
        return $this->title;
    }

    /**
    * 関数名：ユーザ名取得
    * @引数：なし
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function getUserName(){
        return $this->userName;
    }

    /**
    * 関数名：登録日時取得
    * @引数：なし
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function getAddDatetime(){
        return $this->addDatetime;
    }

    /**
    * 関数名：メモ種類ID取得
    * @引数：なし
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function getMemoTypeID(){
        return $this->memoTypeID;
    }

    /**
    * 関数名：メモID取得
    * @引数：なし
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function getMemoID(){
        return $this->memoID;
    }

    /**
    * 関数名：リボン色取得
    * @引数：なし
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function getRibboncolor(){
        return $this->ribboncolor;
    }

    /**
    * 関数名：アイコンタイプ取得
    * @引数：なし
    * @作成日/作成者：2006/09/01 (IIS)S.Komukai
    * @更新日/更新者：
    */
    function getIconType(){
        return $this->iconType;
    }

    /**
    * 関数名：アイコン取得
    * @引数：なし
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function getIcon(){
        return $this->icon;
    }

    /**
    * 関数名：コメントID取得
    * @引数：なし
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function getCommentID(){
        return $this->commentID;
    }

    /**
    * 関数名：親コメントID取得
    * @引数：なし
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function getHigherCommentID(){
        return $this->higherCommentID;
    }
    
    /**
    * 関数名：メモ種類権限区分取得
    * @引数：なし
    * @作成日/作成者：2006/09/01 (IIS)N.Soma
    * @更新日/更新者：
    */
    function getAuthorityMemoType(){
        return $this->authorityMemoType;
    }


}
?>
