<?php

require_once("Mail.php");
require_once("Mail/mimeDecode.php");
require_once("Mail/mime.php");
//require_once("Config.php");
//require_once("function/KakikoLog.php");
require_once("kakikomap/require/common/mailsettingRead.php");

//クラス定数
define("KakikoMail_CHARCODE", "ISO-2022-JP");	// 文字変換コード　JIS7


/**
* KakikoMail.class.php 処理概要：メール処理クラス
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)N.Soma
* @作成日/作成者：2006/09/01 (IIS)N.Soma
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/
class KakikoMail{

	//インスタンス変数
	var $mailMode;
	var $toAddress;
	var $toName;
	var $fromAddress;
	var $fromName;
	var $subject;
	var $replyTo;
	var $message;
	var $sender;
	var $mailOptions;
	var $sendmail_options;
	var $smtp_options;
	var $attachment;
	var $mailObject;
	var $headers;
	var $build_param;
	
    /**
	* 関数名：コンストラクタ
	* @作成日/作成者：2006/09/01 N.Soma
    */
	function KakikoMail(){
		$this->smtp_options = array(
			'host'     => SMTPHOST,	//ホスト名
			'port'     => SMTPPORT,					//ポート
			'auth'     => SMTPAUTH,					//認証必要
			'username' => SMTPUSERNAME,			//ユーザ名
			'password' => SMTPUSERPASS,			//パスワード
			'localhost' => 'localhost'			
			);

		$this->sendmail_options = array(
			'sendmail_path' => SENDMAILPATH,		//システム上のsendmailのパス
			'sendmail_args' => SENDMAILARGS		//sendmailへ渡す追加パラメータ
		);
		$this->headers = array();

	}
	
    /**
	* 関数名：メール作成
	* @引数： (I)   items - array メールの設定内容（連想配列で以下の通り指定する）
	*                   'ToAddress'   : 送信先アドレス
	*                   'ToName'      : 送信先名称
	*                   'FromAddress' : 送信元アドレス
	*                   'FromName'    : 送信元名称
	*                   'ReplyTo'     : 返信先アドレス
	*                   'Subject'     : 件名
	*                   'Message'     : 本文
	*                   'Attachment'  : 添付ファイルパス
	* @注意：日本語で指定する内容は、このクラス内でメール用にエンコードします。
	* @作成日/作成者：2006/09/01 N.Soma
    */
	function createMail($items){
		//引数を設定し、メールのヘッダ情報を組み立てる
		if ($items["ToName"] != null){
			$this->setToName($items["ToName"]);
		}
		if ($items["ToAddress"] != null){
			$this->setToAddress($items["ToAddress"]);
			$this->headers["To"] = "\"".$this->toName."\"<" .$this->toAddress .">";
			$this->headers["Sender"] = $this->sender;
		}
		if ($items["FromName"] != null){
			$this->setFromName($items["FromName"]);
		}
		if ($items["FromAddress"] != null){
			$this->setFromAddress($items["FromAddress"]);
			$this->headers["From"] = "\"".$this->fromName ."\"<" .$this->fromAddress .">";
		}
		if ($items["ReplyTo"] != null){
			$this->setReplyTo($items["ReplyTo"]);
			$this->headers["Reply-To"] = $this->replyTo;
		}
		if ($items["Subject"] != null){
			$this->setSubject($items["Subject"]);
			$this->headers["Subject"] = $this->subject;
		}
		if ($items["Message"] != null){
			$this->setMessage($items["Message"]);
		}
		if ($items["Attachment"] != null){
			$this->setAttachment($items["Attachment"]);
		}

		$this->headers["Content-Type"] = "text/plain; charset=\"ISO-2022-JP\"";
		$this->headers["Content-Transfer-Encoding"] = "7bit";

		return ;
	}



    /**
	* 関数名：メール送信
	* @引数： (I) mode   - int 送信に使用する方法（"mail":PHPのmail関数、"sendmail":sendmail、"smtp":SMTP）
	* @戻値： true:送信成功
	*         PEAR_Errorオブジェクト:送信失敗
	* @作成日/作成者：2006/09/01 N.Soma
    */
	function sendEmail($mode){
		if ($mode == "phpmail"){
				$this->mailMode = "mail";
			
		}elseif ($mode == "sendmail"){
				$this->mailMode = "sendmail";
				$this->mailOptions = $this->sendmail_options;
		}elseif ($mode == "smtp"){
				$this->mailMode = "smtp";
				$this->mailOptions = $this->smtp_options;		
		}else{
			return FALSE;
		}

	
		$mime = & new Mail_mime("\n");
		$mime->setTXTBody($this->message);
		$mime->addAttachment($this->attachment);
		
		$body = $mime->get($this->build_param);
		
		//メール送信準備
		$ret = $this->mailObject =& Mail::factory($this->mailMode, $this->mailOptions );
		if (PEAR::isError($ret)){
			return $ret;
		}
		//日付情報設定(送信直前に設定)
		$this->headers["Date"] = date("r");
		//送信
		$ret = $this->mailObject->send($this->headers["To"], $this->headers, $body);
		return $ret;
	}

	
    /**
	* 関数名：送信先アドレス設定
	* @引数： (I) toAddress   - string 送信先メールアドレス(複数の場合はカンマ区切りで指定)
	* @作成日/作成者：2006/09/01 N.Soma
    */
	function setToAddress($toAddress){
		$this->toAddress = $toAddress;
		$this->sender = $toAddress;
	}

    /**
	* 関数名：送信先名称設定
	* 処理詳細：JISコードに変換して設定
    */	
	function setToName($toName){
		$this->toName = mb_encode_mimeheader(mb_convert_encoding($toName, "JIS", "auto"), KakikoMail_CHARCODE);
	}
	
    /**
	* 関数名：送信元アドレス設定
    */	
	function setFromAddress($fromAddress){
		$this->fromAddress = $fromAddress;
	}

    /**
	* 関数名：送信元名称設定
	* 処理詳細：JISコードに変換して設定
    */	
	function setFromName($fromName){
		$this->fromName = mb_encode_mimeheader(mb_convert_encoding($fromName, "JIS", "auto"), KakikoMail_CHARCODE);
	}

    /**
	* 関数名：メール件名設定
	* 処理詳細：JISコードに変換して設定
    */	
	function setSubject($subject){
		$this->subject = mb_encode_mimeheader(mb_convert_encoding($subject, "JIS", "auto"), KakikoMail_CHARCODE);
	}

    /**
	* 関数名：返信先アドレス設定
    */	
	function setReplyTo($replyTo){
		$this->replyTo = $replyTo;
	}
	
	/**
	* 関数名：本文設定
	* 処理詳細：JISコードに変換して設定
    */	
	function setMessage($message){
		$this->message =mb_convert_encoding($message, "JIS", "auto");
	}
	
    /*
	* 関数名：送信元送信元アドレス(Vodafone用)設定
	function setSender($sender){
		$this->sender = $sender;
	}
    */	

    /**
	* 関数名：添付ファイル設定
	* @引数： (I) toAddress   - string 添付ファイルのパス	
    */	
	function setAttachment($attachment){
		$this->attachment = $attachment;
	}
}

?>
