<?php
/**
* ReadResource.class.php リソース読み込みクラス
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
* 
* @メソッド一覧
*   ReadResource()
* 	getValue()
* 
* @使用方法
*   $o_resource = new ReadResource(0);
*                または
*   $o_resource = new ReadResource(1, "tokyo");
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 
require_once("Config.php");
require_once("function/KakikoLog.php");
//define("USERTABLE_USERTYPE_LAYER",                         "2");    

define("RESOURCE_ADMIN",                         "1");
define("RESOURCE_CONTENTS",                      "2");
define("RESOURCE_SYSTEM",                        "3");

class ReadResource {

	// resource xml
	var $xml;
	

	/**
	* 関数概要：コンストラクタ
	* 処理詳細：[include_path]\[リソースファイル]を検索し保持します
	*
	* @引数： (I) $type - int リソースタイプ
	*                 [0：管理者画面用, 1：各コンテンツ用,  2：システム用]
	*	   ： (I) $dir  - string ディレクトリ名(各コンテンツ用リソース使用の場合のみ指定)
	* @戻値： なし
	* @作成日/作成者：2006/09/01 (IIS)S.Komukai
	* @更新日/更新者：
	* @更新内容：
	*/	 
    function ReadResource($type, $dir="") {
		global $LOG;
		
		$fileName = "";
		switch ($type){
			case RESOURCE_ADMIN :
				$fileName = "admin.xml";
				break;
			case RESOURCE_CONTENTS :
				$fileName = "contents".DIRECTORY_SEPARATOR.$dir.".xml";
				break;
			case RESOURCE_SYSTEM :
				$fileName = "system.xml";
				break;
			default :
				$LOG->crit("This file type is not supported");
				trigger_error("This file type is not supported", E_USER_ERROR);
		} 

		$dirs = split(PATH_SEPARATOR, ini_get('include_path')); 
		foreach ($dirs as $dirpath) {
			$fullPath = $dirpath.DIRECTORY_SEPARATOR."kakikomap".DIRECTORY_SEPARATOR.
										"resource".DIRECTORY_SEPARATOR.$fileName;
			if(is_file($fullPath)){
				$config = new Config();
				$this->xml = $config->parseConfig($fullPath, "xml", array("encoding"=>"UTF-8"));
				break;
			}
		}

		// failed to open		
		if(isset($this->xml) == FALSE){
			$LOG->crit("failed to open the resource file");
			trigger_error("failed to open the resource file", E_USER_ERROR);
		}
    }
    
	/**
	* 関数概要：リソース値取得
	* 処理詳細：resource.xml からリソース値を取得します。
	*
	* @引数： (I) $key - string リソースキー
	* @戻値： string リソース値（キーに一致しない場合はnull）
	* @作成日/作成者：2006/09/01 (IIS)S.Komukai
	* @更新日/更新者：
	* @更新内容：
	*/	 
    function getValue($key){

		$value = null;

		$data =& $this->xml->searchPath(array('resource',
                                  array('data', array('key' => $key))));
		if ($data == false) {
			$value = "";
		} else {
			$value = $data->getAttribute('value');
		}

    	return $value;
    }
}
?>