<?php
/**
* common.php 処理概要：システム共通関数定義
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @バージョン：1.0.0
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

/**
* 関数概要：バイト変換関数
* 処理詳細：省略形の値をバイト変換する(例：2M⇒2097152)
*
* @引数： (I) val - string サイズ
* @戻値： integer  : バイトサイズ
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function return_bytes($val) {
    $val = trim($val);
    $last = strtolower($val{strlen($val)-1});
    switch($last) {
        case 'g':
            $val *= 1024;
        case 'm':
            $val *= 1024;
        case 'k':
            $val *= 1024;
    }
    return $val;
}

/**
* 関数概要：座標変換処理
* 処理詳細：【左下・中心座標】⇔【左下・右上座標】変換
* ※画面入力は左下・中心座標、DB登録時は左下・右上座標に変換するため
*
* @引数： (I) mode - integer 変換モード(0:【左下・中心】⇒【左下・右上】、1:【左下・右上】⇒【左下・中心】)
*      ： (I) x1   - float   x座標1
*      ： (I) y1   - float   y座標1
*      ： (I) x2   - float   x座標2
*      ： (I) y2   - float   y座標2
* @戻値： array
*      ： (O) x1   - float   x座標1
*      ： (O) y1   - float   y座標1
*      ： (O) x2   - float   x座標2
*      ： (O) y2   - float   y座標2
*      ： boolean  - true(正常) false(異常)
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getCoordinates($mode, $x1, $y1, $x2, $y2){
    $ret = array(0,0,0,0);
    if ($mode == 0) {
        // ----------------------------------
        // [左下・中心]→[左下・右上] 変換
        // ----------------------------------
        // 座標の評価
        if ($x1 >= $x2) { return false; }
        if ($y1 >= $y2) { return false; }
        $ret[0] = $x1;
        $ret[1] = $y1;
        $ret[2] = $x1 + (($x2 - $x1) * 2);
        $ret[3] = $y1 + (($y2 - $y1) * 2);
    } elseif ($mode == 1) {
        // ----------------------------------
        // [左下・右上]→[左下・中心] 変換
        // ----------------------------------
        // 座標の評価
        if ($x1 >= $x2) { return false; }
        if ($y1 >= $y2) { return false; }
        $ret[0] = $x1;
        $ret[1] = $y1;
        $ret[2] = $x1 + ($x2 - $x1) / 2;
        $ret[3] = $y1 + ($y2 - $y1) / 2;
    } else {
        // モード指定異常
        return false;
    }
    return $ret;
}

/**
* 関数概要：プロトコル取得関数
* 処理詳細：プロトコルを取得する（http／https）
*
* @引数：
* @戻値： String  : http／https
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容：
*/
function getProtocol(){
  if(isset($_SERVER['HTTPS'])){
    return "https://";
  }else{
    return "http://";
  }
}
/**
* 関数概要：日付検索条件変換処理
* 処理詳細：検索用の日付を変換する
*
* @引数： (I) $date	- string  検索指定日付
* @戻値： 検索日付（null:検索キーなし, false:不正な日付, string:検索日付(yyyy-mm-dd)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function convertSearchDate($date) {
	
	$dateArray = explode("-", $date);
	
	// 日付は「YYYY」「YYYYMM」指定を許可。それぞれ「YYYY0101」「YYYYMM01」で検索
	// 不正な日付が設定された場合は検索失敗としデータを返さない。
	if($dateArray[0] != "" || $dateArray[1] != "" ||  $dateArray[2] != ""){
		if($dateArray[0] != "" && $dateArray[1] != "" && $dateArray[2] != ""){
		}else if($dateArray[0] != "" && $dateArray[1] == "" && $dateArray[2] == ""){
			// 年のみ指定の場合
			$dateArray[1] = "01";
			$dateArray[2] = "01";
		}else if($dateArray[0] != "" && $dateArray[1] != "" && $dateArray[2] == ""){
			// 年、月を指定の場合
			$dateArray[2] = "01";
		}else{
			// それ以外は不正
			return false;
		}
		
		// 日付の整合性チェック
		if(checkdate($dateArray[1], $dateArray[2], $dateArray[0]) == true){
			return $dateArray[0]."-".$dateArray[1]."-".$dateArray[2];
		}else{
			print("");
			return false;
		}
	}
	
	return null;

}
?>
