<?php
/**
* KakikoErrorHandler.php 処理概要：エラートラップ処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
* @使用方法：
*    ・「require_once("function/KakikoErrorHandler.php");」を追加
*    ・任意にエラーを発生させる場合は、「trigger_error」にてエラーを生成
*    　　　例) trigger_error("データベース更新エラー", E_USER_ERROR);
*
* Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.       
* You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese). 
*/ 

require_once("function/KakikoLog.php");
require_once("class/common/KakikoSmarty.class.php");

// エラー出力レベルを設定
error_reporting(0);

/**
* 関数概要：エラーハンドラ関数
* 処理詳細：エラートラップ時の処理
*
* @引数： $errno	:エラーレベル値
*         $errstr	:エラーメッセージ文字列
*         $errfile	:エラー発生ファイル名
*         $errline	:エラー発生行番号
* @戻値： なし
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
// エラーハンドラ関数
function myErrorHandler($errno, $errstr, $errfile, $errline){

    global $LOG;
    $errorPage = FALSE;
    $subMsg1 = "";
    $subMsg2 = "";
    $subMsg3 = "";
    $keyword = "_userid";
    $userid  = "non";
    $dirname = "non";
    
    foreach ($_SESSION as $key=>$value) {
        $col = strpos($key, $keyword);
        if (!is_array($value) && $col !== false) {
            $userid = $value;
            if ($col > 0) {
                $dirname = substr($key, 0, strlen($key) - strlen($keyword));
            } else {
                $dirname = "admin";
            }
        }
    }

    switch ($errno) {

        case E_ERROR :
        case E_CORE_ERROR :
        case E_USER_ERROR :
            $subMsg1 = "ERROR: [$errno] $errstr";
            $subMsg2 = "  Fatal error in line ".$errline." of file ".$errfile;
            $subMsg3 = ", PHP ".PHP_VERSION." (".PHP_OS.")";
            $errorPage = TRUE;
            $LOG->err("[$dirname][$userid] [$errno] $errstr\n  Fatal error in line $errline of file $errfile");
            break;

        case E_WARNING :
        case E_CORE_WARNING :
        case E_USER_WARNING :
            $subMsg1 = "WARNING: [$errno] $errstr";
            $subMsg2 = "  Fatal error in line ".$errline." of file ".$errfile;
            $subMsg3 = ", PHP ".PHP_VERSION." (".PHP_OS.")";
            $errorPage = TRUE;
            $LOG->warning("[$dirname][$userid] [$errno] $errstr\n  Fatal error in line $errline of file $errfile");
            break;

        case E_NOTICE :
        case E_CORE_NOTICE :
        case E_USER_NOTICE :
            $subMsg1 = "NOTICE: [$errno] $errstr";
            $subMsg2 = "  Fatal error in line ".$errline." of file ".$errfile;
            $subMsg3 = ", PHP ".PHP_VERSION." (".PHP_OS.")";
            $errorPage = FALSE;
            //$LOG->notice("[$dirname][$userid] [$errno] $errstr\n  Fatal error in line $errline of file $errfile");
            break;

        default:
            $subMsg1 = "Unkown error type: [$errno] $errstr";
            $subMsg2 = "  Fatal error in line ".$errline." of file ".$errfile;
            $subMsg3 = ", PHP ".PHP_VERSION." (".PHP_OS.")";
            $errorPage = FALSE;
            //$LOG->info("[$dirname][$userid] [$errno] $errstr\n  Fatal error in line $errline of file $errfile");
            break;

    }

    if ($errorPage == TRUE) {
        // smarty インスタンス化
        $o_smarty = new KakikoSmarty();
        
        $o_smarty->assign("title", "エラーページ");
        $o_smarty->assign("main1", "エラーが発生した為、処理を続行できませんでした。");
        $o_smarty->assign("main2", "もう一度最初から処理を行ってください。");
        $o_smarty->assign("sub1", $subMsg1);
        $o_smarty->assign("sub2", $subMsg2);
        $o_smarty->assign("sub3", $subMsg3);
        $o_smarty->display("KakikoErrorHandler.tpl");
        exit(-1);
    }

}

// エラーハンドラを設定
$old_error_handler = set_error_handler("myErrorHandler");

?>
