
class Wiki::TableLineParser

rule
	table_line : columns  { result = TableRow.new(val) }

	columns : columns column { result << val[1] }
		| { result = [] }

	column : ',' text { result = TableColumn.new(val[1]) }
		| ',' { result = TableColumn.new(Text.new('')) }

	text : COLUMN_TEXT { result = @line_parser.parse(val[0]) }

end


---- header
require 'DocumentModel.rb'
require 'InLineParser.rb'

---- inner
def parse(line)
	@yydebug = true;
	@tokens = []
	@line_parser = InLineParser.new();
	@status = :CSV # :CSV or :STRING

	while line and line.length > 0 do
		case @status
		when :STRING then
			case line

			# '""'
			when /\A""/ then
				push_text('"')

			# '"'
			when /\A"/ then
				@status = :CSV

			# text
			when /\A./ then
				push_text($&)
			else
				puts "else : #{__LINE__} #{line}" 
				p line
			end
			line = $'

		when :CSV then
			case line

			# '""'
			when /\A""/ then
				push_text('"')

			# '"'
			when /\A"/ then
				@status = :STRING

			# ','
			when /\A,/ then
				@tokens.push([$&, $&])

			# text
			when /\A./ then
				push_text($&)
			else
				puts "else : " + line
				p line
			end
			line = $'
			
		else
			abort
		end
	end
	@tokens.push [false, '$']

#	@tokens.each(){ |token| p token}
	do_parse()
end

def push_text(str)
	if @tokens.last() and @tokens.last()[0] == :COLUMN_TEXT then
		@tokens.last()[1] += str
	else
		@tokens.push([:COLUMN_TEXT, str])
	end
end

def next_token()
	@tokens.shift
end


---- footer
if $0 == __FILE__ then
	require 'ToHtml.rb'
	begin
		parser = Wiki::TableLineParser.new
		text = ARGF.each_line(){ |line|
			line.chomp!
			result =  parser.parse(line);
			puts "result : #{result.inspect} "
			formatter = Wiki::ToHtml.new()
			Wiki::Page.new(Wiki::Table.new(result)).accept(formatter);
		}
	rescue Racc::ParseError
		p $!
	end
end

