#!/usr/bin/env ruby

$: << "../src"

require 'PStorePageDataSource.rb'
require 'FilePageDataSource.rb'

require 'getopts'

def create_data_source(type, data_dir)
	data_source = nil
	case type
	when "PStorePageDataSource", "PStore", "pstore" then
		data_source = Wiki::PStorePageDataSource.new(data_dir)
	when "FilePageDataSource", "File", "file" then
		data_source = Wiki::FilePageDataSource.new(data_dir)
	end
	return data_source;
end

if $0 == __FILE__ then
	getopts(nil, "from:", "to:") 

	if $OPT_from == nil or $OPT_to == nil or ARGV.length < 2 then
		puts "Usage : #{$0} <options> <from_dir> <to_dir>"
		puts "\t--from <from_type>"
		puts "\t--to <to_type>"
		exit
	end

	input_data_source = create_data_source($OPT_from, ARGV[0])
	output_data_source = create_data_source($OPT_to, ARGV[1])

	output_data_source.site_property(){ |out|
		input_data_source.site_property(){ |in|
			in.each() { |key, value|
				out[key] = value
			}
		}
	}
	input_data_source.page_list().each(){ |page_name|
		source = input_data_source.load_page_source(page_name);
		output_data_source.sage_page_source(page_name, source);
		properties.cache_time = Time.at(0)
		output_data_source.page_property(page_name){ |out|
			input_data_source.page_property(page_name){ |in|
				in.each() { |key, value|
					out[key] = value
				}
				out['cache_time'] = Time.at(0)
			}
		}

	}
end

