#!/usr/bin/env ruby
#
# wiki text compiler
# .txt -> .dat converter
# read wiki format text file, and ouput DOM Tree.
#

$: << "../src"

require 'WikiPageParser.rb'

if $0 == __FILE__ then
	begin
		wiki_file = ARGV[0]
		wiki_file =~ /.*(\.\w+)/
		suffix = $1
		dat_file = wiki_file.sub(/#{suffix}$/, '.dat')

		doc = nil
		parser = Wiki::PageParser.new
		File.open(wiki_file, "r"){ |input|
			doc =  parser.parse(input);
		}
		File.open(dat_file, "w"){ |output|
			Marshal.dump(doc, output)
		}
	rescue Racc::ParseError
		p $!
	rescue 
		p $!
	end
end

