#!/bin/sh

CONFFILE="/etc/apache2/conf.d/trac.conf"

echo "LoadModule python_module modules/mod_python.so" > $CONFFILE

echo "<Location \"/trac\">" >> $CONFFILE
echo "  SetHandler mod_python" >> $CONFFILE
echo "  PythonHandler trac.web.modpython_frontend" >> $CONFFILE
echo "  PythonOption TracEnvParentDir \"/tmp/projects/trac\"" >> $CONFFILE
echo "  PythonOption TracUriRoot /trac" >> $CONFFILE
echo "  SetEnv PYTHON_EGG_CACHE /tmp/tractmp" >> $CONFFILE
echo "  AuthType Digest" >> $CONFFILE
echo "  AuthName trac" >> $CONFFILE
echo "  AuthUserFile /tmp/projects/trac.htdigest" >> $CONFFILE
echo "  Require valid-user" >> $CONFFILE
echo "</Location>" >> $CONFFILE

echo "<Location \"/svn\">" >> $CONFFILE
echo "  DAV svn" >> $CONFFILE
echo "  SVNParentPath \"/tmp/projects/svn\"" >> $CONFFILE
echo "  SVNListParentPath on" >> $CONFFILE
echo "  AuthType Digest" >> $CONFFILE
echo "  AuthName trac" >> $CONFFILE
echo "  AuthUserFile /tmp/projects/trac.htdigest" >> $CONFFILE
echo "  Require valid-user" >> $CONFFILE
echo "</Location>" >> $CONFFILE

echo "<Location /hudson>" >> $CONFFILE
echo "  Order allow,deny" >> $CONFFILE
echo "  Allow from all" >> $CONFFILE
echo "  # $B!JN,!'$3$3$KG'>Z$N=hM}$rF~$l$k!K(B" >> $CONFFILE
echo "  # Hudson$B$N(BhttpPort$B$rM-8z$K$7$F$$$k$H$-$O$3$l$r;H$&(B" >> $CONFFILE
echo "  ProxyPass        http://127.0.0.1:8080/hudson" >> $CONFFILE
echo "  ProxyPassReverse http://127.0.0.1:8080/hudson" >> $CONFFILE
echo "</Location>" >> $CONFFILE
