#!/bin/sh
# $1 is install directory ex. /tmp/projects
INSTALLPATH=$1
SHARED_TRACINI="$INSTALLPATH/trac/trac.ini"
SHARED_TRACINI_TMP="$INSTALLPATH/trac/trac.ini.tmp"

#共有iniファイルを作成
echo "[components]" > $SHARED_TRACINI

#Python のエンコーディングを変更
SIET_CUSTOMIZE=/usr/lib/python2.4/site-packages/sitecustomize.py
echo "import sys" >> $SIET_CUSTOMIZE
echo "sys.setdefaultencoding(\"utf-8\")" >> $SIET_CUSTOMIZE


#Ini Admin Plugin
svn co http://trac-hacks.org/svn/iniadminplugin/0.11/ ./iniadminplugin_0.11
cd ./iniadminplugin_0.11
python setup.py build
python setup.py install
cd ../

sed -e "/\[components\]/a iniadmin.iniadmin.iniadminplugin = enabled" $SHARED_TRACINI > $SHARED_TRACINI_TMP
mv $SHARED_TRACINI_TMP $SHARED_TRACINI


#Hudson Trac Plus Plugin
svn co http://svn.sourceforge.jp/svnroot/shibuya-trac/plugins/hudsontracplus/0.11 ./hudsontracplus_0.11
cd ./hudsontracplus_0.11
python setup.py build
python setup.py install
cd ../

sed -e "/\[components\]/a hudsontracplus.* = enabled" $SHARED_TRACINI > $SHARED_TRACINI_TMP
mv $SHARED_TRACINI_TMP $SHARED_TRACINI

echo "[hudsonplus]" >> $SHARED_TRACINI
echo "hudson_url=http://localhost/hudson" >> $SHARED_TRACINI
echo "main_page=http://localhost/hudson" >> $SHARED_TRACINI
echo "display_in_new_tab=true" >> $SHARED_TRACINI


#Gantt Calendar Plugin
svn co http://svn.sourceforge.jp/svnroot/shibuya-trac/plugins/ganttcalendarplugin/trunk/ ./ganttcalendarplugin

cd ./ganttcalendarplugin
python setup.py build
python setup.py install
cd ../

sed -e "/\[components\]/a ganttcalendar.ticketgantt.* = enabled" $SHARED_TRACINI > $SHARED_TRACINI_TMP
mv $SHARED_TRACINI_TMP $SHARED_TRACINI

sed -e "/\[components\]/a ganttcalendar.ticketcalendar.* = enabled" $SHARED_TRACINI > $SHARED_TRACINI_TMP
mv $SHARED_TRACINI_TMP $SHARED_TRACINI

echo "[ticket-custom]" >> $SHARED_TRACINI
echo "due_assign = text" >> $SHARED_TRACINI
echo "due_assign.label = 開始日" >> $SHARED_TRACINI
echo "due_assign.order = 1" >> $SHARED_TRACINI
echo "due_close= text" >> $SHARED_TRACINI
echo "due_close.label = 終了日" >> $SHARED_TRACINI
echo "due_close.order = 2" >> $SHARED_TRACINI
echo "complete= text" >> $SHARED_TRACINI
echo "complete.label = 進捗率(%)" >> $SHARED_TRACINI
echo "complete.order = 3" >> $SHARED_TRACINI


#Decorator Plugin
svn co http://svn.sourceforge.jp/svnroot/shibuya-trac/plugins/decoratorplugin/trunk ./decoratorplugin
cd ./decoratorplugin
python setup.py build
python setup.py install
cd ../

sed -e "/\[components\]/a decorator.decorator.decoratormodule = enabled" $SHARED_TRACINI > $SHARED_TRACINI_TMP
mv $SHARED_TRACINI_TMP $SHARED_TRACINI


#Account Manager Plugin
svn co http://trac-hacks.org/svn/accountmanagerplugin/trunk ./accountmanagerplugin
cd ./accountmanagerplugin
python setup.py build
python setup.py install
cd ../

sed -e "/\[components\]/a acct_mgr.admin.AccountManagerAdminPage = disabled" $SHARED_TRACINI > $SHARED_TRACINI_TMP
mv $SHARED_TRACINI_TMP $SHARED_TRACINI

sed -e "/\[components\]/a acct_mgr.* = enabled" $SHARED_TRACINI > $SHARED_TRACINI_TMP
mv $SHARED_TRACINI_TMP $SHARED_TRACINI

echo "[account-manager]" >> $SHARED_TRACINI
echo "password_store = HtDigestStore" >> $SHARED_TRACINI
echo "password_format = htdigest" >> $SHARED_TRACINI
echo "password_file = $INSTALLPATH/trac.htdigest" >> $SHARED_TRACINI
echo "htdigest_realm = trac" >> $SHARED_TRACINI


#User Manager Plugin
svn co http://trac-hacks.org/svn/usermanagerplugin/0.11 ./usermanagerplugin
cd ./usermanagerplugin
python setup.py build
python setup.py install
cd ../

sed -e "/\[components\]/a tracusermanager.* = enabled" $SHARED_TRACINI > $SHARED_TRACINI_TMP
mv $SHARED_TRACINI_TMP $SHARED_TRACINI
