#!/bin/sh

if [ "$1" == "" ]; then
echo "undefined install directory"
exit
fi

export TRAC_HOME=$1
export HUDSON_HOME=$TRAC_HOME/hudson

./install-package.sh
./install-trac.sh

mkdir -p $TRAC_HOME
mkdir $TRAC_HOME/trac/
mkdir $TRAC_HOME/svn/

chown -R apache:apache $TRAC_HOME/trac/
chown -R apache:apache $TRAC_HOME/svn/

# Trac,SVN,Hudson $BMQ(B Apache $B$N@_Dj%U%!%$%k$r:n@.(B
./httpd.conf.sh

# Hudson $B$N%$%s%9%H!<%k(B
./install-hudson.sh $HUDSON_HOME

# Trac $B%W%i%0%$%s$N%$%s%9%H!<%k(B
./install-tracplugin.sh $TRAC_HOME

# $B=i4|%"%+%&%s%H!J(Badmin$B!K$N%3%T!<(B
cp ./trac.htdigest $TRAC_HOME/trac.htdigest

# Trac $B%W%m%8%'%/%H$N:n@.(B
./create-project.sh $TRAC_HOME SampleProject

# TestLink $B$N%$%s%9%H!<%k(B
./install-testlink.sh $TRAC_HOME

# Hudson $B$N5/F0(B
./run-hudson.sh $HUDSON_HOME
