/*
Kasumi: Dictionary management tool for Anthy
Copyright (C) 2004 Takashi Nakamoto

This file is part of Kasumi

Kasumi is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Please send bug-reports, opinions and patches, if any, to me by E-Mail.
My E-mail address is following: bluedwarf@openoffice.org
*/

#ifndef __ANTHY_DIC_H__
#define __ANTHY_DIC_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gtk/gtk.h>
#include "intl.h"

#define UTF8_MEISHI "名詞"
#define UTF8_FUKUSHI "副詞"
#define UTF8_JINNMEI "人名"
#define UTF8_CHIMEI "地名"
#define UTF8_KEIYOUSHI "形容詞"

enum yes_or_no{ERROR,NO,YES};

/* word and yomi must be encoded by UTF-8  */
struct anthy_word{
  char *word;
  char *yomi;
  int freq;
  enum part_of_speech {NOTHING,NOUN,ADVERB,PERSON,PLACE,ADJECTIVE} part;
  enum yes_or_no noun_na_connection;
  enum yes_or_no noun_sa_connection;
  enum yes_or_no noun_suru_connection;
  enum yes_or_no noun_gokan;
  enum yes_or_no noun_kakujoshi_connection;
  enum yes_or_no adv_to_connection;
  enum yes_or_no adv_taru_connection;
  enum yes_or_no adv_suru_connection;
  enum yes_or_no adv_gokan;
  GtkTreeRowReference *row_reference;
  struct anthy_word *next;
};

typedef struct anthy_word AnthyWord;

/* chained array */
AnthyWord *first_anthy_word;

void analyze_anthy_dic(char *dic);
void save_anthy_dic();
AnthyWord *add_word(AnthyWord newword);
int remove_word(AnthyWord *word);
AnthyWord *last_anthy_word();
AnthyWord *get_anthy_word_from_iter(GtkTreeModel *model, GtkTreeIter *aiter);

#endif /* __ANTHY_DIC_H__ */
