/*
Kasumi: Dictionary management tool for Anthy
Copyright (C) 2004 Takashi Nakamoto

This file is part of Kasumi

Kasumi is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Please send bug-reports, opinions and patches, if any, to me by E-Mail.
My E-mail address is following: bluedwarf@openoffice.org
*/

#ifndef __EUCJP_H__
#define __EUCJP_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "intl.h"
#include "anthy_dic.h"

#define SPACE 0x20
#define EQUAL 0x3d

#define EUCJP_HINNSHI "\xc9\xca\xbb\xec"
#define EUCJP_MEISHI "\xcc\xbe\xbb\xec"
#define EUCJP_FUKUSHI "\xc9\xfb\xbb\xec"
#define EUCJP_JINNMEI "\xbf\xcd\xcc\xbe"
#define EUCJP_CHIMEI "\xc3\xcf\xcc\xbe"
#define EUCJP_KEIYOUSHI "\xb7\xc1\xcd\xc6\xbb\xec"
#define EUCJP_NASETSUZOKU "\xa4\xca\xc0\xdc\xc2\xb3"
#define EUCJP_GOKANNNOMIDEBUNNSETSU "\xb8\xec\xb4\xb4\xa4\xce\xa4\xdf\xa4\xc7\xca\xb8\xc0\xe1"
#define EUCJP_SASETSUZOKU "\xa4\xb5\xc0\xdc\xc2\xb3"
#define EUCJP_SURUSETSUZOKU "\xa4\xb9\xa4\xeb\xc0\xdc\xc2\xb3"
#define EUCJP_KAKUJOSHISETSUZOKU "\xb3\xca\xbd\xf5\xbb\xec\xc0\xdc\xc2\xb3"
#define EUCJP_TOSETSUZOKU "\xa4\xc8\xc0\xdc\xc2\xb3"
#define EUCJP_TARUSETSUZOKU "\xa4\xbf\xa4\xeb\xc0\xdc\xc2\xb3"

int eucjp_count_str(const char *str, const char *str_search);
void eucjp_split_str(char *str, const char delimiter, char **lines);
int is_comment_line(const char *line);
int is_empty_line(const char *line);
int is_word_entry(const char *line);
gchar *get_utf8_yomi(const char *word_entry);
int get_frequency(const char *word_entry);
char *get_utf8_word(const char *word_entry);
void get_key_and_val(const char *line, AnthyWord *newword,int nline);
enum yes_or_no val_is_yes_or_no(const char *val);

#endif /* __EUCJP_H__ */
