unit untBBS2ch;

interface

uses
  Classes, Dialogs, SysUtils,
  IdComponent, IdTCPConnection, IdTCPClient, IdHTTP,
  IdCookieManager,
  RegExpr, DzURL, 
  untStreamTool, untTool,
  untHttpThread,
  untBBSFramework;

type

  TBBS2chGetTopic = class(TBBSGetTopic)
  private
    FMessageCount : integer;
    FNoFirstLine  : boolean;
    FReadPosition : integer;
    FWriteEvent : TMemoryStreamEx;
    FBuffer : TMemoryStream;
    FBufferReader : TStreamReader;
    FReceivedDatSize : integer;
    procedure HttpReceived(const Buff; Count : int64);
  public
    procedure   Get(); override;
    constructor Create(Server, BoardId, TopicId : string);
    destructor  Destroy; override;
  end;

  TBBS2chPostArticle = class(TBBSPostArticle)
  private
    FServer  : string;
    FBoardId : string;
    FTopicId : string;
  public
    procedure   Post(PostName, PostEmail, Body : string); override;
    constructor Create(Server, BoardId, TopicId : string);
    destructor  Destroy; override;
  end;

  TBBS2chGetTopicList = class(TBBSGetTopicList)
  private
    FServer       : string;
    FBoardId      : string;
    FReadPosition : integer;
    FWriteEvent   : TMemoryStreamEx;
    FBuffer : TMemoryStream;
    FBufferReader : TStreamReader;
    procedure HttpReceived(const Buff; Count : int64);
  public
    procedure   Get(); override;
    constructor Create(Server, BoardId : string);
  end;

implementation

{ TBBS2chGetTopic }

constructor TBBS2chGetTopic.Create(Server, BoardId, TopicId : string);
begin
  inherited Create();

  FURL := 'http://' + Server + '/' + BoardId + '/dat/' + TopicId + '.dat';

end;

destructor TBBS2chGetTopic.Destroy;
begin

  inherited;
end;

procedure TBBS2chGetTopic.Get;
var
  contentsize : integer;
begin
  inherited;

  try
    FReadPosition := 0;
    FWriteEvent := TMemoryStreamEx.Create();
    FWriteEvent.OnWrite := HttpReceived;
    FBuffer       := TMemoryStream.Create();
    FBufferReader := TStreamReader.Create(FBuffer);
    //Http.CookieManager := gCookieManager; // ƎM|悤?
    if FDatSize > 0 then FHttp.Request.ContentRangeStart := FDatSize - 1;
    FNoFirstLine := true;
    FHttp.Get(FURL, FWriteEvent);

    contentsize := FHttp.Response.ContentLength;
    if contentsize > 0 then
    if FDatSize = 0 then
      FDatSize := contentsize
    else
      FDatSize := FDatSize + contentsize - 1;

  finally
    FBufferReader.Free;
    FBuffer.Free;
    FWriteEvent.Free;
  end;

end;

procedure TBBS2chGetTopic.HttpReceived(const Buff; Count: int64);
var
  line   : string;
  RegExp :TRegExpr;
begin

  FBuffer.Seek(0, soFromEnd);
  FBuffer.Write(Buff, Count);
  FBuffer.Seek(FReadPosition, soFromBeginning);

  RegExp := TRegExpr.Create;
  RegExp.Expression := '^(.*?)<>(.*?)<>(.*?)<>(.*?)<>';

  while FBufferReader.ReadLine(line) do
  begin
    FReadPosition := FBuffer.Position;

    // Ol܂`FbN
    if FNoFirstLine then
    begin
      FNoFirstLine := false;
      if FDatSize > 0 then
        if line = '' then
        begin
          continue;
        end else
        begin
          RaiseError(etAbone, '폜ځ[ŃOl܂悤ł');
          exit;
        end;
      end;

    // sǉ
    if RegExp.Exec(line) then
      FArticleList.Add(line)
    else begin
      RaiseError(etParse, '̓G[');
      FArticleList.Add('<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                       '<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                       '<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                       '<FONT COLOR="Gray">[Ă܂]</FONT><>');
    end;

  end;

  Regexp.Free;

  //Synchronize(RaiseMessageReceivedEvent);
  FBuffer.Seek(0, soFromEnd);

  if Assigned(OnReceived) then OnReceived(self);

end;

{ TBBS2chPostArticle }

constructor TBBS2chPostArticle.Create(Server, BoardId, TopicId: string);
begin
  inherited Create();

  FServer  := Server;
  FBoardId := BoardId;
  FTopicId := TopicId;
end;

destructor TBBS2chPostArticle.Destroy;
begin

  inherited;
end;

procedure TBBS2chPostArticle.Post(PostName, PostEmail, Body: string);
var
  PostData : TStringList;
  intTime  : integer;
  response : string;
  ErrorMsg : string;
begin

  FHttp.Request.Referer := 'http://' + FServer + '/' + FBoardId  + '/index2.html';
  FHttp.CookieManager   := TIdCookieManager.Create(nil);
  FHttp.HTTPOptions := [];
  FHttp.Request.CustomHeaders.Add('Cookie: NAME=' + UrlEncode(PostName)
                               + '&Cookie: MAIL=' + UrlEncode(PostEmail) +';');

  intTime := Round((Now() - EncodeDate(1970, 1, 1)) * 86400);
  PostData := TStringList.Create;
  PostData.Add('submit='  + UrlEncode('') + '&' +
               'FROM='    + UrlEncode(PostName)   + '&' +
               'mail='    + UrlEncode(PostEmail)  + '&' +
               'MESSAGE=' + UrlEncode(Body)       + '&' +
               'bbs='     + FBoardId              + '&' +
               'key='     + FTopicId              + '&' +
               'time='    + IntToStr(intTime));

  response := FHttp.Post('http://' + FServer + '/test/bbs.cgi', PostData);
  if Pos('݂܂', response) = 0 then
  begin
    response := FHttp.Post('http://' + FServer + '/test/bbs.cgi', PostData);
    if Pos('݂܂', response) = 0 then
    begin
      ErrorMsg := CopyMiddle(response, '<b>', '</b>');
    end;
  end;

  PostData.Free;
  FHttp.CookieManager.Free;
  FHttp.CookieManager := nil;

  if ErrorMsg <> '' then
    RaiseError(etPostArticle, ErrorMsg)
  else
    if Assigned(FOnComplete) then FOnComplete(self);

end;

{ TBBS2chGetTopicList }

constructor TBBS2chGetTopicList.Create(Server, BoardId: string);
begin
  inherited Create();

  FServer  := Server;
  FBoardId := BoardId;

end;

procedure TBBS2chGetTopicList.Get;
begin
  inherited;

  try
    FWriteEvent := TMemoryStreamEx.Create();
    FWriteEvent.OnWrite := HttpReceived;
    FBuffer       := TMemoryStream.Create();
    FBufferReader := TStreamReader.Create(FBuffer);
    FHttp.Get('http://' + FServer + '/' + FBoardId + '/subject.txt', FWriteEvent);
  finally
    FBufferReader.Free;
    FBuffer.Free;
    FWriteEvent.Free;
  end;

end;

procedure TBBS2chGetTopicList.HttpReceived(const Buff; Count: int64);
var
  line  : string;
  Regex : TRegExpr;
begin

  Regex := TRegExpr.Create;

  // sPʂ
  FBuffer.Seek(0, soFromEnd);
  FBuffer.Write(Buff, Count);
  FBuffer.Seek(FReadPosition, soFromBeginning);

  while FBufferReader.ReadLine(line) do
  begin
    FReadPosition := FBuffer.Position;

    Regex.Expression := '^(.+?)\.dat<>(.*) \((.+?)\)$';
    if Regex.Exec(line) then
    begin
      FTopicList.Add(line);
    end else
    begin
      RaiseError(etParse, '̓G[');
    end;

    if Assigned(OnReceived) then OnReceived(self);
  end;

  Regex.Free;

end;

end.
