unit untBBSFramework;

interface

uses
  Classes,
  IdComponent, IdTCPConnection, IdTCPClient, IdHTTP,
  IdCookieManager,
  RegExpr,
  untTool, untOption;

type
                                     
  TBBSType = (bt2ch, btJBBS, btShitaraba, btMitinoku, btYahoo, btWinny, btNone);
  TFrameworkErrorType = (etAbone, etParse, etPostArticle);

  TStatusTextChangeEvent = procedure(Sender : TObject; StatusText : string) of object;
  TFrameworkError        = procedure(Sender : TObject; ErrorCode : TFrameworkErrorType; ErrorString : string) of object;

  TBBSGetTopic = class
  protected
    FOnError            : TFrameworkError;
    FDatSize            : integer;
    FLastModified       : string;
    FOnReceived         : TNotifyEvent;
    FOnComplete         : TNotifyEvent;
    FOnStatusTextChange : TStatusTextChangeEvent;
    FArticleList        : TStringList;
    FHttp               : TIdHttp;
    FUrl: string;
    procedure SetDatSize           (const Value: integer);
    procedure SetLastModified      (const Value: string);
    procedure SetOnComplete        (const Value: TNotifyEvent);
    procedure SetOnReceived        (const Value: TNotifyEvent);
    procedure SetOnStatusTextChange(const Value: TStatusTextChangeEvent);
    procedure SetUrl(const Value: string);
    procedure SetOnError(const Value: TFrameworkError);
    procedure HttpStatusChange(axSender: TObject;
      const axStatus: TIdStatus; const asStatusText: string);
    procedure ChangeStatusText(NewText : string);
    procedure RaiseError(ErrorCode : TFrameworkErrorType; ErrorString : string);
  public
    property    LastModified       : string read FLastModified write SetLastModified;
    property    DatSize            : integer read FDatSize write SetDatSize;
    property    ArticleList        : TStringList read FArticleList;
    property    Url                : string read FUrl write SetUrl;
    property    OnReceived         : TNotifyEvent read FOnReceived write SetOnReceived;
    property    OnComplete         : TNotifyEvent read FOnComplete write SetOnComplete;
    property    OnStatusTextChange : TStatusTextChangeEvent read FOnStatusTextChange write SetOnStatusTextChange;
    property    OnError : TFrameworkError read FOnError write SetOnError;
    procedure   Get(); virtual;
    constructor Create;
    destructor  Destroy; virtual;
  end;

  TBBSPostArticle = class
  protected
    FOnComplete         : TNotifyEvent;
    FOnStatusTextChange : TStatusTextChangeEvent;
    FOnError            : TFrameworkError;
    FHttp               : TIdHttp;
    procedure SetOnComplete(const Value: TNotifyEvent);
    procedure SetOnStatusTextChange(const Value: TStatusTextChangeEvent);
    procedure SetOnError(const Value: TFrameworkError);
    procedure HttpStatusChange(axSender: TObject;
      const axStatus: TIdStatus; const asStatusText: string);
    procedure ChangeStatusText(NewText : string);
    procedure RaiseError(ErrorCode : TFrameworkErrorType; ErrorString : string);
  public
    property    OnComplete         : TNotifyEvent read FOnComplete write SetOnComplete;
    property    OnError            : TFrameworkError read FOnError write SetOnError;
    property    OnStatusTextChange : TStatusTextChangeEvent read FOnStatusTextChange write SetOnStatusTextChange;
    procedure   Post(PostName, PostEmail, Body : string); virtual; abstract;
    constructor Create();
    destructor  Destroy; virtual;
  end;

  TBBSGetTopicList = class
  protected
    FHttp               : TIdHttp;
    FTopicList          : TStringList;
    FOnError            : TFrameworkError;
    FOnComplete         : TNotifyEvent;
    FOnReceived         : TNotifyEvent;
    FOnStatusTextChange : TStatusTextChangeEvent;
    procedure ChangeStatusText(NewText : string);
    procedure SetTopicList(const Value: TStringList);
    procedure SetOnComplete(const Value: TNotifyEvent);
    procedure SetOnError(const Value: TFrameworkError);
    procedure SetOnReceived(const Value: TNotifyEvent);
    procedure SetOnStatusTextChange(const Value: TStatusTextChangeEvent);
    procedure HttpStatusChange(axSender: TObject;
      const axStatus: TIdStatus; const asStatusText: string);
    procedure RaiseError(ErrorCode: TFrameworkErrorType;
      ErrorString: string);
  public
    property    TopicList : TStringList read FTopicList write SetTopicList;
    property    OnReceived         : TNotifyEvent read FOnReceived write SetOnReceived;
    property    OnComplete         : TNotifyEvent read FOnComplete write SetOnComplete;
    property    OnStatusTextChange : TStatusTextChangeEvent read FOnStatusTextChange write SetOnStatusTextChange;
    property    OnError : TFrameworkError read FOnError write SetOnError;
    procedure   Get(); virtual; abstract;
    constructor Create;
    destructor  Destroy; virtual;
  end;

  function IsBBSUrl(Url : string) : boolean;
  function CreateBBSGetTopic    (Server, BoardId, TopicId : string) : TBBSGetTopic;
  function CreateBBSPostArticle (Server, BoardId, TopicId : string) : TBBSPostArticle;
  function CreateBBSGetTopicList(Server, BoardId : string) : TBBSGetTopicList;

var

  gCookieManager: TIdCookieManager;

implementation

uses
  untBBS2ch, untBBSJBBS;

function GetBBSType(Server : string) : TBBSType;
begin

  // BBSType𔻒f
  
  if Pos('jbbs', Server) > 0 then
    result := btJBBS
  else if Pos('machibbs.com', Server) > 0 then
    result := btJBBS
  else if Pos('shitaraba.com', Server) > 0 then
    result := btShitaraba
  else if Pos('www.mitinoku.jp', Server) > 0 then
    result := btMitinoku
  else
    result := bt2ch;

end;

procedure ParseUrl(Url : string; var BBSType : TBBSType; var DatUrl : string; var SubjectUrl : string);
var
  Regex   : TRegexpr;
  server  : string;
  boardid : string;
begin

  (* sample format *)
  (* http://server.2ch.net/bbs/ *)
  (* http://server.2ch.net/test/read.cgi/bbs/?opt  *)
  (* http://server.2ch.net/test/read.cgi/bbs/dat/opt  *)
  (* http://server.2ch.net/bbs/dat/nnn.dat  *)
  (* http://server.2ch.net/bbs/kako/nnn/dat.html  *)
  (* http://server.2ch.net/bbs/kako/nnn/nnnn/dat.html  *)
  (* http://server.2ch.net/test/read.cgi?bbs=bbs&key=dat  *)
  (* http://server.2ch.net/sub/bbs/kako/nnn/dat.html  *)
  (* http://server.2ch.net/sub/test/read.cgi?bbs=bbs&key=dat  *)
  (* http://server.yahoo.co.jp/bbs?action=topics&board=bbs&sid=dat *)

  Regex := TRegexpr.Create;


  Regex.Free;

end;

function IsBBSUrl(Url : string) : boolean;
begin

  //if(ParseUrl(Url, '', '', '') <> btNone) then
  //  result := true
  //else
    result := false;

end;

function CreateBBSGetTopic(Server, BoardId, TopicId : string) : TBBSGetTopic;
begin

  case GetBBSType(Server) of
    bt2ch  : result := TBBS2chGetTopic.Create (Server, BoardId, TopicId);
    btJBBS : result := TBBSJBBSGetTopic.Create(Server, BoardId, TopicId);
    else     result := nil;
  end;

end;

function CreateBBSPostArticle(Server, BoardId, TopicId : string) : TBBSPostArticle;
begin

  case GetBBSType(Server) of
    bt2ch  : result := TBBS2chPostArticle.Create (Server, BoardId, TopicId);
    btJBBS : result := TBBSJBBSPostArticle.Create(Server, BoardId, TopicId)
    else     result := nil;
  end;

end;

function CreateBBSGetTopicList(Server, BoardId : string) : TBBSGetTopicList;
begin

  case GetBBSType(Server) of
    bt2ch      : result := TBBS2chGetTopicList.Create(Server, BoardId);
    btJBBS,
    btMitinoku : result := TBBSJBBSGetTopicList.Create(Server, BoardId);
    else         result := nil;
  end;

end;

{ TBBSGetTopic }

constructor TBBSGetTopic.Create;
var
  proxyitem : TStringArray;
  proxyhost : string;
  proxyport : integer;
begin

  FArticleList := TStringList.Create;;

  FHttp := TIdHttp.Create(nil);
  FHttp.OnStatus            := HttpStatusChange;
  FHttp.Request.UserAgent   := gUserAgent;

  // proxy
  if gReadProxyUse = true then
    if gReadProxy <> '' then
    begin
      proxyitem := Split(gReadProxy, ':');
      if length(proxyitem) >= 2 then
        proxyport := StrToIntNeo(proxyitem[1])
      else
        proxyport := 8080;
      proxyhost := proxyitem[0];

      FHttp.ProxyParams.ProxyServer := proxyhost;
      FHttp.ProxyParams.ProxyPort   := proxyport;
    end;

end;

destructor TBBSGetTopic.Destroy;
begin

  FArticleList.Free;
  FHttp.Free;

end;

procedure TBBSGetTopic.Get;
begin



end;

procedure TBBSGetTopic.SetDatSize(const Value: integer);
begin
  FDatSize := Value;
end;

procedure TBBSGetTopic.SetLastModified(const Value: string);
begin
  FLastModified := Value;
end;

procedure TBBSGetTopic.SetOnComplete(const Value: TNotifyEvent);
begin
  FOnComplete := Value;
end;

procedure TBBSGetTopic.SetOnError(const Value: TFrameworkError);
begin
  FOnError := Value;
end;

procedure TBBSGetTopic.SetOnReceived(const Value: TNotifyEvent);
begin
  FOnReceived := Value;
end;

procedure TBBSGetTopic.SetOnStatusTextChange(
  const Value: TStatusTextChangeEvent);
begin
  FOnStatusTextChange := Value;
end;

procedure TBBSGetTopic.SetUrl(const Value: string);
begin
  FUrl := Value;
end;

procedure TBBSGetTopic.HttpStatusChange(axSender: TObject;
  const axStatus: TIdStatus; const asStatusText: string);
begin

  case axStatus of

    hsConnecting :
    begin
      ChangeStatusText(FHttp.Host + 'ɐڑ');
    end;

    hsConnected :
    begin
      //FParent.DownloadState := dsProcessing;
      ChangeStatusText(FHttp.Host + 'ɐڑ܂');
    end;

  end;

end;

procedure TBBSGetTopic.ChangeStatusText(NewText: string);
begin
  if Assigned(FOnStatusTextChange) then
    FOnStatusTextChange(self, NewText);
end;

procedure TBBSGetTopic.RaiseError(ErrorCode: TFrameworkErrorType; ErrorString: string);
begin
  if Assigned(FOnError) then
    FOnError(self, ErrorCode, ErrorString);
end;

{ TBBSPostArticle }

constructor TBBSPostArticle.Create;
var
  proxyitem : TStringArray;
  proxyhost : string;
  proxyport : integer;
begin

  FHttp := TIdHttp.Create(nil);
  FHttp.OnStatus            := HttpStatusChange;
  FHttp.Request.UserAgent   := gUserAgent;

  // proxy
  if gWriteProxyUse = true then
    if gWriteProxy <> '' then
    begin
      proxyitem := Split(gWriteProxy, ':');
      if length(proxyitem) >= 2 then
        proxyport := StrToIntNeo(proxyitem[1])
      else
        proxyport := 8080;
      proxyhost := proxyitem[0];

      FHttp.ProxyParams.ProxyServer := proxyhost;
      FHttp.ProxyParams.ProxyPort   := proxyport;
    end;

end;

destructor TBBSPostArticle.Destroy;
begin
  FHttp.Free;
  inherited;
end;

procedure TBBSPostArticle.SetOnComplete(const Value: TNotifyEvent);
begin
  FOnComplete := Value;
end;

procedure TBBSPostArticle.SetOnError(const Value: TFrameworkError);
begin
  FOnError := Value;
end;

procedure TBBSPostArticle.SetOnStatusTextChange(
  const Value: TStatusTextChangeEvent);
begin
  FOnStatusTextChange := Value;
end;

procedure TBBSPostArticle.ChangeStatusText(NewText: string);
begin
  if Assigned(FOnStatusTextChange) then
    FOnStatusTextChange(self, NewText);
end;

procedure TBBSPostArticle.RaiseError(ErrorCode: TFrameworkErrorType;
  ErrorString: string);
begin
  if Assigned(FOnError) then
    FOnError(self, ErrorCode, ErrorString);
end;

procedure TBBSPostArticle.HttpStatusChange(axSender: TObject;
  const axStatus: TIdStatus; const asStatusText: string);
begin

  case axStatus of

    hsConnecting :
    begin
      ChangeStatusText(FHttp.Host + 'ɐڑ');
    end;

    hsConnected :
    begin
      //FParent.DownloadState := dsProcessing;
      ChangeStatusText(FHttp.Host + 'ɐڑ܂');
    end;

  end;

end;

{ TBBSGetTopicList }

constructor TBBSGetTopicList.Create;
var
  proxyitem : TStringArray;
  proxyhost : string;
  proxyport : integer;
begin

  FTopicList := TStringList.Create;

  FHttp := TIdHttp.Create(nil);
  FHttp.OnStatus            := HttpStatusChange;
  FHttp.Request.UserAgent   := gUserAgent;

  // proxy
  if gReadProxyUse = true then
    if gReadProxy <> '' then
    begin
      proxyitem := Split(gReadProxy, ':');
      if length(proxyitem) >= 2 then
        proxyport := StrToIntNeo(proxyitem[1])
      else
        proxyport := 8080;
      proxyhost := proxyitem[0];

      FHttp.ProxyParams.ProxyServer := proxyhost;
      FHttp.ProxyParams.ProxyPort   := proxyport;
    end;

end;

destructor TBBSGetTopicList.Destroy;
begin

  FHttp.Free;
  FTopicList.Free;

end;

procedure TBBSGetTopicList.SetOnComplete(const Value: TNotifyEvent);
begin
  FOnComplete := Value;
end;

procedure TBBSGetTopicList.SetOnError(const Value: TFrameworkError);
begin
  FOnError := Value;
end;

procedure TBBSGetTopicList.SetOnReceived(const Value: TNotifyEvent);
begin
  FOnReceived := Value;
end;

procedure TBBSGetTopicList.SetOnStatusTextChange(
  const Value: TStatusTextChangeEvent);
begin
  FOnStatusTextChange := Value;
end;

procedure TBBSGetTopicList.SetTopicList(const Value: TStringList);
begin
  FTopicList := Value;
end;

procedure TBBSGetTopicList.HttpStatusChange(axSender: TObject;
  const axStatus: TIdStatus; const asStatusText: string);
begin

  case axStatus of
    hsConnecting :
    begin
      ChangeStatusText(FHttp.Host + 'ɐڑ');
    end;

    hsConnected :
    begin
      //FParent.DownloadState := dsProcessing;
      ChangeStatusText(FHttp.Host + 'ɐڑ܂');
    end;
  end;

end;

procedure TBBSGetTopicList.ChangeStatusText(NewText: string);
begin
  if Assigned(FOnStatusTextChange) then
    FOnStatusTextChange(self, NewText);
end;

procedure TBBSGetTopicList.RaiseError(ErrorCode: TFrameworkErrorType;
  ErrorString: string);
begin
  if Assigned(FOnError) then
    FOnError(self, ErrorCode, ErrorString);
end;

initialization

  gCookieManager := TIdCookieManager.Create(nil);

finalization

  gCookieManager.Free;

end.
