unit untBoardDownloadThread;

interface

uses
  Classes, SysUtils,
  RegExpr,
  untStreamTool, untTool,
  untHttpThread, untBoard, untTopic, untBBSSub,
  untGlobal, untBBSFramework;

type

  TBoardDownloadThread = class(TThread)
  private
    FBBSGetTopicList : TBBSGetTopicList;
    FBoard           : TOnlineBoard;
    FBuffer          : TMemoryStream;
    FBufferReader    : TStreamReader;
    FLastPosition    : integer;
    FReceivedIndex   : integer;
    procedure BBS_DownloadProcess (Sender : TObject);
    procedure BBS_DownloadComplete(Sender : TObject);
    procedure BBS_StatusTextChange(Sender : TObject; StatusText : string);
  public
    constructor Create(Board : TOnlineBoard);
    destructor  Destroy; override;
    procedure   Execute; override;
  end;

implementation

{ TBoardDownloadThread }

procedure TBoardDownloadThread.BBS_DownloadProcess(Sender: TObject);
var
  line          : string;
  Regex         : TRegExpr;
  topic         : TTopic;
  topicId       : string;
  topicPath     : string;
  topicTitle    : string;
  topicMsgCount : integer;
  I             : integer;
begin

  Regex := TRegExpr.Create;

  for I := FReceivedIndex + 1 to FBBSGetTopicList.TopicList.Count - 1 do
  begin
    line := FBBSGetTopicList.TopicList[I];

    Regex.Expression := '^(.+?)\.dat<>(.*) \((.+?)\)$';
    if Regex.Exec(line) then
    begin

      topicId       := Regex.Substitute('$1');
      topicTitle    := Regex.Substitute('$2');
      topicMsgCount := StrToIntNeo(Regex.Substitute('$3'));

      // ꕶϊ
      topicTitle := StringReplace(topicTitle, '&gt;', '>', [rfReplaceAll]);
      topicTitle := StringReplace(topicTitle, '&lt;', '<', [rfReplaceAll]);

      // gsbN̐
      //topicPath          := FBoard.BoardPath + '/' + topicId;
      topic              := gBBSCore.GetTopic(FBoard, topicId);
      topic.Index        := FReceivedIndex + 2;
      topic.Title        := topicTitle;
      topic.MessageCount := topicMsgCount;
      topic.NoIndex      := false;

      // Cxgs
      FBoard.RaiseTopicReceivedEvent(topic);
    end;

    FReceivedIndex := I;
  end;

  Regex.Free;

end;

procedure TBoardDownloadThread.BBS_DownloadComplete(Sender: TObject);
begin

end;

procedure TBoardDownloadThread.BBS_StatusTextChange(Sender: TObject;
  StatusText: string);
begin

end;

constructor TBoardDownloadThread.Create(Board: TOnlineBoard);
begin
  inherited Create(true);

  FBoard := Board;
  FBBSGetTopicList := CreateBBSGetTopicList(Board.Server, Board.BoardName);
  FBBSGetTopicList.OnReceived         := BBS_DownloadProcess;
  FBBSGetTopicList.OnComplete         := BBS_DownloadComplete;
  FBBSGetTopicList.OnStatusTextChange := BBS_StatusTextChange;

end;

destructor TBoardDownloadThread.Destroy;
begin
  FBuffer.Free;
  FBufferReader.Free;
  FBBSGetTopicList.Free;

  inherited;
end;

procedure TBoardDownloadThread.Execute;
begin
  inherited;

  FReceivedIndex := -1;
  FBoard.IsDownloading := true;
  FBBSGetTopicList.Get;
  FBoard.IsDownloading := false;

  Terminate;

end;

end.
