unit untTopicDownloadThread;

interface

uses
  Classes, SysUtils, Dialogs, SyncObjs,
  untHttpClient, untStreamTool, untTool,
  untBBSCore, untTopic, untGlobal, untOption,
  untHttp3, untHttpThread, IdComponent, RegExpr,
  untBBSSub, untBoard, jconvert, untBBSFramework;

type
  TTopicDownloadThread = class(TThread)
  protected
    FBBSGetTopic    : TBBSGetTopic;
    FParent         : TTopic;
    FNoDownload     : Boolean;
    FTopicStateType : TTopicStateType;
    FDatFile        : TextFile;
    FNewMessage     : TTopicMessage;
    FBuffer         : TMemoryStream;
    FBufferReader   : TStreamReader;
    FReadPosition   : int64;
    FMessageCount   : integer;
    FNoFirstLine    : Boolean;
    FDatValue       : string;
    FRegex          : TRegExpr;
    FReadCgi        : boolean;
    FBufferLine     : string;
    FReceivedIndex  : integer;
    FCritSec        : TCriticalSection;
    procedure LoadLog;
    procedure BBS_DownloadProcess (Sender : TObject);
    procedure BBS_DownloadComplete(Sender : TObject);
    procedure BBS_StatusTextChange(Sender : TObject; StatusText : string);
    function  ParseDat(line : string) : TTopicMessage;
  public
    procedure   Execute; override;
    constructor Create(Parent: TTopic; NoDownload : Boolean);
    destructor  Destroy; override;
    procedure   RaiseMessageReceivedEvent;
  end;

implementation

{ TTopicDownloadThread }

constructor TTopicDownloadThread.Create(Parent: TTopic; NoDownload : Boolean);
var
  Board : TOnlineBoard;
begin
  inherited Create(True);

  FParent := Parent;
  FParent.CountUp;
  FNoDownload := NoDownload;
  FCritSec    := TCriticalSection.Create;

  Board := TOnlineBoard(Parent.Board);
  FBBSGetTopic := CreateBBSGetTopic(Board.Server, Board.BoardName, parent.TopicId);
  FBBSGetTopic.OnReceived         := BBS_DownloadProcess;
  FBBSGetTopic.OnComplete         := BBS_DownloadComplete;
  FBBSGetTopic.OnStatusTextChange := BBS_StatusTextChange;

end;

destructor TTopicDownloadThread.Destroy;
begin
  FBBSGetTopic.Free;
  FParent.CountDown;
  FCritSec.Free;

  inherited;
end;

procedure TTopicDownloadThread.Execute;
var
  logpath        : string;
  range          : integer;
  sr             : TStreamReader;
  line           : string;
  firstchar      : char;
  msgcount       : integer;
  parse          : TTopicMessage;
  contentsize    : integer;
  blnError       : boolean;
  I              : integer;
  blnBreak       : boolean;
  starttime      : integer;
  totalsecond    : string;
  proxyitem      : TStringArray;
  proxyhost      : string;
  proxyport      : integer;
  logvalue       : string;
  msg            : TTopicMessage;
  startindex     : integer;
label
  Finish;
begin
  inherited;

  FParent.IsDownloadingTopic := true;
  FParent.CheckWriteFolder;

  blnError := false;

  // Oǂݍ
  LoadLog();

  startindex := FParent.MessageList.Count;
  if FNoDownload = false then
  begin

    if Terminated = true then goto Finish;

    // ʐMJn
    FReceivedIndex := -1;
    FBBSGetTopic.LastModified := FParent.LastModified;
    FBBSGetTopic.DatSize      := FParent.DatSize;
    FBBSGetTopic.Get;

    // L^
    FParent.LastModified := FBBSGetTopic.LastModified;
    FParent.DatSize      := FBBSGetTopic.DatSize;

    FParent.NewMessageCount := FParent.NewMessageCount + (FParent.MessageList.Count - FParent.GotMessageCount);
    FParent.GotMessageCount := FParent.MessageList.Count;

    if blnError = false then
    begin
      FParent.DownloadState := dsNone;

      if FParent.NewMessageCount = 0 then
        FParent.StatusText := 'VȂ'
      else
        FParent.StatusText := IntToStr(FParent.NewMessageCount) + '̃XM';
    end;

  end;

  // ÂOǂݍł̂ȂΑSo
  if FParent.OldLog = true then
  begin
    startindex := 0;
    FParent.OldLog := false;
  end;

  logvalue := '';
  for I := startindex to FParent.MessageList.Count - 1 do
  begin
    msg := TTopicMessage(FParent.MessageList[I]);
    logvalue := logvalue +
                msg.PostName  + '<>'
              + msg.Postemail + '<>'
              + msg.RestStr   + '<>'
              + msg.Body + #10;
  end;

  // DATt@C̏o
  logpath := FParent.LocalDir + FParent.TopicId + '.d';
  AssignFile(FDatFile, logpath);
  if FileExists(logpath) = false then ReWrite(FDatFile);
  Append(FDatFile);
  Write(FDatFile, logvalue);
  CloseFile(FDatFile);

Finish:

  FParent.SaveIdx();

  FParent.DownloadState := dsNone;
  FParent.IsDownloadingTopic := false;

  Terminate;
end;

procedure TTopicDownloadThread.BBS_DownloadComplete(Sender: TObject);
begin
end;

procedure TTopicDownloadThread.BBS_DownloadProcess(Sender: TObject);
var
  I   : integer;
  msg : TTopicMessage;
begin

  FCritSec.Enter;

  for I := FReceivedIndex + 1 to FBBSGetTopic.ArticleList.Count - 1 do
  begin
    msg := ParseDat(FBBSGetTopic.ArticleList[I]);
    msg.IsNewMessage := true;
    FParent.AddNewMessage(msg);

    FReceivedIndex := I;
  end;

  RaiseMessageReceivedEvent;

  FCritSec.Leave;

end;

procedure TTopicDownloadThread.BBS_StatusTextChange(Sender: TObject;
  StatusText: string);
begin
  FParent.StatusText := StatusText;
end;

procedure TTopicDownloadThread.LoadLog;
var
  localloaded : boolean;
  I, J        : Integer;
  msg         : TTopicMessage;
  msgcount    : Integer;
  logpath     : string;
  logvalue    : string;
  lines       : TStringList;
  parse       : TTopicMessage;
  items       : TStringArray;
  msgName     : string;
  msgEmail    : string;
  msgRestStr  : string;
  msgBody     : string;
begin

  msgcount := FParent.MessageList.Count;

  if FParent.IsLoadedLocalDat = false then
  begin

    lines := TStringList.Create;

    logpath := FParent.LocalDir + FParent.TopicId + '.d';
    if FileExists(logpath) = true then
    begin

   	  // [Jǂݍ
      lines.LoadFromFile(logpath);
      for I := 0 to lines.Count - 1 do
      begin
        msg := ParseDat(lines[I]);
        FParent.AddNewMessage(msg);

        localloaded := true;
      end;

    end else
    begin

      // Of[^AÂ``
      // ÔȂ炻炩ǂݍ
      logpath := FParent.LocalDir + FParent.TopicId + '.dat';
      if FileExists(logpath) = true then
      begin
        FParent.OldLog := true;

        lines.LoadFromFile(logpath);
        for I := 0 to lines.Count - 1 do
        begin
          items := Split(lines[I], ',');
          for J := 0 to 3 do
            items[J] := StringReplace(items[J], 'M', ',', [rfReplaceAll]);

          msgName    := items[0];
          msgEmail   := items[1];
          msgRestStr := items[2];
          msgBody    := items[3];

          msg := TTopicMessage.Create;
          msg.PostName  := msgName;
          msg.PostEmail := msgEmail;
          msg.RestStr   := msgRestStr;
          msg.Body      := msgBody;
          FParent.AddNewMessage(msg);

          localloaded := true;

        end;
      end;
    end;
    FParent.IsLoadedLocalDat := true;

    lines.Free;    
  end;
	FParent.Gotmessagecount := FParent.MessageList.Count;

  //if localloaded = true then
  //begin
    Synchronize(RaiseMessageReceivedEvent);

    FParent.DownloadState := dsDatLoaded;
  //end;
  
end;

procedure TTopicDownloadThread.RaiseMessageReceivedEvent;
begin
  if Assigned(FParent.OnMessageReceived) then
    FParent.OnMessageReceived(FParent);
end;

function TTopicDownloadThread.ParseDat(line: string): TTopicMessage;
var
  items : TStringArray;
  msgName     : string;
  msgEmail    : string;
  msgRestStr  : string;
  msgBody     : string;
  msg         : TTopicMessage;
begin

  items := Split(line, '<>');
  msgName    := items[0];
  msgEmail   := items[1];
  msgRestStr := items[2];
  msgBody    := items[3];

  msg := TTopicMessage.Create;
  msg.PostName  := msgName;
  msg.PostEmail := msgEmail;
  msg.RestStr   := msgRestStr;
  msg.Body      := msgBody;

  result := msg

end;



end.
