unit untTopicPostThread;

interface

uses
  Classes, SysUtils, Dialogs, DzURL,
  untHttpClient, untStreamTool, untTool,
  untBBSCore, untBoard, untGlobal, untOption,
  untBBSFramework;

type

  TTopicPostThread = class(TThread)
  protected
    FOnError: TFrameworkError;
    FOnStatusTextChange: TStatusTextChangeEvent;
    FBBSPostArticle : TBBSPostArticle;
    FParent         : TOnlineBoard;
    FTitle          : string;
    FPostName       : string;
    FPostEmail      : string;
    FPostBody       : string;
    FTopicId        : string;
    FErrorMessage   : string;
    FBoardStateType : TBoardStateType;
    FOnComplete: TNotifyEvent;
    procedure SetOnComplete(const Value: TNotifyEvent);
    procedure RaiseBoardStateChangeEvent;
    procedure BBS_Complete(Sender : TObject);
    procedure BBS_Error(Sender : TObject; ErrorCode : TFrameworkErrorType; ErrorString : string);
    procedure BBS_StatusTextChange(Sender : TObject; StatusText : string);
    procedure SetOnError(const Value: TFrameworkError);
    procedure SetOnStatusTextChange(const Value: TStatusTextChangeEvent);
  public
    property    OnComplete : TNotifyEvent read FOnComplete write SetOnComplete;
    property    OnStatusTextChange : TStatusTextChangeEvent read FOnStatusTextChange write SetOnStatusTextChange;
    property    OnError : TFrameworkError read FOnError write SetOnError;
    procedure   Execute; override;
    constructor Create(Parent: TOnlineBoard;TopicId, Title, PostName, PostEmail, PostBody : string);
    destructor  Destroy; override;
  end;

implementation

{ TTopicPostThread }

constructor TTopicPostThread.Create(Parent: TOnlineBoard; TopicId, Title, PostName, PostEmail, PostBody : string);
begin
  inherited Create(true);

  FBBSPostArticle := CreateBBSPostArticle(Parent.Server, Parent.BoardName, TopicId);
  FBBSPostArticle.OnStatusTextChange := BBS_StatusTextChange;
  FBBSPostArticle.OnComplete         := BBS_Complete;
  FBBSPostArticle.OnError            := BBS_Error;

  FParent := Parent;
  FPostName  := PostName;
  FPostEmail := PostEmail;
  FPostBody  := PostBody;
  FTitle     := Title;
  FTopicId   := TopicId;
end;

destructor TTopicPostThread.Destroy;
begin
  FBBSPostArticle.Free;

  inherited;
end;

procedure TTopicPostThread.Execute;
begin
  inherited;

  // 
  FBBSPostArticle.Post(FPostName, FPostEmail, FPostBody);

  Terminate;

end;

procedure TTopicPostThread.BBS_Complete(Sender: TObject);
begin
  if Assigned(FOnComplete) then
    FOnComplete(self);
end;

procedure TTopicPostThread.BBS_StatusTextChange(Sender: TObject;
  StatusText: string);
begin
  if Assigned(FOnStatusTextChange) then
    FOnStatusTextChange(self, StatusText);
end;

procedure TTopicPostThread.BBS_Error(Sender: TObject;
  ErrorCode: TFrameworkErrorType; ErrorString: string);
begin
  if Assigned(FOnError) then
    FOnError(self, ErrorCode, ErrorString);
end;

procedure TTopicPostThread.RaiseBoardStateChangeEvent;
begin
  gBBSCore.RaiseBoardStateChangeEvent(FParent, FBoardStateType);
end;


procedure TTopicPostThread.SetOnError(const Value: TFrameworkError);
begin
  FOnError := Value;
end;

procedure TTopicPostThread.SetOnStatusTextChange(
  const Value: TStatusTextChangeEvent);
begin
  FOnStatusTextChange := Value;
end;

procedure TTopicPostThread.SetOnComplete(const Value: TNotifyEvent);
begin
  FOnComplete := Value;
end;



end.
