unit HintWindow;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

type
  TToolTip = class(THintWindow)
  private
    { Private 錾 }
  public
    { Public 錾 }
    procedure   SetHint(HintText : string);
    constructor Create(AOwner: TComponent); override;
  end;

var
  ToolTip: TToolTip;

implementation

{$R *.dfm}

constructor TToolTip.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  self.Color := clWhite;
end;

procedure TToolTip.SetHint(HintText: string);
var
  Rect : TRect;
begin

  Rect := self.CalcHintRect(600, HintText, nil);
  self.ActivateHint(Rect, HintText);

end;

end.
