unit untHttp;

interface

uses
  ScktComp, SysUtils, Dialogs, Classes,
  untTool, gzip;

type

  {URL̓NX}
  TUrlProtocol = (Http, Https, Ftp, NoSupport);
  TUrlParse = class
  private
    FServerPort: integer;
    FUrl: string;
    FFilePath: string;
    FServerHost: string;
    FProtocol: TUrlProtocol;
    FNoSupportProtocolName : string;
    FErrorUrl: Boolean;
    procedure SetFilePath(const Value: string);
    procedure SetProtocol(const Value: TUrlProtocol);
    procedure SetServerHost(const Value: string);
    procedure SetServerPort(const Value: integer);
    procedure SetUrl(const Value: string);
    procedure UpdateUrl;
    procedure SetErrorUrl(const Value: Boolean);
  public
    property Url : string read FUrl write SetUrl;
    property ErrorUrl   : Boolean read FErrorUrl write SetErrorUrl;
    property Protocol   : TUrlProtocol read FProtocol write SetProtocol;
    property ServerHost : string read FServerHost write SetServerHost;
    property ServerPort : integer read FServerPort write SetServerPort;
    property FilePath   : string read FFilePath write SetFilePath;
  end;

  THttpState = (hsConnecting, hsConnected, hsDisconnected);
  THttpStateChange = procedure(Sender: TObject; HttpState : THttpState) of object;

  TBufferArray = array[1 .. 255] of Char;
  TDownloadThread = class(TThread)
  private
    { Private 錾 }
    FParent         : TObject;
    FDownloadSocket : TClientSocket;
    FRequest        : string;
    FReceivedData   : TBufferArray;
    FComplete       : Boolean;
    FRest           : string;
    FHttpState      : THttpState;
    FContentLength  : Integer;
    FLastModifed    : string;
    FHttpResultCode : Integer;
  protected
    procedure   Execute; override;
    procedure   RaiseReceivedEvent;
    procedure   RaiseHttpStateEvent;
    procedure   SetHttpInfo;
    constructor Create(Parent : TObject);
  end;

  {HTTPNX}
  TReceiveEventTiming = (OnComplete, OnTime, OnOneLine);
  TReceiveEvent = procedure (Sender: TObject; Complete : Boolean;
                             ReceiveText : string) of object;
  THttpGetErrorCode  = (SocketError, OtherError);
  THttpGetErrorEvent = procedure (Sender: TObject; ErrorCode : THttpGetErrorCode;
                                  ErrorText : string) of object;
  THttpGet = class
  private
    FSendData       : string;
    FDownloadThread : TDownloadThread;
    FClientSocket : TClientSocket;
    FUserAgent: string;
    FReceiveEventTiming: TReceiveEventTiming;
    FOnReceive: TReceiveEvent;
    FOnError: THttpGetErrorEvent;
    FServerHost : string;
    FServerPort : integer;
    FOnStateChange: THttpStateChange;
    FPriority: TThreadPriority;
    FHttpState: THttpState;
    FContentLength: Integer;
    FIfModifiedSince: string;
    FLastModified: string;
    FHttpResultCode: Integer;
    FProxy: string;
    procedure SetReceiveEventTiming(const Value: TReceiveEventTiming);
    procedure SetOnReceive(const Value: TReceiveEvent);
    procedure SetUserAgent(const Value: string);
    procedure SetOnError(const Value: THttpGetErrorEvent);
    function  GetActive : Boolean;
    procedure SetOnStateChange(const Value: THttpStateChange);
    procedure SetPriority(const Value: TThreadPriority);
    procedure SetHttpState(const Value: THttpState);
    procedure SetContentLength(const Value: Integer);
    procedure SetIfModifiedSince(const Value: string);
    procedure SetLastModified(const Value: string);
    procedure SetHttpResultCode(const Value: Integer);
    procedure SetProxy(const Value: string);
  public
    // vpeB
    property Request : string read FSendData;
    property ClientSocket : TClientSocket read FClientSocket;
    property ServerHost : string  read FServerHost;
    property ServerPort : integer read FServerPort;
    property Proxy : string read FProxy write SetProxy;
    property UserAgent : string  read FUserAgent write SetUserAgent;              // UserAgent
    property ReceiveEventTiming : TReceiveEventTiming read FReceiveEventTiming write SetReceiveEventTiming;
    //property Communicating : boolean read FCommunicating;
    property OnReceive : TReceiveEvent read FOnReceive write SetOnReceive;
    property OnError : THttpGetErrorEvent read FOnError write SetOnError;
    property OnStateChange : THttpStateChange read FOnStateChange write SetOnStateChange;
    property Priority : TThreadPriority read FPriority write SetPriority;
    property HttpState : THttpState read FHttpState write SetHttpState;
    property ContentLength : Integer read FContentLength write SetContentLength;
    property LastModified : string read FLastModified write SetLastModified;
    property IfModifiedSince : string read FIfModifiedSince write SetIfModifiedSince;
    property HttpResultCode : Integer read FHttpResultCode write SetHttpResultCode;

    // \bh
    constructor Create;                 // RXgN^
    destructor  Destroy; override;      // fXgN^
    procedure   Connect(Url: string; StartRange : Integer = 0);
    procedure   RaiseReceivedEvent(Complete : Boolean; ReceiveText : string);
    procedure   Close();

  end;

implementation

//
// TUrlParse 
//

{  vpeB  }

// t@C
procedure TUrlParse.SetFilePath(const Value: string);
begin
  FFilePath := Value;
  UpdateUrl;
end;

// URL
procedure TUrlParse.SetErrorUrl(const Value: Boolean);
begin
  FErrorUrl := Value;
end;

// vgR
procedure TUrlParse.SetProtocol(const Value: TUrlProtocol);
begin
  FProtocol := Value;
  FNoSupportProtocolName := '';
  UpdateUrl;
end;

// T[o[zXg
procedure TUrlParse.SetServerHost(const Value: string);
begin
  FServerHost := Value;
  UpdateUrl;
end;

// T[o[|[g
procedure TUrlParse.SetServerPort(const Value: integer);
begin
  FServerPort := Value;
  UpdateUrl;
end;

// URL
procedure TUrlParse.SetUrl(const Value: string);
var
  intPos      : Integer;
  strTemp     : string;
  strProtocol : string;
  strServer   : string;
  intPortPos  : integer;
  intPort     : Integer;
label
  ErrorExit;
begin
  FUrl := Value;

  // URL͂
  strTemp   := UpperCase(FUrl);
  intPos    := Pos('//', FUrl);
  if intPos < 2 then goto ErrorExit;

  // vgRiΉȂj
  strProtocol := Copy(strTemp, 1, intPos - 1);
  if      strProtocol = 'HTTP:'  then begin
                                      FProtocol   := Http;
                                      FServerPort := 80;
                                      end
  else if strProtocol = 'HTTPS:' then begin
                                      FProtocol   := Https;
                                      FServerPort := 443;
                                      end
  else if strProtocol = 'FTP:'   then begin
                                      FProtocol   := Ftp;
                                      FServerPort := 20;
                                      end
  else
    goto ErrorExit;

  // T[o[
  strTemp   := Copy(FUrl, intPos + 2, Length(FUrl) - intPos - 1);
  intPos    := Pos('/', strTemp);
  if intPos = 0 then
  begin
    intPos    := Length(strTemp);
    strServer := Copy(strTemp, 1, intPos);
  end
  else
   strServer := Copy(strTemp, 1, intPos - 1);

  // T[o[|[gw肳Ă邩
  intPortPos := Pos(':', strServer);
  if intPortPos = 0 then
    FServerHost := strServer
  else if intPortPos = 1 then goto ErrorExit
  else
  begin
    FServerHost := Copy(strServer, 1, intPortPos - 1);
    intPort := StrToInt(Copy(strServer, intPortPos + 1, Length(strServer) - intPortPos));
    if intPort > 0 then FServerPort :=intPort;
  end;

  // c̃t@CpX
  FFilePath := '/' + Copy(strTemp, intPos + 1, Length(strTemp) - intPos);

  // ͊
  FErrorUrl := false;

  exit;

ErrorExit:
// G[

  // ͎s
  FErrorUrl := true;

end;

{  vCx[g֐  }

// -----------------------------------------------------
// ֐ : UpdateUrl
// @ : URL̐
// @ : Ȃ
// ߂l : Ȃ
// l@ : Ȃ
// -----------------------------------------------------
procedure TUrlParse.UpdateUrl;
var
  strUrl : string;
begin

  // vgR
  case Protocol of
    Http  : strUrl := 'http';
    Https : strUrl := 'https';
    Ftp   : strUrl := 'ftp';
    else    strUrl := FNoSupportProtocolName;
  end;
  strUrl := strUrl + '://';

  // T[o[
  strUrl := strUrl + ServerHost;

  // T[o[|[g(80ȊÔƂ)
  if ServerPort <> 80 then
    strUrl := strUrl + ':' + IntToStr(ServerPort);

  // t@CpX
  if Copy(FFilePath, 1, 1) <> '/' then strUrl := strUrl + '/';
  strUrl := strUrl + FilePath;
end;

{ TDownloadThread }

constructor TDownloadThread.Create(Parent : TObject);
var
  ParentHttp : THttpGet;
begin
  inherited Create(true);

  Priority := tpLower;

  FParent := Parent;
  ParentHttp := THttpGet(Parent);
  FDownloadSocket := ParentHttp.ClientSocket;
  FRequest        := ParentHttp.Request;
end;

procedure TDownloadThread.Execute;
var
  TheStream        : TWinSocketStream;
  Buffer           : TBufferArray;
  GzipStream       : TGzipDecompressStream;
  decomp           : TMemoryStream;
  intSize          : Integer;
  ReceivedData     : string;
  IsReceivedHeader : Boolean;
  intBodyStart     : Integer;
  HeaderData       : string;
  BodyData         : string;
  Headers          : TStringArray;
  Header           : string;
  IsGZip           : Boolean;
  I                : Integer;
  temp             : TStringStream;
  CurrentPos       : Integer;
  HeaderName       : string;
  HeaderValue      : string;
  HeaderItems      : TStringArray;      
begin
  inherited;

  // ڑJn
  FDownloadSocket.Open;

  // Cxg
  FHttpState := hsConnected;
  RaiseHttpStateEvent;
  
  { ǂݏp TWinSocketStream 쐬 }
  TheStream  := TWinSocketStream.Create(FDownloadSocket.Socket, 60000);
  decomp     := TMemoryStream.Create;
  GzipStream := TGzipDecompressStream.Create(decomp);

  //try
    TheStream.Write(FRequest[1], Length(FRequest));

    IsReceivedHeader := false;
    while Terminated = false do
    begin
      FillChar(Buffer, Sizeof(Buffer), 0);
      intSize := TheStream.Read(Buffer, Sizeof(Buffer));
      if (intSize = 0) or (Terminated = true) then break;

      // wb_܂܂ŉ䖝
      if IsReceivedHeader = false then
      begin
        ReceivedData := ReceivedData + Buffer;

        // wb_ImF
        intBodyStart := Pos(#13#10#13#10, ReceivedData) + 4;
        if intBodyStart > 5 then
        begin
          IsReceivedHeader := true;
          HeaderData   := Copy(ReceivedData, 1, intBodyStart - 5);
          ReceivedData := CopyAfter(ReceivedData, intBodyStart);

          temp := TStringStream.Create(ReceivedData);
          FillChar(Buffer, Sizeof(Buffer), 0);
          temp.Position := 0;
          intSize := temp.Read(Buffer, Length(Buffer));
          temp.Free;

          Headers := Split(HeaderData, #13#10);

          // wb_
          if Length(Headers) > 0 then
          begin
            HeaderItems := Split(Headers[0], ' ');
            if Length(HeaderItems) >= 3 then
            begin
              FHttpResultCode := StrToIntNeo(HeaderItems[1]);
            end;
          end;
          IsGZip := false;
          for I := 1 to Length(Headers) - 1 do
          begin
            HeaderItems := Split(Headers[I], ':', 2);
            if Length(HeaderItems) >= 2then
            begin
              HeaderName  := UpperCase(Trim(HeaderItems[0]));
              HeaderValue := Trim(HeaderItems[1]);

              if Pos('CONTENT-ENCODING', HeaderName) > 0 then
              begin
                if Pos('GZIP', UpperCase(HeaderValue)) > 0 then
                  IsGZip := true;
              end else
              if HeaderName = 'CONTENT-LENGTH' then
              begin
                FContentLength := StrToInt(HeaderValue);
              end else
              if HeaderName = 'LAST-MODIFIED' then
              begin
                FLastModifed := HeaderValue;
              end;
            end;
          end;

          SetHttpInfo;
        end;
      end;

      if IsReceivedHeader = true then
      begin

        // GZIP
        if IsGZip = true then
        begin
          //GzipStream.Write(ReceivedData[1], Length(ReceivedData));
          CurrentPos := decomp.Position;
          GzipStream.Write(Buffer, intSize);
          decomp.Position := CurrentPos;
          ReceivedData := '';
          while true do
          begin
            FillChar(Buffer, Sizeof(Buffer), 0);
            intSize := decomp.Read(Buffer, Sizeof(Buffer));
            if (intSize = 0) or (Terminated = true) then break;

            // Cxgs
            //Move(FReceivedData, Buffer, intSize);
            FReceivedData := Buffer;
            FComplete     := false;
            RaiseReceivedEvent;
          end;

        end else
        begin

          // Cxgs
          //Move(FReceivedData, Buffer, intSize);
          FReceivedData := Buffer;
          FComplete     := false;
          RaiseReceivedEvent;
        end;
      end;

    end;

    // Cxgs
    //Move(FReceivedData, Buffer, intSize);
    FReceivedData := Buffer;
    FComplete     := true;
    RaiseReceivedEvent;
  //end;

  //except
    //if not(ExceptObject is EAbort) then
      //Synchronize(HandleThreadException); { HandleThreadException LqȂ΂ȂȂ }

  //finally
   TheStream.free;
   decomp.Free;
   GzipStream.Free;
  //end;

  FHttpState := hsDisconnected;
  RaiseHttpStateEvent;

end;

procedure TDownloadThread.RaiseHttpStateEvent;
var
  Parent : THttpGet;
begin

  Parent := THttpGet(FParent);
  if Assigned(Parent.OnStateChange) then
    Parent.OnStateChange(Parent, FHttpState);
    
end;

procedure TDownloadThread.RaiseReceivedEvent;
var
  Lines    : TStringArray;
  I        : Integer;
  strData  : string;
  strData2 : string;
  intPos   : Integer;
  blnOk    : Boolean;
  strLast  : string;
  intMax   : Integer;
begin

  intPos   := Pos(#0, FReceivedData);
  if intPos >  0 then
    strData2 := Copy(FReceivedData, 1, intPos - 1)
  else
    strData2 := FReceivedData;

  if FRest <> '' then strData2 := FRest + strData2;
  FRest := '';

  Lines := Split(strData2, #10);
  if Copy(strData2, Length(strData2), 1) = #10 then
    intMax := Length(Lines) - 1
  else
    intMax := Length(Lines) - 2;

  for I := 0 to intMax do
    THttpGet(FParent).RaiseReceivedEvent(false, Lines[I]);

  if intMax = Length(Lines) - 2 then
    if Length(Lines) > 0 then
    begin
      strData := Lines[Length(Lines) - 1];
      if FComplete = true then
        THttpGet(FParent).RaiseReceivedEvent(true, strData)
      else
        FRest := strData;
    end;

  FillChar(FReceivedData, Sizeof(FReceivedData), 0);

end;

procedure TDownloadThread.SetHttpInfo;
begin
  THttpGet(FParent).ContentLength  := FContentLength;
  THttpGet(FParent).LastModified   := FLastModifed;
  THttpGet(FParent).HttpResultCode := FHttpResultCode;
end;

//
// THttpGet
//

{  vpeB }

procedure THttpGet.SetLastModified(const Value: string);
begin
  FLastModified := Value;
end;

procedure THttpGet.SetIfModifiedSince(const Value: string);
begin
  FIfModifiedSince := Value;
end;

procedure THttpGet.SetContentLength(const Value: Integer);
begin
  FContentLength := Value;
end;

// XbhvCIeB
procedure THttpGet.SetPriority(const Value: TThreadPriority);
begin
  FPriority := Value;

  if FDownloadThread <> nil then
    FDownloadThread.Priority := Value;
end;

// UserAgent
procedure THttpGet.SetUserAgent(const Value: string);
begin
  FUserAgent := Value;
end;

// MCxg̃^C~O
procedure THttpGet.SetReceiveEventTiming(const Value: TReceiveEventTiming);
begin
  FReceiveEventTiming := Value;
end;

// MCxg
procedure THttpGet.SetOnReceive(const Value: TReceiveEvent);
begin
  FOnReceive := Value;
end;

// G[Cxg
procedure THttpGet.SetOnError(const Value: THttpGetErrorEvent);
begin
  FOnError := Value;
end;

function THttpGet.GetActive: Boolean;
begin
  result := FClientSocket.Active;
end;

procedure THttpGet.SetOnStateChange(const Value: THttpStateChange);
begin
  FOnStateChange := Value;
end;

procedure THttpGet.SetHttpState(const Value: THttpState);
begin
  FHttpState := Value;
end;

procedure THttpGet.SetHttpResultCode(const Value: Integer);
begin
  FHttpResultCode := Value;
end;


{  \bh  }

// -----------------------------------------------------
// ֐ : Create
// @ : RXgN^
// @ : Ȃ
// ߂l : Ȃ
// l@ : Ȃ
// -----------------------------------------------------
constructor THttpGet.Create;
begin

  FPriority := tpNormal;	

  FClientSocket := TClientSocket.Create(nil);
  FClientSocket.ClientType := ctBlocking;
end;

// -----------------------------------------------------
// ֐ : Destroy
// @ : fXgN^
// @ : Ȃ
// ߂l : Ȃ
// l@ : Ȃ
// -----------------------------------------------------
destructor THttpGet.Destroy;
begin
  inherited;

  FClientSocket.Free;
end;

// -----------------------------------------------------
// ֐ : Connect
// @ : 擾Jn
// @ : Url - GETΏۂURL
// ߂l : Ȃ
// l@ : Ȃ
// -----------------------------------------------------
procedure THttpGet.Connect(Url: string; StartRange : Integer = 0);
var
  ServerHost : string;
  ServerPort : integer;
  FilePath   : string;
  UrlParse   : TUrlParse;
  proxyitem  : TStringArray;
begin

  // URL
  UrlParse := TUrlParse.Create;
  UrlParse.Url := Url;
  if UrlParse.ErrorUrl = true then
  begin
    ShowMessage('URL - ' + Url);
    exit;
  end;
  ServerHost := UrlParse.ServerHost;
  ServerPort := UrlParse.ServerPort;
  FilePath   := UrlParse.FilePath;

  // 擾v̍쐬
  FSendData := 'Host: ' + ServerHost + #13#10
             + 'User-Agent: ' + FUserAgent + #13#10
             + 'Connection: close' + #13#10
             + 'Accept-Encoding: gzip' + #13#10
             //+ 'Transfer-Encoding: gzip' + #13#10
             + #13#10;

  // If-Modified-Since
  if FIfModifiedSince <> '' then
    FSendData := 'If-Modified-Since: ' + FIfModifiedSince + #13#10
               + FSendData;

  // HTTPvLVg
  if FProxy <> '' then
  begin
    proxyitem := Split(FProxy, ':');
    if length(proxyitem) >= 2 then
      ServerPort := StrToIntNeo(proxyitem[1])
    else
      ServerPort := 8080;
    ServerHost := proxyitem[0];
    FilePath := Url;
  end;

  // W
  if StartRange > 0 then
    FSendData := 'Range: bytes=' + IntToStr(StartRange) + ' - ' + #13#10
               + FSendData;

  // 擾v𐶐
  FSendData := 'GET ' + FilePath + ' ' + 'HTTP/1.1' + #13#10
             + FSendData;

  // 
  FServerHost := ServerHost;
  FServerPort := ServerPort;

  // ڑJn
  if Assigned(FOnStateChange) then FOnStateChange(self, hsConnecting);
  if FClientSocket.Active then FClientSocket.Active := false;
  //FCommunicating := true;
  FClientSocket.Host := ServerHost;
  FClientSocket.Port := ServerPort;

  // _E[hXbh𗧂グ
  FDownloadThread.Free;
  FDownloadThread := TDownloadThread.Create(self);
  FDownloadThread.Priority := FPriority;
  FDownloadThread.Resume;

end;

// -----------------------------------------------------
// ֐ : Close
// @ : ؒf
// @ : Ȃ
// ߂l : Ȃ
// l@ : Ȃ
// -----------------------------------------------------
procedure THttpGet.Close;
begin

  if FDownloadThread <> nil then
    FDownloadThread.Terminate;

  FClientSocket.Close;

  // Cxgs
  if Assigned(FOnStateChange) then FOnStateChange(self, hsDisconnected);

end;

{  NCg\PbgCxg  }

// ڑ
{
procedure THttpGet.ClientSocketConnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin

  // 擾v𑗐M
  //if Assigned(FOnStateChange) then FOnStateChange(self, hsConnected);
  //Socket.SendText(FSendData);
end;
}

// G[
{
procedure THttpGet.ClientSocketError(Sender: TObject;
  Socket: TCustomWinSocket; ErrorEvent: TErrorEvent;
  var ErrorCode: Integer);
begin

  ErrorCode := 0;

  // Cxgs
  if Assigned(FOnError) then
    FOnError(self, SocketError, '\PbgG[ : ErrorCode - ' + IntToStr(ErrorCode));
  ShowMessage(IntToStr(ErrorCode));

  // ڑ
  FClientSocket.Close;
  //FCommunicating := false;
end;
}

// f[^M
{
procedure THttpGet.ClientSocketRead(Sender: TObject;
  Socket: TCustomWinSocket);
var
  strData       : string;
  intBodyStart  : integer;
  intBodySize   : integer;
  strTemp       : string;
  intNull       : Integer;
  //Buff        : array[0..600000] of Byte;
  intSize       : Integer;
  Buff          : PChar;
  blnNowBodyEnd : Boolean;
  Lines         : TStringArray;
  I             : Integer;
begin

  blnNowBodyEnd := false;
  strData := '';
  repeat
    strData := strData + Socket.ReceiveText;
  until Socket.ReceiveLength = 0;

  // wb_܂܂ŉ䖝
  if FReceivedHeader = false then
  begin
    FReceiveBuff := FReceiveBuff + strData;

    // wb_ImF
    intBodyStart := Pos(#13#10#13#10, FReceiveBuff) + 4;
    if intBodyStart > 5 then
    begin
      FReceivedHeader := true;
      FHeader := Copy(FReceiveBuff, 1, intBodyStart - 5);
      strData := CopyAfter(FReceiveBuff, intBodyStart);
      //strData := FBody;
      blnNowBodyEnd := true;
    end;
  end;

  // Cxgs or obt@
  if FReceiveEventTiming = OnTime then
  begin
    if Assigned(FOnReceive) then
        FOnReceive(self, false, strData);
  end else
  begin
    FBody := FBody + strData;

    if FReceiveEventTiming = OnOneLine then
      if FBody <> '' then
      begin
        Lines := Split(FBody, #10);
        for I := 0 to Length(Lines) - 2 do
          if Assigned(FOnReceive) then
            FOnReceive(self, false, Lines[I]);
        FBody := Lines[Length(Lines) - 1];
      end;
  end;

end;
}

procedure THttpGet.RaiseReceivedEvent(Complete: Boolean;
  ReceiveText: string);
begin
  if Assigned(FOnReceive) then
    FOnReceive(self, Complete, ReceiveText);
end;


{
procedure THttpGet.ClientSocketDisconnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  FClientSocket.Close;

  // Cxgs
  if Assigned(FOnStateChange) then FOnStateChange(self, hsDisconnected);
end;
}

procedure THttpGet.SetProxy(const Value: string);
begin
  FProxy := Value;
end;

end.
