unit untHttp3;

interface

uses
  Classes;

type

  TWriteEvent = procedure(const Buffer; Count : int64) of object;
  TOnWriteStream = class(TMemoryStream)
  private
    FOnWrite: TWriteEvent;
    procedure SetOnWrite(const Value: TWriteEvent);
  public
    property OnWrite : TWriteEvent read FOnWrite write SetOnWrite;
    function Write(const Buffer; Count: integer) : integer; override;
  end;

implementation

{ TOnWriteStream }

procedure TOnWriteStream.SetOnWrite(const Value: TWriteEvent);
begin
  FOnWrite := Value;
end;

function TOnWriteStream.Write(const Buffer; Count: integer): integer;
begin

  inherited Seek(0, soFromEnd);
  inherited Write(Buffer, Count);
  if Assigned(FOnWrite) then FOnWrite(Buffer, Count);
  result := count;

end;

end.
